/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.persistence.impl;

import java.util.Date;
import java.util.List;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.enlinkd.model.LldpLink;
import org.opennms.netmgt.enlinkd.persistence.api.LldpLinkDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.springframework.util.Assert;

public class LldpLinkDaoHibernate
extends AbstractDaoHibernate<LldpLink, Integer>
implements LldpLinkDao {
    public LldpLinkDaoHibernate() {
        super(LldpLink.class);
    }

    @Override
    public LldpLink get(OnmsNode node, Integer lldpRemLocalPortNum, Integer lldpRemIndex) {
        return (LldpLink)this.findUnique("from LldpLink as lldpLink where lldpLink.node = ? and lldpLink.lldpRemLocalPortNum = ? and lldpRemIndex = ?", node, lldpRemLocalPortNum, lldpRemIndex);
    }

    @Override
    public LldpLink get(Integer nodeId, Integer lldpRemLocalPortNum, Integer lldpRemIndex) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        Assert.notNull((Object)lldpRemLocalPortNum, (String)"lldpRemLocalPortNum cannot be null");
        Assert.notNull((Object)lldpRemIndex, (String)"lldpRemIndex cannot be null");
        return (LldpLink)this.findUnique("from LldpLink as lldpLink where lldpLink.node.id = ? and lldpLink.lldpRemLocalPortNum = ? and lldpLink.lldpRemIndex = ?", nodeId, lldpRemLocalPortNum, lldpRemIndex);
    }

    @Override
    public List<LldpLink> findByNodeId(Integer nodeId) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        return this.find("from LldpLink lldpLink where lldpLink.node.id = ?", nodeId);
    }

    @Override
    public void deleteByNodeIdOlderThen(Integer nodeId, Date now) {
        this.getHibernateTemplate().bulkUpdate("delete from LldpLink lldpLink where lldpLink.node.id = ? and lldpLink.lldpLinkLastPollTime < ?", new Object[]{nodeId, now});
    }

    @Override
    public void deleteByNodeId(Integer nodeId) {
        this.getHibernateTemplate().bulkUpdate("delete from LldpLink lldpLink where lldpLink.node.id = ? ", new Object[]{nodeId});
    }

    @Override
    public void deleteAll() {
        this.getHibernateTemplate().bulkUpdate("delete from LldpLink");
    }

    @Override
    public List<LldpLink> findLinksForIds(List<Integer> linkIds) {
        StringBuilder sql = new StringBuilder();
        sql.append("FROM LldpLink lldplink ");
        if (linkIds.size() == 1) {
            sql.append("WHERE lldplink.id = ").append(linkIds.get(0)).append(" ");
        } else {
            sql.append("where lldplink.id in (");
            int counter = 0;
            for (Integer id : linkIds) {
                sql.append(id);
                if (counter < linkIds.size() - 1) {
                    sql.append(",");
                }
                ++counter;
            }
            sql.append(")");
        }
        return this.find(sql.toString());
    }

    @Override
    public Integer getIfIndex(Integer nodeid, String portId) {
        Assert.notNull((Object)nodeid, (String)"nodeId may not be null");
        Assert.notNull((Object)portId, (String)"portId may not be null");
        List ifaces = this.getHibernateTemplate().find("SELECT snmpIf FROM OnmsSnmpInterface AS snmpIf WHERE snmpIf.node.id = ? AND (LOWER(snmpIf.ifDescr) = LOWER(?) OR LOWER(snmpIf.ifName) = LOWER(?) OR snmpIf.physAddr = ?)", new Object[]{nodeid, portId, portId, portId});
        if (ifaces.size() == 1) {
            return ((OnmsSnmpInterface)ifaces.iterator().next()).getIfIndex();
        }
        ifaces = this.getHibernateTemplate().find("SELECT ipIf FROM OnmsIpInterface AS ipIf WHERE ipIf.node.id = ? AND ipIf.ipAddress = ?", new Object[]{nodeid, portId});
        if (ifaces.size() == 1) {
            OnmsIpInterface ipif = (OnmsIpInterface)ifaces.iterator().next();
            if (ipif.getSnmpInterface() != null) {
                ifaces = this.getHibernateTemplate().find("SELECT snmpIf FROM OnmsSnmpInterface AS snmpIf WHERE snmpIf.id = ?)", (Object)ipif.getSnmpInterface().getId());
            }
            if (ifaces.size() == 1) {
                return ((OnmsSnmpInterface)ifaces.iterator().next()).getIfIndex();
            }
        }
        return -1;
    }
}

