/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic.agg;

import org.opennms.netmgt.flows.api.Conversation;
import org.opennms.netmgt.flows.api.ConversationKey;
import org.opennms.netmgt.flows.api.Host;
import org.opennms.netmgt.flows.processing.ConversationKeyUtils;

public class Types {
    private static final String AGG_TOPK = "TOPK";
    private static final String AGG_TOTAL = "TOTAL";
    public static final ApplicationType APPLICATION = new ApplicationType();
    public static final ConversationType CONVERSATION = new ConversationType();
    public static final HostType HOST = new HostType();
    public static final DscpType DSCP = new DscpType();

    public static class ApplicationType
    implements Type<String> {
        public static final String UNKNOWN_APPLICATION_NAME_DISPLAY = "Unknown";
        public static final String OTHER_APPLICATION_NAME_DISPLAY = "Other";

        @Override
        public String getKey() {
            return "application";
        }

        @Override
        public String toEntity(String key) {
            if ("__unknown".equals(key)) {
                return UNKNOWN_APPLICATION_NAME_DISPLAY;
            }
            return key;
        }

        @Override
        public String getAggregationType() {
            return Types.AGG_TOPK;
        }

        @Override
        public String getOtherEntity() {
            return OTHER_APPLICATION_NAME_DISPLAY;
        }
    }

    public static class ConversationType
    implements Type<Conversation> {
        public static final Conversation OTHER = Conversation.forOther().build();

        @Override
        public String getKey() {
            return "conversation_key";
        }

        @Override
        public Conversation toEntity(String conversationKey) {
            return Conversation.from((ConversationKey)ConversationKeyUtils.fromJsonString((String)conversationKey)).build();
        }

        @Override
        public String getAggregationType() {
            return Types.AGG_TOPK;
        }

        @Override
        public Conversation getOtherEntity() {
            return OTHER;
        }
    }

    public static class HostType
    implements Type<Host> {
        public static final Host OTHER = Host.forOther().build();

        @Override
        public String getKey() {
            return "host_address";
        }

        @Override
        public Host toEntity(String host) {
            return Host.from((String)host).build();
        }

        @Override
        public String getAggregationType() {
            return Types.AGG_TOPK;
        }

        @Override
        public Host getOtherEntity() {
            return OTHER;
        }
    }

    public static class DscpType
    implements Type<String> {
        public static final String OTHER_DSCP_NAME_DISPLAY = "Other";

        @Override
        public String getKey() {
            return "dscp";
        }

        @Override
        public String toEntity(String key) {
            return key;
        }

        @Override
        public String getAggregationType() {
            return Types.AGG_TOTAL;
        }

        @Override
        public String getOtherEntity() {
            return OTHER_DSCP_NAME_DISPLAY;
        }
    }

    public static interface Type<T> {
        public String getKey();

        public T toEntity(String var1);

        public T getOtherEntity();

        public String getAggregationType();
    }
}

