/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.samplewrite;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.integration.api.v1.timeseries.Tag;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableMetric;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableSample;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableTag;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.PersistException;
import org.opennms.netmgt.collection.api.PersistOperationBuilder;
import org.opennms.netmgt.collection.api.ResourceIdentifier;
import org.opennms.netmgt.collection.api.TimeKeeper;
import org.opennms.netmgt.collection.support.DefaultTimeKeeper;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.timeseries.samplewrite.TimeseriesWriter;
import org.opennms.netmgt.timeseries.util.TimeseriesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeseriesPersistOperationBuilder
implements PersistOperationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TimeseriesPersistOperationBuilder.class);
    private final TimeseriesWriter writer;
    private final RrdRepository rrepository;
    private final String groupName;
    private final ResourceIdentifier resource;
    private final Map<CollectionAttributeType, Number> declarations = Maps.newLinkedHashMap();
    private final Set<Tag> configuredAdditionalMetaTags;
    private final Map<ResourcePath, Map<String, String>> stringAttributesByPath;
    private final Map<Set<Tag>, Map<String, String>> stringAttributesByResourceIdAndName = Maps.newLinkedHashMap();
    private final Timer commitTimer;
    private TimeKeeper timeKeeper = new DefaultTimeKeeper();

    public TimeseriesPersistOperationBuilder(TimeseriesWriter writer, RrdRepository repository, ResourceIdentifier resource, String groupName, Set<Tag> configuredAdditionalMetaTags, Map<ResourcePath, Map<String, String>> stringAttributesByPath, MetricRegistry metricRegistry) {
        this.writer = writer;
        this.rrepository = repository;
        this.resource = resource;
        this.groupName = groupName;
        this.configuredAdditionalMetaTags = configuredAdditionalMetaTags;
        this.stringAttributesByPath = stringAttributesByPath;
        this.commitTimer = metricRegistry.timer("samples.write.integration");
    }

    public String getName() {
        return this.groupName;
    }

    public void setAttributeValue(CollectionAttributeType attributeType, Number value) {
        this.declarations.put(attributeType, value);
    }

    public void persistStringAttribute(ResourcePath path, String key, String value) {
        Map stringAttributesForPath = this.stringAttributesByPath.computeIfAbsent(path, k -> Maps.newLinkedHashMap());
        stringAttributesForPath.put(key, value);
    }

    public void persistStringAttributeForMetricLevel(ResourcePath path, String metricName, String key, String value) {
        HashSet intrinsicTags = Sets.newHashSet((Object[])new Tag[]{new ImmutableTag("resourceId", TimeseriesUtils.toResourceId(path)), new ImmutableTag("name", metricName)});
        Map stringAttributesForPath = this.stringAttributesByResourceIdAndName.computeIfAbsent(intrinsicTags, k -> Maps.newLinkedHashMap());
        stringAttributesForPath.put(key, value);
    }

    public void setAttributeMetadata(String metricIdentifier, String name) {
        throw new UnsupportedOperationException("Should never be called. We made a mistake!");
    }

    public void commit() throws PersistException {
        try (Timer.Context context = this.commitTimer.time();){
            this.writer.insert(this.getSamplesToInsert());
        }
    }

    public List<Sample> getSamplesToInsert() {
        HashSet resourceIdLevelExternalData = Sets.newHashSet();
        LinkedList samples = Lists.newLinkedList();
        ResourcePath path = ResourceTypeUtils.getResourcePathWithRepository((RrdRepository)this.rrepository, (ResourcePath)ResourcePath.get((ResourcePath)this.resource.getPath(), (String[])new String[]{this.groupName}));
        HashMap stringAttributes = new HashMap();
        ResourcePath p = path;
        while (p.hasParent()) {
            Map<String, String> attributes = this.stringAttributesByPath.get(p = p.getParent());
            if (attributes == null) continue;
            stringAttributes.putAll(attributes);
        }
        for (Map.Entry entry : stringAttributes.entrySet()) {
            resourceIdLevelExternalData.add(new ImmutableTag((String)entry.getKey(), (String)entry.getValue()));
        }
        String resourceId = TimeseriesUtils.toResourceId(path);
        Instant time = Instant.ofEpochMilli(this.timeKeeper.getCurrentTime());
        for (Map.Entry<CollectionAttributeType, Number> entry : this.declarations.entrySet()) {
            Number value;
            CollectionAttributeType attrType = entry.getKey();
            Tag type = this.typeToTag(attrType.getType());
            if (type == null || (value = entry.getValue()) == null) continue;
            ImmutableMetric.MetricBuilder builder = ImmutableMetric.builder().intrinsicTag("resourceId", resourceId).intrinsicTag("name", attrType.getName()).metaTag(type);
            this.configuredAdditionalMetaTags.forEach(arg_0 -> ((ImmutableMetric.MetricBuilder)builder).metaTag(arg_0));
            resourceIdLevelExternalData.forEach(arg_0 -> ((ImmutableMetric.MetricBuilder)builder).externalTag(arg_0));
            Map<String, String> metricLevelAttributes = this.stringAttributesByResourceIdAndName.get(builder.build().getIntrinsicTags());
            if (metricLevelAttributes != null) {
                for (Map.Entry<String, String> entry2 : this.stringAttributesByResourceIdAndName.get(builder.build().getIntrinsicTags()).entrySet()) {
                    builder.externalTag(entry2.getKey(), entry2.getValue());
                }
            }
            ImmutableMetric metric = builder.build();
            Double sampleValue = value.doubleValue();
            samples.add(ImmutableSample.builder().metric((Metric)metric).time(time).value(sampleValue).build());
        }
        return samples;
    }

    private Tag typeToTag(AttributeType type) {
        Metric.Mtype mtype;
        if (type == AttributeType.COUNTER) {
            mtype = Metric.Mtype.count;
        } else if (type == AttributeType.GAUGE) {
            mtype = Metric.Mtype.gauge;
        } else {
            if (type == AttributeType.STRING) {
                return null;
            }
            mtype = Metric.Mtype.gauge;
        }
        return new ImmutableTag("mtype", mtype.name());
    }

    public void setTimeKeeper(TimeKeeper timeKeeper) {
        this.timeKeeper = timeKeeper;
    }
}

