/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.ValueType;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.accessor.Evaluator;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.mvel.evaluators.AfterEvaluatorDefinition;
import org.drools.mvel.evaluators.BeforeEvaluatorDefinition;
import org.drools.mvel.evaluators.MeetsEvaluatorDefinition;
import org.drools.mvel.evaluators.MetByEvaluatorDefinition;

public class VariableRestriction {
    private VariableRestriction() {
    }

    public static VariableContextEntry createContextEntry(ReadAccessor fieldExtractor, Declaration declaration, Evaluator evaluator) {
        ValueType coerced = evaluator.getCoercedValueType();
        if (evaluator.isTemporal()) {
            if (evaluator instanceof BeforeEvaluatorDefinition.BeforeEvaluator || evaluator instanceof MeetsEvaluatorDefinition.MeetsEvaluator) {
                return new LeftStartRightEndContextEntry(fieldExtractor, declaration, evaluator);
            }
            if (evaluator instanceof AfterEvaluatorDefinition.AfterEvaluator || evaluator instanceof MetByEvaluatorDefinition.MetByEvaluator) {
                return new LeftEndRightStartContextEntry(fieldExtractor, declaration, evaluator);
            }
            return new TemporalVariableContextEntry(fieldExtractor, declaration, evaluator);
        }
        if (coerced.isBoolean()) {
            return new BooleanVariableContextEntry(fieldExtractor, declaration, evaluator);
        }
        if (coerced.isDecimalNumber()) {
            return new DoubleVariableContextEntry(fieldExtractor, declaration, evaluator);
        }
        if (coerced.isIntegerNumber() || coerced.isEvent()) {
            return new LongVariableContextEntry(fieldExtractor, declaration, evaluator);
        }
        if (coerced.isChar()) {
            return new CharVariableContextEntry(fieldExtractor, declaration, evaluator);
        }
        return new ObjectVariableContextEntry(fieldExtractor, declaration, evaluator);
    }

    public static class TemporalVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 510L;
        public long startTS;
        public long endTS;

        public TemporalVariableContextEntry() {
        }

        public TemporalVariableContextEntry(ReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.startTS = in.readLong();
            this.endTS = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.startTS);
            out.writeLong(this.startTS);
        }

        public void updateFromTuple(ReteEvaluator reteEvaluator, Tuple tuple) {
            this.tuple = tuple;
            this.reteEvaluator = reteEvaluator;
            if (this.declaration.getExtractor().isSelfReference()) {
                EventFactHandle efh = (EventFactHandle)tuple.get(this.declaration);
                this.startTS = efh.getStartTimestamp();
                this.endTS = efh.getEndTimestamp();
            } else {
                this.leftNull = this.declaration.getExtractor().isNullValue(reteEvaluator, tuple.getObject(this.declaration));
                this.startTS = !this.leftNull ? this.declaration.getExtractor().getLongValue(reteEvaluator, tuple.getObject(this.declaration)) : 0L;
                this.endTS = this.startTS;
            }
        }

        public void updateFromFactHandle(ReteEvaluator reteEvaluator, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.reteEvaluator = reteEvaluator;
            if (this.extractor.isSelfReference()) {
                this.startTS = ((EventFactHandle)handle).getStartTimestamp();
                this.endTS = ((EventFactHandle)handle).getEndTimestamp();
            } else {
                this.rightNull = this.extractor.isNullValue(reteEvaluator, handle.getObject());
                this.startTS = !this.rightNull ? this.extractor.getLongValue(reteEvaluator, handle.getObject()) : 0L;
                this.endTS = this.startTS;
            }
        }
    }

    public static class LeftEndRightStartContextEntry
    extends TimestampedContextEntry {
        private static final long serialVersionUID = 510L;

        public LeftEndRightStartContextEntry() {
        }

        public LeftEndRightStartContextEntry(ReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        protected long getTimestampFromTuple(Tuple tuple) {
            return ((EventFactHandle)tuple.get(this.declaration)).getEndTimestamp();
        }

        @Override
        protected long getTimestampFromFactHandle(InternalFactHandle handle) {
            return ((EventFactHandle)handle).getStartTimestamp();
        }
    }

    public static class LeftStartRightEndContextEntry
    extends TimestampedContextEntry {
        private static final long serialVersionUID = 510L;

        public LeftStartRightEndContextEntry() {
        }

        public LeftStartRightEndContextEntry(ReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        protected long getTimestampFromTuple(Tuple tuple) {
            return ((EventFactHandle)tuple.get(this.declaration)).getStartTimestamp();
        }

        @Override
        protected long getTimestampFromFactHandle(InternalFactHandle handle) {
            return ((EventFactHandle)handle).getEndTimestamp();
        }
    }

    public static abstract class TimestampedContextEntry
    extends VariableContextEntry {
        public long timestamp;

        public TimestampedContextEntry() {
        }

        public TimestampedContextEntry(ReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.timestamp = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.timestamp);
        }

        protected abstract long getTimestampFromTuple(Tuple var1);

        protected abstract long getTimestampFromFactHandle(InternalFactHandle var1);

        public void updateFromTuple(ReteEvaluator reteEvaluator, Tuple tuple) {
            this.tuple = tuple;
            this.reteEvaluator = reteEvaluator;
            if (this.declaration.getExtractor().isSelfReference()) {
                this.timestamp = this.getTimestampFromTuple(tuple);
            } else {
                this.leftNull = this.declaration.getExtractor().isNullValue(reteEvaluator, tuple.getObject(this.declaration));
                this.timestamp = !this.leftNull ? this.declaration.getExtractor().getLongValue(reteEvaluator, tuple.getObject(this.declaration)) : 0L;
            }
        }

        public void updateFromFactHandle(ReteEvaluator reteEvaluator, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.reteEvaluator = reteEvaluator;
            if (this.extractor.isSelfReference()) {
                this.timestamp = this.getTimestampFromFactHandle(handle);
            } else {
                this.rightNull = this.extractor.isNullValue(reteEvaluator, handle.getObject());
                this.timestamp = !this.rightNull ? this.extractor.getLongValue(reteEvaluator, handle.getObject()) : 0L;
            }
        }
    }

    public static class BooleanVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 510L;
        public boolean left;
        public boolean right;

        public BooleanVariableContextEntry() {
        }

        public BooleanVariableContextEntry(ReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readBoolean();
            this.right = in.readBoolean();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeBoolean(this.left);
            out.writeBoolean(this.right);
        }

        public void updateFromTuple(ReteEvaluator reteEvaluator, Tuple tuple) {
            this.tuple = tuple;
            this.reteEvaluator = reteEvaluator;
            this.leftNull = this.declaration.getExtractor().isNullValue(reteEvaluator, tuple.getObject(this.declaration));
            this.left = !this.leftNull && this.declaration.getExtractor().getBooleanValue(reteEvaluator, tuple.getObject(this.declaration));
        }

        public void updateFromFactHandle(ReteEvaluator reteEvaluator, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.reteEvaluator = reteEvaluator;
            this.rightNull = this.extractor.isNullValue(reteEvaluator, handle.getObject());
            this.right = !this.rightNull && this.extractor.getBooleanValue(reteEvaluator, handle.getObject());
        }
    }

    public static class DoubleVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 510L;
        public double left;
        public double right;

        public DoubleVariableContextEntry() {
        }

        public DoubleVariableContextEntry(ReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readDouble();
            this.right = in.readDouble();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeDouble(this.left);
            out.writeDouble(this.right);
        }

        public void updateFromTuple(ReteEvaluator reteEvaluator, Tuple tuple) {
            this.tuple = tuple;
            this.reteEvaluator = reteEvaluator;
            this.leftNull = this.declaration.getExtractor().isNullValue(reteEvaluator, tuple.getObject(this.declaration));
            this.left = !this.leftNull ? this.declaration.getExtractor().getDoubleValue(reteEvaluator, tuple.getObject(this.declaration)) : 0.0;
        }

        public void updateFromFactHandle(ReteEvaluator reteEvaluator, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.reteEvaluator = reteEvaluator;
            this.rightNull = this.extractor.isNullValue(reteEvaluator, handle.getObject());
            this.right = !this.rightNull ? this.extractor.getDoubleValue(reteEvaluator, handle.getObject()) : 0.0;
        }
    }

    public static class CharVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 510L;
        public char left;
        public char right;

        public CharVariableContextEntry() {
        }

        public CharVariableContextEntry(ReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readChar();
            this.right = in.readChar();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeChar(this.left);
            out.writeChar(this.right);
        }

        public void updateFromTuple(ReteEvaluator reteEvaluator, Tuple tuple) {
            this.tuple = tuple;
            this.reteEvaluator = reteEvaluator;
            this.leftNull = this.declaration.getExtractor().isNullValue(reteEvaluator, tuple.getObject(this.declaration));
            this.left = !this.leftNull ? this.declaration.getExtractor().getCharValue(reteEvaluator, tuple.getObject(this.declaration)) : (char)'\u0000';
        }

        public void updateFromFactHandle(ReteEvaluator reteEvaluator, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.reteEvaluator = reteEvaluator;
            this.rightNull = this.extractor.isNullValue(reteEvaluator, handle.getObject());
            this.right = !this.rightNull ? this.extractor.getCharValue(reteEvaluator, handle.getObject()) : (char)'\u0000';
        }
    }

    public static class LongVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 510L;
        public long left;
        public long right;

        public LongVariableContextEntry() {
        }

        public LongVariableContextEntry(ReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readLong();
            this.right = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.left);
            out.writeLong(this.right);
        }

        public void updateFromTuple(ReteEvaluator reteEvaluator, Tuple tuple) {
            this.tuple = tuple;
            this.reteEvaluator = reteEvaluator;
            this.leftNull = this.declaration.getExtractor().isNullValue(reteEvaluator, tuple.getObject(this.declaration));
            this.left = !this.leftNull ? this.declaration.getExtractor().getLongValue(reteEvaluator, tuple.getObject(this.declaration)) : 0L;
        }

        public void updateFromFactHandle(ReteEvaluator reteEvaluator, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.reteEvaluator = reteEvaluator;
            this.rightNull = this.extractor.isNullValue(reteEvaluator, handle.getObject());
            this.right = !this.rightNull ? this.extractor.getLongValue(reteEvaluator, handle.getObject()) : 0L;
        }
    }

    public static class ObjectVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 510L;
        public Object left;
        public Object right;

        public ObjectVariableContextEntry() {
        }

        public ObjectVariableContextEntry(ReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readObject();
            this.right = in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.left);
            out.writeObject(this.right);
        }

        public void updateFromTuple(ReteEvaluator reteEvaluator, Tuple tuple) {
            this.tuple = tuple;
            this.reteEvaluator = reteEvaluator;
            this.leftNull = this.declaration.getExtractor().isNullValue(reteEvaluator, tuple.getObject(this.declaration));
            this.left = this.declaration.getExtractor().getValue(reteEvaluator, tuple.getObject(this.declaration));
        }

        public void updateFromFactHandle(ReteEvaluator reteEvaluator, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.reteEvaluator = reteEvaluator;
            this.rightNull = this.extractor.isNullValue(reteEvaluator, handle.getObject());
            this.right = this.extractor.getValue(reteEvaluator, handle.getObject());
        }

        @Override
        public void resetTuple() {
            this.left = null;
            this.tuple = null;
        }

        @Override
        public void resetFactHandle() {
            this.right = null;
            this.object = null;
        }
    }

    public static abstract class VariableContextEntry
    implements ContextEntry {
        public ReadAccessor extractor;
        public Evaluator evaluator;
        public Object object;
        public Declaration declaration;
        public Tuple tuple;
        public ContextEntry entry;
        public boolean leftNull;
        public boolean rightNull;
        public ReteEvaluator reteEvaluator;

        public VariableContextEntry() {
        }

        public VariableContextEntry(ReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            this.extractor = extractor;
            this.declaration = declaration;
            this.evaluator = evaluator;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.reteEvaluator = (ReteEvaluator)in.readObject();
            this.extractor = (ReadAccessor)in.readObject();
            this.evaluator = (Evaluator)in.readObject();
            this.object = in.readObject();
            this.declaration = (Declaration)in.readObject();
            this.tuple = (Tuple)in.readObject();
            this.entry = (ContextEntry)in.readObject();
            this.leftNull = in.readBoolean();
            this.rightNull = in.readBoolean();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.reteEvaluator);
            out.writeObject(this.extractor);
            out.writeObject(this.evaluator);
            out.writeObject(this.object);
            out.writeObject(this.declaration);
            out.writeObject(this.tuple);
            out.writeObject(this.entry);
            out.writeBoolean(this.leftNull);
            out.writeBoolean(this.rightNull);
        }

        public ContextEntry getNext() {
            return this.entry;
        }

        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        public ReadAccessor getFieldExtractor() {
            return this.extractor;
        }

        public Object getObject() {
            return this.object;
        }

        public Tuple getTuple() {
            return this.tuple;
        }

        public Declaration getVariableDeclaration() {
            return this.declaration;
        }

        public boolean isLeftNull() {
            return this.leftNull;
        }

        public boolean isRightNull() {
            return this.rightNull;
        }

        public void resetTuple() {
            this.tuple = null;
        }

        public void resetFactHandle() {
            this.object = null;
        }
    }
}

