/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.status.api.application;

import java.util.List;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.status.api.AbstractStatusService;
import org.opennms.features.status.api.Query;
import org.opennms.features.status.api.StatusEntity;
import org.opennms.features.status.api.StatusEntityWrapper;
import org.opennms.features.status.api.StatusSummary;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.ApplicationStatus;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.utils.CriteriaBuilderUtils;
import org.opennms.web.utils.QueryParameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApplicationStatusService
extends AbstractStatusService<OnmsApplication, Query> {
    @Autowired
    private ApplicationDao applicationDao;

    @Override
    protected CriteriaBuilder getCriteriaBuilder(QueryParameters queryParameters) {
        return CriteriaBuilderUtils.buildFrom(OnmsApplication.class, (QueryParameters)queryParameters);
    }

    @Override
    protected int countMatching(Criteria criteria) {
        return this.applicationDao.countMatching(criteria);
    }

    public StatusSummary getSummary() {
        List<ApplicationStatus> statusList = this.getApplicationStatus();
        List<OnmsSeverity> severityList = statusList.stream().map(status -> status.getSeverity()).collect(Collectors.toList());
        long applicationCount = this.applicationDao.countAll();
        return new StatusSummary(severityList, applicationCount);
    }

    @Override
    protected List<StatusEntity<OnmsApplication>> findMatching(Query query, CriteriaBuilder criteriaBuilder) {
        List applications = this.applicationDao.findMatching(criteriaBuilder.toCriteria());
        List<ApplicationStatus> applicationStatus = this.getApplicationStatus(applications);
        List<StatusEntity<OnmsApplication>> collect = applicationStatus.stream().map(status -> new StatusEntityWrapper<OnmsApplication>(status.getApplication(), status.getSeverity())).collect(Collectors.toList());
        return collect;
    }

    private List<ApplicationStatus> getApplicationStatus() {
        return this.getApplicationStatus(this.applicationDao.findAll());
    }

    private List<ApplicationStatus> getApplicationStatus(List<OnmsApplication> applications) {
        return this.applicationDao.getApplicationStatus(applications);
    }
}

