/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.requisition.command;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.EventSubscriptionService;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.provision.requisition.command.ProviderTypeNameCompleter;

@Command(scope="opennms", name="import-requisition", description="Sends an 'uei.opennms.org/internal/importer/reloadImport' event to import the requisition from a given url parameter")
@Service
public class ImportRequisition
implements Action {
    public static final String EVENT_SOURCE = "karaf-shell";
    public static final String URI_SCHEME = "requisition";
    @Reference
    private EventForwarder eventForwarder;
    @Reference
    private EventSubscriptionService eventSubscriptionService;
    @Option(name="-w", aliases={"--wait"}, description="Wait for completion event")
    private Boolean wait = false;
    @Option(name="-r", aliases={"--rescan"}, description="Specify rescanExisting value, valid values : 'true', 'false', 'dbonly'")
    private String rescanExisting;
    @Argument(index=0, name="type", description="Type of import handler", required=true)
    @Completion(value=ProviderTypeNameCompleter.class)
    private String type;
    @Argument(index=1, name="parameters", description="Provide parameters in key=value form", multiValued=true)
    private List<String> parameters = new LinkedList<String>();

    public Object execute() throws Exception {
        return ImportRequisition.sendImportRequisitionEvent(this.eventForwarder, this.type, this.parameters, this.rescanExisting, this.wait, this.eventSubscriptionService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object sendImportRequisitionEvent(EventForwarder eventForwarder, String type, List<String> parameters, String rescanExisting, boolean wait, EventSubscriptionService eventSubscriptionService) throws URISyntaxException {
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/importer/reloadImport", EVENT_SOURCE);
        URIBuilder builder = new URIBuilder().setScheme(URI_SCHEME).setHost(type);
        ImportRequisition.parse(parameters, builder);
        String url = builder.build().toString();
        eventBuilder.addParam("url", url);
        if (!Strings.isNullOrEmpty((String)rescanExisting)) {
            List<String> validValues = Arrays.asList("true", "false", "dbonly");
            if (validValues.contains(rescanExisting)) {
                eventBuilder.addParam("importRescanExisting", rescanExisting);
            } else {
                System.out.printf("Not a valid rescanExisting value, valid values are: %s\n", validValues);
                return null;
            }
        }
        ImportEventListener importEventListener = new ImportEventListener(url);
        if (wait) {
            eventSubscriptionService.addEventListener((EventListener)importEventListener, ImportEventListener.UEIS);
        }
        eventForwarder.sendNow(eventBuilder.getEvent());
        System.out.printf("Requisition import triggered asynchronously for URL:\n\t%s\n", url);
        if (wait) {
            try {
                while (!importEventListener.isDone()) {
                    try {
                        Thread.sleep(1000L);
                        System.out.print(".");
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if ("uei.opennms.org/internal/importer/importSuccessful".equals(importEventListener.getReceivedUei())) {
                    System.out.printf("\nImport succeeded.\n", new Object[0]);
                } else {
                    System.out.printf("\nImport failed.\n", new Object[0]);
                }
            }
            finally {
                eventSubscriptionService.removeEventListener((EventListener)importEventListener);
            }
        }
        return null;
    }

    private static void parse(List<String> attributeList, URIBuilder builder) {
        if (attributeList != null) {
            for (String keyValue : attributeList) {
                int splitAt = keyValue.indexOf("=");
                if (splitAt <= 0) {
                    throw new IllegalArgumentException("Invalid property " + keyValue);
                }
                String key = keyValue.substring(0, splitAt);
                String value = keyValue.substring(splitAt + 1, keyValue.length());
                builder.addParameter(key, value);
            }
        }
    }

    static class ImportEventListener
    implements EventListener {
        public static final List<String> UEIS = Lists.newArrayList((Object[])new String[]{"uei.opennms.org/internal/importer/importSuccessful", "uei.opennms.org/internal/importer/importFailed"});
        private String importResource;
        private String receivedUei;

        ImportEventListener(String importResource) {
            this.importResource = ImportEventListener.stripCredentials(importResource);
        }

        static String stripCredentials(String string) {
            if (string == null) {
                return null;
            }
            return string.replaceAll("(username=)[^;&]*(;&)?", "$1***$2").replaceAll("(password=)[^;&]*(;&)?", "$1***$2");
        }

        public String getName() {
            return "ImportRequisition-eventListener";
        }

        String getReceivedUei() {
            return this.receivedUei;
        }

        public void onEvent(IEvent e) {
            if (!e.getParm("importResource").getValue().getContent().contains(this.importResource)) {
                return;
            }
            if (e.getUei().equals("uei.opennms.org/internal/importer/importSuccessful") || e.getUei().equals("uei.opennms.org/internal/importer/importFailed")) {
                this.receivedUei = e.getUei();
            }
        }

        boolean isDone() {
            return this.receivedUei != null;
        }
    }
}

