/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRHibernateAbstractDataSource;
import net.sf.jasperreports.engine.query.JRHibernateQueryExecuter;

public class JRHibernateListDataSource
extends JRHibernateAbstractDataSource
implements JRRewindableDataSource {
    private final int pageSize;
    private int pageCount;
    private boolean nextPage;
    private List<?> returnValues;
    private Iterator<?> iterator;

    public JRHibernateListDataSource(JRHibernateQueryExecuter queryExecuter, boolean useFieldDescription, int pageSize) {
        super(queryExecuter, useFieldDescription, false);
        this.pageSize = pageSize;
        this.pageCount = 0;
        this.fetchPage();
    }

    protected void fetchPage() {
        if (this.pageSize <= 0) {
            this.returnValues = this.queryExecuter.list();
            this.nextPage = false;
        } else {
            this.returnValues = this.queryExecuter.list(this.pageCount * this.pageSize, this.pageSize);
            this.nextPage = this.returnValues.size() == this.pageSize;
        }
        ++this.pageCount;
        this.initIterator();
    }

    @Override
    public boolean next() {
        if (this.iterator == null) {
            return false;
        }
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext && this.nextPage) {
            this.fetchPage();
            boolean bl = hasNext = this.iterator != null && this.iterator.hasNext();
        }
        if (hasNext) {
            this.setCurrentRowValue(this.iterator.next());
        }
        return hasNext;
    }

    @Override
    public void moveFirst() {
        if (this.pageCount == 1) {
            this.initIterator();
        } else {
            this.pageCount = 0;
            this.fetchPage();
        }
    }

    private void initIterator() {
        this.iterator = this.returnValues == null ? null : this.returnValues.iterator();
    }
}

