/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.blueprint.generator;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.xbean.blueprint.generator.AttributeMapping;
import org.apache.xbean.blueprint.generator.MapMapping;

public class ElementMapping
implements Comparable {
    private final String namespace;
    private final String elementName;
    private final String className;
    private final String description;
    private final boolean rootElement;
    private final String initMethod;
    private final String destroyMethod;
    private final String factoryMethod;
    private final String contentProperty;
    private final Set attributes;
    private final Map attributesByName;
    private final List constructors;
    private final List flatProperties;
    private final Map maps;
    private final Map flatCollections;
    private final List superClasses;
    private final HashSet interfaces;

    public ElementMapping(String namespace, String elementName, String className, String description, boolean rootElement, String initMethod, String destroyMethod, String factoryMethod, String contentProperty, Set attributes, List constructors, List flatProperties, Map maps, Map flatCollections, List superClasses, HashSet interfaces) {
        this.superClasses = superClasses;
        this.interfaces = interfaces;
        if (namespace == null) {
            throw new NullPointerException("namespace");
        }
        if (elementName == null) {
            throw new NullPointerException("elementName");
        }
        if (className == null) {
            throw new NullPointerException("className");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes");
        }
        if (constructors == null) {
            throw new NullPointerException("constructors");
        }
        this.namespace = namespace;
        this.elementName = elementName;
        this.className = className;
        this.description = description;
        this.rootElement = rootElement;
        this.initMethod = initMethod;
        this.destroyMethod = destroyMethod;
        this.factoryMethod = factoryMethod;
        this.contentProperty = contentProperty;
        this.constructors = constructors;
        this.attributes = Collections.unmodifiableSet(new TreeSet(attributes));
        this.maps = Collections.unmodifiableMap(maps);
        this.flatProperties = Collections.unmodifiableList(flatProperties);
        this.flatCollections = Collections.unmodifiableMap(flatCollections);
        HashMap<String, AttributeMapping> attributesByName = new HashMap<String, AttributeMapping>();
        for (AttributeMapping attribute : attributes) {
            attributesByName.put(attribute.getAttributeName(), attribute);
        }
        this.attributesByName = Collections.unmodifiableMap(attributesByName);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRootElement() {
        return this.rootElement;
    }

    public String getInitMethod() {
        return this.initMethod;
    }

    public String getDestroyMethod() {
        return this.destroyMethod;
    }

    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    public String getContentProperty() {
        return this.contentProperty;
    }

    public Set getAttributes() {
        return this.attributes;
    }

    public AttributeMapping getAttribute(String attributeName) {
        return (AttributeMapping)this.attributesByName.get(attributeName);
    }

    public Map getMapMappings() {
        return this.maps;
    }

    public MapMapping getMapMapping(String name) {
        return (MapMapping)this.maps.get(name);
    }

    public Map getFlatCollections() {
        return this.flatCollections;
    }

    public List getFlatProperties() {
        return this.flatProperties;
    }

    public List getConstructors() {
        return this.constructors;
    }

    public int hashCode() {
        return this.elementName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ElementMapping) {
            return this.elementName.equals(((ElementMapping)obj).elementName);
        }
        return false;
    }

    public int compareTo(Object obj) {
        return this.elementName.compareTo(((ElementMapping)obj).elementName);
    }

    public HashSet getInterfaces() {
        return this.interfaces;
    }

    public List getSuperClasses() {
        return this.superClasses;
    }
}

