/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.NodeCollectionGroupOspf;
import org.opennms.netmgt.enlinkd.common.NodeCollector;
import org.opennms.netmgt.enlinkd.model.OspfArea;
import org.opennms.netmgt.enlinkd.model.OspfElement;
import org.opennms.netmgt.enlinkd.model.OspfIf;
import org.opennms.netmgt.enlinkd.model.OspfLink;
import org.opennms.netmgt.enlinkd.service.api.Node;
import org.opennms.netmgt.enlinkd.service.api.OspfTopologyService;
import org.opennms.netmgt.enlinkd.snmp.OspfAreaTableTracker;
import org.opennms.netmgt.enlinkd.snmp.OspfGeneralGroupTracker;
import org.opennms.netmgt.enlinkd.snmp.OspfIfTableTracker;
import org.opennms.netmgt.enlinkd.snmp.OspfIpAddrTableGetter;
import org.opennms.netmgt.enlinkd.snmp.OspfNbrTableTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryOspf
extends NodeCollector {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryOspf.class);
    private final OspfTopologyService m_ospfTopologyService;

    public NodeDiscoveryOspf(NodeCollectionGroupOspf group, Node node, int priority) {
        super(group.getLocationAwareSnmpClient(), node, priority);
        this.m_ospfTopologyService = group.getOspfTopologyService();
    }

    public void collect() {
        Date now = new Date();
        SnmpAgentConfig peer = this.getSnmpAgentConfig();
        OspfIpAddrTableGetter ipAddrTableGetter = new OspfIpAddrTableGetter(peer, this.getLocationAwareSnmpClient(), this.getLocation());
        OspfGeneralGroupTracker ospfGeneralGroup = new OspfGeneralGroupTracker();
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)ospfGeneralGroup).withDescription("ospfGeneralGroup").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: ospf mib not supported {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: ospf mib not supported {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        if (ospfGeneralGroup.getOspfRouterId() == null) {
            LOG.info("run: node[{}]: ospf mib not supported", (Object)this.getNodeId());
            return;
        }
        if (ospfGeneralGroup.getOspfRouterId().equals(InetAddressUtils.addr((String)"0.0.0.0"))) {
            LOG.info("run: node[{}]: ospf mib not supported not valid ospf identifier 0.0.0.0", (Object)this.getNodeId());
            return;
        }
        if (OspfElement.Status.get((Integer)ospfGeneralGroup.getOspfAdminStat()) == OspfElement.Status.disabled) {
            LOG.info("run: node[{}]: ospf mib not supported ospf status: disabled", (Object)this.getNodeId());
            return;
        }
        this.m_ospfTopologyService.store(this.getNodeId(), ipAddrTableGetter.get(ospfGeneralGroup.getOspfElement()));
        final ArrayList links = new ArrayList();
        OspfNbrTableTracker ospfNbrTableTracker = new OspfNbrTableTracker(){

            @Override
            public void processOspfNbrRow(OspfNbrTableTracker.OspfNbrRow row) {
                links.add(row.getOspfLink());
            }
        };
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)ospfNbrTableTracker).withDescription("ospfNbrTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        final ArrayList<OspfIf> localOspfPorts = new ArrayList<OspfIf>();
        final ArrayList portsNeedingLookup = new ArrayList();
        OspfIfTableTracker ospfIfTableTracker = new OspfIfTableTracker(){

            @Override
            public void processOspfIfRow(OspfIfTableTracker.OspfIfRow row) {
                if (row.getOspfIf().getOspfIfAddressLessIf() != 0) {
                    localOspfPorts.add(row.getOspfIf());
                } else {
                    portsNeedingLookup.add(row.getOspfIf());
                }
            }
        };
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)ospfIfTableTracker).withDescription("ospfIfTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        for (OspfIf ospfIf : portsNeedingLookup) {
            try {
                localOspfPorts.add(ipAddrTableGetter.get(ospfIf));
            }
            catch (Exception e) {
                LOG.warn("run: node [{}]: failed to lookup IP for OSPF interface: {}", new Object[]{this.getNodeId(), e.getMessage(), e});
            }
        }
        for (OspfLink link : links) {
            for (OspfIf localospfport : localOspfPorts) {
                if (localospfport.getOspfIfAddressLessIf() != 0 && link.getOspfRemAddressLessIndex() != 0) {
                    link.setOspfIpAddr(localospfport.getOspfIfIpaddress());
                    link.setOspfAddressLessIndex(localospfport.getOspfIfAddressLessIf());
                    link.setOspfIfIndex(localospfport.getOspfIfAddressLessIf());
                    link.setOspfIfAreaId(localospfport.getOspfIfAreaId());
                    break;
                }
                if (localospfport.getOspfIfAddressLessIf() == 0 && link.getOspfRemAddressLessIndex() != 0 || localospfport.getOspfIfAddressLessIf() != 0 && link.getOspfRemAddressLessIndex() == 0 || !InetAddressUtils.inSameNetwork((InetAddress)localospfport.getOspfIfIpaddress(), (InetAddress)link.getOspfRemIpAddr(), (InetAddress)localospfport.getOspfIfNetmask())) continue;
                link.setOspfIpAddr(localospfport.getOspfIfIpaddress());
                link.setOspfAddressLessIndex(localospfport.getOspfIfAddressLessIf());
                link.setOspfIfAreaId(localospfport.getOspfIfAreaId());
                link.setOspfIpMask(localospfport.getOspfIfNetmask());
                link.setOspfIfIndex(localospfport.getOspfIfIfindex());
                break;
            }
            this.m_ospfTopologyService.store(this.getNodeId(), link);
        }
        final ArrayList areas = new ArrayList();
        OspfAreaTableTracker ospfAreaTableTracker = new OspfAreaTableTracker(){

            @Override
            public void processOspfAreaRow(OspfAreaTableTracker.OspfAreaRow row) {
                areas.add(row.getOspfArea());
            }
        };
        try {
            this.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)ospfAreaTableTracker).withDescription("ospfAreaTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.debug("run: node [{}]: ExecutionException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.debug("run: node [{}]: InterruptedException: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        for (OspfArea area : areas) {
            this.m_ospfTopologyService.store(this.getNodeId(), area);
        }
        this.m_ospfTopologyService.reconcile(this.getNodeId(), now);
    }

    public String getName() {
        return "NodeDiscoveryOspf";
    }
}

