/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.dao.common.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import org.opennms.core.xml.AbstractWritableJaxbConfigDao;
import org.opennms.netmgt.config.dao.common.api.SaveableConfigContainer;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class FileSystemSaveableConfigContainer<T>
implements SaveableConfigContainer<T> {
    private final ConfigDao proxyConfigDao;

    public FileSystemSaveableConfigContainer(Class<T> clazz, String configName, Collection<Consumer<T>> onConfigChangeCallbacks, File configFile) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(configName);
        Objects.requireNonNull(configFile);
        this.proxyConfigDao = new ConfigDao(clazz, configName);
        if (onConfigChangeCallbacks != null) {
            onConfigChangeCallbacks.forEach(arg_0 -> ((ConfigDao)this.proxyConfigDao).addOnReloadedCallback(arg_0));
        }
        this.proxyConfigDao.setConfigResource((Resource)new FileSystemResource(configFile));
        this.proxyConfigDao.afterPropertiesSet();
    }

    public void saveConfig() {
        try {
            this.proxyConfigDao.saveCurrent();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reload() {
        this.proxyConfigDao.update();
    }

    public T getConfig() {
        this.getReadLock().lock();
        try {
            Object object = this.proxyConfigDao.getContainer().getObject();
            return (T)object;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public Lock getReadLock() {
        return this.proxyConfigDao.getReadLock();
    }

    public Lock getWriteLock() {
        return this.proxyConfigDao.getWriteLock();
    }

    private class ConfigDao
    extends AbstractWritableJaxbConfigDao<T, T> {
        public ConfigDao(Class<T> entityClass, String description) {
            super(entityClass, description);
        }

        protected T translateConfig(T config) {
            return config;
        }
    }
}

