/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet.attribute.value;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import net.jradius.log.RadiusLog;
import net.jradius.util.Hex;

public abstract class AttributeValue
implements Serializable {
    private static final long serialVersionUID = 0L;

    public abstract void getBytes(OutputStream var1) throws IOException;

    public abstract void getBytes(ByteBuffer var1);

    public void getBytes(ByteBuffer buffer, int valueOffset, int valueLength) {
        this.getBytes(buffer);
    }

    public byte[] getBytes() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.getBytes(out);
            out.close();
        }
        catch (Exception e) {
            RadiusLog.error(e.getMessage(), e);
        }
        return out.toByteArray();
    }

    public int getLength() {
        return 0;
    }

    public Serializable getValueObject() {
        return null;
    }

    public abstract void setValue(byte[] var1);

    public abstract void setValue(byte[] var1, int var2, int var3);

    public abstract void setValueObject(Serializable var1);

    public abstract void copy(AttributeValue var1);

    public void setValue(String s) {
        if (s.startsWith("0x")) {
            this.setValue(Hex.hexStringToByteArray(s.substring(2)));
        } else {
            this.setValue(s.getBytes());
        }
    }

    public String toString() {
        return "[Binary Data]";
    }

    public String toDebugString() {
        return this.toString();
    }

    public String toXMLString() {
        return "";
    }
}

