/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.jdbc;

import java.util.regex.Pattern;
import org.opennms.netmgt.provision.detector.jdbc.AbstractJdbcDetector;
import org.opennms.netmgt.provision.detector.jdbc.request.JDBCRequest;
import org.opennms.netmgt.provision.detector.jdbc.response.JDBCResponse;
import org.opennms.netmgt.provision.support.RequestBuilder;
import org.opennms.netmgt.provision.support.ResponseValidator;

public class JdbcStoredProcedureDetector
extends AbstractJdbcDetector {
    private static final String DEFAULT_STORED_PROCEDURE = "isRunning";
    private static final String DEFAULT_SCHEMA = "test";
    private String m_storedProcedure;
    private String m_schema = "test";

    public JdbcStoredProcedureDetector() {
        super("JdbcStoredProcedureDetector", 3306);
        this.setSchema(DEFAULT_SCHEMA);
        this.setStoredProcedure(DEFAULT_STORED_PROCEDURE);
    }

    protected void onInit() {
        this.expectBanner(JdbcStoredProcedureDetector.resultSetNotNull());
        this.send(JdbcStoredProcedureDetector.storedProcedure(this.createProcedureCall(this.getSchema(), this.getStoredProcedure())), JdbcStoredProcedureDetector.isValidProcedureCall());
    }

    private static ResponseValidator<JDBCResponse> isValidProcedureCall() {
        return new ResponseValidator<JDBCResponse>(){

            public boolean validate(JDBCResponse response) {
                return response.isValidProcedureCall();
            }
        };
    }

    private static RequestBuilder<JDBCRequest> storedProcedure(final String storedProcedure) {
        return new RequestBuilder<JDBCRequest>(){

            public JDBCRequest getRequest() {
                JDBCRequest request = new JDBCRequest();
                request.setStoredProcedure(storedProcedure);
                return request;
            }
        };
    }

    private String createProcedureCall(String schema, String procedure) {
        if (schema != null) {
            return String.format("%s.%s", schema, procedure);
        }
        return procedure;
    }

    public void setStoredProcedure(String storedProcedure) {
        if (!this.isValidProcedureName(storedProcedure)) {
            throw new IllegalArgumentException(String.format("%s is not a valid procedure name", storedProcedure));
        }
        this.m_storedProcedure = storedProcedure;
    }

    private boolean isValidProcedureName(String procedure) {
        return Pattern.matches("^[0-9a-zA-Z_]*$", procedure);
    }

    public String getStoredProcedure() {
        return this.m_storedProcedure;
    }

    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    public String getSchema() {
        return this.m_schema;
    }
}

