/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.shell.internal;

import com.eclipsesource.jaxrs.publisher.api.ApplicationRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="rest", name="list-providers", description="List all providers and features")
@Service
public class ListProviderAndFeatureCommand
implements Action {
    @Reference
    private ApplicationRegistry applicationRegistry;

    public Object execute() throws Exception {
        System.out.println("List all providers");
        List applicationDTOList = this.applicationRegistry.getAllApplications();
        if (applicationDTOList.isEmpty()) {
            System.out.println("No providers found");
        } else {
            applicationDTOList.stream().map(a -> {
                Set features = a.getFeatures();
                Set providers = a.getProviders();
                HashSet combined = new HashSet();
                combined.addAll(features);
                combined.addAll(providers);
                return combined;
            }).flatMap(s -> s.stream()).forEach(s -> System.out.println(s));
        }
        return null;
    }
}

