/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.security.SaslFrameBody;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.Attach;
import org.apache.qpid.proton.amqp.transport.Begin;
import org.apache.qpid.proton.amqp.transport.Close;
import org.apache.qpid.proton.amqp.transport.ConnectionError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.Detach;
import org.apache.qpid.proton.amqp.transport.Disposition;
import org.apache.qpid.proton.amqp.transport.End;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.Flow;
import org.apache.qpid.proton.amqp.transport.FrameBody;
import org.apache.qpid.proton.amqp.transport.Open;
import org.apache.qpid.proton.amqp.transport.Role;
import org.apache.qpid.proton.amqp.transport.Transfer;
import org.apache.qpid.proton.codec.AMQPDefinedTypes;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.ProtonJTransport;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Ssl;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.SslPeerDetails;
import org.apache.qpid.proton.engine.TransportDecodeException;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.TransportResult;
import org.apache.qpid.proton.engine.TransportResultFactory;
import org.apache.qpid.proton.engine.impl.AmqpHeader;
import org.apache.qpid.proton.engine.impl.ByteBufferUtils;
import org.apache.qpid.proton.engine.impl.ConnectionImpl;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.engine.impl.EndpointImpl;
import org.apache.qpid.proton.engine.impl.FrameHandler;
import org.apache.qpid.proton.engine.impl.FrameParser;
import org.apache.qpid.proton.engine.impl.FrameWriter;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.engine.impl.ReceiverImpl;
import org.apache.qpid.proton.engine.impl.Ref;
import org.apache.qpid.proton.engine.impl.SaslImpl;
import org.apache.qpid.proton.engine.impl.SenderImpl;
import org.apache.qpid.proton.engine.impl.SessionImpl;
import org.apache.qpid.proton.engine.impl.StringUtils;
import org.apache.qpid.proton.engine.impl.TransportDelivery;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.engine.impl.TransportLayer;
import org.apache.qpid.proton.engine.impl.TransportLink;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.TransportOutputAdaptor;
import org.apache.qpid.proton.engine.impl.TransportOutputWriter;
import org.apache.qpid.proton.engine.impl.TransportSender;
import org.apache.qpid.proton.engine.impl.TransportSession;
import org.apache.qpid.proton.engine.impl.TransportWrapper;
import org.apache.qpid.proton.engine.impl.ssl.SslImpl;
import org.apache.qpid.proton.framing.TransportFrame;
import org.apache.qpid.proton.reactor.Reactor;
import org.apache.qpid.proton.reactor.Selectable;

public class TransportImpl
extends EndpointImpl
implements ProtonJTransport,
FrameBody.FrameBodyHandler<Integer>,
FrameHandler,
TransportOutputWriter,
TransportInternal {
    static final int BUFFER_RELEASE_THRESHOLD = Integer.getInteger("proton.transport_buffer_release_threshold", 0x200000);
    private static final int CHANNEL_MAX_LIMIT = 65535;
    private static final boolean FRM_ENABLED = TransportImpl.getBooleanEnv("PN_TRACE_FRM");
    private static final int TRACE_FRAME_PAYLOAD_LENGTH = Integer.getInteger("proton.trace_frame_payload_length", 1024);
    private static final String HEADER_DESCRIPTION = "AMQP";
    private int _levels = FRM_ENABLED ? 2 : 0;
    private FrameParser _frameParser;
    private ConnectionImpl _connectionEndpoint;
    private boolean _isOpenSent;
    private boolean _isCloseSent;
    private boolean _headerWritten;
    private Map<Integer, TransportSession> _remoteSessions = new HashMap<Integer, TransportSession>();
    private Map<Integer, TransportSession> _localSessions = new HashMap<Integer, TransportSession>();
    private TransportInput _inputProcessor;
    private TransportOutput _outputProcessor;
    private DecoderImpl _decoder = new DecoderImpl();
    private EncoderImpl _encoder = new EncoderImpl(this._decoder);
    private int _maxFrameSize = -1;
    private int _remoteMaxFrameSize = 512;
    private int _outboundFrameSizeLimit = 0;
    private int _channelMax = 65535;
    private int _remoteChannelMax = 65535;
    private final FrameWriter _frameWriter;
    private boolean _closeReceived;
    private Open _open;
    private SaslImpl _sasl;
    private SslImpl _ssl;
    private final Ref<ProtocolTracer> _protocolTracer = new Ref<Object>(null);
    private TransportResult _lastTransportResult = TransportResultFactory.ok();
    private boolean _init;
    private boolean _processingStarted;
    private boolean _emitFlowEventOnSend = true;
    private boolean _useReadOnlyOutputBuffer = true;
    private FrameHandler _frameHandler = this;
    private boolean _head_closed = false;
    private boolean _conditionSet;
    private boolean postedHeadClosed = false;
    private boolean postedTailClosed = false;
    private boolean postedTransportError = false;
    private int _localIdleTimeout = 0;
    private int _remoteIdleTimeout = 0;
    private long _bytesInput = 0L;
    private long _bytesOutput = 0L;
    private long _localIdleDeadline = 0L;
    private long _lastBytesInput = 0L;
    private long _lastBytesOutput = 0L;
    private long _remoteIdleDeadline = 0L;
    private Selectable _selectable;
    private Reactor _reactor;
    private List<TransportLayer> _additionalTransportLayers;
    private final Disposition cachedDisposition = new Disposition();
    private final Flow cachedFlow = new Flow();
    private final Transfer cachedTransfer = new Transfer();
    static String INCOMING = "<-";
    static String OUTGOING = "->";

    private static final boolean getBooleanEnv(String name) {
        String value = System.getenv(name);
        return "true".equalsIgnoreCase(value) || "1".equals(value) || "yes".equalsIgnoreCase(value);
    }

    public TransportImpl() {
        this(-1);
    }

    TransportImpl(int maxFrameSize) {
        AMQPDefinedTypes.registerAllTypes(this._decoder, this._encoder);
        this._maxFrameSize = maxFrameSize;
        this._frameWriter = new FrameWriter(this._encoder, this._remoteMaxFrameSize, 0, this);
    }

    private void init() {
        if (!this._init) {
            this._init = true;
            this._frameParser = new FrameParser(this._frameHandler, this._decoder, this._maxFrameSize, this);
            this._inputProcessor = this._frameParser;
            this._outputProcessor = new TransportOutputAdaptor(this, this._maxFrameSize, this.isUseReadOnlyOutputBuffer());
        }
    }

    @Override
    public void trace(int levels) {
        this._levels = levels;
    }

    @Override
    public int getMaxFrameSize() {
        return this._maxFrameSize;
    }

    @Override
    public int getRemoteMaxFrameSize() {
        return this._remoteMaxFrameSize;
    }

    @Override
    public void setInitialRemoteMaxFrameSize(int remoteMaxFrameSize) {
        if (this._init) {
            throw new IllegalStateException("Cannot set initial remote max frame size after transport has been initialised");
        }
        this._remoteMaxFrameSize = remoteMaxFrameSize;
    }

    @Override
    public void setMaxFrameSize(int maxFrameSize) {
        if (this._init) {
            throw new IllegalStateException("Cannot set max frame size after transport has been initialised");
        }
        this._maxFrameSize = maxFrameSize;
    }

    @Override
    public int getChannelMax() {
        return this._channelMax;
    }

    @Override
    public void setChannelMax(int channelMax) {
        if (this._isOpenSent) {
            throw new IllegalArgumentException("Cannot change channel max after open frame has been sent");
        }
        if (channelMax < 0 || channelMax >= 65536) {
            throw new NumberFormatException("Value \"" + channelMax + "\" lies outside the range [0-" + 65536 + ").");
        }
        this._channelMax = channelMax;
    }

    @Override
    public int getRemoteChannelMax() {
        return this._remoteChannelMax;
    }

    @Override
    public ErrorCondition getCondition() {
        ErrorCondition errorCondition = super.getCondition();
        return this.isConditionPopulated(errorCondition) ? errorCondition : null;
    }

    @Override
    public void setCondition(ErrorCondition error) {
        super.setCondition(error);
        this._conditionSet = this.isConditionPopulated(error);
    }

    private boolean isConditionPopulated(ErrorCondition error) {
        return error != null && error.getCondition() != null;
    }

    @Override
    public void bind(Connection conn) {
        this._connectionEndpoint = (ConnectionImpl)conn;
        this.put(Event.Type.CONNECTION_BOUND, conn);
        this._connectionEndpoint.setTransport(this);
        this._connectionEndpoint.incref();
        if (this.getRemoteState() != EndpointState.UNINITIALIZED) {
            this._connectionEndpoint.handleOpen(this._open);
            if (this.getRemoteState() == EndpointState.CLOSED) {
                this._connectionEndpoint.setRemoteState(EndpointState.CLOSED);
            }
            this._frameParser.flush();
        }
    }

    @Override
    public void unbind() {
        for (TransportSession ts : this._localSessions.values()) {
            ts.unbind();
        }
        for (TransportSession ts : this._remoteSessions.values()) {
            ts.unbind();
        }
        this.put(Event.Type.CONNECTION_UNBOUND, this._connectionEndpoint);
        this._connectionEndpoint.modifyEndpoints();
        this._connectionEndpoint.setTransport(null);
        this._connectionEndpoint.decref();
    }

    @Override
    public int input(byte[] bytes, int offset, int length) {
        this.oldApiCheckStateBeforeInput(length).checkIsOk();
        ByteBuffer inputBuffer = this.getInputBuffer();
        int numberOfBytesConsumed = ByteBufferUtils.pourArrayToBuffer(bytes, offset, length, inputBuffer);
        this.processInput().checkIsOk();
        return numberOfBytesConsumed;
    }

    public TransportResult oldApiCheckStateBeforeInput(int inputLength) {
        this._lastTransportResult.checkIsOk();
        if (inputLength == 0 && (this._connectionEndpoint == null || this._connectionEndpoint.getRemoteState() != EndpointState.CLOSED)) {
            return TransportResultFactory.error(new TransportException("Unexpected EOS when remote connection not closed: connection aborted"));
        }
        return TransportResultFactory.ok();
    }

    @Override
    public int output(byte[] bytes, int offset, int size) {
        ByteBuffer outputBuffer = this.getOutputBuffer();
        int numberOfBytesOutput = ByteBufferUtils.pourBufferToArray(outputBuffer, bytes, offset, size);
        this.outputConsumed();
        return numberOfBytesOutput;
    }

    @Override
    public boolean writeInto(ByteBuffer outputBuffer) {
        this.processHeader();
        this.processOpen();
        this.processBegin();
        this.processAttach();
        this.processReceiverFlow();
        this.processTransportWork();
        this.processTransportWork();
        this.processSenderFlow();
        this.processDetach();
        this.processEnd();
        this.processClose();
        this._frameWriter.readBytes(outputBuffer);
        return this._isCloseSent || this._head_closed;
    }

    @Override
    public Sasl sasl() {
        if (this._sasl == null) {
            if (this._processingStarted) {
                throw new IllegalStateException("Sasl can't be initiated after transport has started processing");
            }
            this.init();
            this._sasl = new SaslImpl(this, this._remoteMaxFrameSize);
            TransportWrapper transportWrapper = this._sasl.wrap(this._inputProcessor, this._outputProcessor);
            this._inputProcessor = transportWrapper;
            this._outputProcessor = transportWrapper;
        }
        return this._sasl;
    }

    @Override
    public Ssl ssl(SslDomain sslDomain, SslPeerDetails sslPeerDetails) {
        if (this._ssl == null) {
            this.init();
            this._ssl = new SslImpl(sslDomain, sslPeerDetails);
            TransportWrapper transportWrapper = this._ssl.wrap(this._inputProcessor, this._outputProcessor);
            this._inputProcessor = transportWrapper;
            this._outputProcessor = transportWrapper;
        }
        return this._ssl;
    }

    @Override
    public Ssl ssl(SslDomain sslDomain) {
        return this.ssl(sslDomain, null);
    }

    private void processDetach() {
        if (this._connectionEndpoint != null && this._isOpenSent) {
            EndpointImpl endpoint = this._connectionEndpoint.getTransportHead();
            while (endpoint != null) {
                if (endpoint instanceof LinkImpl) {
                    LinkImpl link = (LinkImpl)endpoint;
                    TransportLink<?> transportLink = this.getTransportState(link);
                    SessionImpl session = link.getSession();
                    TransportSession transportSession = this.getTransportState(session);
                    if ((link.getLocalState() == EndpointState.CLOSED || link.detached()) && transportLink.isLocalHandleSet() && transportSession.isLocalChannelSet() && !this._isCloseSent) {
                        if (link instanceof SenderImpl && link.getQueued() > 0 && !transportLink.detachReceived() && !transportSession.endReceived() && !this._closeReceived) {
                            endpoint = endpoint.transportNext();
                            continue;
                        }
                        UnsignedInteger localHandle = transportLink.getLocalHandle();
                        transportLink.clearLocalHandle();
                        transportSession.freeLocalHandle(localHandle);
                        Detach detach = new Detach();
                        detach.setHandle(localHandle);
                        detach.setClosed(!link.detached());
                        ErrorCondition localError = link.getCondition();
                        if (localError.getCondition() != null) {
                            detach.setError(localError);
                        }
                        this.writeFrame(transportSession.getLocalChannel(), detach, null, null);
                    }
                    endpoint.clearModified();
                }
                endpoint = endpoint.transportNext();
            }
        }
    }

    private void writeFlow(TransportSession ssn, TransportLink link) {
        this.cachedFlow.setNextIncomingId(ssn.getNextIncomingId());
        this.cachedFlow.setNextOutgoingId(ssn.getNextOutgoingId());
        ssn.updateIncomingWindow();
        this.cachedFlow.setIncomingWindow(ssn.getIncomingWindowSize());
        this.cachedFlow.setOutgoingWindow(ssn.getOutgoingWindowSize());
        this.cachedFlow.setProperties(null);
        if (link != null) {
            this.cachedFlow.setHandle(link.getLocalHandle());
            this.cachedFlow.setDeliveryCount(link.getDeliveryCount());
            this.cachedFlow.setLinkCredit(link.getLinkCredit());
            this.cachedFlow.setDrain(((LinkImpl)link.getLink()).getDrain());
        } else {
            this.cachedFlow.setHandle(null);
            this.cachedFlow.setDeliveryCount(null);
            this.cachedFlow.setLinkCredit(null);
            this.cachedFlow.setDrain(false);
        }
        this.writeFrame(ssn.getLocalChannel(), this.cachedFlow, null, null);
    }

    private void processSenderFlow() {
        if (this._connectionEndpoint != null && this._isOpenSent && !this._isCloseSent) {
            for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null; endpoint = endpoint.transportNext()) {
                SenderImpl sender;
                if (!(endpoint instanceof SenderImpl) || !(sender = (SenderImpl)endpoint).getDrain() || sender.getDrained() <= 0) continue;
                TransportSender transportLink = sender.getTransportLink();
                TransportSession transportSession = sender.getSession().getTransportSession();
                UnsignedInteger credits = transportLink.getLinkCredit();
                transportLink.setLinkCredit(UnsignedInteger.ZERO);
                transportLink.setDeliveryCount(transportLink.getDeliveryCount().add(credits));
                sender.setDrained(0);
                this.writeFlow(transportSession, transportLink);
            }
        }
    }

    private void processTransportWork() {
        if (this._connectionEndpoint != null && this._isOpenSent && !this._isCloseSent) {
            DeliveryImpl delivery = this._connectionEndpoint.getTransportWorkHead();
            while (delivery != null) {
                LinkImpl link = delivery.getLink();
                if (link instanceof SenderImpl) {
                    if (this.processTransportWorkSender(delivery, (SenderImpl)link)) {
                        delivery = delivery.clearTransportWork();
                        continue;
                    }
                    delivery = delivery.getTransportWorkNext();
                    continue;
                }
                if (this.processTransportWorkReceiver(delivery, (ReceiverImpl)link)) {
                    delivery = delivery.clearTransportWork();
                    continue;
                }
                delivery = delivery.getTransportWorkNext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processTransportWorkSender(DeliveryImpl delivery, SenderImpl snd) {
        TransportSender tpLink = snd.getTransportLink();
        SessionImpl session = snd.getSession();
        TransportSession tpSession = session.getTransportSession();
        boolean wasDone = delivery.isDone();
        if (!delivery.isDone() && (delivery.getDataLength() > 0 || delivery != snd.current()) && tpSession.hasOutgoingCredit() && tpLink.hasCredit() && tpSession.isLocalChannelSet() && tpLink.getLocalHandle() != null && !this._frameWriter.isFull()) {
            UnsignedInteger deliveryId;
            DeliveryImpl inProgress = tpLink.getInProgressDelivery();
            if (inProgress != null && inProgress != delivery) {
                return false;
            }
            TransportDelivery tpDelivery = delivery.getTransportDelivery();
            if (tpDelivery != null) {
                deliveryId = tpDelivery.getDeliveryId();
            } else {
                deliveryId = tpSession.getOutgoingDeliveryId();
                tpSession.incrementOutgoingDeliveryId();
            }
            tpDelivery = new TransportDelivery(deliveryId, delivery, tpLink);
            delivery.setTransportDelivery(tpDelivery);
            this.cachedTransfer.setDeliveryId(deliveryId);
            this.cachedTransfer.setDeliveryTag(new Binary(delivery.getTag()));
            this.cachedTransfer.setHandle(tpLink.getLocalHandle());
            this.cachedTransfer.setRcvSettleMode(null);
            this.cachedTransfer.setResume(false);
            this.cachedTransfer.setAborted(false);
            this.cachedTransfer.setBatchable(false);
            if (delivery.getLocalState() != null) {
                this.cachedTransfer.setState(delivery.getLocalState());
            } else {
                this.cachedTransfer.setState(null);
            }
            if (delivery.isSettled()) {
                this.cachedTransfer.setSettled(Boolean.TRUE);
            } else {
                this.cachedTransfer.setSettled(Boolean.FALSE);
                tpSession.addUnsettledOutgoing(deliveryId, delivery);
            }
            if (snd.current() == delivery) {
                this.cachedTransfer.setMore(true);
            } else {
                this.cachedTransfer.setMore(false);
            }
            int messageFormat = delivery.getMessageFormat();
            if (messageFormat == 0) {
                this.cachedTransfer.setMessageFormat(UnsignedInteger.ZERO);
            } else {
                this.cachedTransfer.setMessageFormat(UnsignedInteger.valueOf(messageFormat));
            }
            ReadableBuffer payload = delivery.getData();
            int pending = payload.remaining();
            try {
                this.writeFrame(tpSession.getLocalChannel(), this.cachedTransfer, payload, () -> this.cachedTransfer.setMore(true));
            }
            finally {
                delivery.afterSend();
            }
            tpSession.incrementOutgoingId();
            tpSession.decrementRemoteIncomingWindow();
            if (payload == null || !payload.hasRemaining()) {
                session.incrementOutgoingBytes(-pending);
                if (!this.cachedTransfer.getMore()) {
                    tpLink.setInProgressDelivery(null);
                    delivery.setDone();
                    tpLink.setDeliveryCount(tpLink.getDeliveryCount().add(UnsignedInteger.ONE));
                    tpLink.setLinkCredit(tpLink.getLinkCredit().subtract(UnsignedInteger.ONE));
                    session.incrementOutgoingDeliveries(-1);
                    snd.decrementQueued();
                }
            } else {
                session.incrementOutgoingBytes(-(pending - payload.remaining()));
                tpLink.setInProgressDelivery(delivery);
            }
            if (this._emitFlowEventOnSend && snd.getLocalState() != EndpointState.CLOSED) {
                this.getConnectionImpl().put(Event.Type.LINK_FLOW, snd);
            }
        }
        if (wasDone && delivery.getLocalState() != null) {
            TransportDelivery tpDelivery = delivery.getTransportDelivery();
            this.cachedDisposition.setFirst(tpDelivery.getDeliveryId());
            this.cachedDisposition.setLast(tpDelivery.getDeliveryId());
            this.cachedDisposition.setRole(Role.SENDER);
            this.cachedDisposition.setSettled(delivery.isSettled());
            this.cachedDisposition.setBatchable(false);
            if (delivery.isSettled()) {
                tpDelivery.settled();
            }
            this.cachedDisposition.setState(delivery.getLocalState());
            this.writeFrame(tpSession.getLocalChannel(), this.cachedDisposition, null, null);
        }
        return !delivery.isBuffered();
    }

    private boolean processTransportWorkReceiver(DeliveryImpl delivery, ReceiverImpl rcv) {
        TransportDelivery tpDelivery = delivery.getTransportDelivery();
        SessionImpl session = rcv.getSession();
        TransportSession tpSession = session.getTransportSession();
        if (tpSession.isLocalChannelSet()) {
            boolean settled = delivery.isSettled();
            DeliveryState localState = delivery.getLocalState();
            this.cachedDisposition.setFirst(tpDelivery.getDeliveryId());
            this.cachedDisposition.setLast(tpDelivery.getDeliveryId());
            this.cachedDisposition.setRole(Role.RECEIVER);
            this.cachedDisposition.setSettled(settled);
            this.cachedDisposition.setState(localState);
            this.cachedDisposition.setBatchable(false);
            if (localState == null && settled) {
                this.cachedDisposition.setState(delivery.getDefaultDeliveryState());
            }
            this.writeFrame(tpSession.getLocalChannel(), this.cachedDisposition, null, null);
            if (settled) {
                tpDelivery.settled();
            }
            return true;
        }
        return false;
    }

    private void processReceiverFlow() {
        if (this._connectionEndpoint != null && this._isOpenSent && !this._isCloseSent) {
            EndpointImpl endpoint;
            for (endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null; endpoint = endpoint.transportNext()) {
                int credits;
                if (!(endpoint instanceof ReceiverImpl)) continue;
                ReceiverImpl receiver = (ReceiverImpl)endpoint;
                TransportLink<?> transportLink = this.getTransportState(receiver);
                TransportSession transportSession = this.getTransportState(receiver.getSession());
                if (receiver.getLocalState() != EndpointState.ACTIVE || !transportSession.isLocalChannelSet() || receiver.detached() || (credits = receiver.clearUnsentCredits()) == 0 && !receiver.getDrain() && !transportSession.getIncomingWindowSize().equals(UnsignedInteger.ZERO)) continue;
                transportLink.addCredit(credits);
                this.writeFlow(transportSession, transportLink);
            }
            for (endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null; endpoint = endpoint.transportNext()) {
                if (!(endpoint instanceof SessionImpl)) continue;
                SessionImpl session = (SessionImpl)endpoint;
                TransportSession transportSession = this.getTransportState(session);
                if (session.getLocalState() != EndpointState.ACTIVE || !transportSession.isLocalChannelSet() || !transportSession.getIncomingWindowSize().equals(UnsignedInteger.ZERO)) continue;
                this.writeFlow(transportSession, null);
            }
        }
    }

    private void processAttach() {
        if (this._connectionEndpoint != null && this._isOpenSent && !this._isCloseSent) {
            for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null; endpoint = endpoint.transportNext()) {
                if (!(endpoint instanceof LinkImpl)) continue;
                LinkImpl link = (LinkImpl)endpoint;
                TransportLink<?> transportLink = this.getTransportState(link);
                SessionImpl session = link.getSession();
                TransportSession transportSession = this.getTransportState(session);
                if (link.getLocalState() == EndpointState.UNINITIALIZED || transportLink.attachSent() || !transportSession.isLocalChannelSet() || (link.getRemoteState() != EndpointState.ACTIVE || transportLink.isLocalHandleSet()) && link.getRemoteState() != EndpointState.UNINITIALIZED) continue;
                Role role = endpoint instanceof ReceiverImpl ? Role.RECEIVER : Role.SENDER;
                UnsignedInteger localHandle = transportSession.allocateLocalHandle(transportLink);
                if (link.getRemoteState() == EndpointState.UNINITIALIZED) {
                    transportSession.addHalfOpenLink(transportLink, Role.SENDER == role);
                }
                Attach attach = new Attach();
                attach.setHandle(localHandle);
                attach.setName(transportLink.getName());
                if (link.getSenderSettleMode() != null) {
                    attach.setSndSettleMode(link.getSenderSettleMode());
                }
                if (link.getReceiverSettleMode() != null) {
                    attach.setRcvSettleMode(link.getReceiverSettleMode());
                }
                if (link.getSource() != null) {
                    attach.setSource(link.getSource());
                }
                if (link.getTarget() != null) {
                    attach.setTarget(link.getTarget());
                }
                if (link.getProperties() != null) {
                    attach.setProperties(link.getProperties());
                }
                if (link.getOfferedCapabilities() != null) {
                    attach.setOfferedCapabilities(link.getOfferedCapabilities());
                }
                if (link.getDesiredCapabilities() != null) {
                    attach.setDesiredCapabilities(link.getDesiredCapabilities());
                }
                if (link.getMaxMessageSize() != null) {
                    attach.setMaxMessageSize(link.getMaxMessageSize());
                }
                attach.setRole(role);
                if (link instanceof SenderImpl) {
                    attach.setInitialDeliveryCount(UnsignedInteger.ZERO);
                }
                this.writeFrame(transportSession.getLocalChannel(), attach, null, null);
                transportLink.sentAttach();
            }
        }
    }

    private void processHeader() {
        if (!this._headerWritten) {
            this.outputHeaderDescription();
            this._frameWriter.writeHeader(AmqpHeader.HEADER);
            this._headerWritten = true;
        }
    }

    private void outputHeaderDescription() {
        if (this.isFrameTracingEnabled()) {
            this.log(OUTGOING, HEADER_DESCRIPTION);
            ProtocolTracer tracer = this.getProtocolTracer();
            if (tracer != null) {
                tracer.sentHeader(HEADER_DESCRIPTION);
            }
        }
    }

    private void processOpen() {
        if (!this._isOpenSent && (this._conditionSet || this._connectionEndpoint != null && this._connectionEndpoint.getLocalState() != EndpointState.UNINITIALIZED)) {
            Open open = new Open();
            if (this._connectionEndpoint != null) {
                String cid = this._connectionEndpoint.getLocalContainerId();
                open.setContainerId(cid == null ? "" : cid);
                open.setHostname(this._connectionEndpoint.getHostname());
                open.setDesiredCapabilities(this._connectionEndpoint.getDesiredCapabilities());
                open.setOfferedCapabilities(this._connectionEndpoint.getOfferedCapabilities());
                open.setProperties(this._connectionEndpoint.getProperties());
            } else {
                open.setContainerId("");
            }
            if (this._maxFrameSize > 0) {
                open.setMaxFrameSize(UnsignedInteger.valueOf(this._maxFrameSize));
            }
            if (this._channelMax > 0) {
                open.setChannelMax(UnsignedShort.valueOf((short)this._channelMax));
            }
            if (this._localIdleTimeout > 0) {
                open.setIdleTimeOut(new UnsignedInteger(this._localIdleTimeout / 2));
            }
            this._isOpenSent = true;
            this.writeFrame(0, open, null, null);
        }
    }

    private void processBegin() {
        if (this._connectionEndpoint != null && this._isOpenSent && !this._isCloseSent) {
            for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null; endpoint = endpoint.transportNext()) {
                if (!(endpoint instanceof SessionImpl)) continue;
                SessionImpl session = (SessionImpl)endpoint;
                TransportSession transportSession = this.getTransportState(session);
                if (session.getLocalState() == EndpointState.UNINITIALIZED || transportSession.beginSent()) continue;
                int channelId = this.allocateLocalChannel(transportSession);
                Begin begin = new Begin();
                if (session.getRemoteState() != EndpointState.UNINITIALIZED) {
                    begin.setRemoteChannel(UnsignedShort.valueOf((short)transportSession.getRemoteChannel()));
                }
                transportSession.updateIncomingWindow();
                begin.setHandleMax(transportSession.getHandleMax());
                begin.setIncomingWindow(transportSession.getIncomingWindowSize());
                begin.setOutgoingWindow(transportSession.getOutgoingWindowSize());
                begin.setNextOutgoingId(transportSession.getNextOutgoingId());
                if (session.getProperties() != null) {
                    begin.setProperties(session.getProperties());
                }
                if (session.getOfferedCapabilities() != null) {
                    begin.setOfferedCapabilities(session.getOfferedCapabilities());
                }
                if (session.getDesiredCapabilities() != null) {
                    begin.setDesiredCapabilities(session.getDesiredCapabilities());
                }
                this.writeFrame(channelId, begin, null, null);
                transportSession.sentBegin();
            }
        }
    }

    private TransportSession getTransportState(SessionImpl session) {
        TransportSession transportSession = session.getTransportSession();
        if (transportSession == null) {
            transportSession = new TransportSession(this, session);
            session.setTransportSession(transportSession);
        }
        return transportSession;
    }

    private TransportLink<?> getTransportState(LinkImpl link) {
        TransportLink<LinkImpl> transportLink = link.getTransportLink();
        if (transportLink == null) {
            transportLink = TransportLink.createTransportLink(link);
        }
        return transportLink;
    }

    private int allocateLocalChannel(TransportSession transportSession) {
        for (int i = 0; i < this._connectionEndpoint.getMaxChannels(); ++i) {
            if (this._localSessions.containsKey(i)) continue;
            this._localSessions.put(i, transportSession);
            transportSession.setLocalChannel(i);
            return i;
        }
        return -1;
    }

    private int freeLocalChannel(TransportSession transportSession) {
        int channel = transportSession.getLocalChannel();
        this._localSessions.remove(channel);
        transportSession.freeLocalChannel();
        return channel;
    }

    private void processEnd() {
        if (this._connectionEndpoint != null && this._isOpenSent) {
            EndpointImpl endpoint = this._connectionEndpoint.getTransportHead();
            while (endpoint != null) {
                if (endpoint instanceof SessionImpl) {
                    TransportSession transportSession;
                    SessionImpl session = (SessionImpl)endpoint;
                    if (session.getLocalState() == EndpointState.CLOSED && (transportSession = session.getTransportSession()).isLocalChannelSet() && !this._isCloseSent) {
                        if (this.hasSendableMessages(session)) {
                            endpoint = endpoint.transportNext();
                            continue;
                        }
                        int channel = this.freeLocalChannel(transportSession);
                        End end = new End();
                        ErrorCondition localError = endpoint.getCondition();
                        if (localError.getCondition() != null) {
                            end.setError(localError);
                        }
                        this.writeFrame(channel, end, null, null);
                    }
                    endpoint.clearModified();
                }
                endpoint = endpoint.transportNext();
            }
        }
    }

    private boolean hasSendableMessages(SessionImpl session) {
        if (this._connectionEndpoint == null) {
            return false;
        }
        if (!(this._closeReceived || session != null && session.getTransportSession().endReceived())) {
            for (EndpointImpl endpoint = this._connectionEndpoint.getTransportHead(); endpoint != null; endpoint = endpoint.transportNext()) {
                if (!(endpoint instanceof SenderImpl)) continue;
                SenderImpl sender = (SenderImpl)endpoint;
                if (session != null && sender.getSession() != session || sender.getQueued() == 0 || this.getTransportState(sender).detachReceived()) continue;
                return true;
            }
        }
        return false;
    }

    private void processClose() {
        if ((this._conditionSet || this._connectionEndpoint != null && this._connectionEndpoint.getLocalState() == EndpointState.CLOSED) && !this._isCloseSent && !this.hasSendableMessages(null)) {
            Close close = new Close();
            ErrorCondition localError = this._connectionEndpoint != null && this.isConditionPopulated(this._connectionEndpoint.getCondition()) ? this._connectionEndpoint.getCondition() : this.getCondition();
            if (this.isConditionPopulated(localError)) {
                close.setError(localError);
            }
            this._isCloseSent = true;
            this.writeFrame(0, close, null, null);
            if (this._connectionEndpoint != null) {
                this._connectionEndpoint.clearModified();
            }
        }
    }

    protected void writeFrame(int channel, FrameBody frameBody, ReadableBuffer payload, Runnable onPayloadTooLarge) {
        this._frameWriter.writeFrame(channel, frameBody, payload, onPayloadTooLarge);
    }

    @Override
    protected ConnectionImpl getConnectionImpl() {
        return this._connectionEndpoint;
    }

    @Override
    void postFinal() {
    }

    @Override
    void doFree() {
    }

    @Override
    public void handleOpen(Open open, Binary payload, Integer channel) {
        this.setRemoteState(EndpointState.ACTIVE);
        if (this._connectionEndpoint != null) {
            this._connectionEndpoint.handleOpen(open);
        } else {
            this._open = open;
        }
        int effectiveMaxFrameSize = this._remoteMaxFrameSize;
        if (open.getMaxFrameSize().longValue() > 0L) {
            this._remoteMaxFrameSize = (int)open.getMaxFrameSize().longValue();
            effectiveMaxFrameSize = (int)Math.min(open.getMaxFrameSize().longValue(), Integer.MAX_VALUE);
        }
        if (this._outboundFrameSizeLimit > 0) {
            effectiveMaxFrameSize = (int)Math.min(open.getMaxFrameSize().longValue(), (long)this._outboundFrameSizeLimit);
        }
        this._frameWriter.setMaxFrameSize(effectiveMaxFrameSize);
        if (open.getChannelMax().longValue() > 0L) {
            this._remoteChannelMax = (int)open.getChannelMax().longValue();
        }
        if (open.getIdleTimeOut() != null && open.getIdleTimeOut().longValue() > 0L) {
            this._remoteIdleTimeout = open.getIdleTimeOut().intValue();
        }
    }

    @Override
    public void handleBegin(Begin begin, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions.get(channel);
        if (transportSession == null) {
            SessionImpl session;
            if (begin.getRemoteChannel() == null) {
                session = this._connectionEndpoint.session();
                transportSession = this.getTransportState(session);
            } else {
                transportSession = this._localSessions.get(begin.getRemoteChannel().intValue());
                if (transportSession == null) {
                    throw new NullPointerException("uncorrelated channel: " + begin.getRemoteChannel());
                }
                session = transportSession.getSession();
            }
            transportSession.setRemoteChannel(channel);
            session.setRemoteState(EndpointState.ACTIVE);
            transportSession.setNextIncomingId(begin.getNextOutgoingId());
            session.setRemoteProperties(begin.getProperties());
            session.setRemoteDesiredCapabilities(begin.getDesiredCapabilities());
            session.setRemoteOfferedCapabilities(begin.getOfferedCapabilities());
            this._remoteSessions.put(channel, transportSession);
            this._connectionEndpoint.put(Event.Type.SESSION_REMOTE_OPEN, session);
        }
    }

    @Override
    public void handleAttach(Attach attach, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions.get(channel);
        if (transportSession != null) {
            SessionImpl session = transportSession.getSession();
            UnsignedInteger handle = attach.getHandle();
            if (handle.compareTo(transportSession.getHandleMax()) > 0) {
                ErrorCondition condition = new ErrorCondition(ConnectionError.FRAMING_ERROR, "handle-max exceeded");
                this._connectionEndpoint.setCondition(condition);
                this._connectionEndpoint.setLocalState(EndpointState.CLOSED);
                if (!this._isCloseSent) {
                    Close close = new Close();
                    close.setError(condition);
                    this._isCloseSent = true;
                    this.writeFrame(0, close, null, null);
                }
                this.close_tail();
                return;
            }
            TransportLink transportLink = transportSession.getLinkFromRemoteHandle(handle);
            LinkImpl link = null;
            if (transportLink == null) {
                transportLink = transportSession.resolveHalfOpenLink(attach.getName(), Role.RECEIVER == attach.getRole());
                if (transportLink == null) {
                    link = attach.getRole() == Role.RECEIVER ? session.sender(attach.getName()) : session.receiver(attach.getName());
                    transportLink = this.getTransportState(link);
                } else {
                    link = (LinkImpl)transportLink.getLink();
                }
                if (attach.getRole() == Role.SENDER) {
                    transportLink.setDeliveryCount(attach.getInitialDeliveryCount());
                }
                link.setRemoteState(EndpointState.ACTIVE);
                link.setRemoteSource(attach.getSource());
                link.setRemoteTarget(attach.getTarget());
                link.setRemoteReceiverSettleMode(attach.getRcvSettleMode());
                link.setRemoteSenderSettleMode(attach.getSndSettleMode());
                link.setRemoteProperties(attach.getProperties());
                link.setRemoteDesiredCapabilities(attach.getDesiredCapabilities());
                link.setRemoteOfferedCapabilities(attach.getOfferedCapabilities());
                link.setRemoteMaxMessageSize(attach.getMaxMessageSize());
                transportLink.setName(attach.getName());
                transportLink.setRemoteHandle(handle);
                transportSession.addLinkRemoteHandle(transportLink, handle);
            }
            this._connectionEndpoint.put(Event.Type.LINK_REMOTE_OPEN, link);
        }
    }

    @Override
    public void handleFlow(Flow flow, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions.get(channel);
        if (transportSession != null) {
            transportSession.handleFlow(flow);
        }
    }

    @Override
    public void handleTransfer(Transfer transfer, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions.get(channel);
        if (transportSession != null) {
            transportSession.handleTransfer(transfer, payload);
        }
    }

    @Override
    public void handleDisposition(Disposition disposition, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions.get(channel);
        if (transportSession != null) {
            transportSession.handleDisposition(disposition);
        }
    }

    @Override
    public void handleDetach(Detach detach, Binary payload, Integer channel) {
        TransportLink transportLink;
        TransportSession transportSession = this._remoteSessions.get(channel);
        if (transportSession != null && (transportLink = transportSession.getLinkFromRemoteHandle(detach.getHandle())) != null) {
            Object link = transportLink.getLink();
            transportLink.receivedDetach();
            transportSession.freeRemoteHandle(transportLink.getRemoteHandle());
            if (detach.getClosed()) {
                this._connectionEndpoint.put(Event.Type.LINK_REMOTE_CLOSE, link);
            } else {
                this._connectionEndpoint.put(Event.Type.LINK_REMOTE_DETACH, link);
            }
            transportLink.clearRemoteHandle();
            ((EndpointImpl)link).setRemoteState(EndpointState.CLOSED);
            if (detach.getError() != null) {
                ((EndpointImpl)link).getRemoteCondition().copyFrom(detach.getError());
            }
        }
    }

    @Override
    public void handleEnd(End end, Binary payload, Integer channel) {
        TransportSession transportSession = this._remoteSessions.get(channel);
        if (transportSession != null) {
            this._remoteSessions.remove(channel);
            transportSession.receivedEnd();
            transportSession.unsetRemoteChannel();
            SessionImpl session = transportSession.getSession();
            session.setRemoteState(EndpointState.CLOSED);
            ErrorCondition errorCondition = end.getError();
            if (errorCondition != null) {
                session.getRemoteCondition().copyFrom(errorCondition);
            }
            this._connectionEndpoint.put(Event.Type.SESSION_REMOTE_CLOSE, session);
        }
    }

    @Override
    public void handleClose(Close close, Binary payload, Integer channel) {
        this._closeReceived = true;
        this._remoteIdleTimeout = 0;
        this.setRemoteState(EndpointState.CLOSED);
        if (this._connectionEndpoint != null) {
            this._connectionEndpoint.setRemoteState(EndpointState.CLOSED);
            if (close.getError() != null) {
                this._connectionEndpoint.getRemoteCondition().copyFrom(close.getError());
            }
            this._connectionEndpoint.put(Event.Type.CONNECTION_REMOTE_CLOSE, this._connectionEndpoint);
        }
    }

    @Override
    public boolean handleFrame(TransportFrame frame) {
        if (!this.isHandlingFrames()) {
            throw new IllegalStateException("Transport cannot accept frame: " + frame);
        }
        this.log(INCOMING, frame);
        ProtocolTracer tracer = this._protocolTracer.get();
        if (tracer != null) {
            tracer.receivedFrame(frame);
        }
        frame.getBody().invoke(this, frame.getPayload(), frame.getChannel());
        return this._closeReceived;
    }

    void put(Event.Type type, Object context) {
        if (this._connectionEndpoint != null) {
            this._connectionEndpoint.put(type, context);
        }
    }

    private void maybePostClosed() {
        if (this.postedHeadClosed && this.postedTailClosed) {
            this.put(Event.Type.TRANSPORT_CLOSED, this);
        }
    }

    @Override
    public void closed(TransportException error) {
        if (!this._closeReceived || error != null) {
            if (!this._conditionSet) {
                if (error instanceof TransportDecodeException) {
                    this.setCondition(new ErrorCondition(AmqpError.DECODE_ERROR, error.getMessage()));
                } else {
                    String description = error == null ? "connection aborted" : error.toString();
                    this.setCondition(new ErrorCondition(ConnectionError.FRAMING_ERROR, description));
                }
            }
            this._head_closed = true;
        }
        if (this._conditionSet && !this.postedTransportError) {
            this.put(Event.Type.TRANSPORT_ERROR, this);
            this.postedTransportError = true;
        }
        if (!this.postedTailClosed) {
            this.put(Event.Type.TRANSPORT_TAIL_CLOSED, this);
            this.postedTailClosed = true;
            this.maybePostClosed();
        }
    }

    @Override
    public boolean isHandlingFrames() {
        return this._connectionEndpoint != null || this.getRemoteState() == EndpointState.UNINITIALIZED;
    }

    @Override
    public ProtocolTracer getProtocolTracer() {
        return this._protocolTracer.get();
    }

    @Override
    public void setProtocolTracer(ProtocolTracer protocolTracer) {
        this._protocolTracer.set(protocolTracer);
    }

    @Override
    public ByteBuffer getInputBuffer() {
        return this.tail();
    }

    @Override
    public TransportResult processInput() {
        try {
            this.process();
            return TransportResultFactory.ok();
        }
        catch (TransportException e) {
            return TransportResultFactory.error(e);
        }
    }

    @Override
    public ByteBuffer getOutputBuffer() {
        this.pending();
        return this.head();
    }

    @Override
    public void outputConsumed() {
        this.pop(this._outputProcessor.head().position());
    }

    @Override
    public int capacity() {
        this.init();
        return this._inputProcessor.capacity();
    }

    @Override
    public ByteBuffer tail() {
        this.init();
        return this._inputProcessor.tail();
    }

    @Override
    public void process() throws TransportException {
        this._processingStarted = true;
        try {
            this.init();
            int beforePosition = this._inputProcessor.position();
            this._inputProcessor.process();
            this._bytesInput += (long)(beforePosition - this._inputProcessor.position());
        }
        catch (TransportException e) {
            this._head_closed = true;
            throw e;
        }
    }

    @Override
    public void close_tail() {
        this.init();
        this._inputProcessor.close_tail();
    }

    @Override
    public int pending() {
        this.init();
        return this._outputProcessor.pending();
    }

    @Override
    public ByteBuffer head() {
        this.init();
        return this._outputProcessor.head();
    }

    @Override
    public void pop(int bytes) {
        this.init();
        this._outputProcessor.pop(bytes);
        this._bytesOutput += (long)bytes;
        int p = this.pending();
        if (p < 0 && !this.postedHeadClosed) {
            this.put(Event.Type.TRANSPORT_HEAD_CLOSED, this);
            this.postedHeadClosed = true;
            this.maybePostClosed();
        }
    }

    @Override
    public void setIdleTimeout(int timeout) {
        this._localIdleTimeout = timeout;
    }

    @Override
    public int getIdleTimeout() {
        return this._localIdleTimeout;
    }

    @Override
    public int getRemoteIdleTimeout() {
        return this._remoteIdleTimeout;
    }

    @Override
    public long tick(long now) {
        long deadline = 0L;
        if (this._localIdleTimeout > 0) {
            if (this._localIdleDeadline == 0L || this._lastBytesInput != this._bytesInput) {
                this._localIdleDeadline = this.computeDeadline(now, this._localIdleTimeout);
                this._lastBytesInput = this._bytesInput;
            } else if (this._localIdleDeadline - now <= 0L) {
                this._localIdleDeadline = this.computeDeadline(now, this._localIdleTimeout);
                if (this._connectionEndpoint != null && this._connectionEndpoint.getLocalState() != EndpointState.CLOSED) {
                    ErrorCondition condition = new ErrorCondition(Symbol.getSymbol("amqp:resource-limit-exceeded"), "local-idle-timeout expired");
                    this._connectionEndpoint.setCondition(condition);
                    this._connectionEndpoint.setLocalState(EndpointState.CLOSED);
                    if (!this._isOpenSent) {
                        if (this._sasl != null && !this._sasl.isDone()) {
                            this._sasl.fail();
                        }
                        Open open = new Open();
                        this._isOpenSent = true;
                        this.writeFrame(0, open, null, null);
                    }
                    if (!this._isCloseSent) {
                        Close close = new Close();
                        close.setError(condition);
                        this._isCloseSent = true;
                        this.writeFrame(0, close, null, null);
                    }
                    this.close_tail();
                }
            }
            deadline = this._localIdleDeadline;
        }
        if (this._remoteIdleTimeout != 0 && !this._isCloseSent) {
            if (this._remoteIdleDeadline == 0L || this._lastBytesOutput != this._bytesOutput) {
                this._remoteIdleDeadline = this.computeDeadline(now, this._remoteIdleTimeout / 2);
                this._lastBytesOutput = this._bytesOutput;
            } else if (this._remoteIdleDeadline - now <= 0L) {
                this._remoteIdleDeadline = this.computeDeadline(now, this._remoteIdleTimeout / 2);
                if (this.pending() == 0) {
                    this.writeFrame(0, null, null, null);
                    this._lastBytesOutput += (long)this.pending();
                }
            }
            deadline = deadline == 0L ? this._remoteIdleDeadline : (this._remoteIdleDeadline - this._localIdleDeadline <= 0L ? this._remoteIdleDeadline : this._localIdleDeadline);
        }
        return deadline;
    }

    private long computeDeadline(long now, long timeout) {
        long deadline = now + timeout;
        return deadline != 0L ? deadline : 1L;
    }

    @Override
    public long getFramesOutput() {
        return this._frameWriter.getFramesOutput();
    }

    @Override
    public long getFramesInput() {
        return this._frameParser.getFramesInput();
    }

    @Override
    public void close_head() {
        this._outputProcessor.close_head();
    }

    @Override
    public boolean isClosed() {
        int p = this.pending();
        int c = this.capacity();
        return p == -1 && c == -1;
    }

    public String toString() {
        return "TransportImpl [_connectionEndpoint=" + this._connectionEndpoint + ", " + super.toString() + "]";
    }

    public void setFrameHandler(FrameHandler frameHandler) {
        this._frameHandler = frameHandler;
    }

    void log(String event, TransportFrame frame) {
        if (this.isTraceFramesEnabled()) {
            this.outputMessage(event, frame.getChannel(), frame.getBody(), frame.getPayload());
        }
    }

    void log(String event, SaslFrameBody frameBody) {
        if (this.isTraceFramesEnabled()) {
            this.outputMessage(event, 0, frameBody, null);
        }
    }

    void log(String event, String headerDescription) {
        if (this.isTraceFramesEnabled()) {
            this.outputMessage(event, 0, headerDescription, null);
        }
    }

    private void outputMessage(String event, int channel, Object frameBody, Binary payload) {
        StringBuilder msg = new StringBuilder();
        msg.append("[").append(System.identityHashCode(this)).append(":").append(channel).append("] ");
        msg.append(event).append(" ").append(frameBody);
        if (payload != null) {
            msg.append(" (").append(payload.getLength()).append(") ");
            msg.append(StringUtils.toQuotedString(payload, TRACE_FRAME_PAYLOAD_LENGTH, true));
        }
        System.out.println(msg.toString());
    }

    boolean isFrameTracingEnabled() {
        return (this._levels & 2) != 0 || this._protocolTracer.get() != null;
    }

    boolean isTraceFramesEnabled() {
        return (this._levels & 2) != 0;
    }

    @Override
    void localOpen() {
    }

    @Override
    void localClose() {
    }

    public void setSelectable(Selectable selectable) {
        this._selectable = selectable;
    }

    public Selectable getSelectable() {
        return this._selectable;
    }

    public void setReactor(Reactor reactor) {
        this._reactor = reactor;
    }

    public Reactor getReactor() {
        return this._reactor;
    }

    @Override
    public void setEmitFlowEventOnSend(boolean emitFlowEventOnSend) {
        this._emitFlowEventOnSend = emitFlowEventOnSend;
    }

    @Override
    public boolean isEmitFlowEventOnSend() {
        return this._emitFlowEventOnSend;
    }

    @Override
    public void setUseReadOnlyOutputBuffer(boolean value) {
        this._useReadOnlyOutputBuffer = value;
    }

    @Override
    public boolean isUseReadOnlyOutputBuffer() {
        return this._useReadOnlyOutputBuffer;
    }

    @Override
    public void addTransportLayer(TransportLayer layer) {
        if (this._processingStarted) {
            throw new IllegalStateException("Additional layer can't be added after transport has started processing");
        }
        if (this._additionalTransportLayers == null) {
            this._additionalTransportLayers = new ArrayList<TransportLayer>();
        }
        if (!this._additionalTransportLayers.contains(layer)) {
            this.init();
            TransportWrapper transportWrapper = layer.wrap(this._inputProcessor, this._outputProcessor);
            this._inputProcessor = transportWrapper;
            this._outputProcessor = transportWrapper;
            this._additionalTransportLayers.add(layer);
        }
    }

    @Override
    public void setOutboundFrameSizeLimit(int limit) {
        this._outboundFrameSizeLimit = limit;
    }

    @Override
    public int getOutboundFrameSizeLimit() {
        return this._outboundFrameSizeLimit;
    }
}

