/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.connectors;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.MessageDispatcherFactory;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.ipc.twin.api.TwinSubscriber;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.telemetry.api.receiver.Connector;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.api.registry.TelemetryRegistry;
import org.opennms.netmgt.telemetry.common.ipc.TelemetrySinkModule;
import org.opennms.netmgt.telemetry.config.api.ConnectorDefinition;
import org.opennms.netmgt.telemetry.config.api.QueueDefinition;
import org.opennms.netmgt.telemetry.config.model.ConnectorTwinConfig;
import org.opennms.netmgt.telemetry.distributed.common.MapBasedConnectorDef;
import org.opennms.netmgt.telemetry.distributed.common.PropertyTree;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConnectorStarter
implements ManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorStarter.class);
    private Map<String, String> configMap = new HashMap<String, String>();
    private MessageDispatcherFactory messageDispatcherFactory;
    private DistPollerDao distPollerDao;
    private TelemetryRegistry telemetryRegistry;
    @Autowired
    private TwinSubscriber twinSubscriber;
    private Closeable twinSubscription;
    private final Object configuredLock = new Object();
    private MapBasedConnectorDef baseDef;
    private final Map<String, Entity> entities = new LinkedHashMap<String, Entity>();
    private AsyncDispatcher<TelemetryMessage> sharedQueueDispatcher = null;
    private String currentQueueName;

    public void start() {
        PropertyTree definition = PropertyTree.from(this.configMap);
        this.baseDef = new MapBasedConnectorDef(definition);
        this.currentQueueName = this.baseDef.getQueueName();
    }

    public void stop() {
        LOG.info("ConnectorListener stopping\u2026");
        if (this.twinSubscription != null) {
            try {
                this.twinSubscription.close();
            }
            catch (IOException e) {
                LOG.error("Failed to  stop twin subscription: error '{}' ", (Object)e.getMessage());
            }
        }
        new ArrayList<String>(this.entities.keySet()).forEach(this::delete);
        this.cleanupDispatcher();
    }

    public void delete(String key) {
        Entity entity = this.entities.remove(key);
        if (entity != null) {
            LOG.info("Stopping connector for key: {}", (Object)key);
            try {
                if (entity.connector != null) {
                    entity.connector.close();
                }
            }
            catch (IOException e) {
                LOG.error("Failed to close connector for key: {}", (Object)key, (Object)e);
            }
        }
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties == null) {
            LOG.info("No configuration received, using defaults");
            return;
        }
        HashMap<String, String> newConfigMap = new HashMap<String, String>();
        for (String key : Collections.list(properties.keys())) {
            newConfigMap.put(key, properties.get(key).toString());
        }
        boolean needsRestart = this.hasQueueNameChanged(newConfigMap);
        this.baseDef = new MapBasedConnectorDef(PropertyTree.from(this.configMap));
        if (needsRestart) {
            LOG.info("Critical configuration changed, restarting all connectors with new dispatcher");
            this.restartAllConnectorsWithNewDispatcher();
        }
    }

    public void subscribe() {
        this.twinSubscription = this.twinSubscriber.subscribe(ConnectorTwinConfig.CONNECTOR_KEY, ConnectorTwinConfig.class, this::handleTwinUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTwinUpdate(ConnectorTwinConfig request) {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"telemetryd");){
            LOG.info("Got connectors config update - reloading");
            Object object = this.configuredLock;
            synchronized (object) {
                Set newConfigKeys = request.getConfigurations().stream().map(ConnectorTwinConfig.ConnectorConfig::getConnectionKey).collect(Collectors.toSet());
                HashSet<String> currentKeys = new HashSet<String>(this.entities.keySet());
                for (String existingKey : currentKeys) {
                    if (newConfigKeys.contains(existingKey)) continue;
                    this.delete(existingKey);
                }
                boolean needsRestart = this.hasQueueNameChanged(request.getQueueInMap());
                this.baseDef = new MapBasedConnectorDef(PropertyTree.from(this.configMap));
                if (needsRestart) {
                    LOG.info("Critical configuration changed, restarting all connectors with new dispatcher");
                    this.restartAllConnectorsWithNewDispatcher();
                }
                if (this.sharedQueueDispatcher == null) {
                    this.initializeOrGetDispatcherForQueue(this.currentQueueName);
                }
                for (ConnectorTwinConfig.ConnectorConfig config : request.getConfigurations()) {
                    LOG.debug("Processing connector config: {}", (Object)config.getConnectionKey());
                    this.processConfig(config);
                }
            }
        }
    }

    private void processConfig(ConnectorTwinConfig.ConnectorConfig config) {
        String key = config.getConnectionKey();
        Entity existing = this.entities.get(key);
        if (existing == null) {
            this.startConnector(config);
            return;
        }
        if (!this.hasConfigChanged(existing.config, config)) {
            LOG.debug("No change for key: {}, skipping start", (Object)key);
            return;
        }
        LOG.info("Configuration changed for key: {}, updating", (Object)key);
        this.delete(key);
        this.startConnector(config);
    }

    private void startConnector(ConnectorTwinConfig.ConnectorConfig config) {
        try {
            Entity entity = new Entity();
            entity.config = config;
            entity.queueName = this.currentQueueName;
            entity.connector = this.telemetryRegistry.getConnector((ConnectorDefinition)this.baseDef);
            InetAddress ip = InetAddressUtils.addr((String)config.getIpAddress());
            entity.connector.stream(config.getNodeId(), ip, config.getParameters());
            this.entities.put(config.getConnectionKey(), entity);
            LOG.info("Started connector for key: {}", (Object)config.getConnectionKey());
        }
        catch (Exception e) {
            LOG.error("Failed to start connector for key: {}", (Object)config.getConnectionKey(), (Object)e);
        }
    }

    private synchronized void initializeOrGetDispatcherForQueue(String queueName) {
        this.sharedQueueDispatcher = this.telemetryRegistry.getDispatcher(queueName);
        if (this.sharedQueueDispatcher == null) {
            TelemetrySinkModule sinkModule = new TelemetrySinkModule((QueueDefinition)this.baseDef);
            sinkModule.setDistPollerDao(this.distPollerDao);
            this.sharedQueueDispatcher = this.messageDispatcherFactory.createAsyncDispatcher((SinkModule)sinkModule);
            this.telemetryRegistry.registerDispatcher(queueName, this.sharedQueueDispatcher);
        }
    }

    private boolean hasConfigChanged(ConnectorTwinConfig.ConnectorConfig oldConfig, ConnectorTwinConfig.ConnectorConfig newConfig) {
        return !Objects.equals(oldConfig.getNodeId(), newConfig.getNodeId()) || !Objects.equals(oldConfig.getIpAddress(), newConfig.getIpAddress()) || !Objects.equals(oldConfig.getParameters(), newConfig.getParameters());
    }

    private boolean hasQueueNameChanged(Map<String, String> newConfig) {
        String newQueueName = newConfig.get("queue");
        if (!Objects.equals(this.currentQueueName, newQueueName)) {
            LOG.info("Queue name changed from {} to {}", (Object)this.currentQueueName, (Object)newQueueName);
            this.configMap.put("queue", newQueueName);
            this.configMap.put("name", newQueueName);
            return true;
        }
        return false;
    }

    private void restartAllConnectorsWithNewDispatcher() {
        HashMap<String, ConnectorTwinConfig.ConnectorConfig> savedConfigs = new HashMap<String, ConnectorTwinConfig.ConnectorConfig>();
        for (Map.Entry<String, Entity> entry : this.entities.entrySet()) {
            savedConfigs.put(entry.getKey(), entry.getValue().config);
        }
        new ArrayList<String>(this.entities.keySet()).forEach(this::delete);
        this.cleanupDispatcher();
        this.currentQueueName = this.baseDef.getQueueName();
        this.initializeOrGetDispatcherForQueue(this.currentQueueName);
        for (Map.Entry<String, Entity> entry : savedConfigs.entrySet()) {
            this.startConnector((ConnectorTwinConfig.ConnectorConfig)entry.getValue());
        }
        LOG.info("All connectors restarted with new dispatcher for queue: {}", (Object)this.currentQueueName);
    }

    private void cleanupDispatcher() {
        if (this.sharedQueueDispatcher != null) {
            try {
                this.sharedQueueDispatcher.close();
            }
            catch (Exception ex) {
                LOG.error("Failed to close dispatcher.", (Throwable)ex);
            }
            finally {
                if (this.currentQueueName != null) {
                    this.telemetryRegistry.removeDispatcher(this.currentQueueName);
                }
            }
        }
    }

    public void bind(TwinSubscriber twinSubscriber) {
        this.twinSubscriber = twinSubscriber;
        this.subscribe();
    }

    public void unbind(TwinSubscriber twinSubscriber) {
        twinSubscriber = null;
    }

    public Map<String, Entity> getEntities() {
        return this.entities;
    }

    public Map<String, String> getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(Map<String, String> configMap) {
        this.configMap = configMap;
    }

    public MessageDispatcherFactory getMessageDispatcherFactory() {
        return this.messageDispatcherFactory;
    }

    public void setMessageDispatcherFactory(MessageDispatcherFactory messageDispatcherFactory) {
        this.messageDispatcherFactory = messageDispatcherFactory;
    }

    public DistPollerDao getDistPollerDao() {
        return this.distPollerDao;
    }

    public void setDistPollerDao(DistPollerDao distPollerDao) {
        this.distPollerDao = distPollerDao;
    }

    public void setTelemetryRegistry(TelemetryRegistry telemetryRegistry) {
        this.telemetryRegistry = telemetryRegistry;
    }

    public TwinSubscriber getTwinSubscriber() {
        return this.twinSubscriber;
    }

    @VisibleForTesting
    public void setTwinSubscriber(TwinSubscriber twinSubscriber) {
        this.twinSubscriber = twinSubscriber;
        this.subscribe();
    }

    @VisibleForTesting
    public TelemetryRegistry getTelemetryRegistry() {
        return this.telemetryRegistry;
    }

    public static class Entity {
        private ConnectorTwinConfig.ConnectorConfig config;
        private Connector connector;
        private String queueName;
    }
}

