/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext2.cm.change.converter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.json.JSONObject;
import org.opennms.features.config.dao.api.ConfigItem;
import org.opennms.features.config.service.api.JsonAsString;

public class PropertiesToJson {
    private final JsonAsString json;
    private final ConfigItem schema;

    public PropertiesToJson(InputStream inputStream, ConfigItem schema) {
        this.schema = schema;
        Properties props = new Properties();
        try {
            props.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            jsonObject.put(entry.getKey().toString(), this.cast(entry));
        }
        this.json = new JsonAsString(jsonObject.toString());
    }

    private Object cast(Map.Entry<?, ?> entry) {
        if (null == entry.getValue()) {
            return null;
        }
        ConfigItem.Type type = this.schema.getChild(entry.getKey().toString()).map(ConfigItem::getType).orElse(ConfigItem.Type.STRING);
        switch (type) {
            case STRING: {
                return entry.getValue().toString();
            }
            case NUMBER: {
                return Double.parseDouble(entry.getValue().toString());
            }
            case LONG: {
                return Long.parseLong(entry.getValue().toString());
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(entry.getValue().toString());
            }
            case INTEGER: 
            case POSITIVE_INTEGER: 
            case NON_NEGATIVE_INTEGER: 
            case NEGATIVE_INTEGER: {
                return Integer.parseInt(entry.getValue().toString());
            }
        }
        return entry.getValue().toString();
    }

    public JsonAsString getJson() {
        return this.json;
    }
}

