/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.StreamJoined;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.JoinWindowsInternal;
import org.apache.kafka.streams.kstream.internals.KStreamImpl;
import org.apache.kafka.streams.kstream.internals.KStreamJoinWindow;
import org.apache.kafka.streams.kstream.internals.KStreamKStreamJoin;
import org.apache.kafka.streams.kstream.internals.KStreamKStreamSelfJoin;
import org.apache.kafka.streams.kstream.internals.NamedInternal;
import org.apache.kafka.streams.kstream.internals.PassThrough;
import org.apache.kafka.streams.kstream.internals.StreamJoinedInternal;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.kstream.internals.graph.StreamStreamJoinNode;
import org.apache.kafka.streams.kstream.internals.graph.WindowedStreamProcessorNode;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.LeftOrRightValue;
import org.apache.kafka.streams.state.internals.LeftOrRightValueSerde;
import org.apache.kafka.streams.state.internals.ListValueStoreBuilder;
import org.apache.kafka.streams.state.internals.TimestampedKeyAndJoinSide;
import org.apache.kafka.streams.state.internals.TimestampedKeyAndJoinSideSerde;

class KStreamImplJoin {
    private final InternalStreamsBuilder builder;
    private final boolean leftOuter;
    private final boolean rightOuter;

    KStreamImplJoin(InternalStreamsBuilder builder, boolean leftOuter, boolean rightOuter) {
        this.builder = builder;
        this.leftOuter = leftOuter;
        this.rightOuter = rightOuter;
    }

    public <K, V1, V2, VOut> KStream<K, VOut> join(KStream<K, V1> lhs, KStream<K, V2> other, ValueJoinerWithKey<? super K, ? super V1, ? super V2, ? extends VOut> joiner, JoinWindows windows, StreamJoined<K, V1, V2> streamJoined) {
        StoreBuilder<WindowStore<K, V2>> otherWindowStore;
        StoreBuilder<WindowStore<K, V1>> thisWindowStore;
        StreamJoinedInternal<K, V1, V2> streamJoinedInternal = new StreamJoinedInternal<K, V1, V2>(streamJoined);
        NamedInternal renamed = new NamedInternal(streamJoinedInternal.name());
        String joinThisSuffix = this.rightOuter ? "-outer-this-join" : "-this-join";
        String joinOtherSuffix = this.leftOuter ? "-outer-other-join" : "-other-join";
        String thisWindowStreamProcessorName = renamed.suffixWithOrElseGet("-this-windowed", this.builder, "KSTREAM-WINDOWED-");
        String otherWindowStreamProcessorName = renamed.suffixWithOrElseGet("-other-windowed", this.builder, "KSTREAM-WINDOWED-");
        String joinThisGeneratedName = this.rightOuter ? this.builder.newProcessorName("KSTREAM-OUTERTHIS-") : this.builder.newProcessorName("KSTREAM-JOINTHIS-");
        String joinOtherGeneratedName = this.leftOuter ? this.builder.newProcessorName("KSTREAM-OUTEROTHER-") : this.builder.newProcessorName("KSTREAM-JOINOTHER-");
        String joinThisName = renamed.suffixWithOrElseGet(joinThisSuffix, joinThisGeneratedName);
        String joinOtherName = renamed.suffixWithOrElseGet(joinOtherSuffix, joinOtherGeneratedName);
        String joinMergeName = renamed.suffixWithOrElseGet("-merge", this.builder, "KSTREAM-MERGE-");
        GraphNode thisGraphNode = ((AbstractStream)((Object)lhs)).graphNode;
        GraphNode otherGraphNode = ((AbstractStream)((Object)other)).graphNode;
        String userProvidedBaseStoreName = streamJoinedInternal.storeName();
        WindowBytesStoreSupplier thisStoreSupplier = streamJoinedInternal.thisStoreSupplier();
        WindowBytesStoreSupplier otherStoreSupplier = streamJoinedInternal.otherStoreSupplier();
        this.assertUniqueStoreNames(thisStoreSupplier, otherStoreSupplier);
        if (thisStoreSupplier == null) {
            String thisJoinStoreName = userProvidedBaseStoreName == null ? joinThisGeneratedName : userProvidedBaseStoreName + joinThisSuffix;
            thisWindowStore = KStreamImplJoin.joinWindowStoreBuilder(thisJoinStoreName, windows, streamJoinedInternal.keySerde(), streamJoinedInternal.valueSerde(), streamJoinedInternal.loggingEnabled(), streamJoinedInternal.logConfig());
        } else {
            this.assertWindowSettings(thisStoreSupplier, windows);
            thisWindowStore = KStreamImplJoin.joinWindowStoreBuilderFromSupplier(thisStoreSupplier, streamJoinedInternal.keySerde(), streamJoinedInternal.valueSerde());
        }
        if (otherStoreSupplier == null) {
            String otherJoinStoreName = userProvidedBaseStoreName == null ? joinOtherGeneratedName : userProvidedBaseStoreName + joinOtherSuffix;
            otherWindowStore = KStreamImplJoin.joinWindowStoreBuilder(otherJoinStoreName, windows, streamJoinedInternal.keySerde(), streamJoinedInternal.otherValueSerde(), streamJoinedInternal.loggingEnabled(), streamJoinedInternal.logConfig());
        } else {
            this.assertWindowSettings(otherStoreSupplier, windows);
            otherWindowStore = KStreamImplJoin.joinWindowStoreBuilderFromSupplier(otherStoreSupplier, streamJoinedInternal.keySerde(), streamJoinedInternal.otherValueSerde());
        }
        KStreamJoinWindow thisWindowedStream = new KStreamJoinWindow(thisWindowStore.name());
        ProcessorParameters thisWindowStreamProcessorParams = new ProcessorParameters(thisWindowedStream, thisWindowStreamProcessorName);
        WindowedStreamProcessorNode thisWindowedStreamsNode = new WindowedStreamProcessorNode(thisWindowStore.name(), thisWindowStreamProcessorParams);
        this.builder.addGraphNode(thisGraphNode, thisWindowedStreamsNode);
        KStreamJoinWindow otherWindowedStream = new KStreamJoinWindow(otherWindowStore.name());
        ProcessorParameters otherWindowStreamProcessorParams = new ProcessorParameters(otherWindowedStream, otherWindowStreamProcessorName);
        WindowedStreamProcessorNode otherWindowedStreamsNode = new WindowedStreamProcessorNode(otherWindowStore.name(), otherWindowStreamProcessorParams);
        this.builder.addGraphNode(otherGraphNode, otherWindowedStreamsNode);
        Optional<Object> outerJoinWindowStore = Optional.empty();
        if (this.leftOuter) {
            outerJoinWindowStore = Optional.of(this.sharedOuterJoinWindowStoreBuilder(windows, streamJoinedInternal, joinThisGeneratedName));
        }
        TimeTrackerSupplier sharedTimeTrackerSupplier = new TimeTrackerSupplier();
        JoinWindowsInternal internalWindows = new JoinWindowsInternal(windows);
        KStreamKStreamJoin<? super K, ? super V1, ? super V2, ? extends VOut> joinThis = new KStreamKStreamJoin<K, V1, V2, VOut>(true, otherWindowStore.name(), internalWindows, joiner, this.leftOuter, outerJoinWindowStore.map(StoreBuilder::name), sharedTimeTrackerSupplier);
        KStreamKStreamJoin<? super K, ? super V2, ? super V1, ? extends VOut> joinOther = new KStreamKStreamJoin<K, V2, V1, VOut>(false, thisWindowStore.name(), internalWindows, AbstractStream.reverseJoinerWithKey(joiner), this.rightOuter, outerJoinWindowStore.map(StoreBuilder::name), sharedTimeTrackerSupplier);
        KStreamKStreamSelfJoin<? super K, ? super V1, ? super V2, ? extends VOut> selfJoin = new KStreamKStreamSelfJoin<K, V1, V2, VOut>(thisWindowStore.name(), internalWindows, joiner, windows.size() + windows.gracePeriodMs());
        PassThrough joinMerge = new PassThrough();
        StreamStreamJoinNode.StreamStreamJoinNodeBuilder joinBuilder = StreamStreamJoinNode.streamStreamJoinNodeBuilder();
        ProcessorParameters<? super K, ? super V1, ? super V2, ? extends VOut> joinThisProcessorParams = new ProcessorParameters<K, V1, V2, VOut>(joinThis, joinThisName);
        ProcessorParameters<? super K, ? super V2, ? super V1, ? extends VOut> joinOtherProcessorParams = new ProcessorParameters<K, V2, V1, VOut>(joinOther, joinOtherName);
        ProcessorParameters joinMergeProcessorParams = new ProcessorParameters(joinMerge, joinMergeName);
        ProcessorParameters<? super K, ? super V1, ? super V2, ? extends VOut> selfJoinProcessorParams = new ProcessorParameters<K, V1, V2, VOut>(selfJoin, joinMergeName);
        joinBuilder.withJoinMergeProcessorParameters(joinMergeProcessorParams).withJoinThisProcessorParameters(joinThisProcessorParams).withJoinOtherProcessorParameters(joinOtherProcessorParams).withThisWindowStoreBuilder(thisWindowStore).withOtherWindowStoreBuilder(otherWindowStore).withThisWindowedStreamProcessorParameters(thisWindowStreamProcessorParams).withOtherWindowedStreamProcessorParameters(otherWindowStreamProcessorParams).withOuterJoinWindowStoreBuilder(outerJoinWindowStore).withValueJoiner(joiner).withNodeName(joinMergeName).withSelfJoinProcessorParameters(selfJoinProcessorParams);
        if (internalWindows.spuriousResultFixEnabled()) {
            joinBuilder.withSpuriousResultFixEnabled();
        }
        StreamStreamJoinNode joinGraphNode = joinBuilder.build();
        this.builder.addGraphNode(Arrays.asList(thisGraphNode, otherGraphNode), joinGraphNode);
        HashSet<String> allSourceNodes = new HashSet<String>(((KStreamImpl)lhs).subTopologySourceNodes);
        allSourceNodes.addAll(((KStreamImpl)other).subTopologySourceNodes);
        return new KStreamImpl(joinMergeName, streamJoinedInternal.keySerde(), null, allSourceNodes, false, joinGraphNode, this.builder);
    }

    private void assertWindowSettings(WindowBytesStoreSupplier supplier, JoinWindows joinWindows) {
        boolean allMatch;
        if (!supplier.retainDuplicates()) {
            throw new StreamsException("The StoreSupplier must set retainDuplicates=true, found retainDuplicates=false");
        }
        boolean bl = allMatch = supplier.retentionPeriod() == joinWindows.size() + joinWindows.gracePeriodMs() && supplier.windowSize() == joinWindows.size();
        if (!allMatch) {
            throw new StreamsException(String.format("Window settings mismatch. WindowBytesStoreSupplier settings %s must match JoinWindows settings %s for the window size and retention period", supplier, joinWindows));
        }
    }

    private void assertUniqueStoreNames(WindowBytesStoreSupplier supplier, WindowBytesStoreSupplier otherSupplier) {
        if (supplier != null && otherSupplier != null && supplier.name().equals(otherSupplier.name())) {
            throw new StreamsException("Both StoreSuppliers have the same name.  StoreSuppliers must provide unique names");
        }
    }

    private static <K, V> StoreBuilder<WindowStore<K, V>> joinWindowStoreBuilder(String storeName, JoinWindows windows, Serde<K> keySerde, Serde<V> valueSerde, boolean loggingEnabled, Map<String, String> logConfig) {
        StoreBuilder<WindowStore<K, V>> builder = Stores.windowStoreBuilder(Stores.persistentWindowStore(storeName + "-store", Duration.ofMillis(windows.size() + windows.gracePeriodMs()), Duration.ofMillis(windows.size()), true), keySerde, valueSerde);
        if (loggingEnabled) {
            builder.withLoggingEnabled(logConfig);
        } else {
            builder.withLoggingDisabled();
        }
        return builder;
    }

    private <K, V1, V2> String buildOuterJoinWindowStoreName(StreamJoinedInternal<K, V1, V2> streamJoinedInternal, String joinThisGeneratedName) {
        String outerJoinSuffix;
        String string = outerJoinSuffix = this.rightOuter ? "-outer-shared-join" : "-left-shared-join";
        if (streamJoinedInternal.thisStoreSupplier() != null && !streamJoinedInternal.thisStoreSupplier().name().isEmpty()) {
            return streamJoinedInternal.thisStoreSupplier().name() + outerJoinSuffix;
        }
        if (streamJoinedInternal.storeName() != null) {
            return streamJoinedInternal.storeName() + outerJoinSuffix;
        }
        return "KSTREAM-OUTERSHARED-" + joinThisGeneratedName.substring(this.rightOuter ? "KSTREAM-OUTERTHIS-".length() : "KSTREAM-JOINTHIS-".length());
    }

    private <K, V1, V2> StoreBuilder<KeyValueStore<TimestampedKeyAndJoinSide<K>, LeftOrRightValue<V1, V2>>> sharedOuterJoinWindowStoreBuilder(JoinWindows windows, StreamJoinedInternal<K, V1, V2> streamJoinedInternal, String joinThisGeneratedName) {
        boolean persistent = streamJoinedInternal.thisStoreSupplier() == null || ((WindowStore)streamJoinedInternal.thisStoreSupplier().get()).persistent();
        String storeName = this.buildOuterJoinWindowStoreName(streamJoinedInternal, joinThisGeneratedName) + "-store";
        Duration retentionPeriod = Duration.ofMillis(windows.size() + windows.gracePeriodMs());
        Duration windowSize = Duration.ofMillis(windows.size());
        String rpMsgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(retentionPeriod, "retentionPeriod");
        long retentionMs = ApiUtils.validateMillisecondDuration(retentionPeriod, rpMsgPrefix);
        String wsMsgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(windowSize, "windowSize");
        long windowSizeMs = ApiUtils.validateMillisecondDuration(windowSize, wsMsgPrefix);
        if (retentionMs < 0L) {
            throw new IllegalArgumentException("retentionPeriod cannot be negative");
        }
        if (windowSizeMs < 0L) {
            throw new IllegalArgumentException("windowSize cannot be negative");
        }
        if (windowSizeMs > retentionMs) {
            throw new IllegalArgumentException("The retention period of the window store " + storeName + " must be no smaller than its window size. Got size=[" + windowSizeMs + "], retention=[" + retentionMs + "]");
        }
        TimestampedKeyAndJoinSideSerde<K> timestampedKeyAndJoinSideSerde = new TimestampedKeyAndJoinSideSerde<K>(streamJoinedInternal.keySerde());
        LeftOrRightValueSerde<V1, V2> leftOrRightValueSerde = new LeftOrRightValueSerde<V1, V2>(streamJoinedInternal.valueSerde(), streamJoinedInternal.otherValueSerde());
        ListValueStoreBuilder<TimestampedKeyAndJoinSide<K>, LeftOrRightValue<V1, V2>> builder = new ListValueStoreBuilder<TimestampedKeyAndJoinSide<K>, LeftOrRightValue<V1, V2>>(persistent ? Stores.persistentKeyValueStore(storeName) : Stores.inMemoryKeyValueStore(storeName), timestampedKeyAndJoinSideSerde, leftOrRightValueSerde, Time.SYSTEM);
        if (streamJoinedInternal.loggingEnabled()) {
            builder.withLoggingEnabled(streamJoinedInternal.logConfig());
        } else {
            builder.withLoggingDisabled();
        }
        return builder;
    }

    private static <K, V> StoreBuilder<WindowStore<K, V>> joinWindowStoreBuilderFromSupplier(WindowBytesStoreSupplier storeSupplier, Serde<K> keySerde, Serde<V> valueSerde) {
        return Stores.windowStoreBuilder(storeSupplier, keySerde, valueSerde);
    }

    static class TimeTracker {
        private long emitIntervalMs = 1000L;
        long streamTime = -1L;
        long minTime = Long.MAX_VALUE;
        long nextTimeToEmit;

        TimeTracker() {
        }

        public void setEmitInterval(long emitIntervalMs) {
            this.emitIntervalMs = emitIntervalMs;
        }

        public void advanceStreamTime(long recordTimestamp) {
            this.streamTime = Math.max(recordTimestamp, this.streamTime);
        }

        public void updatedMinTime(long recordTimestamp) {
            this.minTime = Math.min(recordTimestamp, this.minTime);
        }

        public void advanceNextTimeToEmit() {
            this.nextTimeToEmit += this.emitIntervalMs;
        }
    }

    static class TimeTrackerSupplier {
        private final Map<TaskId, TimeTracker> tracker = new ConcurrentHashMap<TaskId, TimeTracker>();

        TimeTrackerSupplier() {
        }

        public TimeTracker get(TaskId taskId) {
            return this.tracker.computeIfAbsent(taskId, taskId1 -> new TimeTracker());
        }

        public void remove(TaskId taskId) {
            this.tracker.remove(taskId);
        }
    }
}

