/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class SupplierUtils {
    private SupplierUtils() {
    }

    public static <T, R> Supplier<R> andThen(Supplier<T> supplier, Function<T, R> resultHandler) {
        return () -> resultHandler.apply(supplier.get());
    }

    public static <T, R> Supplier<R> andThen(Supplier<T> supplier, BiFunction<T, Exception, R> handler) {
        return () -> {
            try {
                Object result = supplier.get();
                return handler.apply(result, null);
            }
            catch (Exception exception) {
                return handler.apply(null, exception);
            }
        };
    }

    public static <T> Supplier<T> recover(Supplier<T> supplier, Function<Exception, T> exceptionHandler) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception exception) {
                return exceptionHandler.apply(exception);
            }
        };
    }

    public static <T, R> Supplier<R> andThen(Supplier<T> supplier, Function<T, R> resultHandler, Function<Exception, R> exceptionHandler) {
        return () -> {
            try {
                Object result = supplier.get();
                return resultHandler.apply(result);
            }
            catch (Exception exception) {
                return exceptionHandler.apply(exception);
            }
        };
    }
}

