/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.adapter.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URL;
import java.sql.Date;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.stats.RouteInfo;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.stats.RpkiInfo;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.stats.Utils;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpRpkiInfo;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpRpkiInfoDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpkiValidatorClient {
    private static final Logger LOG = LoggerFactory.getLogger(RpkiValidatorClient.class);
    private static final Integer DEFAULT_HOUR_OF_THE_DAY = 3;
    private final String rpkiUrl;
    private String authorizationHeader;
    private BmpRpkiInfoDao bmpRpkiInfoDao;
    private String rpkiUsername;
    private String rpkiPassword;
    private Integer hourOfTheDay = DEFAULT_HOUR_OF_THE_DAY;
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("UpdateRpkiInfo-%d").build();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(this.threadFactory);

    public RpkiValidatorClient(String rpkiUrl) {
        this.rpkiUrl = rpkiUrl;
        if (!Strings.isNullOrEmpty((String)this.rpkiUsername) && !Strings.isNullOrEmpty((String)this.rpkiPassword)) {
            this.authorizationHeader = "Basic " + Base64.getEncoder().encodeToString((this.rpkiPassword + ":" + this.rpkiPassword).getBytes());
        }
    }

    public void init() {
        Long hourOfTheDayInMinutes = Utils.getHourOfTheDayInMinutes(this.hourOfTheDay);
        this.scheduledExecutorService.scheduleAtFixedRate(this::updateRpkiInfo, hourOfTheDayInMinutes, TimeUnit.DAYS.toMinutes(1L), TimeUnit.MINUTES);
    }

    public void destroy() {
        this.scheduledExecutorService.shutdown();
    }

    private void updateRpkiInfo() {
        String jsonResponse = this.getJsonRestResponse();
        if (jsonResponse != null) {
            List<RpkiInfo> rpkiInfoList = this.parseRpkiInfoFromResponse(jsonResponse);
            rpkiInfoList.forEach(rpkiInfo -> {
                BmpRpkiInfo bmpRpkiInfo = this.buildBmpRpkiValidator((RpkiInfo)rpkiInfo);
                if (bmpRpkiInfo != null && this.bmpRpkiInfoDao != null) {
                    try {
                        this.bmpRpkiInfoDao.saveOrUpdate((Object)bmpRpkiInfo);
                    }
                    catch (Exception e) {
                        LOG.error("Exception while persisting BMP Rpki validator {}", (Object)bmpRpkiInfo, (Object)e);
                    }
                }
            });
        }
    }

    private BmpRpkiInfo buildBmpRpkiValidator(RpkiInfo rpkiInfo) {
        BmpRpkiInfo bmpRpkiInfo = this.bmpRpkiInfoDao.findBmpRpkiInfoWith(rpkiInfo.getPrefix(), rpkiInfo.getPrefixMaxLen(), rpkiInfo.getAsn());
        if (bmpRpkiInfo == null) {
            bmpRpkiInfo = new BmpRpkiInfo();
            bmpRpkiInfo.setOriginAs(rpkiInfo.getAsn());
            bmpRpkiInfo.setPrefix(rpkiInfo.getPrefix());
            bmpRpkiInfo.setPrefixLenMax(rpkiInfo.getPrefixMaxLen());
        }
        bmpRpkiInfo.setPrefixLen(rpkiInfo.getPrefixLen());
        bmpRpkiInfo.setTimestamp(Date.from(Instant.now()));
        return bmpRpkiInfo;
    }

    @VisibleForTesting
    List<RpkiInfo> parseRpkiInfoFromResponse(String jsonResponse) {
        ArrayList<RpkiInfo> rpkiInfos = new ArrayList<RpkiInfo>();
        try {
            JsonParser parser = new JsonParser();
            JsonObject jsonObject = parser.parse(jsonResponse).getAsJsonObject();
            JsonArray jsonArray = jsonObject.getAsJsonArray("roas");
            for (JsonElement jsonElement : jsonArray) {
                try {
                    Long asn;
                    RpkiInfo rpkiInfo = new RpkiInfo();
                    JsonObject roa = jsonElement.getAsJsonObject();
                    JsonElement asnElement = roa.get("asn");
                    if (asnElement == null || (asn = StringUtils.parseLong((String)asnElement.getAsString(), null)) == null) continue;
                    rpkiInfo.setAsn(asn);
                    JsonElement maxLengthElement = roa.get("maxLength");
                    if (maxLengthElement == null) continue;
                    rpkiInfo.setPrefixMaxLen(maxLengthElement.getAsInt());
                    JsonElement prefixElement = roa.get("prefix");
                    if (prefixElement == null) continue;
                    String prefixString = prefixElement.getAsString();
                    if (prefixString.contains("/")) {
                        Integer prefixLen;
                        String[] prefixArray = prefixString.split("/", 2);
                        if (RouteInfo.isValidIpAddress(prefixArray[0])) {
                            rpkiInfo.setPrefix(prefixArray[0]);
                        }
                        if ((prefixLen = StringUtils.parseInt((String)prefixArray[1], null)) != null) {
                            rpkiInfo.setPrefixLen(prefixLen);
                        }
                    }
                    rpkiInfos.add(rpkiInfo);
                }
                catch (Exception e) {
                    LOG.warn("Exception while parsing Rpki element {}", (Object)jsonElement, (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception while parsing Rpki Info from json response {}", (Object)jsonResponse, (Object)e);
        }
        return rpkiInfos;
    }

    private String getJsonRestResponse() {
        try {
            URL url = new URL(this.rpkiUrl);
            Client client = ClientBuilder.newClient();
            WebTarget target = client.target(url.toString());
            Invocation.Builder builder = target.request();
            if (!Strings.isNullOrEmpty((String)this.authorizationHeader)) {
                builder.header("Authorization", (Object)this.authorizationHeader);
            }
            Response response = builder.get();
            return (String)response.readEntity(String.class);
        }
        catch (Exception e) {
            LOG.error("Exception while fetching response from {}", (Object)this.rpkiUrl, (Object)e);
            return null;
        }
    }

    public void setBmpRpkiInfoDao(BmpRpkiInfoDao bmpRpkiInfoDao) {
        this.bmpRpkiInfoDao = bmpRpkiInfoDao;
    }

    public void setRpkiUsername(String rpkiUsername) {
        this.rpkiUsername = rpkiUsername;
    }

    public void setRpkiPassword(String rpkiPassword) {
        this.rpkiPassword = rpkiPassword;
    }

    public void setHourOfTheDay(Integer hourOfTheDay) {
        this.hourOfTheDay = hourOfTheDay;
    }
}

