/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.services;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;

public class ServiceJspUtil {
    private OnmsMonitoredService service;
    private Collection<OnmsOutage> currentOutages;

    public ServiceJspUtil(OnmsMonitoredService service, Collection<OnmsOutage> currentOutages) {
        this.service = service;
        this.currentOutages = currentOutages;
    }

    public List<OnmsMonitoringLocation> getAllPerspectives() {
        return this.service.getApplications().stream().flatMap(app -> app.getPerspectiveLocations().stream()).distinct().sorted(Comparator.comparing(OnmsMonitoringLocation::getLocationName)).collect(Collectors.toList());
    }

    public Optional<OnmsOutage> getOutageForPerspective(OnmsMonitoringLocation onmsMonitoringLocation) {
        return this.currentOutages.stream().filter(out -> onmsMonitoringLocation.equals((Object)out.getPerspective())).findFirst();
    }

    public String getOutageUrl(OnmsOutage outage) {
        return String.format("<a href=\"outage/detail.htm?id=%s\">%s</a>", outage.getId(), outage.getId());
    }
}

