/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.destinationPaths;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="target")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="destinationPaths.xsd")
public class Target
implements Serializable {
    public static String DEFAULT_INTERVAL = "0s";
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="interval")
    private String m_interval;
    @XmlElement(name="name", required=true)
    private String m_name;
    @XmlElement(name="autoNotify")
    private String m_autoNotify;
    @XmlElement(name="command", required=true)
    private List<String> m_commands = new ArrayList<String>();

    public Target() {
    }

    public Target(String name, String ... commands) {
        this.m_name = name;
        for (String c : commands) {
            this.m_commands.add(c);
        }
    }

    public Optional<String> getInterval() {
        return Optional.ofNullable(this.m_interval);
    }

    public void setInterval(String interval) {
        this.m_interval = interval;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public Optional<String> getAutoNotify() {
        return Optional.ofNullable(this.m_autoNotify);
    }

    public void setAutoNotify(String autoNotify) {
        this.m_autoNotify = autoNotify;
    }

    public List<String> getCommands() {
        return this.m_commands;
    }

    public void setCommands(List<String> commands) {
        if (commands == this.m_commands) {
            return;
        }
        this.m_commands.clear();
        if (commands != null) {
            this.m_commands.addAll(commands);
        }
    }

    public void addCommand(String command) {
        this.m_commands.add(command);
    }

    public void clearCommands() {
        this.m_commands.clear();
    }

    public int hashCode() {
        return Objects.hash(this.m_interval, this.m_name, this.m_autoNotify, this.m_commands);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Target) {
            Target temp = (Target)obj;
            return Objects.equals(temp.m_interval, this.m_interval) && Objects.equals(temp.m_name, this.m_name) && Objects.equals(temp.m_autoNotify, this.m_autoNotify) && Objects.equals(temp.m_commands, this.m_commands);
        }
        return false;
    }

    public String toString() {
        return "Target [interval=" + this.m_interval + ", name=" + this.m_name + ", autoNotify=" + this.m_autoNotify + ", commands=" + String.valueOf(this.m_commands) + "]";
    }
}

