/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.BmpParser;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Attribute;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerFlags;

public class Origin
implements Attribute {
    public final Value value;

    public Origin(ByteBuf buffer, PeerFlags flags) {
        this.value = Value.from(BufferUtils.uint8((ByteBuf)buffer));
    }

    @Override
    public void accept(Attribute.Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }

    public static enum Value {
        IGP,
        EGP,
        INCOMPLETE,
        UNKNOWN;


        private static Value from(int code) {
            switch (code) {
                case 0: {
                    return IGP;
                }
                case 1: {
                    return EGP;
                }
                case 2: {
                    return INCOMPLETE;
                }
            }
            BmpParser.RATE_LIMITED_LOG.debug("Unknown Originator Code: {}", (Object)code);
            return UNKNOWN;
        }

        public <R> R map(Function<Value, R> mapper) {
            return mapper.apply(this);
        }
    }
}

