/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.mate.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.mate.api.ContextKey;
import org.opennms.core.mate.api.Scope;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.core.xml.JaxbUtils;

public class Interpolator {
    private static final String OUTER_REGEXP = "\\$\\{([^\\{\\}]+?:[^\\{\\}]+?)\\}";
    private static final String INNER_REGEXP = "(?:([^\\|\"']+?:[^\\|]+)|('[^\\|]+')|(\"[^\\|]+\")|([^\\|]+))";
    private static final Pattern OUTER_PATTERN = Pattern.compile("\\$\\{([^\\{\\}]+?:[^\\{\\}]+?)\\}");
    private static final Pattern INNER_PATTERN = Pattern.compile("(?:([^\\|\"']+?:[^\\|]+)|('[^\\|]+')|(\"[^\\|]+\")|([^\\|]+))");
    private static final int MAX_RECURSION_DEPTH = SystemProperties.getInteger((String)"org.opennms.mate.maxRecursionDepth", (int)8);

    private Interpolator() {
    }

    public static Map<String, Object> interpolateAttributes(Map<String, Object> attributes, Scope scope) {
        return Maps.transformValues(attributes, raw -> Interpolator.interpolateAttribute(raw, scope));
    }

    public static ToBeInterpolated pleaseInterpolate(Object value) {
        return new ToBeInterpolated(value);
    }

    public static Map<String, Object> pleaseInterpolate(Map<String, ?> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Interpolator.pleaseInterpolate(e.getValue())));
    }

    public static Map<String, Object> interpolateObjects(Map<String, Object> attributes, Scope scope) {
        return Maps.transformValues(attributes, raw -> Interpolator.interpolate(raw, scope));
    }

    public static Map<String, String> interpolateStrings(Map<String, String> attributes, Scope scope) {
        return Maps.transformValues(attributes, raw -> raw != null ? Interpolator.interpolate((String)raw, (Scope)scope).output : null);
    }

    private static Object interpolateAttribute(Object value, Scope scope) {
        if (value == null) {
            return null;
        }
        if (value instanceof ToBeInterpolated) {
            return Interpolator.interpolate(((ToBeInterpolated)value).value, scope);
        }
        return value;
    }

    public static Object interpolate(Object value, Scope scope) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Interpolator.interpolate((String)((String)value), (Scope)scope).output;
        }
        if (value.getClass().isAnnotationPresent(XmlRootElement.class)) {
            return JaxbUtils.unmarshal(value.getClass(), (String)Interpolator.interpolate((String)JaxbUtils.marshal((Object)value), (Scope)scope).output, (boolean)false);
        }
        return value;
    }

    public static Result interpolate(String raw, Scope scope) {
        if (raw == null) {
            return new Result(null, List.of());
        }
        ImmutableList.Builder parts = ImmutableList.builder();
        String output = Interpolator.interpolateRecursive(raw, (ImmutableList.Builder<ResultPart>)parts, scope, 1);
        return new Result(output, (List<ResultPart>)parts.build());
    }

    private static String interpolateRecursive(String input, ImmutableList.Builder<ResultPart> parts, Scope scope, int depth) {
        if (depth > MAX_RECURSION_DEPTH) {
            return input;
        }
        String result = Interpolator.interpolateSingle(input, parts, scope);
        if (Objects.equals(input, result)) {
            return result;
        }
        return Interpolator.interpolateRecursive(result, parts, scope, depth + 1);
    }

    private static String interpolateSingle(String input, ImmutableList.Builder<ResultPart> parts, Scope scope) {
        StringBuilder output = new StringBuilder();
        Matcher outerMatcher = OUTER_PATTERN.matcher(input);
        while (outerMatcher.find()) {
            Matcher innerMatcher = INNER_PATTERN.matcher(outerMatcher.group(1));
            String result = "";
            while (innerMatcher.find()) {
                if (innerMatcher.group(1) != null) {
                    String[] arr = innerMatcher.group(1).split(":", 2);
                    ContextKey contextKey = new ContextKey(arr[0], arr[1]);
                    Optional<Scope.ScopeValue> replacement = scope.get(contextKey);
                    if (!replacement.isPresent()) continue;
                    result = Matcher.quoteReplacement(replacement.get().value);
                    parts.add((Object)new ResultPart(outerMatcher.group(), innerMatcher.group(1), replacement.get()));
                    break;
                }
                if (innerMatcher.group(4) != null) {
                    result = Matcher.quoteReplacement(innerMatcher.group(4));
                    parts.add((Object)new ResultPart(outerMatcher.group(), innerMatcher.group(4), new Scope.ScopeValue(Scope.ScopeName.DEFAULT, innerMatcher.group(4))));
                    break;
                }
                if (innerMatcher.group(2) == null && innerMatcher.group(3) == null) continue;
                int index = innerMatcher.group(2) != null ? 2 : 3;
                String string = innerMatcher.group(index).trim();
                result = string = string.substring(1, string.length() - 1);
                parts.add((Object)new ResultPart(outerMatcher.group(), string, new Scope.ScopeValue(Scope.ScopeName.DEFAULT, string)));
                break;
            }
            outerMatcher.appendReplacement(output, result);
        }
        outerMatcher.appendTail(output);
        return output.toString();
    }

    private static class ToBeInterpolated {
        private final Object value;

        public ToBeInterpolated(Object value) {
            this.value = value;
        }
    }

    public static class Result {
        public final String output;
        public final List<ResultPart> parts;

        public Result(String output, List<ResultPart> parts) {
            this.output = output;
            this.parts = parts;
        }
    }

    public static class ResultPart {
        public final String input;
        public final String match;
        public final Scope.ScopeValue value;

        public ResultPart(String input, String match, Scope.ScopeValue value) {
            this.input = input;
            this.match = match;
            this.value = value;
        }
    }
}

