/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.mate.api;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.mate.api.ContextKey;
import org.opennms.core.mate.api.Scope;

public class EnvironmentScope
implements Scope {
    public static final String CONTEXT = "env";

    @Override
    public Optional<Scope.ScopeValue> get(ContextKey contextKey) {
        if (!CONTEXT.equals(contextKey.context)) {
            return Optional.empty();
        }
        if (Strings.isNullOrEmpty((String)contextKey.key)) {
            return Optional.empty();
        }
        String value = System.getenv(contextKey.key);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(new Scope.ScopeValue(Scope.ScopeName.GLOBAL, value));
    }

    @Override
    public Set<ContextKey> keys() {
        return System.getenv().entrySet().stream().map(entry -> new ContextKey(CONTEXT, (String)entry.getKey())).collect(Collectors.toSet());
    }
}

