/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.karaf.health.daemon;

import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.soa.lookup.ServiceLookup;
import org.opennms.core.soa.lookup.ServiceLookupBuilder;
import org.opennms.core.soa.lookup.ServiceRegistryLookup;
import org.opennms.core.soa.support.DefaultServiceRegistry;
import org.opennms.features.karaf.health.service.KarafHealthService;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafStartupMonitor
implements SpringServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(KarafStartupMonitor.class);
    public static final String NAME = "KarafStartupMonitor";
    private static final ServiceLookup<Class<?>, String> SERVICE_LOOKUP = new ServiceLookupBuilder((ServiceLookup)new ServiceRegistryLookup((ServiceRegistry)DefaultServiceRegistry.INSTANCE)).blocking().build();

    public synchronized void start() {
        LOG.info("{} is starting.", (Object)NAME);
        if (!this.isKarafOk()) {
            String message = String.format("KarafStartupMonitor: It seems Karaf can't be started properly. This is bad, will fail startup.%nWhat can you do about this?%n1.) check in logs/karaf.log for problems%n2.) clear the 'data' folder - it contains Karaf's cache%n3.) run the script bin/fix-karaf-setup.sh", new Object[0]);
            throw new IllegalStateException(message);
        }
        LOG.info("{} is started.", (Object)NAME);
    }

    private boolean isKarafOk() {
        Class<KarafHealthService> serviceClass = KarafHealthService.class;
        try {
            LOG.info("Waiting for loading of {}, will block startup until service is available.", (Object)serviceClass.getName());
            KarafHealthService service = (KarafHealthService)SERVICE_LOOKUP.lookup(serviceClass, null);
            return service != null;
        }
        catch (Exception e) {
            LOG.error("Could not lookup {}, will fail.", (Object)serviceClass.getName(), (Object)e);
            return false;
        }
    }

    public synchronized void destroy() {
        LOG.info("{} is stopped.", (Object)NAME);
    }

    public void afterPropertiesSet() {
    }
}

