/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.karaf.health.bundle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.karaf.health.bundle.KarafHealthServiceImpl;
import org.opennms.features.karaf.health.service.KarafHealthService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.FrameworkWiring;

public class Activator
implements BundleActivator {
    private ServiceRegistration karafHealthServiceSvcReg;

    public void start(BundleContext context) throws Exception {
        Set<Bundle> unresolvedVaadinThemeFragments = Activator.getUnresolvedVaadinThemeFragments(context);
        if (!unresolvedVaadinThemeFragments.isEmpty()) {
            Bundle vaadinThemeHostBundle = Activator.getVaadinThemeHostbundle(context);
            ArrayList<Bundle> bundlesToRefresh = new ArrayList<Bundle>();
            bundlesToRefresh.add(vaadinThemeHostBundle);
            Bundle systemBundle = context.getBundle(0L);
            FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
            frameworkWiring.refreshBundles(bundlesToRefresh, new FrameworkListener[0]);
        }
        KarafHealthServiceImpl karafHealthService = new KarafHealthServiceImpl();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("registration.export", "true");
        this.karafHealthServiceSvcReg = context.registerService(KarafHealthService.class, (Object)karafHealthService, props);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.karafHealthServiceSvcReg != null) {
            this.karafHealthServiceSvcReg.unregister();
        }
    }

    private static Bundle getVaadinThemeHostbundle(BundleContext context) {
        return Arrays.stream(context.getBundles()).filter(b -> "com.vaadin.themes".equalsIgnoreCase(b.getSymbolicName())).findFirst().orElse(null);
    }

    private static Set<Bundle> getUnresolvedVaadinThemeFragments(BundleContext context) {
        return Arrays.stream(context.getBundles()).filter(bundle -> {
            String fragmentHost = (String)bundle.getHeaders().get("Fragment-Host");
            return fragmentHost != null && fragmentHost.contains("com.vaadin.themes") && bundle.getState() == 2;
        }).collect(Collectors.toSet());
    }
}

