/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geocoder.mapquest;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.features.geocoder.GeocoderConfiguration;
import org.opennms.features.geocoder.GeocoderConfigurationException;
import org.opennms.features.geocoder.GeocoderResult;
import org.opennms.features.geocoder.GeocoderService;
import org.opennms.features.geocoder.mapquest.MapquestConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapquestGeocoderService
implements GeocoderService {
    private static final Logger LOG = LoggerFactory.getLogger(MapquestGeocoderService.class);
    private final MapquestConfiguration configuration;

    public MapquestGeocoderService(MapquestConfiguration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
    }

    public String getId() {
        return "mapquest";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GeocoderResult resolveAddress(String address) throws GeocoderConfigurationException {
        this.configuration.validate();
        LOG.debug("Configuration: {}", this.configuration.asMap());
        try (HttpClientWrapper clientWrapper = HttpClientWrapper.create().dontReuseConnections();){
            block23: {
                if (this.configuration.isUseSystemProxy()) {
                    clientWrapper.useSystemProxySettings();
                }
                String requestUrl = this.buildURL(this.configuration.getUrlTemplate(), this.configuration.getApiKey(), address);
                HttpGet request = new HttpGet(requestUrl);
                try (CloseableHttpResponse response = clientWrapper.execute((HttpUriRequest)request);){
                    StatusLine statusLine = response.getStatusLine();
                    LOG.trace("Invoking URL {} returned {}:{} => {}", new Object[]{requestUrl, statusLine.getStatusCode(), statusLine.getReasonPhrase(), statusLine.getStatusCode() == 200 ? "OK" : "NOK"});
                    if (statusLine.getStatusCode() != 200) {
                        GeocoderResult geocoderResult = GeocoderResult.error((String)String.format("MapQuest returned a non-OK response code: %s: %s", statusLine.getStatusCode(), statusLine.getReasonPhrase())).build();
                        return geocoderResult;
                    }
                    InputStream responseStream = response.getEntity().getContent();
                    JSONTokener jsonTokener = new JSONTokener(responseStream);
                    JSONObject jsonObject = new JSONObject(jsonTokener);
                    if (!jsonObject.has("results") || jsonObject.getJSONArray("results").length() <= 0 || !jsonObject.getJSONArray("results").getJSONObject(0).has("locations")) break block23;
                    JSONArray locationResults = jsonObject.getJSONArray("results").getJSONObject(0).getJSONArray("locations");
                    if (locationResults.length() > 0) {
                        LOG.trace("API returned {} of results. If multiple, the first is used.", (Object)locationResults.length());
                        JSONObject location = (JSONObject)locationResults.get(0);
                        if (location.has("latLng")) {
                            double lat = location.getJSONObject("latLng").getDouble("lat");
                            double lng = location.getJSONObject("latLng").getDouble("lng");
                            LOG.trace("API returned a result with valid long/lat fields: {}/{}", (Object)lng, (Object)lat);
                            GeocoderResult geocoderResult = GeocoderResult.success((String)address, (double)lng, (double)lat).build();
                            return geocoderResult;
                        }
                        LOG.trace("API returned a result which does not contain lon/lat fields: {}", (Object)location);
                    } else {
                        LOG.trace("API returned an empty result");
                    }
                }
            }
            LOG.debug("Couldn't resolve coordinates for address {}", (Object)address);
            GeocoderResult geocoderResult = GeocoderResult.noResult((String)address).build();
            return geocoderResult;
        }
        catch (IOException e) {
            return GeocoderResult.error((Exception)e).build();
        }
    }

    public GeocoderConfiguration getConfiguration() {
        return this.configuration;
    }

    public void validateConfiguration(Map<String, Object> properties) throws GeocoderConfigurationException {
        MapquestConfiguration.fromMap(properties).validate();
    }

    private String buildURL(String urlTemplate, String apiKey, String addressToResolve) throws UnsupportedEncodingException {
        Objects.requireNonNull(urlTemplate);
        Objects.requireNonNull(apiKey);
        Objects.requireNonNull(addressToResolve);
        String url = urlTemplate.replaceAll("\\{apiKey\\}", apiKey).replaceAll("\\{query\\}", URLEncoder.encode(addressToResolve, "UTF-8"));
        return url;
    }
}

