/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.json.JSONArray;
import org.json.JSONTokener;

@Entity
@Table(name="graph_focus")
public class FocusEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="graphSequence")
    @SequenceGenerator(name="graphSequence", sequenceName="graphnxtid")
    @Column(name="id", nullable=false)
    private Long id;
    @Column(name="type", nullable=false)
    private String type;
    @Column(name="selection")
    private String selection;

    public FocusEntity() {
    }

    public FocusEntity(String type) {
        this.type = Objects.requireNonNull(type);
    }

    public FocusEntity(String type, List<String> vertexIds) {
        this(type);
        this.setSelection(vertexIds);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSelection() {
        return this.selection;
    }

    public void setSelection(String selection) {
        this.selection = selection;
    }

    public void setSelection(List<String> vertexIds) {
        JSONArray vertexIdArray = new JSONArray(vertexIds);
        this.setSelection(vertexIdArray.toString());
    }

    public List<String> getVertexIds() {
        String jsonString = this.selection;
        JSONTokener tokener = new JSONTokener(jsonString);
        JSONArray jsonArray = new JSONArray(tokener);
        ArrayList vertices = Lists.newArrayList();
        for (int i = 0; i < jsonArray.length(); ++i) {
            String vertexId = jsonArray.getString(i);
            vertices.add(vertexId);
        }
        return vertices;
    }
}

