/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.opennms.shaded.org.bouncycastle.crypto.Digest;
import org.opennms.shaded.org.bouncycastle.crypto.macs.HMac;
import org.opennms.shaded.org.bouncycastle.crypto.params.KeyParameter;
import org.opennms.shaded.org.bouncycastle.crypto.tls.TlsUtils;

public class TlsMac {
    protected long seqNo;
    protected HMac mac;

    public TlsMac(Digest digest, byte[] byArray, int n, int n2) {
        this.mac = new HMac(digest);
        KeyParameter keyParameter = new KeyParameter(byArray, n, n2);
        this.mac.init(keyParameter);
        this.seqNo = 0L;
    }

    public int getSize() {
        return this.mac.getMacSize();
    }

    public byte[] calculateMac(short s, byte[] byArray, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(13);
        try {
            TlsUtils.writeUint64(this.seqNo++, byteArrayOutputStream);
            TlsUtils.writeUint8(s, byteArrayOutputStream);
            TlsUtils.writeVersion(byteArrayOutputStream);
            TlsUtils.writeUint16(n2, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Internal error during mac calculation");
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        this.mac.update(byArray2, 0, byArray2.length);
        this.mac.update(byArray, n, n2);
        byte[] byArray3 = new byte[this.mac.getMacSize()];
        this.mac.doFinal(byArray3, 0);
        return byArray3;
    }
}

