/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.handler.dhcp;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import net.jradius.handler.dhcp.AddressPool;
import net.jradius.handler.dhcp.AddressPoolListener;
import net.jradius.util.RadiusRandom;
import net.jradius.util.RadiusUtils;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

public class AddressPoolImpl
implements AddressPool,
CacheEventListener {
    protected String leaseFile = "/tmp/leases.dhcp";
    protected InetAddress network;
    protected InetAddress netmask;
    protected InetAddress router;
    protected InetAddress[] dns;
    protected byte next = RadiusRandom.getBytes((int)1)[0];
    protected int fudge = 10;
    protected int leaseTime;
    protected AddressPoolListener listener;
    protected Cache leases;
    private static InetAddress anyIPAddress;

    public AddressPoolImpl() {
    }

    public AddressPoolImpl(InetAddress network, InetAddress netmask, InetAddress router, int leaseTime) {
        this.network = network;
        this.netmask = netmask;
        this.router = router;
        this.leaseTime = leaseTime;
    }

    public boolean contains(InetAddress ip) {
        if (this.getNetwork() == null || this.getNetmask() == null) {
            throw new RuntimeException("network/netmask requierd");
        }
        byte[] networkBytes = this.getNetwork().getAddress();
        byte[] netmaskBytes = this.getNetmask().getAddress();
        byte[] ipBytes = ip.getAddress();
        if (networkBytes.length != netmaskBytes.length || netmaskBytes.length != ipBytes.length) {
            return false;
        }
        for (int i = 0; i < netmaskBytes.length; ++i) {
            int mask = netmaskBytes[i] & 0xFF;
            if ((networkBytes[i] & mask) == (ipBytes[i] & mask)) continue;
            return false;
        }
        return true;
    }

    public InetAddress nextIP() throws UnknownHostException {
        byte[] b;
        if (this.getNetwork() == null || this.getNetmask() == null) {
            throw new RuntimeException("network/netmask requierd");
        }
        InetAddress nextAddress = null;
        do {
            b = this.getNetwork().getAddress();
            byte by = this.next;
            this.next = (byte)(by + 1);
            b[b.length - 1] = by;
        } while (this.leases.get((Serializable)(nextAddress = InetAddress.getByAddress(b))) != null || this.router != null && nextAddress.equals(this.router));
        return nextAddress;
    }

    public InetAddress getIP(byte[] hwa, InetAddress requested, boolean forceNew) throws UnknownHostException {
        if (this.leases == null) {
            throw new RuntimeException("leases not set");
        }
        MACKey hwKey = new MACKey(hwa);
        Element eHW = this.leases.get((Serializable)hwKey);
        Element eIP = this.leases.get((Serializable)requested);
        if (anyIPAddress.equals(requested)) {
            requested = null;
        }
        if (eHW == null) {
            if (requested != null) {
                if (!this.contains(requested)) {
                    return null;
                }
                if (eIP == null || !hwKey.equals(eIP.getValue())) {
                    return null;
                }
                this.leases.remove(eIP.getKey());
                eHW = new Element((Serializable)hwKey, (Serializable)requested);
            } else {
                eHW = new Element((Serializable)hwKey, (Serializable)this.nextIP());
            }
        } else if (forceNew) {
            if (eIP != null && hwKey.equals(eIP.getValue())) {
                this.leases.remove(eIP.getKey());
            }
            eHW = new Element((Serializable)hwKey, (Serializable)this.nextIP());
        } else if (requested != null && !requested.equals(eHW.getValue())) {
            if (eIP != null && hwKey.equals(eIP.getValue())) {
                this.leases.remove(eIP.getKey());
            } else {
                return null;
            }
        }
        eIP = new Element(eHW.getValue(), eHW.getKey());
        this.leases.put(eHW);
        this.leases.put(eIP);
        this.writeLeaseFile();
        return (InetAddress)eHW.getValue();
    }

    public void writeLeaseFile() {
        if (this.getLeaseFile() == null) {
            return;
        }
        try {
            File file = new File(this.getLeaseFile());
            PrintWriter writer = new PrintWriter(new FileWriter(file));
            for (Object o : this.leases.getKeys()) {
                if (!(o instanceof MACKey)) continue;
                InetAddress inet = (InetAddress)this.leases.get(o).getValue();
                MACKey macKey = (MACKey)o;
                writer.print(inet.getHostAddress());
                writer.print(" ");
                writer.println(RadiusUtils.byteArrayToHexString((byte[])macKey.getMAC()));
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void notifyElementEvicted(Ehcache cache, Element e) {
    }

    public void notifyElementExpired(Ehcache cache, Element e) {
    }

    public void notifyElementPut(Ehcache cache, Element e) throws CacheException {
    }

    public void notifyElementRemoved(Ehcache cache, Element e) throws CacheException {
    }

    public void notifyElementUpdated(Ehcache cache, Element e) throws CacheException {
    }

    public void notifyRemoveAll(Ehcache cache) {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void dispose() {
    }

    public void setFudge(int fudge) {
        this.fudge = fudge;
    }

    public void setLeaseFile(String leaseFile) {
        this.leaseFile = leaseFile;
    }

    public void setLeases(Cache leases) {
        this.leases = leases;
    }

    public void setLeaseTime(int leaseTime) {
        this.leaseTime = leaseTime;
    }

    public void setNetmask(InetAddress netmask) {
        this.netmask = netmask;
    }

    public void setNetwork(InetAddress network) {
        this.network = network;
    }

    public void setRouter(InetAddress router) {
        this.router = router;
    }

    public String getLeaseFile() {
        return this.leaseFile;
    }

    public Ehcache getLeases() {
        return this.leases;
    }

    public int getLeaseTime() {
        return this.leaseTime;
    }

    public InetAddress getNetmask() {
        return this.netmask;
    }

    public InetAddress getNetwork() {
        return this.network;
    }

    public InetAddress getRouter() {
        return this.router;
    }

    public InetAddress[] getDns() {
        return this.dns;
    }

    public void setDns(InetAddress[] dns) {
        this.dns = dns;
    }

    public AddressPoolListener getListener() {
        return this.listener;
    }

    public void setListener(AddressPoolListener listener) {
        this.listener = listener;
    }

    static {
        try {
            anyIPAddress = InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class MACKey
    implements Serializable {
        private static final long serialVersionUID = 0L;
        byte[] mac;

        public MACKey(byte[] b) {
            this.mac = b;
        }

        public byte[] getMAC() {
            return this.mac;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MACKey)) {
                return false;
            }
            if (this == o) {
                return true;
            }
            byte[] omac = ((MACKey)o).getMAC();
            if (this.mac.length != omac.length) {
                return false;
            }
            for (int i = 0; i < this.mac.length; ++i) {
                if (this.mac[i] == omac[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Arrays.hashCode(this.mac);
        }
    }
}

