/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.impl;

import java.util.Map;
import javax.xml.namespace.QName;
import org.joda.time.ReadableInstant;
import org.opensaml.Configuration;
import org.opensaml.common.impl.AbstractSAMLObjectMarshaller;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SubjectConfirmationDataMarshaller
extends AbstractSAMLObjectMarshaller {
    @Override
    protected void marshallAttributes(XMLObject samlObject, Element domElement) throws MarshallingException {
        SubjectConfirmationData subjectCD = (SubjectConfirmationData)samlObject;
        if (subjectCD.getNotBefore() != null) {
            String notBeforeStr = Configuration.getSAMLDateFormatter().print((ReadableInstant)subjectCD.getNotBefore());
            domElement.setAttributeNS(null, "NotBefore", notBeforeStr);
        }
        if (subjectCD.getNotOnOrAfter() != null) {
            String notOnOrAfterStr = Configuration.getSAMLDateFormatter().print((ReadableInstant)subjectCD.getNotOnOrAfter());
            domElement.setAttributeNS(null, "NotOnOrAfter", notOnOrAfterStr);
        }
        if (subjectCD.getRecipient() != null) {
            domElement.setAttributeNS(null, "Recipient", subjectCD.getRecipient());
        }
        if (subjectCD.getInResponseTo() != null) {
            domElement.setAttributeNS(null, "InResponseTo", subjectCD.getInResponseTo());
        }
        if (subjectCD.getAddress() != null) {
            domElement.setAttributeNS(null, "Address", subjectCD.getAddress());
        }
        for (Map.Entry entry : subjectCD.getUnknownAttributes().entrySet()) {
            Attr attribute = XMLHelper.constructAttribute((Document)domElement.getOwnerDocument(), (QName)((QName)entry.getKey()));
            attribute.setValue((String)entry.getValue());
            domElement.setAttributeNodeNS(attribute);
            if (!Configuration.isIDAttribute((QName)((QName)entry.getKey())) && !subjectCD.getUnknownAttributes().isIDAttribute((QName)entry.getKey())) continue;
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        }
    }
}

