/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.mapper;

import java.util.Date;
import java.util.List;
import org.mapstruct.CollectionMappingStrategy;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.NullValueCheckStrategy;
import org.mapstruct.NullValueMappingStrategy;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.plugin.grpc.proto.spog.Alarm;
import org.opennms.plugin.grpc.proto.spog.AlarmUpdateList;
import org.opennms.plugin.grpc.proto.spog.NodeCriteria;
import org.opennms.plugin.grpc.proto.spog.Severity;

@Mapper(collectionMappingStrategy=CollectionMappingStrategy.ADDER_PREFERRED, nullValueCheckStrategy=NullValueCheckStrategy.ALWAYS)
public interface AlarmMapper {
    public static final AlarmMapper INSTANCE = (AlarmMapper)Mappers.getMapper(AlarmMapper.class);

    @Mappings(value={@Mapping(target="lastEventTime", expression="java(mapDate(onmsAlarm.getLastEventTime()))"), @Mapping(target="firstEventTime", expression="java(mapDate(onmsAlarm.getFirstEventTime()))"), @Mapping(target="lastUpdateTime", expression="java(mapDate(onmsAlarm.getLastUpdateTime()))"), @Mapping(source="counter", target="count"), @Mapping(target="type", expression="java(mapType(onmsAlarm.getType().getId()))"), @Mapping(target="nodeCriteria", expression="java(mapNodeCriteria(onmsAlarm))"), @Mapping(target="logMessage", source="logMsg"), @Mapping(target="severity", expression="java(mapSeverity(onmsAlarm.getSeverity().toString()))"), @Mapping(target="operatorInstructions", source="operInstruct"), @Mapping(target="managedObjectInstance", source="managedObjectInstance"), @Mapping(target="managedObjectType", source="managedObjectType"), @Mapping(source="ipAddr.hostAddress", target="ipAddress")})
    public Alarm toAlarmUpdate(OnmsAlarm var1);

    @IterableMapping(nullValueMappingStrategy=NullValueMappingStrategy.RETURN_DEFAULT)
    @Mappings(value={@Mapping(target="instanceId", source="runtimeInfo.systemId"), @Mapping(target="instanceName", source="instanceName"), @Mapping(target="alarms", source="onmsAlarmUpdates")})
    public AlarmUpdateList toAlarmUpdates(List<OnmsAlarm> var1, RuntimeInfo var2, String var3, boolean var4);

    default public AlarmUpdateList toAlarmUpdatesList(List<OnmsAlarm> onmsAlarmUpdates, RuntimeInfo runtimeInfo, String instanceName, boolean snapshot) {
        AlarmUpdateList.Builder builder = this.toAlarmUpdates(onmsAlarmUpdates, runtimeInfo, instanceName, snapshot).toBuilder();
        return builder.build();
    }

    @Mappings(value={@Mapping(target="nodeLabel", source="nodeLabel", nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.SET_TO_DEFAULT), @Mapping(target="location", source="node.location.locationName", nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.SET_TO_DEFAULT), @Mapping(target="foreignId", source="node.foreignId", nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.SET_TO_DEFAULT), @Mapping(target="foreignSource", source="node.foreignSource", nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.SET_TO_DEFAULT), @Mapping(target="id", source="nodeId", nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.SET_TO_DEFAULT)})
    public NodeCriteria mapNodeCriteria(OnmsAlarm var1);

    default public int mapType(Integer value) {
        switch (value) {
            case 0: {
                return Alarm.Type.PROBLEM_WITH_CLEAR.getNumber();
            }
            case 1: {
                return Alarm.Type.CLEAR.getNumber();
            }
            case 2: {
                return Alarm.Type.PROBLEM_WITHOUT_CLEAR.getNumber();
            }
        }
        throw new IllegalArgumentException("Unknown value for Type: " + value);
    }

    default public long mapDate(Date date) {
        return date != null ? date.getTime() : 0L;
    }

    default public int mapSeverity(String severity) {
        switch (severity) {
            case "NORMAL": {
                return Severity.NORMAL.getNumber();
            }
            case "CLEARED": {
                return Severity.CLEARED.getNumber();
            }
            case "MINOR": {
                return Severity.MINOR.getNumber();
            }
            case "WARNING": {
                return Severity.WARNING.getNumber();
            }
            case "INDETERMINATE": {
                return Severity.INDETERMINATE.getNumber();
            }
            case "MAJOR": {
                return Severity.MAJOR.getNumber();
            }
            case "CRITICAL": {
                return Severity.CRITICAL.getNumber();
            }
        }
        return Severity.UNRECOGNIZED.getNumber();
    }
}

