/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.model.OnmsNode;

public class NodeRef {
    private final Integer nodeId;
    private final String foreignSource;
    private final String foreignId;

    private NodeRef(int nodeId) {
        this.nodeId = nodeId;
        this.foreignSource = null;
        this.foreignId = null;
    }

    private NodeRef(String foreignSource, String foreignId) {
        this.nodeId = null;
        this.foreignSource = Objects.requireNonNull(foreignSource);
        this.foreignId = Objects.requireNonNull(foreignId);
    }

    private NodeRef(int nodeId, String foreignSource, String foreignId) {
        this.nodeId = nodeId;
        this.foreignSource = Objects.requireNonNull(foreignSource);
        this.foreignId = Objects.requireNonNull(foreignId);
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public String getForeignSource() {
        return this.foreignSource;
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public boolean matches(OnmsNode node) {
        Objects.requireNonNull(node);
        boolean match = Objects.equals(node.getId(), this.nodeId) || Objects.equals(node.getForeignSource(), this.foreignSource) && Objects.equals(node.getForeignId(), this.foreignId);
        return match;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeRef nodeRef = (NodeRef)o;
        return Objects.equals(this.nodeId, nodeRef.nodeId) && Objects.equals(this.foreignSource, nodeRef.foreignSource) && Objects.equals(this.foreignId, nodeRef.foreignId);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.foreignSource, this.foreignId);
    }

    public List<NodeRef> getVariants() {
        ArrayList<NodeRef> variants = new ArrayList<NodeRef>();
        if (this.getNodeId() != null) {
            variants.add(NodeRef.from(this.getNodeId()));
        }
        if (this.getForeignSource() != null && this.getForeignId() != null) {
            variants.add(NodeRef.from(this.getForeignSource(), this.foreignId));
        }
        return variants;
    }

    public static NodeRef from(String nodeRefCriteria) {
        if (nodeRefCriteria.contains(":")) {
            String[] criteria = nodeRefCriteria.split(":");
            return new NodeRef(criteria[0], criteria[1]);
        }
        try {
            int nodeId = Integer.parseInt(nodeRefCriteria);
            return new NodeRef(nodeId);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Provided criteria '" + nodeRefCriteria + "' is not valid. Cannot parse '" + nodeRefCriteria + "' to integer", ex);
        }
    }

    public static NodeRef from(String foreignSource, String foreignId) {
        return new NodeRef(foreignSource, foreignId);
    }

    public static NodeRef from(int nodeId, String foreignSource, String foreignId) {
        return new NodeRef(nodeId, foreignSource, foreignId);
    }

    public static NodeRef from(int nodeId) {
        return new NodeRef(nodeId);
    }

    public static List<NodeRef> from(GenericVertex vertex) {
        Objects.requireNonNull(vertex);
        Object nodeId = vertex.getProperty("nodeID");
        String foreignSource = (String)vertex.getProperty("foreignSource");
        String foreignId = (String)vertex.getProperty("foreignID");
        String nodeRef = (String)vertex.getProperty("nodeCriteria");
        ArrayList nodeRefs = Lists.newArrayList();
        if (nodeId != null) {
            if (nodeId instanceof String) {
                nodeRefs.add(NodeRef.from((String)nodeId));
            } else if (nodeId instanceof Integer) {
                nodeRefs.add(NodeRef.from((Integer)nodeId));
            }
        }
        if (!Strings.isNullOrEmpty((String)foreignSource) && !Strings.isNullOrEmpty((String)foreignId)) {
            nodeRefs.add(NodeRef.from(foreignSource, foreignId));
        }
        if (!Strings.isNullOrEmpty((String)nodeRef)) {
            nodeRefs.add(NodeRef.from(nodeRef));
        }
        return nodeRefs;
    }
}

