/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.daemon;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.ServiceRef;
import org.opennms.netmgt.telemetry.config.model.ConnectorTwinConfig;
import org.opennms.netmgt.telemetry.daemon.LocationPublisher;
import org.opennms.netmgt.telemetry.daemon.LocationPublisherManager;
import org.opennms.netmgt.telemetry.daemon.OpenConfigTwinPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OpenConfigTwinPublisherImpl
implements OpenConfigTwinPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(OpenConfigTwinPublisherImpl.class);
    private final LocationPublisherManager locationPublisherManager;

    @Autowired
    public OpenConfigTwinPublisherImpl(LocationPublisherManager locationPublisherManager) {
        this.locationPublisherManager = locationPublisherManager;
    }

    @Override
    public void publishConfig(ServiceRef serviceRef, List<Map<String, String>> interpolatedMapList, String nodeConnectorKey, String queueName) throws IOException {
        ConnectorTwinConfig.ConnectorConfig twinConfig = this.createTwinConfig(serviceRef, interpolatedMapList, nodeConnectorKey);
        LocationPublisher locationPublisher = this.locationPublisherManager.getOrCreate(serviceRef.getLocation());
        locationPublisher.setQueueName(queueName);
        locationPublisher.addConfigAndPublish(twinConfig);
    }

    @Override
    public void removeConfig(ServiceRef serviceRef, String nodeConnectorKey) throws IOException {
        LocationPublisher locationPublisher = this.locationPublisherManager.getOrCreate(serviceRef.getLocation());
        locationPublisher.removeConfigAndPublish(nodeConnectorKey);
        this.locationPublisherManager.removeIfEmpty(serviceRef.getLocation());
    }

    @Override
    public void close() throws IOException {
        this.locationPublisherManager.forceCloseAll();
    }

    private ConnectorTwinConfig.ConnectorConfig createTwinConfig(ServiceRef serviceRef, List<Map<String, String>> parameters, String nodeConnectotrKey) {
        return new ConnectorTwinConfig.ConnectorConfig(serviceRef.getNodeId(), InetAddressUtils.str((InetAddress)serviceRef.getIpAddress()), nodeConnectotrKey, parameters);
    }
}

