/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.config.vmware.VmwareServer;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.vmware.VmwareConfigDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.opennms.netmgt.provision.service.vmware.VmwareImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractVmwareMonitor
extends AbstractServiceMonitor {
    private final Logger logger = LoggerFactory.getLogger(AbstractVmwareMonitor.class);
    private NodeDao m_nodeDao = null;
    private TransactionTemplate m_transactionTemplate = null;
    private VmwareConfigDao m_vmwareConfigDao = null;

    public Map<String, Object> getRuntimeAttributes(final MonitoredService svc, Map<String, Object> parameters) {
        if (this.m_nodeDao == null) {
            this.m_nodeDao = (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class);
        }
        if (this.m_vmwareConfigDao == null) {
            this.m_vmwareConfigDao = (VmwareConfigDao)BeanUtils.getBean((String)"daoContext", (String)"vmwareConfigDao", VmwareConfigDao.class);
        }
        if (this.m_transactionTemplate == null) {
            this.m_transactionTemplate = (TransactionTemplate)BeanUtils.getBean((String)"daoContext", (String)"transactionTemplate", TransactionTemplate.class);
        }
        final HashMap<String, Object> runtimeAttributes = new HashMap<String, Object>();
        this.m_transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus transactionStatus) {
                OnmsNode onmsNode = (OnmsNode)AbstractVmwareMonitor.this.m_nodeDao.get((Serializable)Integer.valueOf(svc.getNodeId()));
                if (onmsNode == null) {
                    throw new IllegalArgumentException("No node found with ID: " + svc.getNodeId());
                }
                String vmwareManagementServer = VmwareImporter.getManagementServer(onmsNode);
                String vmwareManagedEntityType = VmwareImporter.getManagedEntityType(onmsNode);
                String vmwareManagedObjectId = onmsNode.getForeignId();
                Map<String, VmwareServer> serverMap = AbstractVmwareMonitor.this.m_vmwareConfigDao.getServerMap();
                if (serverMap == null) {
                    AbstractVmwareMonitor.this.logger.error("Error getting vmware-config.xml's server map.");
                } else {
                    VmwareServer vmwareServer = serverMap.get(vmwareManagementServer);
                    if (vmwareServer == null) {
                        AbstractVmwareMonitor.this.logger.error("Error getting credentials for VMware management server '{}'.", (Object)vmwareManagementServer);
                    } else {
                        runtimeAttributes.put("managementServerUsername", Interpolator.pleaseInterpolate((Object)vmwareServer.getUsername()));
                        runtimeAttributes.put("managementServerPassword", Interpolator.pleaseInterpolate((Object)vmwareServer.getPassword()));
                    }
                }
                runtimeAttributes.put("managementServer", vmwareManagementServer);
                runtimeAttributes.put("managedEntityType", vmwareManagedEntityType);
                runtimeAttributes.put("managedObjectId", vmwareManagedObjectId);
                return null;
            }
        });
        return runtimeAttributes;
    }
}

