/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.opennms.autoincrement;

import java.util.ArrayList;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeNote;
import liquibase.change.core.AddAutoIncrementChange;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddDefaultValueStatement;
import liquibase.statement.core.CreateSequenceStatement;
import liquibase.statement.core.SetNullableStatement;

@DatabaseChange(name="addAutoIncrement", description="Converts an existing column to be an auto-increment (a.k.a 'identity') column", priority=2, appliesTo={"column"}, databaseNotes={@DatabaseChangeNote(database="sqlite", notes="If the column type is not INTEGER it is converted to INTEGER")})
public class AddNamedAutoIncrementChange
extends AddAutoIncrementChange {
    private String m_sequenceName;

    public String getSequenceName() {
        return this.m_sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.m_sequenceName = sequenceName;
    }

    public SqlStatement[] generateStatements(Database database) {
        ArrayList<Object> statements = new ArrayList<Object>();
        if (database instanceof PostgresDatabase) {
            String sequenceName = this.m_sequenceName;
            if (this.m_sequenceName == null) {
                sequenceName = (this.getTableName() + "_" + this.getColumnName() + "_seq").toLowerCase();
                statements.add(new CreateSequenceStatement(this.getCatalogName(), this.getSchemaName(), sequenceName));
            }
            statements.add(new SetNullableStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getColumnName(), null, false));
            statements.add(new AddDefaultValueStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getColumnName(), this.getColumnDataType(), (Object)new DatabaseFunction("NEXTVAL('" + sequenceName + "')")));
            return statements.toArray(new SqlStatement[0]);
        }
        return super.generateStatements(database);
    }
}

