/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.util;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableMetric;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableSample;
import org.opennms.netmgt.model.ResourcePath;

public final class TimeseriesUtils {
    public static String toResourceId(ResourcePath path) {
        return String.join((CharSequence)"/", path.elements());
    }

    public static ResourcePath toResourcePath(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        List<String> els = Arrays.asList(resourceId.split("/"));
        return ResourcePath.get(els.subList(0, els.size() - 1));
    }

    public static String toMetricName(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        List<String> els = Arrays.asList(resourceId.split("/"));
        return els.get(els.size() - 1);
    }

    public static Sample createSampleForIndexingStrings(String resourceId, Map<String, String> attributes) {
        ImmutableMetric.MetricBuilder metric = ImmutableMetric.builder().intrinsicTag("resourceId", resourceId).intrinsicTag("name", "Not needed");
        attributes.forEach((arg_0, arg_1) -> ((ImmutableMetric.MetricBuilder)metric).metaTag(arg_0, arg_1));
        return ImmutableSample.builder().time(Instant.EPOCH).value(Double.valueOf(0.0)).metric((Metric)metric.build()).build();
    }

    public static String toSearchRegex(ResourcePath path, int depth) {
        return "^" + TimeseriesUtils.toResourceId(path) + "/[^./]*".repeat(depth) + "$";
    }
}

