/*
 * Decompiled with CFR 0.152.
 */
package rpc.pdu;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import ndr.NdrBuffer;
import ndr.NetworkDataRepresentation;
import rpc.ConnectionOrientedPdu;
import rpc.FaultCodes;
import rpc.Fragmentable;

public class FaultCoPdu
extends ConnectionOrientedPdu
implements FaultCodes,
Fragmentable {
    public static final int FAULT_TYPE = 3;
    private byte[] stub;
    private int allocationHint = 0;
    private int contextId = 0;
    private int cancelCount = 0;
    private int status = 469762057;

    @Override
    public int getType() {
        return 3;
    }

    public byte[] getStub() {
        return this.stub;
    }

    public void setStub(byte[] stub) {
        this.stub = stub;
    }

    public int getAllocationHint() {
        return this.allocationHint;
    }

    public void setAllocationHint(int allocationHint) {
        this.allocationHint = allocationHint;
    }

    public int getContextId() {
        return this.contextId;
    }

    public void setContextId(int contextId) {
        this.contextId = contextId;
    }

    public int getCancelCount() {
        return this.cancelCount;
    }

    public void setCancelCount(int cancelCount) {
        this.cancelCount = cancelCount;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    protected void readPdu(NetworkDataRepresentation ndr) {
        this.readHeader(ndr);
        this.readBody(ndr);
        this.readStub(ndr);
    }

    @Override
    protected void writePdu(NetworkDataRepresentation ndr) {
        this.writeHeader(ndr);
        this.writeBody(ndr);
        this.writeStub(ndr);
    }

    @Override
    protected void readBody(NetworkDataRepresentation ndr) {
        this.setAllocationHint(ndr.readUnsignedLong());
        this.setContextId(ndr.readUnsignedShort());
        this.setCancelCount(ndr.readUnsignedSmall());
        this.setStatus(ndr.readUnsignedLong());
    }

    @Override
    protected void writeBody(NetworkDataRepresentation ndr) {
        ndr.writeUnsignedLong(this.getAllocationHint());
        ndr.writeUnsignedShort(this.getContextId());
        ndr.writeUnsignedSmall((short)this.getCancelCount());
        ndr.writeUnsignedLong(this.getStatus());
    }

    protected void readStub(NetworkDataRepresentation ndr) {
        NdrBuffer buf = ndr.getBuffer();
        buf.align(8);
        byte[] stub = null;
        int length = this.getFragmentLength() - buf.getIndex();
        if (length > 0) {
            stub = new byte[length];
            ndr.readOctetArray(stub, 0, length);
        }
        this.setStub(stub);
    }

    protected void writeStub(NetworkDataRepresentation ndr) {
        NdrBuffer buf = ndr.getBuffer();
        buf.align(8, (byte)0);
        byte[] stub = this.getStub();
        if (stub != null) {
            ndr.writeOctetArray(stub, 0, stub.length);
        }
    }

    @Override
    public Iterator fragment(int size) {
        byte[] stub = this.getStub();
        if (stub == null) {
            return Arrays.asList(this).iterator();
        }
        int stubSize = size - 24;
        if (stub.length <= stubSize) {
            return Arrays.asList(this).iterator();
        }
        return new FragmentIterator(stubSize);
    }

    @Override
    public Fragmentable assemble(Iterator fragments) throws IOException {
        if (!fragments.hasNext()) {
            throw new IOException("No fragments available.");
        }
        try {
            FaultCoPdu pdu = (FaultCoPdu)fragments.next();
            byte[] stub = pdu.getStub();
            if (stub == null) {
                stub = new byte[]{};
            }
            while (fragments.hasNext()) {
                FaultCoPdu fragment = (FaultCoPdu)fragments.next();
                byte[] fragmentStub = fragment.getStub();
                if (fragmentStub == null || fragmentStub.length <= 0) continue;
                byte[] tmp = new byte[stub.length + fragmentStub.length];
                System.arraycopy(stub, 0, tmp, 0, stub.length);
                System.arraycopy(fragmentStub, 0, tmp, stub.length, fragmentStub.length);
                stub = tmp;
            }
            int length = stub.length;
            if (length > 0) {
                pdu.setStub(stub);
                pdu.setAllocationHint(length);
            } else {
                pdu.setStub(null);
                pdu.setAllocationHint(0);
            }
            pdu.setFlag(1, true);
            pdu.setFlag(2, true);
            return pdu;
        }
        catch (Exception ex) {
            throw new IOException("Unable to assemble PDU fragments.");
        }
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            throw new IllegalStateException();
        }
    }

    private class FragmentIterator
    implements Iterator {
        private final int stubSize;
        private int index = 0;

        FragmentIterator(int stubSize) {
            this.stubSize = stubSize;
        }

        @Override
        public boolean hasNext() {
            return this.index < FaultCoPdu.this.stub.length;
        }

        public Object next() {
            if (this.index >= FaultCoPdu.this.stub.length) {
                throw new NoSuchElementException();
            }
            FaultCoPdu fragment = (FaultCoPdu)FaultCoPdu.this.clone();
            int allocation = FaultCoPdu.this.stub.length - this.index;
            fragment.setAllocationHint(allocation);
            if (this.stubSize < allocation) {
                allocation = this.stubSize;
            }
            byte[] fragmentStub = new byte[allocation];
            System.arraycopy(FaultCoPdu.this.stub, this.index, fragmentStub, 0, allocation);
            fragment.setStub(fragmentStub);
            int flags = FaultCoPdu.this.getFlags() & 0xFFFFFFFC;
            if (this.index == 0) {
                flags |= 1;
            }
            this.index += allocation;
            if (this.index >= FaultCoPdu.this.stub.length) {
                flags |= 2;
            }
            fragment.setFlags(flags);
            return fragment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

