/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.legacy;

import java.util.List;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.MetaTopologyProvider;
import org.opennms.netmgt.graph.api.ImmutableGraphContainer;
import org.opennms.netmgt.graph.api.generic.GenericGraphContainer;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.provider.legacy.LegacyGraph;

public class LegacyGraphContainer
implements ImmutableGraphContainer<LegacyGraph> {
    private final MetaTopologyProvider delegate;
    private final String id;
    private final String label;
    private final String description;

    public LegacyGraphContainer(MetaTopologyProvider delegate, String id, String label, String description) {
        this.delegate = delegate;
        this.id = id;
        this.label = label;
        this.description = description;
    }

    public List<LegacyGraph> getGraphs() {
        return this.delegate.getGraphProviders().stream().map(LegacyGraph::getLegacyGraphFromTopoGraphProvider).collect(Collectors.toList());
    }

    public LegacyGraph getGraph(String namespace) {
        return LegacyGraph.getLegacyGraphFromTopoGraphProvider(this.delegate.getGraphProviderBy(namespace));
    }

    public GenericGraphContainer asGenericGraphContainer() {
        GenericGraphContainer.GenericGraphContainerBuilder builder = GenericGraphContainer.builder().id(this.id).label(this.label).description(this.description);
        for (LegacyGraph graph : this.getGraphs()) {
            builder.addGraph(graph.asGenericGraph());
        }
        return builder.build();
    }

    public String getId() {
        return this.id;
    }

    public List<String> getNamespaces() {
        return this.delegate.getGraphProviders().stream().map(GraphProvider::getNamespace).collect(Collectors.toList());
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public GraphInfo getGraphInfo(String namespace) {
        return LegacyGraph.getGraphInfo(this.delegate.getGraphProviderBy(namespace));
    }

    public GraphInfo getPrimaryGraphInfo() {
        return LegacyGraph.getGraphInfo(this.delegate.getDefaultGraphProvider());
    }

    public List<GraphInfo> getGraphInfos() {
        return this.delegate.getGraphProviders().stream().map(LegacyGraph::getGraphInfo).collect(Collectors.toList());
    }
}

