/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.twin.jms.publisher;

import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.opentracing.Scope;
import io.opentracing.Tracer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Converter;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TypeConverters;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.opennms.core.ipc.twin.api.LocalTwinSubscriber;
import org.opennms.core.ipc.twin.api.TwinRequest;
import org.opennms.core.ipc.twin.api.TwinUpdate;
import org.opennms.core.ipc.twin.common.AbstractTwinPublisher;
import org.opennms.core.ipc.twin.model.TwinResponseProto;
import org.opennms.core.logging.Logging;
import org.opennms.core.tracing.api.TracerRegistry;
import org.opennms.core.tracing.util.TracingInfoCarrier;
import org.opennms.core.utils.SystemInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsTwinPublisher
extends AbstractTwinPublisher
implements AsyncProcessor {
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("jms-twin-publisher-%d").build();
    private static final String TWIN_QUEUE_NAME_FORMAT = "%s.%s";
    private static final Logger LOG = LoggerFactory.getLogger(JmsTwinPublisher.class);
    public static String JMS_QUEUE_NAME_HEADER = "JmsQueueName";
    private final CamelContext rpcCamelContext;
    private final ExecutorService executor = Executors.newFixedThreadPool(10, this.threadFactory);
    @EndpointInject(uri="direct:sendTwinUpdate", context="twinSinkClient")
    private ProducerTemplate template;
    @EndpointInject(uri="direct:sendTwinUpdate", context="twinSinkClient")
    private Endpoint endpoint;

    public JmsTwinPublisher(CamelContext camelContext, LocalTwinSubscriber twinSubscriber, TracerRegistry tracerRegistry, MetricRegistry metricRegistry) {
        super(twinSubscriber, tracerRegistry, metricRegistry);
        this.rpcCamelContext = camelContext;
        camelContext.getTypeConverterRegistry().addTypeConverters((TypeConverters)new BooleanTypeConverters());
    }

    protected void handleSinkUpdate(TwinUpdate sinkUpdate) {
        try {
            TwinResponseProto twinResponseProto = this.mapTwinResponse(sinkUpdate);
            HashMap<String, String> headers = new HashMap<String, String>();
            String queueName = String.format(TWIN_QUEUE_NAME_FORMAT, SystemInfoUtils.getInstanceId(), "Twin.Sink");
            headers.put(JMS_QUEUE_NAME_HEADER, queueName);
            this.template.sendBodyAndHeaders((Object)twinResponseProto.toByteArray(), headers);
        }
        catch (Exception e) {
            LOG.error("Exception while sending update for key {} at location {} ", (Object)sinkUpdate.getKey(), (Object)sinkUpdate.getLocation());
        }
    }

    public void init() throws Exception {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            this.rpcCamelContext.addRoutes((RoutesBuilder)new RpcRouteBuilder(this, this.rpcCamelContext));
            LOG.info("JMS Twin publisher initialized");
        }
    }

    public void close() throws IOException {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
            this.executor.shutdownNow();
            LOG.info("JMS Twin publisher stopped");
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        byte[] requestBytes = (byte[])exchange.getIn().getBody(byte[].class);
        CompletableFuture.runAsync(() -> {
            try {
                TwinRequest twinRequest = this.mapTwinRequestProto(requestBytes);
                String tracingOperationKey = JmsTwinPublisher.generateTracingOperationKey((String)twinRequest.getLocation(), (String)twinRequest.getKey());
                Tracer.SpanBuilder spanBuilder = TracingInfoCarrier.buildSpanFromTracingMetadata((Tracer)this.getTracer(), (String)tracingOperationKey, (Map)twinRequest.getTracingInfo(), (String)"follows_from");
                try (Scope scope = spanBuilder.startActive(true);){
                    TwinUpdate twinUpdate = this.getTwin(twinRequest);
                    this.addTracingInfo(scope.span(), twinUpdate);
                    TwinResponseProto twinResponseProto = this.mapTwinResponse(twinUpdate);
                    exchange.getOut().setBody((Object)twinResponseProto.toByteArray());
                    callback.done(false);
                }
            }
            catch (Exception e) {
                LOG.error("Exception while processing request", (Throwable)e);
            }
        }, this.executor);
        return false;
    }

    public void process(Exchange exchange) throws Exception {
        throw new UnsupportedOperationException("This processor must be invoked using the async interface.");
    }

    public static final class BooleanTypeConverters
    implements TypeConverters {
        @Converter
        public String toString(boolean data) {
            return Boolean.toString(data);
        }

        @Converter
        public boolean toBoolean(String data) {
            return Boolean.valueOf(data);
        }
    }

    private static class RpcRouteBuilder
    extends RouteBuilder {
        private final AsyncProcessor asyncProcessor;

        private RpcRouteBuilder(AsyncProcessor asyncProcessor, CamelContext camelContext) {
            super(camelContext);
            this.asyncProcessor = asyncProcessor;
            camelContext.getTypeConverterRegistry().addTypeConverters((TypeConverters)new BooleanTypeConverters());
        }

        public void configure() throws Exception {
            String queueName = String.format(JmsTwinPublisher.TWIN_QUEUE_NAME_FORMAT, SystemInfoUtils.getInstanceId(), "Twin.RPC");
            JmsEndpoint endpoint = (JmsEndpoint)this.getContext().getEndpoint(String.format("queuingservice:%s?asyncConsumer=true", queueName), JmsEndpoint.class);
            ((RouteDefinition)((RouteDefinition)this.from((Endpoint)endpoint).setExchangePattern(ExchangePattern.InOut)).process((Processor)this.asyncProcessor)).routeId(SystemInfoUtils.getInstanceId() + ".Twin.RPC");
        }
    }
}

