/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.tree;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.tree.TreeNode;

public final class TreeModelUtils {
    private static Log logger = LogFactory.getLog(TreeModelUtils.class);

    private TreeModelUtils() {
    }

    public static List loadTreeStructure(TableModel model, Collection inputList) throws Exception {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        ArrayList searchList = new ArrayList();
        searchList.addAll(inputList);
        Iterator iter = searchList.iterator();
        while (iter.hasNext()) {
            String parentAttribute;
            Object bean = iter.next();
            String parentId = BeanUtils.getProperty(bean, (String)(parentAttribute = model.getTableHandler().getTable().getAttributeAsString("parentAttribute")));
            if (parentId != null && !StringUtils.isBlank((CharSequence)(parentId + ""))) continue;
            TreeNode node = new TreeNode(bean, TreeModelUtils.getBeanId(model, bean), 0);
            result.add(node);
            iter.remove();
            TreeModelUtils.loadChildren(model, result, searchList, node, 0);
        }
        return result;
    }

    public static void loadChildren(TableModel model, List displayList, List searchList, TreeNode node, int currentDepth) throws Exception {
        ++currentDepth;
        ArrayList subList = new ArrayList();
        subList.addAll(searchList);
        Object id = node.getIdentifier();
        String key = TreeModelUtils.getNodeKey(model, id);
        Map openNodes = (Map)model.getTableHandler().getTable().getAttribute("openNodes");
        if (openNodes.get(key) != null) {
            node.setOpen(true);
        } else {
            node.setOpen(false);
        }
        Iterator iter = subList.iterator();
        while (iter.hasNext()) {
            Object bean = iter.next();
            if (!TreeModelUtils.nodeIsBeanParent(model, node, bean)) continue;
            TreeNode childNode = new TreeNode(bean, TreeModelUtils.getBeanId(model, bean), currentDepth);
            node.addChild(childNode);
            childNode.setParent(node);
            iter.remove();
            if (TreeModelUtils.isOpen(model, node, true)) {
                displayList.add(childNode);
            }
            TreeModelUtils.loadChildren(model, displayList, subList, childNode, currentDepth);
        }
    }

    public static Collection findParents(TableModel model, Collection searchList) throws Exception {
        logger.debug((Object)"TableModel.findParents()");
        ArrayList result = new ArrayList();
        for (Object bean : searchList) {
            if (!result.contains(bean)) {
                result.add(bean);
            }
            TreeModelUtils.findBeanParents(model, searchList, result, bean);
        }
        return result;
    }

    public static void findBeanParents(TableModel model, Collection searchList, Collection parents, Object bean) throws Exception {
        Object parent = null;
        String parentAttribute = model.getTableHandler().getTable().getAttributeAsString("parentAttribute");
        parent = bean instanceof Map ? ((Map)bean).get(parentAttribute) : PropertyUtils.getProperty((Object)bean, (String)parentAttribute);
        if (parent == null) {
            return;
        }
        Object parentBean = TreeModelUtils.findByIdentifierOrReference(model, (List)searchList, parent);
        if (parentBean == null) {
            return;
        }
        if (!parents.contains(parentBean)) {
            parents.add(parentBean);
        }
        TreeModelUtils.findBeanParents(model, searchList, parents, parentBean);
    }

    public static Object findByIdentifierOrReference(TableModel model, List searchList, Object bean) {
        if (searchList.contains(bean)) {
            return bean;
        }
        String identifier = model.getTableHandler().getTable().getAttributeAsString("identifier");
        for (int i = 0; i < searchList.size(); ++i) {
            Object row = searchList.get(i);
            try {
                if (!bean.equals(BeanUtils.getProperty(row, (String)identifier))) continue;
                return row;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.error((Object)("failed to fetch property " + row), (Throwable)e);
            }
        }
        return null;
    }

    public static void addClosedChildren(TableModel model, Collection displayList) throws Exception {
        logger.debug((Object)"TableModel.addClosedChildren()");
        ArrayList parents = new ArrayList();
        parents.addAll(displayList);
        for (TreeNode node : parents) {
            if (node.getChildren() != null && node.getChildren().size() != 0) continue;
            TreeModelUtils.addChildren(model, displayList, node);
        }
    }

    public static void addChildren(TableModel model, Collection displayList, TreeNode node) throws Exception {
        for (Object bean : model.getCollectionOfBeans()) {
            if (!TreeModelUtils.nodeIsBeanParent(model, node, bean)) continue;
            TreeNode childNode = new TreeNode(bean, TreeModelUtils.getBeanId(model, bean), node.getDepth() + 1);
            node.addChild(childNode);
            Object id = node.getIdentifier();
            Map openNodes = (Map)model.getTableHandler().getTable().getAttribute("openNodes");
            String nodeKey = TreeModelUtils.getNodeKey(model, id);
            Object openParam = openNodes.get(nodeKey);
            if (openParam != null && openParam instanceof String[]) {
                openParam = ((String[])openParam)[0];
            }
            if (TreeModelUtils.isOpen(model, node, false) || "true".equals(openParam)) {
                node.setOpen(true);
                int parentPosition = ((List)displayList).indexOf(node);
                ((List)displayList).add(parentPosition + 1, childNode);
            }
            TreeModelUtils.addChildren(model, displayList, childNode);
        }
    }

    public static boolean nodeIsBeanParent(TableModel model, TreeNode node, Object bean) throws Exception {
        Object parent = null;
        String parentAttribute = model.getTableHandler().getTable().getAttributeAsString("parentAttribute");
        parent = bean instanceof Map ? ((Map)bean).get(parentAttribute) : PropertyUtils.getProperty((Object)bean, (String)parentAttribute);
        if (parent != null) {
            logger.debug((Object)("parent instanceof " + parent.getClass().getName()));
        }
        if (parent == null || StringUtils.isBlank((CharSequence)(parent + ""))) {
            return false;
        }
        Object nodeId = node.getIdentifier();
        Object parentId = TreeModelUtils.getBeanId(model, parent);
        if (node.getBean().equals(parent)) {
            return true;
        }
        return nodeId.equals(parentId);
    }

    public static Object getBeanId(TableModel model, Object bean) throws Exception {
        try {
            String identifier = model.getTableHandler().getTable().getAttributeAsString("identifier");
            if (bean instanceof Map) {
                return ((Map)bean).get(identifier);
            }
            return PropertyUtils.getProperty((Object)bean, (String)identifier);
        }
        catch (NoSuchMethodException e) {
            return bean;
        }
    }

    public static boolean isOpen(TableModel model, TreeNode node, boolean filterControlled) {
        boolean filtered = model.getLimit().isFiltered();
        boolean cleared = model.getLimit().isCleared();
        if (filterControlled && filtered && !cleared) {
            node.setOpen(true);
            return true;
        }
        if (!node.isOpen()) {
            return false;
        }
        if (node.getParent() == null) {
            return true;
        }
        return TreeModelUtils.isOpen(model, node.getParent(), filterControlled);
    }

    public static String getNodeKey(TableModel model, Object id) {
        return model.getTableHandler().prefixWithTableId() + "o_" + id;
    }
}

