/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.endpoints.grafana.client;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.opennms.netmgt.endpoints.grafana.api.Dashboard;
import org.opennms.netmgt.endpoints.grafana.api.DashboardWithMeta;
import org.opennms.netmgt.endpoints.grafana.api.GrafanaClient;
import org.opennms.netmgt.endpoints.grafana.api.Panel;
import org.opennms.netmgt.endpoints.grafana.client.GrafanaServerConfiguration;
import org.opennms.netmgt.endpoints.grafana.client.PanelDeserializer;

public class GrafanaClientImpl
implements GrafanaClient {
    private final GrafanaServerConfiguration config;
    private final Gson gson;
    private final OkHttpClient client;
    private final HttpUrl baseUrl;

    public GrafanaClientImpl(GrafanaServerConfiguration grafanaServerConfiguration) {
        this.config = Objects.requireNonNull(grafanaServerConfiguration);
        this.baseUrl = HttpUrl.parse((String)grafanaServerConfiguration.getUrl());
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout((long)this.config.getConnectTimeoutSeconds(), TimeUnit.SECONDS).readTimeout((long)this.config.getReadTimeoutSeconds(), TimeUnit.SECONDS);
        builder = GrafanaClientImpl.configureToIgnoreCertificate(builder);
        this.client = builder.build();
        this.gson = new GsonBuilder().registerTypeAdapter(Panel.class, (Object)new PanelDeserializer()).create();
    }

    public List<Dashboard> getDashboards() throws IOException {
        HttpUrl url = this.baseUrl.newBuilder().addPathSegment("api").addPathSegment("search").query("query=&type=dash-db").build();
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + this.config.getApiKey()).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Request failed: " + GrafanaClientImpl.extractMessageFromErrorResponse(response));
            }
            String json = response.body().string();
            Dashboard[] dashboards = (Dashboard[])this.gson.fromJson(json, Dashboard[].class);
            List<Dashboard> list = Arrays.asList(dashboards);
            return list;
        }
    }

    public Dashboard getDashboardByUid(String uid) throws IOException {
        HttpUrl url = this.baseUrl.newBuilder().addPathSegment("api").addPathSegment("dashboards").addPathSegment("uid").addPathSegment(uid).build();
        Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + this.config.getApiKey()).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Request failed: " + GrafanaClientImpl.extractMessageFromErrorResponse(response));
            }
            String json = response.body().string();
            DashboardWithMeta dashboardWithMeta = (DashboardWithMeta)this.gson.fromJson(json, DashboardWithMeta.class);
            dashboardWithMeta.getDashboard().setMeta(dashboardWithMeta.getMeta());
            Dashboard dashboard = dashboardWithMeta.getDashboard();
            return dashboard;
        }
    }

    public CompletableFuture<byte[]> renderPngForPanel(Dashboard dashboard, Panel panel, int width, int height, long from, long to, String timezone, Map<String, String> variables) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegment("render").addPathSegment("d-solo").addPathSegment(dashboard.getUid()).addPathSegments(dashboard.getMeta().getSlug());
        builder.addQueryParameter("panelId", Integer.toString(panel.getId())).addQueryParameter("from", Long.toString(from)).addQueryParameter("to", Long.toString(to)).addQueryParameter("width", Integer.toString(width)).addQueryParameter("height", Integer.toString(height)).addQueryParameter("timeout", Integer.toString(this.config.getReadTimeoutSeconds())).addQueryParameter("theme", "light");
        if (!Strings.isNullOrEmpty((String)timezone)) {
            builder.addQueryParameter("tz", timezone);
        }
        variables.forEach((k, v) -> builder.addQueryParameter("var-" + k, v));
        Request request = new Request.Builder().url(builder.build()).addHeader("Authorization", "Bearer " + this.config.getApiKey()).build();
        final CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
            }

            public void onResponse(Call call, Response response) {
                try (ResponseBody responseBody = response.body();){
                    if (!response.isSuccessful()) {
                        try {
                            future.completeExceptionally(new IOException("Request failed: " + GrafanaClientImpl.extractMessageFromErrorResponse(response)));
                        }
                        catch (IOException e) {
                            future.completeExceptionally(new IOException("Could not extract message from error response", e));
                        }
                    }
                    try (InputStream is = responseBody.byteStream();){
                        future.complete(GrafanaClientImpl.inputStreamToByteArray(is));
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                }
            }
        });
        return future;
    }

    private static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private static OkHttpClient.Builder configureToIgnoreCertificate(OkHttpClient.Builder builder) {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            builder.hostnameVerifier((hostname, session) -> true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return builder;
    }

    private static String extractMessageFromErrorResponse(Response response) throws IOException {
        String contentType = response.header("Content-Type");
        if (contentType.toLowerCase().contains("application/json")) {
            JSONTokener tokener = new JSONTokener(response.body().string());
            JSONObject json = new JSONObject(tokener);
            if (json.has("message")) {
                return json.getString("message");
            }
            return json.toString();
        }
        return response.body().string();
    }
}

