/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.ticketing.immutables;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.integration.api.v1.ticketing.Ticket;
import org.opennms.integration.api.v1.util.ImmutableCollections;
import org.opennms.integration.api.v1.util.MutableCollections;

public final class ImmutableTicket
implements Ticket {
    private final Integer alarmId;
    private final Map<String, String> attributes;
    private final String details;
    private final String id;
    private final InetAddress ipAddress;
    private final Integer nodeId;
    private final Ticket.State state;
    private final String summary;
    private final String user;

    private ImmutableTicket(Builder builder) {
        this.alarmId = builder.alarmId;
        this.attributes = ImmutableCollections.newMapOfImmutableTypes(builder.attributes);
        this.details = builder.details;
        this.id = builder.id;
        this.ipAddress = builder.ipAddress;
        this.nodeId = builder.nodeId;
        this.state = builder.state;
        this.summary = builder.summary;
        this.user = builder.user;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(Ticket ticket) {
        return new Builder(ticket);
    }

    public static Ticket immutableCopy(Ticket ticket) {
        if (ticket == null || ticket instanceof ImmutableTicket) {
            return ticket;
        }
        return ImmutableTicket.newBuilderFrom(ticket).build();
    }

    public Integer getAlarmId() {
        return this.alarmId;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getDetails() {
        return this.details;
    }

    public String getId() {
        return this.id;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public Ticket.State getState() {
        return this.state;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableTicket that = (ImmutableTicket)o;
        return Objects.equals(this.alarmId, that.alarmId) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.details, that.details) && Objects.equals(this.id, that.id) && Objects.equals(this.ipAddress, that.ipAddress) && Objects.equals(this.nodeId, that.nodeId) && this.state == that.state && Objects.equals(this.summary, that.summary) && Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.alarmId, this.attributes, this.details, this.id, this.ipAddress, this.nodeId, this.state, this.summary, this.user);
    }

    public String toString() {
        return "ImmutableTicket{alarmId=" + this.alarmId + ", attributes=" + this.attributes + ", details='" + this.details + "', id='" + this.id + "', ipAddress=" + this.ipAddress + ", nodeId=" + this.nodeId + ", state=" + this.state + ", summary='" + this.summary + "', user='" + this.user + "'}";
    }

    public static final class Builder {
        private Integer alarmId;
        private Map<String, String> attributes;
        private String details;
        private String id;
        private InetAddress ipAddress;
        private Integer nodeId;
        private Ticket.State state;
        private String summary;
        private String user;

        private Builder() {
        }

        private Builder(Ticket ticket) {
            this.alarmId = ticket.getAlarmId();
            this.attributes = MutableCollections.copyMapFromNullable(ticket.getAttributes());
            this.details = ticket.getDetails();
            this.id = ticket.getId();
            this.ipAddress = ticket.getIpAddress();
            this.nodeId = ticket.getNodeId();
            this.state = ticket.getState();
            this.summary = ticket.getSummary();
            this.user = ticket.getUser();
        }

        public Builder setAlarmId(Integer alarmId) {
            this.alarmId = alarmId;
            return this;
        }

        public Builder setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder addAttribute(String key, String value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(key, value);
            return this;
        }

        public Builder setDetails(String details) {
            this.details = details;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setIpAddress(InetAddress ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder setNodeId(Integer nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setState(Ticket.State state) {
            this.state = state;
            return this;
        }

        public Builder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public ImmutableTicket build() {
            return new ImmutableTicket(this);
        }
    }
}

