/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability;

import io.swagger.v3.oas.annotations.Hidden;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.reporting.availability.DaysOfWeek;
import org.opennms.reporting.availability.Week;

@XmlRootElement(name="calendarTable")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CalendarTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="month")
    private String month;
    @XmlElement(name="daysOfWeek")
    private DaysOfWeek daysOfWeek;
    @XmlElement(name="week", required=true)
    private List<Week> weekList = new ArrayList<Week>();

    public void addWeek(Week vWeek) throws IndexOutOfBoundsException {
        if (this.weekList.size() >= 6) {
            throw new IndexOutOfBoundsException("addWeek has a maximum of 6");
        }
        this.weekList.add(vWeek);
    }

    public void addWeek(int index, Week vWeek) throws IndexOutOfBoundsException {
        if (this.weekList.size() >= 6) {
            throw new IndexOutOfBoundsException("addWeek has a maximum of 6");
        }
        this.weekList.add(index, vWeek);
    }

    public Enumeration<Week> enumerateWeek() {
        return Collections.enumeration(this.weekList);
    }

    public DaysOfWeek getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public String getMonth() {
        return this.month;
    }

    public Week getWeek(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.weekList.size()) {
            throw new IndexOutOfBoundsException("getWeek: Index value '" + index + "' not in range [0.." + (this.weekList.size() - 1) + "]");
        }
        return this.weekList.get(index);
    }

    public Week[] getWeek() {
        Week[] array = new Week[]{};
        return this.weekList.toArray(array);
    }

    public List<Week> getWeekCollection() {
        return this.weekList;
    }

    public int getWeekCount() {
        return this.weekList.size();
    }

    public Iterator<Week> iterateWeek() {
        return this.weekList.iterator();
    }

    public void removeAllWeek() {
        this.weekList.clear();
    }

    public boolean removeWeek(Week vWeek) {
        boolean removed = this.weekList.remove(vWeek);
        return removed;
    }

    public Week removeWeekAt(int index) {
        Week obj = this.weekList.remove(index);
        return obj;
    }

    public void setDaysOfWeek(DaysOfWeek daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    @Hidden
    public void setWeek(int index, Week vWeek) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.weekList.size()) {
            throw new IndexOutOfBoundsException("setWeek: Index value '" + index + "' not in range [0.." + (this.weekList.size() - 1) + "]");
        }
        this.weekList.set(index, vWeek);
    }

    @Hidden
    public void setWeek(Week[] vWeekArray) {
        this.weekList.clear();
        for (int i = 0; i < vWeekArray.length; ++i) {
            this.weekList.add(vWeekArray[i]);
        }
    }

    public void setWeek(List<Week> vWeekList) {
        this.weekList.clear();
        this.weekList.addAll(vWeekList);
    }

    @Hidden
    public void setWeekCollection(List<Week> weekList) {
        this.weekList = weekList;
    }
}

