/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.docpath;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.walker.XmlSchemaAttrInfo;
import org.apache.ws.commons.schema.walker.XmlSchemaTypeInfo;

public final class XmlSchemaStateMachineNode {
    private final Type nodeType;
    private final XmlSchemaElement element;
    private final List<XmlSchemaAttrInfo> attributes;
    private final XmlSchemaTypeInfo typeInfo;
    private final long minOccurs;
    private final long maxOccurs;
    private final XmlSchemaAny any;
    private List<XmlSchemaStateMachineNode> possibleNextStates;

    XmlSchemaStateMachineNode(Type nodeType, long minOccurs, long maxOccurs) {
        if (nodeType.equals((Object)Type.ELEMENT)) {
            throw new IllegalArgumentException("This constructor cannot be used for elements.");
        }
        if (nodeType.equals((Object)Type.ANY)) {
            throw new IllegalArgumentException("This constructor cannot be used for wildcard elements.");
        }
        this.nodeType = nodeType;
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
        this.element = null;
        this.attributes = null;
        this.typeInfo = null;
        this.any = null;
        this.possibleNextStates = new ArrayList<XmlSchemaStateMachineNode>();
    }

    XmlSchemaStateMachineNode(XmlSchemaElement elem, List<XmlSchemaAttrInfo> attrs, XmlSchemaTypeInfo typeInfo) {
        this.nodeType = Type.ELEMENT;
        this.element = elem;
        this.attributes = attrs;
        this.typeInfo = typeInfo;
        this.minOccurs = elem.getMinOccurs();
        this.maxOccurs = elem.getMaxOccurs();
        this.any = null;
        this.possibleNextStates = new ArrayList<XmlSchemaStateMachineNode>();
    }

    XmlSchemaStateMachineNode(XmlSchemaAny any) {
        this.nodeType = Type.ANY;
        this.any = any;
        this.minOccurs = any.getMinOccurs();
        this.maxOccurs = any.getMaxOccurs();
        this.element = null;
        this.attributes = null;
        this.typeInfo = null;
        this.possibleNextStates = new ArrayList<XmlSchemaStateMachineNode>();
    }

    public Type getNodeType() {
        return this.nodeType;
    }

    public XmlSchemaElement getElement() {
        return this.element;
    }

    public XmlSchemaTypeInfo getElementType() {
        return this.typeInfo;
    }

    public List<XmlSchemaAttrInfo> getAttributes() {
        return this.attributes;
    }

    public long getMinOccurs() {
        return this.minOccurs;
    }

    public long getMaxOccurs() {
        return this.maxOccurs;
    }

    public XmlSchemaAny getAny() {
        return this.any;
    }

    XmlSchemaStateMachineNode addPossibleNextState(XmlSchemaStateMachineNode next) {
        this.possibleNextStates.add(next);
        return this;
    }

    XmlSchemaStateMachineNode addPossibleNextStates(Collection<XmlSchemaStateMachineNode> nextStates) {
        this.possibleNextStates.addAll(nextStates);
        return this;
    }

    public List<XmlSchemaStateMachineNode> getPossibleNextStates() {
        return this.possibleNextStates;
    }

    public String toString() {
        StringBuilder name = new StringBuilder(this.nodeType.name());
        switch (this.nodeType) {
            case ELEMENT: {
                name.append(": ").append(this.element.getQName()).append(" [");
                name.append(this.minOccurs).append(", ");
                name.append(this.maxOccurs).append("]");
                break;
            }
            case ANY: {
                name.append(": NS: \"").append(this.any.getNamespace()).append("\", ");
                name.append("Processing: ").append(this.any.getProcessContent());
                name.append(" [").append(this.minOccurs).append(", ").append(this.maxOccurs);
                name.append(']');
                break;
            }
            default: {
                name.append(" [").append(this.minOccurs).append(", ").append(this.maxOccurs);
                name.append(']');
            }
        }
        return name.toString();
    }

    public static enum Type {
        ELEMENT,
        SUBSTITUTION_GROUP,
        ALL,
        CHOICE,
        SEQUENCE,
        ANY;

    }
}

