/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.provision.service.ImportJob;
import org.opennms.netmgt.provision.service.TimeTrackerOverallMonitor;
import org.opennms.netmgt.provision.service.TimeTrackingMonitor;
import org.opennms.netmgt.provision.service.operations.ProvisionMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorHolder {
    private static final Logger LOG = LoggerFactory.getLogger(MonitorHolder.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final DateTimeFormatter datetimeFormat = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private LoadingCache<String, TimeTrackingMonitor> monitors;
    private final ConcurrentHashMap<String, TimeTrackerOverallMonitor> overallMonitors = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentLinkedDeque<String>> metricAssociation = new ConcurrentHashMap();
    public static final int MAX_METRIC_ASSOCIATION_SIZE = 30;
    private MetricRegistry metricRegistry = new MetricRegistry();
    private MetricRegistry metricRegistryOverall = new MetricRegistry();
    private JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).inDomain("org.opennms.netmgt.provision.status").build();
    private JmxReporter jmxReporterOverall;

    public MonitorHolder() {
        this(259200L);
    }

    public MonitorHolder(long seconds) {
        this.jmxReporter.start();
        this.jmxReporterOverall = JmxReporter.forRegistry((MetricRegistry)this.metricRegistryOverall).inDomain("org.opennms.netmgt.provision.overall").build();
        this.jmxReporterOverall.start();
        this.createCacheWithExpireTime(seconds);
    }

    public void createCacheWithExpireTime(long seconds) {
        LOG.info("Create cache with expire time {} seconds.", (Object)seconds);
        LoadingCache<String, TimeTrackingMonitor> oldMonitors = this.monitors;
        this.monitors = CacheBuilder.newBuilder().expireAfterAccess(seconds, TimeUnit.SECONDS).removalListener(removalNotification -> {
            this.metricRegistry.removeMatching((s, metric) -> s.indexOf((String)removalNotification.getKey()) == 0);
            try {
                LOG.info("{} Summary job name: {}\nOutput:\n{}", new Object[]{LocalDateTime.now().format(DateTimeFormatter.ISO_TIME), removalNotification.getKey(), mapper.writeValueAsString(removalNotification.getValue())});
            }
            catch (JsonProcessingException e) {
                LOG.warn("Fail to write summary for {} error: {}.", removalNotification.getKey(), (Object)e.getMessage());
            }
        }).build((CacheLoader)new CacheLoader<String, TimeTrackingMonitor>(){

            public TimeTrackingMonitor load(String key) {
                return new TimeTrackingMonitor(key, MonitorHolder.this.metricRegistry);
            }
        });
        if (oldMonitors != null) {
            this.monitors.putAll((Map)oldMonitors.asMap());
        }
    }

    public TimeTrackingMonitor createMonitor(String name, ImportJob job) throws ExecutionException {
        this.monitors.cleanUp();
        String metricName = MetricRegistry.name((String)name, (String[])new String[]{LocalDateTime.now().format(this.datetimeFormat), String.valueOf(job.hashCode())});
        this.updateAssociations(name, metricName);
        return (TimeTrackingMonitor)this.monitors.get((Object)metricName);
    }

    public TimeTrackingMonitor createMonitor(String name) throws ExecutionException {
        this.monitors.cleanUp();
        String metricName = MetricRegistry.name((String)name, (String[])new String[]{LocalDateTime.now().format(this.datetimeFormat)});
        this.updateAssociations(name, metricName);
        return (TimeTrackingMonitor)this.monitors.get((Object)metricName);
    }

    public void updateAssociations(String key, String metricName) {
        if (!this.metricAssociation.containsKey(key)) {
            ConcurrentLinkedDeque<String> names = new ConcurrentLinkedDeque<String>();
            names.addFirst(metricName);
            this.metricAssociation.put(key, names);
        } else if (this.metricAssociation.containsKey(key) && !this.metricAssociation.get(key).contains(metricName)) {
            this.metricAssociation.get(key).addFirst(metricName);
        }
        if (this.metricAssociation.get(key).size() > 30) {
            this.metricAssociation.get(key).removeLast();
        }
    }

    public TimeTrackerOverallMonitor createOverallMonitor(String name) {
        TimeTrackerOverallMonitor overallMonitor = null;
        if (this.overallMonitors.containsKey(name)) {
            overallMonitor = this.overallMonitors.get(name);
        } else {
            overallMonitor = new TimeTrackerOverallMonitor(name, this.metricRegistryOverall);
            this.overallMonitors.put(name, overallMonitor);
        }
        return overallMonitor;
    }

    public ProvisionMonitor getMonitor(String key) {
        this.monitors.cleanUp();
        if (key == null) {
            return null;
        }
        return (ProvisionMonitor)this.monitors.getIfPresent((Object)key);
    }

    public Map<String, TimeTrackingMonitor> getMonitors() {
        this.monitors.cleanUp();
        return this.monitors.asMap();
    }

    public TimeTrackerOverallMonitor getOverallMonitorForMetric(String metricName) {
        for (Map.Entry<String, ConcurrentLinkedDeque<String>> map : this.metricAssociation.entrySet()) {
            if (!map.getValue().contains(metricName)) continue;
            return this.overallMonitors.get(map.getKey());
        }
        return null;
    }

    public Map<String, TimeTrackerOverallMonitor> getOverallMonitors() {
        return this.overallMonitors;
    }

    public AbstractMap<String, ConcurrentLinkedDeque<String>> getAssociatedMetrics() {
        return this.metricAssociation;
    }

    public void shutdown() {
        this.jmxReporter.close();
        this.jmxReporterOverall.close();
    }
}

