/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.elastic.client;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.opennms.features.elastic.client.ElasticRestClient;
import org.opennms.features.elastic.client.model.BulkRequest;
import org.opennms.features.elastic.client.model.BulkResponse;
import org.opennms.features.elastic.client.model.SearchRequest;
import org.opennms.features.elastic.client.model.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticRestClientWithCircuitBreaker
implements ElasticRestClient {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticRestClientWithCircuitBreaker.class);
    private final ElasticRestClient delegate;
    private final CircuitBreaker circuitBreaker;

    public ElasticRestClientWithCircuitBreaker(ElasticRestClient delegate, CircuitBreaker circuitBreaker) {
        this.delegate = delegate;
        this.circuitBreaker = circuitBreaker;
    }

    @Override
    public BulkResponse executeBulk(BulkRequest bulkRequest) throws IOException {
        try {
            return (BulkResponse)this.circuitBreaker.executeCallable(() -> this.delegate.executeBulk(bulkRequest));
        }
        catch (CallNotPermittedException e) {
            LOG.error("Circuit breaker is open. Bulk request rejected.", (Throwable)e);
            throw new IOException("Circuit breaker is open. Request rejected.", e);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException("Unexpected error during bulk execution", e);
        }
    }

    @Override
    public CompletableFuture<BulkResponse> executeBulkAsync(BulkRequest bulkRequest) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.executeBulk(bulkRequest);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to execute bulk request", e);
            }
        });
    }

    @Override
    public SearchResponse search(SearchRequest searchRequest) throws IOException {
        try {
            return (SearchResponse)this.circuitBreaker.executeCallable(() -> this.delegate.search(searchRequest));
        }
        catch (CallNotPermittedException e) {
            LOG.error("Circuit breaker is open. Search request rejected.", (Throwable)e);
            throw new IOException("Circuit breaker is open. Request rejected.", e);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException("Unexpected error during search execution", e);
        }
    }

    @Override
    public CompletableFuture<SearchResponse> searchAsync(SearchRequest searchRequest) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.search(searchRequest);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to execute search request", e);
            }
        });
    }

    @Override
    public String health() throws IOException {
        return this.delegate.health();
    }

    @Override
    public Map<String, String> listTemplates() throws IOException {
        return this.delegate.listTemplates();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public boolean applyILMPolicy(String policyName, String policyBody) throws IOException {
        return this.delegate.applyILMPolicy(policyName, policyBody);
    }

    @Override
    public boolean applyComponentTemplate(String componentName, String componentBody) throws IOException {
        return this.delegate.applyComponentTemplate(componentName, componentBody);
    }

    @Override
    public boolean applyComposableIndexTemplate(String templateName, String templateBody) throws IOException {
        return this.delegate.applyComposableIndexTemplate(templateName, templateBody);
    }

    @Override
    public int applyAllTemplatesFromDirectory(String templateDirectory) throws IOException {
        return this.delegate.applyAllTemplatesFromDirectory(templateDirectory);
    }

    @Override
    public boolean applyLegacyIndexTemplate(String templateName, String templateBody) throws IOException {
        return this.delegate.applyLegacyIndexTemplate(templateName, templateBody);
    }

    @Override
    public String getServerVersion() throws IOException {
        return this.delegate.getServerVersion();
    }

    @Override
    public boolean deleteIndex(String indices) throws IOException {
        return this.delegate.deleteIndex(indices);
    }
}

