(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return (window["webpackJsonp"] = window["webpackJsonp"] || []).push([["cropper-js"],{

/***/ "./node_modules/raw-loader/index.js!./node_modules/babel-loader/lib/index.js?!./src/main/assets/js/lib/3rdparty/cropper/cropper.uncompressed.js":
/*!**********************************************************************************************************************************************!*\
  !*** ./node_modules/raw-loader!./node_modules/babel-loader/lib??ref--22-0!./src/main/assets/js/lib/3rdparty/cropper/cropper.uncompressed.js ***!
  \**********************************************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "\"use strict\";\n\nrequire(\"../../../../../../../node_modules/core-js/modules/es.object.to-string.js\");\nrequire(\"../../../../../../../node_modules/core-js/modules/es.regexp.exec.js\");\nrequire(\"../../../../../../../node_modules/core-js/modules/es.regexp.to-string.js\");\nrequire(\"../../../../../../../node_modules/core-js/modules/es.string.match.js\");\nrequire(\"../../../../../../../node_modules/core-js/modules/es.string.replace.js\");\nvar _map = _interopRequireDefault(require(\"../../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/map\"));\nvar _bind = _interopRequireDefault(require(\"../../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/bind\"));\nvar _reverse = _interopRequireDefault(require(\"../../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/reverse\"));\nfunction _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }\n/**\r\n * Image Cropper (v. 1.2.2 - 2011-07-04 )\r\n * Copyright (c) 2006-2011 David Spurr (http://www.defusion.org.uk/)\r\n * \r\n * The image cropper provides a way to draw a crop area on an image and capture\r\n * the coordinates of the drawn crop area.\r\n * \r\n * Features include:\r\n *   - Based on Prototype and Scriptaculous\r\n *   - Image editing package styling, the crop area functions and looks \r\n *     like those found in popular image editing software\r\n *   - Dynamic inclusion of required styles\r\n *   - Drag to draw areas\r\n *   - Shift drag to draw/resize areas as squares\r\n *   - Selection area can be moved \r\n *   - Seleciton area can be resized using resize handles\r\n *   - Allows dimension ratio limited crop areas\r\n *   - Allows minimum dimension crop areas\r\n *   - Allows maximum dimesion crop areas\r\n *   - If both min & max dimension options set to the same value for a single axis,then the cropper will not \r\n *     display the resize handles as appropriate (when min & max dimensions are passed for both axes this\r\n *     results in a 'fixed size' crop area)\r\n *   - Allows dynamic preview of resultant crop ( if minimum width & height are provided ), this is\r\n *     implemented as a subclass so can be excluded when not required\r\n *   - Movement of selection area by arrow keys ( shift + arrow key will move selection area by\r\n *     10 pixels )\r\n *   - All operations stay within bounds of image\r\n *   - All functionality & display compatible with most popular browsers supported by Prototype:\r\n *       PC:  IE 9, 8, 7, 6 & 5.5, Firefox 2+, Opera 8.5 (see known issues) & 9.0b +, Google Chrome\r\n *       MAC: Camino 1.0, Firefox 2+, Safari 3.x+, Google Chrome\r\n * \r\n * Requires:\r\n *   - Prototype v. 1.5.0_rc0 > (as packaged with Scriptaculous 1.6.1)\r\n *   - Scriptaculous v. 1.6.1 > modules: dragdrop \r\n * Recommended (for IE9+ support):\r\n *   - Prototype v. 1.7.0 >\r\n *   - Scriptaculous v. 1.9.0 >\r\n *   \r\n * Known issues:\r\n *   - Safari animated gifs, only one of each will animate, this seems to be a known Safari issue\r\n *   \r\n *   - After drawing an area and then clicking to start a new drag in IE 5.5 the rendered height \r\n *       appears as the last height until the user drags, this appears to be the related to the error \r\n *       that the forceReRender() method fixes for IE 6, i.e. IE 5.5 is not redrawing the box properly.\r\n *   \r\n *   - Lack of CSS opacity support in Opera before version 9 mean we disable those style rules, these \r\n *     could be fixed by using PNGs with transparency if Opera 8.5 support is high priority for you\r\n *   \r\n *   - Marching ants keep reloading in IE <6, it is a known issue in IE and I have \r\n *       found no viable workarounds that can be included in the release. If this really is an issue for you\r\n *       either try this post: http://mir.aculo.us/articles/2005/08/28/internet-explorer-and-ajax-image-caching-woes\r\n *       or uncomment the 'FIX MARCHING ANTS IN IE' rules in the CSS file\r\n *   \r\n *   - Styling & borders on image, any CSS styling applied directly to the image itself (floats, borders, padding, margin, etc.) will \r\n *     cause problems with the cropper. The use of a wrapper element to apply these styles to is recommended.\r\n *   \r\n *   - overflow: auto or overflow: scroll on parent will cause cropper to burst out of parent in IE and Opera (maybe Mac browsers too)\r\n *     I'm not sure why yet.\r\n *   \r\n * Usage:\r\n *   See Cropper.Img & Cropper.ImgWithPreview for usage details\r\n * \r\n * Changelog:\r\n * v1.2.2 - 2011-07-04\r\n *    + Support for latest versions of Prototype & script.aculo.us (1.7.0 & 1.9.0 respectively)\r\n *    + Support notice for IE9\r\n *  \r\n * v1.2.1 - 2009-10-06\r\n *    + Added support for latest versions of Prototype & script.aculo.us\r\n *      (1.6.1.0 & 1.8.2 respectively). Changes provided by Tom Hirashima.\r\n *    - No-longer package prototype & script.aculo.us with the release\r\n *    * Changed tests to use google ajax libraries api to load prototype & script.aculo.us\r\n *    + Added option to not auto include the cropper CSS file\r\n *    * #00008 - Fixed bug: Dynamic include of cropper CSS expected cropper.js and failed when using cropper.uncompressed.js\r\n *    * #00028 - Fixed bug: Doesn't work with latest script.aculo.us - Fix by Tom Hirashima\r\n *    * #00030 - Fixed bug: Doesn't work in Firefox 3.5 (CSS include issue)\r\n *    * #00007 - Fixed bug: onEndCrop isn't called when moving with keys\r\n *    * #00011 - Fixed bug: The image that is to be cropped does not show in IE6.0 -- included CSS fix\r\n *    * Tidied up source code & fixed issues that jslint found so it will compress better\r\n * \r\n * v1.2.0 - 2006-10-30\r\n *    + Added id to the preview image element using 'imgCrop_[originalImageID]'\r\n *      * #00001 - Fixed bug: Doesn't account for scroll offsets\r\n *      * #00009 - Fixed bug: Placing the cropper inside differently positioned elements causes incorrect co-ordinates and display\r\n *      * #00013 - Fixed bug: I-bar cursor appears on drag plane\r\n *      * #00014 - Fixed bug: If ID for image tag is not found in document script throws error\r\n *      * Fixed bug with drag start co-ordinates if wrapper element has moved in browser (e.g. dragged to a new position)\r\n *      * Fixed bug with drag start co-ordinates if image contained in a wrapper with scrolling - this may be buggy if image \r\n *      has other ancestors with scrolling applied (except the body)\r\n *      * #00015 - Fixed bug: When cropper removed and then reapplied onEndCrop callback gets called multiple times, solution suggestion from Bill Smith\r\n *      * Various speed increases & code cleanup which meant improved performance in Mac - which allowed removal of different overlay methods for\r\n *        IE and all other browsers, which led to a fix for:\r\n *    * #00010 - Fixed bug: Select area doesn't adhere to image size when image resized using img attributes\r\n *      - #00006 - Removed default behaviour of automatically setting a ratio when both min width & height passed, the ratioDimensions must be passed in\r\n *    + #00005 - Added ability to set maximum crop dimensions, if both min & max set as the same value then we'll get a fixed cropper size on the axes as appropriate\r\n *        and the resize handles will not be displayed as appropriate\r\n *    * Switched keydown for keypress for moving select area with cursor keys (makes for nicer action) - doesn't appear to work in Safari\r\n *    \r\n * v1.1.3 - 2006-08-21\r\n *    * Fixed wrong cursor on western handle in CSS\r\n *    + #00008 & #00003 - Added feature: Allow to set dimensions & position for cropper on load\r\n *      * #00002 - Fixed bug: Pressing 'remove cropper' twice removes image in IE\r\n *    \r\n * v1.1.2 - 2006-06-09\r\n *    * Fixed bugs with ratios when GCD is low (patch submitted by Andy Skelton)\r\n * \r\n * v1.1.1 - 2006-06-03\r\n *    * Fixed bug with rendering issues fix in IE 5.5\r\n *    * Fixed bug with endCrop callback issues once cropper had been removed & reset in IE\r\n * \r\n * v1.1.0 - 2006-06-02\r\n *    * Fixed bug with IE constantly trying to reload select area background image\r\n *    * Applied more robust fix to Safari & IE rendering issues\r\n *    + Added method to reset parameters - useful for when dynamically changing img cropper attached to\r\n *    + Added method to remove cropper from image\r\n *    \r\n * v1.0.0 - 2006-05-18 \r\n *    + Initial verison\r\n * \r\n * \r\n * Copyright (c) 2006-2011, David Spurr (http://www.defusion.org.uk/)\r\n * \r\n * \r\n * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:\r\n * \r\n *     * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.\r\n *     * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.\r\n *     * Neither the name of the David Spurr nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.\r\n * \r\n * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\r\n * \r\n * http://www.opensource.org/licenses/bsd-license.php\r\n * \r\n * See scriptaculous.js for full scriptaculous licence\r\n */\n\n/**\r\n * Extend the Draggable class to allow us to pass the rendering\r\n * down to the Cropper object.\r\n */\nvar CropDraggable = Class.create(Draggable, {\n  initialize: function initialize(element) {\n    this.options = Object.extend({\n      /**\r\n       * The draw method to defer drawing to\r\n       */\n      drawMethod: function drawMethod() {}\n    }, arguments[1] || {});\n    this.element = $(element);\n    this.handle = this.element;\n    this.delta = this.currentDelta();\n    this.dragging = false;\n    this.eventMouseDown = this.initDrag.bindAsEventListener(this);\n    Event.observe(this.handle, \"mousedown\", this.eventMouseDown);\n    Draggables.register(this);\n  },\n  /**\r\n   * Defers the drawing of the draggable to the supplied method\r\n   */\n  draw: function draw(point) {\n    var _context, _context2;\n    var pos = Element.cumulativeOffset(this.element),\n      d = this.currentDelta();\n    pos[0] -= d[0];\n    pos[1] -= d[1];\n    var p = (0, _map.default)(_context = [0, 1]).call(_context, (0, _bind.default)(_context2 = function _context2(i) {\n      return point[i] - pos[i] - this.offset[i];\n    }).call(_context2, this));\n    this.options.drawMethod(p);\n  }\n});\n\n/**\r\n * The Cropper object, this will attach itself to the provided image by wrapping it with \r\n * the generated xHTML structure required by the cropper.\r\n * \r\n * Usage:\r\n *  @param obj Image element to attach to\r\n *  @param obj Optional options:\r\n *     - ratioDim obj \r\n *       The pixel dimensions to apply as a restrictive ratio, with properties x & y\r\n *     \r\n *     - minWidth int \r\n *       The minimum width for the select area in pixels\r\n *     \r\n *     - minHeight\tint \r\n *       The mimimum height for the select area in pixels\r\n *     \r\n *     - maxWidth int\r\n *       The maximum width for the select areas in pixels (if both minWidth & maxWidth set to same the width of the cropper will be fixed)\r\n *     \r\n *     - maxHeight int\r\n *       The maximum height for the select areas in pixels (if both minHeight & maxHeight set to same the height of the cropper will be fixed)\r\n *     \r\n *     - displayOnInit int \r\n *       Whether to display the select area on initialisation, only used when providing minimum width & height or ratio\r\n *     \r\n *     - onEndCrop func\r\n *       The callback function to provide the crop details to on end of a crop (see below)\r\n *     \r\n *     - captureKeys boolean\r\n *       Whether to capture the keys for moving the select area, as these can cause some problems at the moment\r\n *     \r\n *     - onloadCoords obj\r\n *       A coordinates object with properties x1, y1, x2 & y2; for the coordinates of the select area to display onload\r\n *     \r\n *     - autoIncludeCSS boolean\r\n *       Whether to automatically include the stylesheet (assumes it lives in the same location as the cropper JS file)\r\n *-    ---------------------------------------------\r\n * \r\n * The callback function provided via the onEndCrop option should accept the following parameters:\r\n *   - coords obj\r\n *     The coordinates object with properties x1, y1, x2 & y2; for the coordinates of the select area\r\n *   \r\n *   - dimensions obj\r\n *     The dimensions object with properites width & height; for the dimensions of the select area\r\n *   \r\n *   \r\n *   Example:\r\n *     function onEndCrop( coords, dimensions ) {\r\n *         $( 'x1' ).value = coords.x1;\r\n *         $( 'y1' ).value = coords.y1;\r\n *         $( 'x2' ).value = coords.x2;\r\n *         $( 'y2' ).value = coords.y2;\r\n *         $( 'width' ).value = dimensions.width;\r\n *         $( 'height' ).value = dimensions.height;\r\n *     }\r\n * \r\n */\nvar Cropper = {};\nCropper.Img = Class.create({\n  /**\r\n   * Initialises the class\r\n   * \r\n   * @access public\r\n   * @param obj Image element to attach to\r\n   * @param obj Options\r\n   * @return void\r\n   */\n  initialize: function initialize(element, options) {\n    this.options = Object.extend({\n      /**\r\n       * @var obj\r\n       * The pixel dimensions to apply as a restrictive ratio\r\n       */\n      ratioDim: {\n        x: 0,\n        y: 0\n      },\n      /**\r\n       * @var int\r\n       * The minimum pixel width, also used as restrictive ratio if min height passed too\r\n       */\n      minWidth: 0,\n      /**\r\n       * @var int\r\n       * The minimum pixel height, also used as restrictive ratio if min width passed too\r\n       */\n      minHeight: 0,\n      /**\r\n       * @var boolean\r\n       * Whether to display the select area on initialisation, only used when providing minimum width & height or ratio\r\n       */\n      displayOnInit: false,\n      /**\r\n       * @var function\r\n       * The call back function to pass the final values to\r\n       */\n      onEndCrop: Prototype.emptyFunction,\n      /**\r\n       * @var boolean\r\n       * Whether to capture key presses or not\r\n       */\n      captureKeys: true,\n      /**\r\n       * @var obj Coordinate object x1, y1, x2, y2\r\n       * The coordinates to optionally display the select area at onload\r\n       */\n      onloadCoords: null,\n      /**\r\n       * @var int\r\n       * The maximum width for the select areas in pixels (if both minWidth & maxWidth set to same the width of the cropper will be fixed)\r\n       */\n      maxWidth: 0,\n      /**\r\n       * @var int\r\n       * The maximum height for the select areas in pixels (if both minHeight & maxHeight set to same the height of the cropper will be fixed)\r\n       */\n      maxHeight: 0,\n      /**\r\n       * @var boolean - default true\r\n       * Whether to automatically include the stylesheet (assumes it lives in the same location as the cropper JS file)\r\n       */\n      autoIncludeCSS: true\n    }, options || {});\n    /**\r\n     * @var obj\r\n     * The img node to attach to\r\n     */\n    this.img = $(element);\n    /**\r\n     * @var obj\r\n     * The x & y coordinates of the click point\r\n     */\n    this.clickCoords = {\n      x: 0,\n      y: 0\n    };\n    /**\r\n     * @var boolean\r\n     * Whether the user is dragging\r\n     */\n    this.dragging = false;\n    /**\r\n     * @var boolean\r\n     * Whether the user is resizing\r\n     */\n    this.resizing = false;\n    /**\r\n     * @var boolean\r\n     * Whether the user is on a webKit browser\r\n     */\n    this.isWebKit = /Konqueror|Safari|KHTML/.test(navigator.userAgent);\n    /**\r\n     * @var boolean\r\n     * Whether the user is on IE\r\n     */\n    this.isIE = /MSIE/.test(navigator.userAgent);\n    /**\r\n     * @var boolean\r\n     * Whether the user is on Opera below version 9\r\n     */\n    this.isOpera8 = /Opera\\s[1-8]/.test(navigator.userAgent);\n    /**\r\n     * @var int\r\n     * The x ratio \r\n     */\n    this.ratioX = 0;\n    /**\r\n     * @var int\r\n     * The y ratio\r\n     */\n    this.ratioY = 0;\n    /**\r\n     * @var boolean\r\n     * Whether we've attached sucessfully\r\n     */\n    this.attached = false;\n    /**\r\n     * @var boolean\r\n     * Whether we've got a fixed width (if minWidth EQ or GT maxWidth then we have a fixed width\r\n     * in the case of minWidth > maxWidth maxWidth wins as the fixed width)\r\n     */\n    this.fixedWidth = this.options.maxWidth > 0 && this.options.minWidth >= this.options.maxWidth;\n    /**\r\n     * @var boolean\r\n     * Whether we've got a fixed height (if minHeight EQ or GT maxHeight then we have a fixed height\r\n     * in the case of minHeight > maxHeight maxHeight wins as the fixed height)\r\n     */\n    this.fixedHeight = this.options.maxHeight > 0 && this.options.minHeight >= this.options.maxHeight;\n\n    // quit if the image element doesn't exist\n    if (typeof this.img == 'undefined') {\n      return;\n    }\n\n    // include the stylesheet\n    if (this.options.autoIncludeCSS) {\n      $$('script').each(function (s) {\n        if (s.src.match(/\\/cropper([^\\/]*)\\.js/)) {\n          var path = s.src.replace(/\\/cropper([^\\/]*)\\.js.*/, ''),\n            style = document.createElement('link');\n          style.rel = 'stylesheet';\n          style.type = 'text/css';\n          style.href = path + '/cropper.css';\n          style.media = 'screen';\n          document.getElementsByTagName('head')[0].appendChild(style);\n        }\n      });\n    }\n\n    // calculate the ratio when neccessary\n    if (this.options.ratioDim.x > 0 && this.options.ratioDim.y > 0) {\n      var gcd = this.getGCD(this.options.ratioDim.x, this.options.ratioDim.y);\n      this.ratioX = this.options.ratioDim.x / gcd;\n      this.ratioY = this.options.ratioDim.y / gcd;\n      // dump( 'RATIO : ' + this.ratioX + ':' + this.ratioY + '\\n' );\n    }\n\n    // initialise sub classes\n    this.subInitialize();\n\n    // only load the event observers etc. once the image is loaded\n    // this is done after the subInitialize() call just in case the sub class does anything\n    // that will affect the result of the call to onLoad()\n    if (this.img.complete || this.isWebKit) {\n      this.onLoad(); // for some reason Safari seems to support img.complete but returns 'undefined' on the this.img object\n    } else {\n      Event.observe(this.img, 'load', this.onLoad.bindAsEventListener(this));\n    }\n  },\n  /**\r\n   * The Euclidean algorithm used to find the greatest common divisor\r\n   * \r\n   * @acces private\r\n   * @param int Value 1\r\n   * @param int Value 2\r\n   * @return int\r\n   */\n  getGCD: function getGCD(a, b) {\n    if (b === 0) {\n      return a;\n    }\n    return this.getGCD(b, a % b);\n  },\n  /**\r\n   * Attaches the cropper to the image once it has loaded\r\n   * \r\n   * @access private\r\n   * @return void\r\n   */\n  onLoad: function onLoad() {\n    /*\r\n     * Build the container and all related elements, will result in the following\r\n     *\r\n     * <div class=\"imgCrop_wrap\">\r\n     *   <img ... this.img ... />\r\n     *   <div class=\"imgCrop_dragArea\">\r\n     *     <!-- the inner spans are only required for IE to stop it making the divs 1px high/wide -->\r\n     *     <div class=\"imgCrop_overlay imageCrop_north\"><span></span></div>\r\n     *     <div class=\"imgCrop_overlay imageCrop_east\"><span></span></div>\r\n     *     <div class=\"imgCrop_overlay imageCrop_south\"><span></span></div>\r\n     *     <div class=\"imgCrop_overlay imageCrop_west\"><span></span></div>\r\n     *     <div class=\"imgCrop_selArea\">\r\n     *       <!-- marquees -->\r\n     *       <!-- the inner spans are only required for IE to stop it making the divs 1px high/wide -->\r\n     *       <div class=\"imgCrop_marqueeHoriz imgCrop_marqueeNorth\"><span></span></div>\r\n     *       <div class=\"imgCrop_marqueeVert imgCrop_marqueeEast\"><span></span></div>\r\n     *       <div class=\"imgCrop_marqueeHoriz imgCrop_marqueeSouth\"><span></span></div>\r\n     *       <div class=\"imgCrop_marqueeVert imgCrop_marqueeWest\"><span></span></div>\r\n     *       <!-- handles -->\r\n     *       <div class=\"imgCrop_handle imgCrop_handleN\"></div>\r\n     *       <div class=\"imgCrop_handle imgCrop_handleNE\"></div>\r\n     *       <div class=\"imgCrop_handle imgCrop_handleE\"></div>\r\n     *       <div class=\"imgCrop_handle imgCrop_handleSE\"></div>\r\n     *       <div class=\"imgCrop_handle imgCrop_handleS\"></div>\r\n     *       <div class=\"imgCrop_handle imgCrop_handleSW\"></div>\r\n     *       <div class=\"imgCrop_handle imgCrop_handleW\"></div>\r\n     *       <div class=\"imgCrop_handle imgCrop_handleNW\"></div>\r\n     *       <div class=\"imgCrop_clickArea\"></div>\r\n     *     </div>\r\n     *     <div class=\"imgCrop_clickArea\"></div>\r\n     *   </div>\r\n     * </div>\r\n     */\n    var cNamePrefix = 'imgCrop_';\n\n    // get the point to insert the container\n    var insertPoint = this.img.parentNode;\n\n    // apply an extra class to the wrapper to fix Opera below version 9\n    var fixOperaClass = '';\n    if (this.isOpera8) {\n      fixOperaClass = ' opera8';\n    }\n    this.imgWrap = new Element('div', {\n      'class': cNamePrefix + 'wrap' + fixOperaClass\n    });\n    this.north = new Element('div', {\n      'class': cNamePrefix + 'overlay ' + cNamePrefix + 'north'\n    }).insert(new Element('span'));\n    this.east = new Element('div', {\n      'class': cNamePrefix + 'overlay ' + cNamePrefix + 'east'\n    }).insert(new Element('span'));\n    this.south = new Element('div', {\n      'class': cNamePrefix + 'overlay ' + cNamePrefix + 'south'\n    }).insert(new Element('span'));\n    this.west = new Element('div', {\n      'class': cNamePrefix + 'overlay ' + cNamePrefix + 'west'\n    }).insert(new Element('span'));\n    var overlays = [this.north, this.east, this.south, this.west];\n    this.dragArea = new Element('div', {\n      'class': cNamePrefix + 'dragArea'\n    });\n    overlays.each(function (o) {\n      this.dragArea.insert(o);\n    }, this);\n    this.handleN = new Element('div', {\n      'class': cNamePrefix + 'handle ' + cNamePrefix + 'handleN'\n    });\n    this.handleNE = new Element('div', {\n      'class': cNamePrefix + 'handle ' + cNamePrefix + 'handleNE'\n    });\n    this.handleE = new Element('div', {\n      'class': cNamePrefix + 'handle ' + cNamePrefix + 'handleE'\n    });\n    this.handleSE = new Element('div', {\n      'class': cNamePrefix + 'handle ' + cNamePrefix + 'handleSE'\n    });\n    this.handleS = new Element('div', {\n      'class': cNamePrefix + 'handle ' + cNamePrefix + 'handleS'\n    });\n    this.handleSW = new Element('div', {\n      'class': cNamePrefix + 'handle ' + cNamePrefix + 'handleSW'\n    });\n    this.handleW = new Element('div', {\n      'class': cNamePrefix + 'handle ' + cNamePrefix + 'handleW'\n    });\n    this.handleNW = new Element('div', {\n      'class': cNamePrefix + 'handle ' + cNamePrefix + 'handleNW'\n    });\n    this.selArea = new Element('div', {\n      'class': cNamePrefix + 'selArea'\n    });\n    [new Element('div', {\n      'class': cNamePrefix + 'marqueeHoriz ' + cNamePrefix + 'marqueeNorth'\n    }).insert(new Element('span')), new Element('div', {\n      'class': cNamePrefix + 'marqueeVert ' + cNamePrefix + 'marqueeEast'\n    }).insert(new Element('span')), new Element('div', {\n      'class': cNamePrefix + 'marqueeHoriz ' + cNamePrefix + 'marqueeSouth'\n    }).insert(new Element('span')), new Element('div', {\n      'class': cNamePrefix + 'marqueeVert ' + cNamePrefix + 'marqueeWest'\n    }).insert(new Element('span')), this.handleN, this.handleNE, this.handleE, this.handleSE, this.handleS, this.handleSW, this.handleW, this.handleNW, new Element('div', {\n      'class': cNamePrefix + 'clickArea'\n    })].each(function (o) {\n      this.selArea.insert(o);\n    }, this);\n    this.imgWrap.appendChild(this.img);\n    this.imgWrap.appendChild(this.dragArea);\n    this.dragArea.appendChild(this.selArea);\n    this.dragArea.appendChild(new Element('div', {\n      'class': cNamePrefix + 'clickArea'\n    }));\n    insertPoint.appendChild(this.imgWrap);\n\n    // add event observers\n    this.startDragBind = this.startDrag.bindAsEventListener(this);\n    Event.observe(this.dragArea, 'mousedown', this.startDragBind);\n    this.onDragBind = this.onDrag.bindAsEventListener(this);\n    Event.observe(document, 'mousemove', this.onDragBind);\n    this.endCropBind = this.endCrop.bindAsEventListener(this);\n    Event.observe(document, 'mouseup', this.endCropBind);\n    this.resizeBind = this.startResize.bindAsEventListener(this);\n    this.handles = [this.handleN, this.handleNE, this.handleE, this.handleSE, this.handleS, this.handleSW, this.handleW, this.handleNW];\n    this.registerHandles(true);\n    if (this.options.captureKeys) {\n      this.keysBind = this.handleKeys.bindAsEventListener(this);\n      Event.observe(document, 'keypress', this.keysBind);\n    }\n\n    // attach the dragable to the select area\n    var x = new CropDraggable(this.selArea, {\n      drawMethod: this.moveArea.bindAsEventListener(this)\n    });\n    this.setParams();\n  },\n  /**\r\n   * Manages adding or removing the handle event handler and hiding or displaying them as appropriate\r\n   * \r\n   * @access private\r\n   * @param boolean registration true = add, false = remove\r\n   * @return void\r\n   */\n  registerHandles: function registerHandles(registration) {\n    for (var i = 0; i < this.handles.length; i++) {\n      var handle = $(this.handles[i]);\n      if (registration) {\n        var hideHandle = false; // whether to hide the handle\n\n        // disable handles asappropriate if we've got fixed dimensions\n        // if both dimensions are fixed we don't need to do much\n        if (this.fixedWidth && this.fixedHeight) {\n          hideHandle = true;\n        } else if (this.fixedWidth || this.fixedHeight) {\n          // if one of the dimensions is fixed then just hide those handles\n          var isCornerHandle = handle.className.match(/([S|N][E|W])$/),\n            isWidthHandle = handle.className.match(/(E|W)$/),\n            isHeightHandle = handle.className.match(/(N|S)$/);\n          if (isCornerHandle || this.fixedWidth && isWidthHandle || this.fixedHeight && isHeightHandle) {\n            hideHandle = true;\n          }\n        }\n        if (hideHandle) {\n          handle.hide();\n        } else {\n          Event.observe(handle, 'mousedown', this.resizeBind);\n        }\n      } else {\n        handle.show();\n        Event.stopObserving(handle, 'mousedown', this.resizeBind);\n      }\n    }\n  },\n  /**\r\n   * Sets up all the cropper parameters, this can be used to reset the cropper when dynamically\r\n   * changing the images\r\n   * \r\n   * @access private\r\n   * @return void\r\n   */\n  setParams: function setParams() {\n    /**\r\n     * @var int\r\n     * The image width\r\n     */\n    this.imgW = this.img.width;\n    /**\r\n     * @var int\r\n     * The image height\r\n     */\n    this.imgH = this.img.height;\n    $(this.north).setStyle({\n      height: 0\n    });\n    $(this.east).setStyle({\n      width: 0,\n      height: 0\n    });\n    $(this.south).setStyle({\n      height: 0\n    });\n    $(this.west).setStyle({\n      width: 0,\n      height: 0\n    });\n\n    // resize the container to fit the image\n    $(this.imgWrap).setStyle({\n      'width': this.imgW + 'px',\n      'height': this.imgH + 'px'\n    });\n\n    // hide the select area\n    $(this.selArea).hide();\n\n    // setup the starting position of the select area\n    var startCoords = {\n        x1: 0,\n        y1: 0,\n        x2: 0,\n        y2: 0\n      },\n      validCoordsSet = false;\n\n    // display the select area \n    if (this.options.onloadCoords !== null) {\n      // if we've being given some coordinates to \n      startCoords = this.cloneCoords(this.options.onloadCoords);\n      validCoordsSet = true;\n    } else if (this.options.ratioDim.x > 0 && this.options.ratioDim.y > 0) {\n      // if there is a ratio limit applied and the then set it to initial ratio\n      startCoords.x1 = Math.ceil((this.imgW - this.options.ratioDim.x) / 2);\n      startCoords.y1 = Math.ceil((this.imgH - this.options.ratioDim.y) / 2);\n      startCoords.x2 = startCoords.x1 + this.options.ratioDim.x;\n      startCoords.y2 = startCoords.y1 + this.options.ratioDim.y;\n      validCoordsSet = true;\n    }\n    this.setAreaCoords(startCoords, false, false, 1);\n    if (this.options.displayOnInit && validCoordsSet) {\n      this.selArea.show();\n      this.drawArea();\n      this.endCrop();\n    }\n    this.attached = true;\n  },\n  /**\r\n   * Removes the cropper\r\n   * \r\n   * @access public\r\n   * @return void\r\n   */\n  remove: function remove() {\n    if (this.attached) {\n      this.attached = false;\n\n      // remove the elements we inserted\n      this.imgWrap.parentNode.insertBefore(this.img, this.imgWrap);\n      this.imgWrap.parentNode.removeChild(this.imgWrap);\n\n      // remove the event observers\n      Event.stopObserving(this.dragArea, 'mousedown', this.startDragBind);\n      Event.stopObserving(document, 'mousemove', this.onDragBind);\n      Event.stopObserving(document, 'mouseup', this.endCropBind);\n      this.registerHandles(false);\n      if (this.options.captureKeys) {\n        Event.stopObserving(document, 'keypress', this.keysBind);\n      }\n    }\n  },\n  /**\r\n   * Resets the cropper, can be used either after being removed or any time you wish\r\n   * \r\n   * @access public\r\n   * @return void\r\n   */\n  reset: function reset() {\n    if (!this.attached) {\n      this.onLoad();\n    } else {\n      this.setParams();\n    }\n    this.endCrop();\n  },\n  /**\r\n   * Handles the key functionality, currently just using arrow keys to move, if the user\r\n   * presses shift then the area will move by 10 pixels\r\n   */\n  handleKeys: function handleKeys(e) {\n    var dir = {\n      x: 0,\n      y: 0\n    }; // direction to move it in & the amount in pixels\n    if (!this.dragging) {\n      // catch the arrow keys\n      switch (e.keyCode) {\n        case 37:\n          // left\n          dir.x = -1;\n          break;\n        case 38:\n          // up\n          dir.y = -1;\n          break;\n        case 39:\n          // right\n          dir.x = 1;\n          break;\n        case 40:\n          // down\n          dir.y = 1;\n          break;\n      }\n      if (dir.x !== 0 || dir.y !== 0) {\n        // if shift is pressed then move by 10 pixels\n        if (e.shiftKey) {\n          dir.x *= 10;\n          dir.y *= 10;\n        }\n        this.moveArea([this.areaCoords.x1 + dir.x, this.areaCoords.y1 + dir.y]);\n        this.endCrop();\n        Event.stop(e);\n      }\n    }\n  },\n  /**\r\n   * Calculates the width from the areaCoords\r\n   * \r\n   * @access private\r\n   * @return int\r\n   */\n  calcW: function calcW() {\n    return this.areaCoords.x2 - this.areaCoords.x1;\n  },\n  /**\r\n   * Calculates the height from the areaCoords\r\n   * \r\n   * @access private\r\n   * @return int\r\n   */\n  calcH: function calcH() {\n    return this.areaCoords.y2 - this.areaCoords.y1;\n  },\n  /**\r\n   * Moves the select area to the supplied point (assumes the point is x1 & y1 of the select area)\r\n   * \r\n   * @access public\r\n   * @param array Point for x1 & y1 to move select area to\r\n   * @return void\r\n   */\n  moveArea: function moveArea(point) {\n    // dump( 'moveArea        : ' + point[0] + ',' + point[1] + ',' + ( point[0] + ( this.areaCoords.x2 - this.areaCoords.x1 ) ) + ',' + ( point[1] + ( this.areaCoords.y2 - this.areaCoords.y1 ) ) + '\\n' );\n    this.setAreaCoords({\n      x1: point[0],\n      y1: point[1],\n      x2: point[0] + this.calcW(),\n      y2: point[1] + this.calcH()\n    }, true, false);\n    this.drawArea();\n  },\n  /**\r\n   * Clones a co-ordinates object, stops problems with handling them by reference\r\n   * \r\n   * @access private\r\n   * @param obj Coordinate object x1, y1, x2, y2\r\n   * @return obj Coordinate object x1, y1, x2, y2\r\n   */\n  cloneCoords: function cloneCoords(coords) {\n    return {\n      x1: coords.x1,\n      y1: coords.y1,\n      x2: coords.x2,\n      y2: coords.y2\n    };\n  },\n  /**\r\n   * Sets the select coords to those provided but ensures they don't go\r\n   * outside the bounding box\r\n   * \r\n   * @access private\r\n   * @param obj Coordinates x1, y1, x2, y2\r\n   * @param boolean Whether this is a move\r\n   * @param boolean Whether to apply squaring\r\n   * @param obj Direction of mouse along both axis x, y ( -1 = negative, 1 = positive ) only required when moving etc.\r\n   * @param string The current resize handle || null\r\n   * @return void\r\n   */\n  setAreaCoords: function setAreaCoords(coords, moving, square, direction, resizeHandle) {\n    // dump( 'setAreaCoords (in) : ' + coords.x1 + ',' + coords.y1 + ',' + coords.x2 + ',' + coords.y2 );\n    if (moving) {\n      // if moving\n      var targW = coords.x2 - coords.x1,\n        targH = coords.y2 - coords.y1;\n\n      // ensure we're within the bounds\n      if (coords.x1 < 0) {\n        coords.x1 = 0;\n        coords.x2 = targW;\n      }\n      if (coords.y1 < 0) {\n        coords.y1 = 0;\n        coords.y2 = targH;\n      }\n      if (coords.x2 > this.imgW) {\n        coords.x2 = this.imgW;\n        coords.x1 = this.imgW - targW;\n      }\n      if (coords.y2 > this.imgH) {\n        coords.y2 = this.imgH;\n        coords.y1 = this.imgH - targH;\n      }\n    } else {\n      // ensure we're within the bounds\n      if (coords.x1 < 0) {\n        coords.x1 = 0;\n      }\n      if (coords.y1 < 0) {\n        coords.y1 = 0;\n      }\n      if (coords.x2 > this.imgW) {\n        coords.x2 = this.imgW;\n      }\n      if (coords.y2 > this.imgH) {\n        coords.y2 = this.imgH;\n      }\n\n      // This is passed as null in onload\n      if (direction !== null) {\n        // apply the ratio or squaring where appropriate\n        if (this.ratioX > 0) {\n          this.applyRatio(coords, {\n            x: this.ratioX,\n            y: this.ratioY\n          }, direction, resizeHandle);\n        } else if (square) {\n          this.applyRatio(coords, {\n            x: 1,\n            y: 1\n          }, direction, resizeHandle);\n        }\n        var mins = [this.options.minWidth, this.options.minHeight],\n          // minimum dimensions [x,y]\t\t\t\n          maxs = [this.options.maxWidth, this.options.maxHeight]; // maximum dimensions [x,y]\n\n        // apply dimensions where appropriate\n        if (mins[0] > 0 || mins[1] > 0 || maxs[0] > 0 || maxs[1] > 0) {\n          var coordsTransX = {\n              a1: coords.x1,\n              a2: coords.x2\n            },\n            coordsTransY = {\n              a1: coords.y1,\n              a2: coords.y2\n            },\n            boundsX = {\n              min: 0,\n              max: this.imgW\n            },\n            boundsY = {\n              min: 0,\n              max: this.imgH\n            };\n\n          // handle squaring properly on single axis minimum dimensions\n          if ((mins[0] !== 0 || mins[1] !== 0) && square) {\n            if (mins[0] > 0) {\n              mins[1] = mins[0];\n            } else if (mins[1] > 0) {\n              mins[0] = mins[1];\n            }\n          }\n          if ((maxs[0] !== 0 || maxs[0] !== 0) && square) {\n            // if we have a max x value & it is less than the max y value then we set the y max to the max x (so we don't go over the minimum maximum of one of the axes - if that makes sense)\n            if (maxs[0] > 0 && maxs[0] <= maxs[1]) {\n              maxs[1] = maxs[0];\n            } else if (maxs[1] > 0 && maxs[1] <= maxs[0]) {\n              maxs[0] = maxs[1];\n            }\n          }\n          if (mins[0] > 0) {\n            this.applyDimRestriction(coordsTransX, mins[0], direction.x, boundsX, 'min');\n          }\n          if (mins[1] > 1) {\n            this.applyDimRestriction(coordsTransY, mins[1], direction.y, boundsY, 'min');\n          }\n          if (maxs[0] > 0) {\n            this.applyDimRestriction(coordsTransX, maxs[0], direction.x, boundsX, 'max');\n          }\n          if (maxs[1] > 1) {\n            this.applyDimRestriction(coordsTransY, maxs[1], direction.y, boundsY, 'max');\n          }\n          coords = {\n            x1: coordsTransX.a1,\n            y1: coordsTransY.a1,\n            x2: coordsTransX.a2,\n            y2: coordsTransY.a2\n          };\n        }\n      }\n    }\n\n    // dump( 'setAreaCoords (out) : ' + coords.x1 + ',' + coords.y1 + ',' + coords.x2 + ',' + coords.y2 + '\\n' );\n    this.areaCoords = coords;\n  },\n  /**\r\n  * Applies the supplied dimension restriction to the supplied coordinates along a single axis\r\n   * \r\n   * @access private\r\n   * @param obj Single axis coordinates, a1, a2 (e.g. for the x axis a1 = x1 & a2 = x2)\r\n   * @param int The restriction value\r\n   * @param int The direction ( -1 = negative, 1 = positive )\r\n   * @param obj The bounds of the image ( for this axis )\r\n   * @param string The dimension restriction type ( 'min' | 'max' )\r\n   * @return void\r\n   */\n  applyDimRestriction: function applyDimRestriction(coords, val, direction, bounds, type) {\n    var check;\n    if (type == 'min') {\n      check = coords.a2 - coords.a1 < val;\n    } else {\n      check = coords.a2 - coords.a1 > val;\n    }\n    if (check) {\n      if (direction == 1) {\n        coords.a2 = coords.a1 + val;\n      } else {\n        coords.a1 = coords.a2 - val;\n      }\n\n      // make sure we're still in the bounds (not too pretty for the user, but needed)\n      if (coords.a1 < bounds.min) {\n        coords.a1 = bounds.min;\n        coords.a2 = val;\n      } else if (coords.a2 > bounds.max) {\n        coords.a1 = bounds.max - val;\n        coords.a2 = bounds.max;\n      }\n    }\n  },\n  /**\r\n   * Applies the supplied ratio to the supplied coordinates\r\n   * \r\n   * @access private\r\n   * @param obj Coordinates, x1, y1, x2, y2\r\n   * @param obj Ratio, x, y\r\n   * @param obj Direction of mouse, x & y : -1 == negative 1 == positive\r\n   * @param string The current resize handle || null\r\n   * @return void\r\n   */\n  applyRatio: function applyRatio(coords, ratio, direction, resizeHandle) {\n    // dump( 'direction.y : ' + direction.y + '\\n');\n    var newCoords;\n    if (resizeHandle == 'N' || resizeHandle == 'S') {\n      // dump( 'north south \\n');\n      // if moving on either the lone north & south handles apply the ratio on the y axis\n      newCoords = this.applyRatioToAxis({\n        a1: coords.y1,\n        b1: coords.x1,\n        a2: coords.y2,\n        b2: coords.x2\n      }, {\n        a: ratio.y,\n        b: ratio.x\n      }, {\n        a: direction.y,\n        b: direction.x\n      }, {\n        min: 0,\n        max: this.imgW\n      });\n      coords.x1 = newCoords.b1;\n      coords.y1 = newCoords.a1;\n      coords.x2 = newCoords.b2;\n      coords.y2 = newCoords.a2;\n    } else {\n      // otherwise deal with it as if we're applying the ratio on the x axis\n      newCoords = this.applyRatioToAxis({\n        a1: coords.x1,\n        b1: coords.y1,\n        a2: coords.x2,\n        b2: coords.y2\n      }, {\n        a: ratio.x,\n        b: ratio.y\n      }, {\n        a: direction.x,\n        b: direction.y\n      }, {\n        min: 0,\n        max: this.imgH\n      });\n      coords.x1 = newCoords.a1;\n      coords.y1 = newCoords.b1;\n      coords.x2 = newCoords.a2;\n      coords.y2 = newCoords.b2;\n    }\n  },\n  /**\r\n   * Applies the provided ratio to the provided coordinates based on provided direction & bounds,\r\n   * use to encapsulate functionality to make it easy to apply to either axis. This is probably\r\n   * quite hard to visualise so see the x axis example within applyRatio()\r\n   * \r\n   * Example in parameter details & comments is for requesting applying ratio to x axis.\r\n   * \r\n   * @access private\r\n   * @param obj Coords object (a1, b1, a2, b2) where a = x & b = y in example\r\n   * @param obj Ratio object (a, b) where a = x & b = y in example\r\n   * @param obj Direction object (a, b) where a = x & b = y in example\r\n   * @param obj Bounds (min, max)\r\n   * @return obj Coords object (a1, b1, a2, b2) where a = x & b = y in example\r\n   */\n  applyRatioToAxis: function applyRatioToAxis(coords, ratio, direction, bounds) {\n    var newCoords = Object.extend(coords, {}),\n      calcDimA = newCoords.a2 - newCoords.a1,\n      // calculate dimension a (e.g. width)\n      targDimB = Math.floor(calcDimA * ratio.b / ratio.a),\n      // the target dimension b (e.g. height)\n      targB = null,\n      // to hold target b (e.g. y value)\n      targDimA = null,\n      // to hold target dimension a (e.g. width)\n      calcDimB = null; // to hold calculated dimension b (e.g. height)\n\n    // dump( 'newCoords[0]: ' + newCoords.a1 + ',' + newCoords.b1 + ','+ newCoords.a2 + ',' + newCoords.b2 + '\\n');\n\n    if (direction.b == 1) {\n      // if travelling in a positive direction\n      // make sure we're not going out of bounds\n      targB = newCoords.b1 + targDimB;\n      if (targB > bounds.max) {\n        targB = bounds.max;\n        calcDimB = targB - newCoords.b1; // calcuate dimension b (e.g. height)\n      }\n      newCoords.b2 = targB;\n    } else {\n      // if travelling in a negative direction\n      // make sure we're not going out of bounds\n      targB = newCoords.b2 - targDimB;\n      if (targB < bounds.min) {\n        targB = bounds.min;\n        calcDimB = targB + newCoords.b2; // calcuate dimension b (e.g. height)\n      }\n      newCoords.b1 = targB;\n    }\n\n    // dump( 'newCoords[1]: ' + newCoords.a1 + ',' + newCoords.b1 + ','+ newCoords.a2 + ',' + newCoords.b2 + '\\n');\n\n    // apply the calculated dimensions\n    if (calcDimB !== null) {\n      targDimA = Math.floor(calcDimB * ratio.a / ratio.b);\n      if (direction.a == 1) {\n        newCoords.a2 = newCoords.a1 + targDimA;\n      } else {\n        newCoords.a1 = newCoords.a1 = newCoords.a2 - targDimA;\n      }\n    }\n\n    // dump( 'newCoords[2]: ' + newCoords.a1 + ',' + newCoords.b1 + ','+ newCoords.a2 + ',' + newCoords.b2 + '\\n');\n\n    return newCoords;\n  },\n  /**\r\n   * Draws the select area\r\n   * \r\n   * @access private\r\n   * @return void\r\n   */\n  drawArea: function drawArea() {\n    /*\r\n    \tNOTE: I'm not using the Element.setStyle() shortcut as they make it \r\n    \tquite sluggish on Mac based browsers\r\n    */\n    // dump( 'drawArea        : ' + this.areaCoords.x1 + ',' + this.areaCoords.y1 + ',' + this.areaCoords.x2 + ',' + this.areaCoords.y2 + '\\n' );\n    var areaWidth = this.calcW(),\n      areaHeight = this.calcH();\n\n    /*\r\n    \tCalculate all the style strings before we use them, allows reuse & produces quicker\r\n    \trendering (especially noticable in Mac based browsers)\r\n    */\n    var px = 'px',\n      params = [this.areaCoords.x1 + px,\n      // the left of the selArea\n      this.areaCoords.y1 + px,\n      // the top of the selArea\n      areaWidth + px,\n      // width of the selArea\n      areaHeight + px,\n      // height of the selArea\n      this.areaCoords.x2 + px,\n      // bottom of the selArea\n      this.areaCoords.y2 + px,\n      // right of the selArea\n      this.img.width - this.areaCoords.x2 + px,\n      // right edge of selArea\n      this.img.height - this.areaCoords.y2 + px // bottom edge of selArea\n      ];\n\n    // do the select area\n    var areaStyle = this.selArea.style;\n    areaStyle.left = params[0];\n    areaStyle.top = params[1];\n    areaStyle.width = params[2];\n    areaStyle.height = params[3];\n\n    // position the north, east, south & west handles\n    var horizHandlePos = Math.ceil((areaWidth - 6) / 2) + px,\n      vertHandlePos = Math.ceil((areaHeight - 6) / 2) + px;\n    this.handleN.style.left = horizHandlePos;\n    this.handleE.style.top = vertHandlePos;\n    this.handleS.style.left = horizHandlePos;\n    this.handleW.style.top = vertHandlePos;\n\n    // draw the four overlays\n    this.north.style.height = params[1];\n    var eastStyle = this.east.style;\n    eastStyle.top = params[1];\n    eastStyle.height = params[3];\n    eastStyle.left = params[4];\n    eastStyle.width = params[6];\n    var southStyle = this.south.style;\n    southStyle.top = params[5];\n    southStyle.height = params[7];\n    var westStyle = this.west.style;\n    westStyle.top = params[1];\n    westStyle.height = params[3];\n    westStyle.width = params[0];\n\n    // call the draw method on sub classes\n    this.subDrawArea();\n    this.forceReRender();\n  },\n  /**\r\n   * Force the re-rendering of the selArea element which fixes rendering issues in Safari \r\n   * & IE PC, especially evident when re-sizing perfectly vertical using any of the south handles\r\n   * \r\n   * @access private\r\n   * @return void\r\n   */\n  forceReRender: function forceReRender() {\n    if (this.isIE || this.isWebKit) {\n      var n = document.createTextNode(' ');\n      var d, el, fixEL, i;\n      if (this.isIE) {\n        fixEl = this.selArea;\n      } else if (this.isWebKit) {\n        fixEl = document.getElementsByClassName('imgCrop_marqueeSouth', this.imgWrap)[0];\n        /* \r\n        \twe have to be a bit more forceful for Safari, otherwise the the marquee &\r\n        \tthe south handles still don't move\r\n        */\n        d = new Element('div');\n        d.style.visibility = 'hidden';\n        var classList = ['SE', 'S', 'SW'];\n        for (i = 0; i < classList.length; i++) {\n          el = document.getElementsByClassName('imgCrop_handle' + classList[i], this.selArea)[0];\n          if (el.childNodes.length) {\n            el.removeChild(el.childNodes[0]);\n          }\n          el.appendChild(d);\n        }\n      }\n      fixEl.appendChild(n);\n      fixEl.removeChild(n);\n    }\n  },\n  /**\r\n   * Starts the resize\r\n   * \r\n   * @access private\r\n   * @param obj Event\r\n   * @return void\r\n   */\n  startResize: function startResize(e) {\n    this.startCoords = this.cloneCoords(this.areaCoords);\n    this.resizing = true;\n    this.resizeHandle = Event.element(e).classNames().toString().replace(/([^N|NE|E|SE|S|SW|W|NW])+/, '');\n    // dump( 'this.resizeHandle : ' + this.resizeHandle + '\\n' );\n    Event.stop(e);\n  },\n  /**\r\n   * Starts the drag\r\n   * \r\n   * @access private\r\n   * @param obj Event\r\n   * @return void\r\n   */\n  startDrag: function startDrag(e) {\n    this.selArea.show();\n    this.clickCoords = this.getCurPos(e);\n    this.setAreaCoords({\n      x1: this.clickCoords.x,\n      y1: this.clickCoords.y,\n      x2: this.clickCoords.x,\n      y2: this.clickCoords.y\n    }, false, false, null);\n    this.dragging = true;\n    this.onDrag(e); // incase the user just clicks once after already making a selection\n    Event.stop(e);\n  },\n  /**\r\n   * Gets the current cursor position relative to the image\r\n   * \r\n   * @access private\r\n   * @param obj Event\r\n   * @return obj x,y pixels of the cursor\r\n   */\n  getCurPos: function getCurPos(e) {\n    // get the offsets for the wrapper within the document\n    // get the offsets for the wrapper within the document\n    var el = this.imgWrap,\n      wrapOffsets = Element.cumulativeOffset(el);\n    // remove any scrolling that is applied to the wrapper (this may be buggy) - don't count the scroll on the body as that won't affect us\n    while (el.nodeName != 'BODY') {\n      wrapOffsets[1] -= el.scrollTop || 0;\n      wrapOffsets[0] -= el.scrollLeft || 0;\n      el = el.parentNode;\n    }\n    return {\n      x: Event.pointerX(e) - wrapOffsets[0],\n      y: Event.pointerY(e) - wrapOffsets[1]\n    };\n  },\n  /**                            \r\n   * Performs the drag for both   resize & inital draw dragging\r\n   *\r\n   * @access private             \r\n   * @param obj Event\r\n   * @return void\r\n   */\n  onDrag: function onDrag(e) {\n    if (this.dragging || this.resizing) {\n      var resizeHandle = null,\n        curPos = this.getCurPos(e),\n        newCoords = this.cloneCoords(this.areaCoords),\n        direction = {\n          x: 1,\n          y: 1\n        };\n      if (this.dragging) {\n        if (curPos.x < this.clickCoords.x) {\n          direction.x = -1;\n        }\n        if (curPos.y < this.clickCoords.y) {\n          direction.y = -1;\n        }\n        this.transformCoords(curPos.x, this.clickCoords.x, newCoords, 'x');\n        this.transformCoords(curPos.y, this.clickCoords.y, newCoords, 'y');\n      } else if (this.resizing) {\n        resizeHandle = this.resizeHandle;\n        // do x movements first\n        if (resizeHandle.match(/E/)) {\n          // if we're moving an east handle\n          this.transformCoords(curPos.x, this.startCoords.x1, newCoords, 'x');\n          if (curPos.x < this.startCoords.x1) {\n            direction.x = -1;\n          }\n        } else if (resizeHandle.match(/W/)) {\n          // if we're moving an west handle\n          this.transformCoords(curPos.x, this.startCoords.x2, newCoords, 'x');\n          if (curPos.x < this.startCoords.x2) {\n            direction.x = -1;\n          }\n        }\n\n        // do y movements second\n        if (resizeHandle.match(/N/)) {\n          // if we're moving an north handle\t\n          this.transformCoords(curPos.y, this.startCoords.y2, newCoords, 'y');\n          if (curPos.y < this.startCoords.y2) {\n            direction.y = -1;\n          }\n        } else if (resizeHandle.match(/S/)) {\n          // if we're moving an south handle\n          this.transformCoords(curPos.y, this.startCoords.y1, newCoords, 'y');\n          if (curPos.y < this.startCoords.y1) {\n            direction.y = -1;\n          }\n        }\n      }\n      this.setAreaCoords(newCoords, false, e.shiftKey, direction, resizeHandle);\n      this.drawArea();\n      Event.stop(e); // stop the default event (selecting images & text) in Safari & IE PC\n    }\n  },\n  /**\r\n   * Applies the appropriate transform to supplied co-ordinates, on the\r\n   * defined axis, depending on the relationship of the supplied values\r\n   * \r\n   * @access private\r\n   * @param int Current value of pointer\r\n   * @param int Base value to compare current pointer val to\r\n   * @param obj Coordinates to apply transformation on x1, x2, y1, y2\r\n   * @param string Axis to apply transformation on 'x' || 'y'\r\n   * @return void\r\n   */\n  transformCoords: function transformCoords(curVal, baseVal, coords, axis) {\n    var newVals = [curVal, baseVal];\n    if (curVal > baseVal) {\n      (0, _reverse.default)(newVals).call(newVals);\n    }\n    coords[axis + '1'] = newVals[0];\n    coords[axis + '2'] = newVals[1];\n  },\n  /**\r\n   * Ends the crop & passes the values of the select area on to the appropriate \r\n   * callback function on completion of a crop\r\n   * \r\n   * @access private\r\n   * @return void\r\n   */\n  endCrop: function endCrop() {\n    this.dragging = false;\n    this.resizing = false;\n    this.options.onEndCrop(this.areaCoords, {\n      width: this.calcW(),\n      height: this.calcH()\n    });\n  },\n  /**\r\n   * Abstract method called on the end of initialization\r\n   * \r\n   * @access private\r\n   * @abstract\r\n   * @return void\r\n   */\n  subInitialize: function subInitialize() {},\n  /**\r\n   * Abstract method called on the end of drawArea()\r\n   * \r\n   * @access private\r\n   * @abstract\r\n   * @return void\r\n   */\n  subDrawArea: function subDrawArea() {}\n});\n\n/**\r\n *\tExtend the Cropper.Img class to allow for presentation of a preview image of the resulting crop,\r\n *\tthe option for displayOnInit is always overridden to true when displaying a preview image\r\n * \r\n *\tUsage:\r\n *\t\t@param obj Image element to attach to\r\n *\t\t@param obj Optional options:\r\n *\t\t\t- see Cropper.Img for base options\r\n *\t\t\t- previewWrap obj HTML element that will be used as a container for the preview image\r\n */\nCropper.ImgWithPreview = Class.create(Cropper.Img, {\n  /**\r\n   * Implements the abstract method from Cropper.Img to initialize preview image settings.\r\n   * Will only attach a preview image is the previewWrap element is defined and the minWidth\r\n   * & minHeight options are set.\r\n   * \r\n   * @see Croper.Img.subInitialize\r\n   */\n  subInitialize: function subInitialize() {\n    /**\r\n    * Whether or not we've attached a preview image\r\n    * @var boolean\r\n    */\n    this.hasPreviewImg = false;\n    if (typeof this.options.previewWrap != 'undefined' && this.options.minWidth > 0 && this.options.minHeight > 0) {\n      /**\r\n       * The preview image wrapper element\r\n       * @var obj HTML element\r\n       */\n      this.previewWrap = $(this.options.previewWrap);\n      /**\r\n       * The preview image element\r\n       * @var obj HTML IMG element\r\n       */\n      this.previewImg = this.img.cloneNode(false);\n      // set the ID of the preview image to be unique\n      this.previewImg.id = 'imgCrop_' + this.previewImg.id;\n\n      // set the displayOnInit option to true so we display the select area at the same time as the thumbnail\n      this.options.displayOnInit = true;\n      this.hasPreviewImg = true;\n      this.previewWrap.addClassName('imgCrop_previewWrap');\n      this.previewWrap.setStyle({\n        width: this.options.minWidth + 'px',\n        height: this.options.minHeight + 'px'\n      });\n      this.previewWrap.appendChild(this.previewImg);\n    }\n  },\n  /**\r\n   * Implements the abstract method from Cropper.Img to draw the preview image\r\n   * \r\n   * @see Croper.Img.subDrawArea\r\n   */\n  subDrawArea: function subDrawArea() {\n    if (this.hasPreviewImg) {\n      // get the ratio of the select area to the src image\n      var calcWidth = this.calcW(),\n        calcHeight = this.calcH();\n      // ratios for the dimensions of the preview image\n      var dimRatio = {\n        x: this.imgW / calcWidth,\n        y: this.imgH / calcHeight\n      };\n      //ratios for the positions within the preview\n      var posRatio = {\n        x: calcWidth / this.options.minWidth,\n        y: calcHeight / this.options.minHeight\n      };\n\n      // setting the positions in an obj before apply styles for rendering speed increase\n      var calcPos = {\n        w: Math.ceil(this.options.minWidth * dimRatio.x) + 'px',\n        h: Math.ceil(this.options.minHeight * dimRatio.y) + 'px',\n        x: '-' + Math.ceil(this.areaCoords.x1 / posRatio.x) + 'px',\n        y: '-' + Math.ceil(this.areaCoords.y1 / posRatio.y) + 'px'\n      };\n      var previewStyle = this.previewImg.style;\n      previewStyle.width = calcPos.w;\n      previewStyle.height = calcPos.h;\n      previewStyle.left = calcPos.x;\n      previewStyle.top = calcPos.y;\n    }\n  }\n});"

/***/ }),

/***/ "./node_modules/raw-loader/index.js!./node_modules/babel-loader/lib/index.js?!./src/main/assets/js/lib/3rdparty/cropper/lib/scriptaculous.js":
/*!*******************************************************************************************************************************************!*\
  !*** ./node_modules/raw-loader!./node_modules/babel-loader/lib??ref--22-0!./src/main/assets/js/lib/3rdparty/cropper/lib/scriptaculous.js ***!
  \*******************************************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "\"use strict\";\n\nrequire(\"../../../../../../../../node_modules/core-js/modules/es.regexp.exec.js\");\nrequire(\"../../../../../../../../node_modules/core-js/modules/es.string.match.js\");\nrequire(\"../../../../../../../../node_modules/core-js/modules/es.string.replace.js\");\nvar _parseInt2 = _interopRequireDefault(require(\"../../../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/parse-int\"));\nfunction _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }\n// script.aculo.us scriptaculous.js v1.7.1_beta3, Fri May 25 17:19:41 +0200 2007\n\n// Copyright (c) 2005-2007 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)\n// \n// Permission is hereby granted, free of charge, to any person obtaining\n// a copy of this software and associated documentation files (the\n// \"Software\"), to deal in the Software without restriction, including\n// without limitation the rights to use, copy, modify, merge, publish,\n// distribute, sublicense, and/or sell copies of the Software, and to\n// permit persons to whom the Software is furnished to do so, subject to\n// the following conditions:\n// \n// The above copyright notice and this permission notice shall be\n// included in all copies or substantial portions of the Software.\n//\n// THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\n// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE\n// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION\n// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION\n// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n//\n// For details, see the script.aculo.us web site: http://script.aculo.us/\n\nvar Scriptaculous = {\n  Version: '1.7.1_beta3',\n  require: function require(libraryName) {\n    // inserting via DOM fails in Safari 2.0, so brute force approach\n    document.write('<script type=\"text/javascript\" src=\"' + libraryName + '\"></script>');\n  },\n  REQUIRED_PROTOTYPE: '1.5.1',\n  load: function load() {\n    function convertVersionString(versionString) {\n      var r = versionString.split('.');\n      return (0, _parseInt2.default)(r[0]) * 100000 + (0, _parseInt2.default)(r[1]) * 1000 + (0, _parseInt2.default)(r[2]);\n    }\n    if (typeof Prototype == 'undefined' || typeof Element == 'undefined' || typeof Element.Methods == 'undefined' || convertVersionString(Prototype.Version) < convertVersionString(Scriptaculous.REQUIRED_PROTOTYPE)) throw \"script.aculo.us requires the Prototype JavaScript framework >= \" + Scriptaculous.REQUIRED_PROTOTYPE;\n    $A(document.getElementsByTagName(\"script\")).findAll(function (s) {\n      return s.src && s.src.match(/scriptaculous\\.js(\\?.*)?$/);\n    }).each(function (s) {\n      var path = s.src.replace(/scriptaculous\\.js(\\?.*)?$/, '');\n      var includes = s.src.match(/\\?.*load=([a-z,]*)/);\n      (includes ? includes[1] : 'builder,effects,dragdrop,controls,slider,sound').split(',').each(function (include) {\n        Scriptaculous.require(path + include + '.js');\n      });\n    });\n  }\n};\nScriptaculous.load();"

/***/ }),

/***/ "./node_modules/raw-loader/index.js!./node_modules/babel-loader/lib/index.js?!./src/main/assets/js/lib/3rdparty/prototype.js":
/*!***************************************************************************************************************************!*\
  !*** ./node_modules/raw-loader!./node_modules/babel-loader/lib??ref--22-0!./src/main/assets/js/lib/3rdparty/prototype.js ***!
  \***************************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "\"use strict\";\n\nvar _Symbol = require(\"@babel/runtime-corejs3/core-js-stable/symbol\");\nvar _Symbol$iterator = require(\"@babel/runtime-corejs3/core-js-stable/symbol/iterator\");\nvar _indexOf = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/index-of\"));\nvar _keys = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/object/keys\"));\nvar _stringify = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/json/stringify\"));\nvar _isArray = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/array/is-array\"));\nvar _slice = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/slice\"));\nvar _setTimeout2 = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/set-timeout\"));\nvar _bind = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/bind\"));\nvar _setInterval2 = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/set-interval\"));\nvar _map = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/map\"));\nvar _lastIndexOf = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/last-index-of\"));\nvar _trim = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/trim\"));\nvar _startsWith = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/starts-with\"));\nvar _endsWith = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/ends-with\"));\nvar _sort = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/sort\"));\nvar _concat = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/concat\"));\nvar _forEach = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/for-each\"));\nvar _filter = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/filter\"));\nvar _some = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/some\"));\nvar _every = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/every\"));\nvar _entries = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/entries\"));\nvar _reverse = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/reverse\"));\nvar _values = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/values\"));\nvar _parseFloat2 = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/parse-float\"));\nvar _parseInt2 = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/parse-int\"));\nvar _find = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/find\"));\nvar _splice = _interopRequireDefault(require(\"../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/splice\"));\nrequire(\"../../../../../../node_modules/core-js/modules/es.array.concat.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.array.filter.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.array.from.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.array.index-of.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.array.iterator.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.array.join.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.array.last-index-of.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.date.to-iso-string.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.date.to-json.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.function.name.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.number.constructor.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.object.keys.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.object.to-string.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.promise.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.regexp.constructor.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.regexp.exec.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.regexp.to-string.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.string.iterator.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.string.match.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.string.replace.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/es.string.split.js\");\nrequire(\"../../../../../../node_modules/core-js/modules/web.dom-collections.iterator.js\");\nfunction _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }\nfunction _typeof(o) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof _Symbol && \"symbol\" == typeof _Symbol$iterator ? function (o) { return typeof o; } : function (o) { return o && \"function\" == typeof _Symbol && o.constructor === _Symbol && o !== _Symbol.prototype ? \"symbol\" : typeof o; }, _typeof(o); }\n/*  Prototype JavaScript framework, version 1.7.3\n *  (c) 2005-2010 Sam Stephenson\n *\n *  Prototype is freely distributable under the terms of an MIT-style license.\n *  For details, see the Prototype web site: http://www.prototypejs.org/\n *\n *--------------------------------------------------------------------------*/\n\nvar Prototype = {\n  Version: '1.7.3',\n  Browser: function () {\n    var ua = navigator.userAgent;\n    var isOpera = Object.prototype.toString.call(window.opera) == '[object Opera]';\n    return {\n      IE: !!window.attachEvent && !isOpera,\n      Opera: isOpera,\n      WebKit: (0, _indexOf.default)(ua).call(ua, 'AppleWebKit/') > -1,\n      Gecko: (0, _indexOf.default)(ua).call(ua, 'Gecko') > -1 && (0, _indexOf.default)(ua).call(ua, 'KHTML') === -1,\n      MobileSafari: /Apple.*Mobile/.test(ua)\n    };\n  }(),\n  BrowserFeatures: {\n    XPath: !!document.evaluate,\n    SelectorsAPI: !!document.querySelector,\n    ElementExtensions: function () {\n      var constructor = window.Element || window.HTMLElement;\n      return !!(constructor && constructor.prototype);\n    }(),\n    SpecificElementExtensions: function () {\n      if (typeof window.HTMLDivElement !== 'undefined') return true;\n      var div = document.createElement('div'),\n        form = document.createElement('form'),\n        isSupported = false;\n      if (div['__proto__'] && div['__proto__'] !== form['__proto__']) {\n        isSupported = true;\n      }\n      div = form = null;\n      return isSupported;\n    }()\n  },\n  ScriptFragment: '<script[^>]*>([\\\\S\\\\s]*?)<\\/script\\\\s*>',\n  JSONFilter: /^\\/\\*-secure-([\\s\\S]*)\\*\\/\\s*$/,\n  emptyFunction: function emptyFunction() {},\n  K: function K(x) {\n    return x;\n  }\n};\nif (Prototype.Browser.MobileSafari) Prototype.BrowserFeatures.SpecificElementExtensions = false;\n/* Based on Alex Arnell's inheritance implementation. */\n\nvar Class = function () {\n  var IS_DONTENUM_BUGGY = function () {\n    for (var p in {\n      toString: 1\n    }) {\n      if (p === 'toString') return false;\n    }\n    return true;\n  }();\n  function subclass() {}\n  ;\n  function create() {\n    var parent = null,\n      properties = $A(arguments);\n    if (Object.isFunction(properties[0])) parent = properties.shift();\n    function klass() {\n      this.initialize.apply(this, arguments);\n    }\n    Object.extend(klass, Class.Methods);\n    klass.superclass = parent;\n    klass.subclasses = [];\n    if (parent) {\n      subclass.prototype = parent.prototype;\n      klass.prototype = new subclass();\n      parent.subclasses.push(klass);\n    }\n    for (var i = 0, length = properties.length; i < length; i++) klass.addMethods(properties[i]);\n    if (!klass.prototype.initialize) klass.prototype.initialize = Prototype.emptyFunction;\n    klass.prototype.constructor = klass;\n    return klass;\n  }\n  function addMethods(source) {\n    var ancestor = this.superclass && this.superclass.prototype,\n      properties = (0, _keys.default)(source);\n    if (IS_DONTENUM_BUGGY) {\n      if (source.toString != Object.prototype.toString) properties.push(\"toString\");\n      if (source.valueOf != Object.prototype.valueOf) properties.push(\"valueOf\");\n    }\n    for (var i = 0, length = properties.length; i < length; i++) {\n      var property = properties[i],\n        value = source[property];\n      if (ancestor && Object.isFunction(value) && value.argumentNames()[0] == \"$super\") {\n        var method = value;\n        value = function (m) {\n          return function () {\n            return ancestor[m].apply(this, arguments);\n          };\n        }(property).wrap(method);\n        value.valueOf = function (method) {\n          return function () {\n            return method.valueOf.call(method);\n          };\n        }(method);\n        value.toString = function (method) {\n          return function () {\n            return method.toString.call(method);\n          };\n        }(method);\n      }\n      this.prototype[property] = value;\n    }\n    return this;\n  }\n  return {\n    create: create,\n    Methods: {\n      addMethods: addMethods\n    }\n  };\n}();\n(function () {\n  var _toString = Object.prototype.toString,\n    _hasOwnProperty = Object.prototype.hasOwnProperty,\n    NULL_TYPE = 'Null',\n    UNDEFINED_TYPE = 'Undefined',\n    BOOLEAN_TYPE = 'Boolean',\n    NUMBER_TYPE = 'Number',\n    STRING_TYPE = 'String',\n    OBJECT_TYPE = 'Object',\n    FUNCTION_CLASS = '[object Function]',\n    BOOLEAN_CLASS = '[object Boolean]',\n    NUMBER_CLASS = '[object Number]',\n    STRING_CLASS = '[object String]',\n    ARRAY_CLASS = '[object Array]',\n    DATE_CLASS = '[object Date]',\n    NATIVE_JSON_STRINGIFY_SUPPORT = window.JSON && typeof _stringify.default === 'function' && (0, _stringify.default)(0) === '0' && typeof (0, _stringify.default)(Prototype.K) === 'undefined';\n  var DONT_ENUMS = ['toString', 'toLocaleString', 'valueOf', 'hasOwnProperty', 'isPrototypeOf', 'propertyIsEnumerable', 'constructor'];\n  var IS_DONTENUM_BUGGY = function () {\n    for (var p in {\n      toString: 1\n    }) {\n      if (p === 'toString') return false;\n    }\n    return true;\n  }();\n  function Type(o) {\n    switch (o) {\n      case null:\n        return NULL_TYPE;\n      case void 0:\n        return UNDEFINED_TYPE;\n    }\n    var type = _typeof(o);\n    switch (type) {\n      case 'boolean':\n        return BOOLEAN_TYPE;\n      case 'number':\n        return NUMBER_TYPE;\n      case 'string':\n        return STRING_TYPE;\n    }\n    return OBJECT_TYPE;\n  }\n  function extend(destination, source) {\n    for (var property in source) destination[property] = source[property];\n    return destination;\n  }\n  function inspect(object) {\n    try {\n      if (isUndefined(object)) return 'undefined';\n      if (object === null) return 'null';\n      return object.inspect ? object.inspect() : String(object);\n    } catch (e) {\n      if (e instanceof RangeError) return '...';\n      throw e;\n    }\n  }\n  function toJSON(value) {\n    return Str('', {\n      '': value\n    }, []);\n  }\n  function Str(key, holder, stack) {\n    var value = holder[key];\n    if (Type(value) === OBJECT_TYPE && typeof value.toJSON === 'function') {\n      value = value.toJSON(key);\n    }\n    var _class = _toString.call(value);\n    switch (_class) {\n      case NUMBER_CLASS:\n      case BOOLEAN_CLASS:\n      case STRING_CLASS:\n        value = value.valueOf();\n    }\n    switch (value) {\n      case null:\n        return 'null';\n      case true:\n        return 'true';\n      case false:\n        return 'false';\n    }\n    var type = _typeof(value);\n    switch (type) {\n      case 'string':\n        return value.inspect(true);\n      case 'number':\n        return isFinite(value) ? String(value) : 'null';\n      case 'object':\n        for (var i = 0, length = stack.length; i < length; i++) {\n          if (stack[i] === value) {\n            throw new TypeError(\"Cyclic reference to '\" + value + \"' in object\");\n          }\n        }\n        stack.push(value);\n        var partial = [];\n        if (_class === ARRAY_CLASS) {\n          for (var i = 0, length = value.length; i < length; i++) {\n            var str = Str(i, value, stack);\n            partial.push(typeof str === 'undefined' ? 'null' : str);\n          }\n          partial = '[' + partial.join(',') + ']';\n        } else {\n          var keys = (0, _keys.default)(value);\n          for (var i = 0, length = keys.length; i < length; i++) {\n            var key = keys[i],\n              str = Str(key, value, stack);\n            if (typeof str !== \"undefined\") {\n              partial.push(key.inspect(true) + ':' + str);\n            }\n          }\n          partial = '{' + partial.join(',') + '}';\n        }\n        stack.pop();\n        return partial;\n    }\n  }\n  function stringify(object) {\n    return (0, _stringify.default)(object);\n  }\n  function toQueryString(object) {\n    return $H(object).toQueryString();\n  }\n  function toHTML(object) {\n    return object && object.toHTML ? object.toHTML() : String.interpret(object);\n  }\n  function keys(object) {\n    if (Type(object) !== OBJECT_TYPE) {\n      throw new TypeError();\n    }\n    var results = [];\n    for (var property in object) {\n      if (_hasOwnProperty.call(object, property)) results.push(property);\n    }\n    if (IS_DONTENUM_BUGGY) {\n      for (var i = 0; property = DONT_ENUMS[i]; i++) {\n        if (_hasOwnProperty.call(object, property)) results.push(property);\n      }\n    }\n    return results;\n  }\n  function values(object) {\n    var results = [];\n    for (var property in object) results.push(object[property]);\n    return results;\n  }\n  function clone(object) {\n    return extend({}, object);\n  }\n  function isElement(object) {\n    return !!(object && object.nodeType == 1);\n  }\n  function isArray(object) {\n    return _toString.call(object) === ARRAY_CLASS;\n  }\n  var hasNativeIsArray = typeof _isArray.default == 'function' && (0, _isArray.default)([]) && !(0, _isArray.default)({});\n  if (hasNativeIsArray) {\n    isArray = _isArray.default;\n  }\n  function isHash(object) {\n    return object instanceof Hash;\n  }\n  function isFunction(object) {\n    return _toString.call(object) === FUNCTION_CLASS;\n  }\n  function isString(object) {\n    return _toString.call(object) === STRING_CLASS;\n  }\n  function isNumber(object) {\n    return _toString.call(object) === NUMBER_CLASS;\n  }\n  function isDate(object) {\n    return _toString.call(object) === DATE_CLASS;\n  }\n  function isUndefined(object) {\n    return typeof object === \"undefined\";\n  }\n  extend(Object, {\n    extend: extend,\n    inspect: inspect,\n    toJSON: NATIVE_JSON_STRINGIFY_SUPPORT ? stringify : toJSON,\n    toQueryString: toQueryString,\n    toHTML: toHTML,\n    keys: _keys.default || keys,\n    values: values,\n    clone: clone,\n    isElement: isElement,\n    isArray: isArray,\n    isHash: isHash,\n    isFunction: isFunction,\n    isString: isString,\n    isNumber: isNumber,\n    isDate: isDate,\n    isUndefined: isUndefined\n  });\n})();\nObject.extend(Function.prototype, function () {\n  var slice = (0, _slice.default)(Array.prototype);\n  function update(array, args) {\n    var arrayLength = array.length,\n      length = args.length;\n    while (length--) array[arrayLength + length] = args[length];\n    return array;\n  }\n  function merge(array, args) {\n    array = slice.call(array, 0);\n    return update(array, args);\n  }\n  function argumentNames() {\n    var names = this.toString().match(/^[\\s\\(]*function[^(]*\\(([^)]*)\\)/)[1].replace(/\\/\\/.*?[\\r\\n]|\\/\\*(?:.|[\\r\\n])*?\\*\\//g, '').replace(/\\s+/g, '').split(',');\n    return names.length == 1 && !names[0] ? [] : names;\n  }\n  function bind(context) {\n    if (arguments.length < 2 && Object.isUndefined(arguments[0])) return this;\n    if (!Object.isFunction(this)) throw new TypeError(\"The object is not callable.\");\n    var nop = function nop() {};\n    var __method = this,\n      args = slice.call(arguments, 1);\n    var _bound = function bound() {\n      var a = merge(args, arguments);\n      var c = this instanceof _bound ? this : context;\n      return __method.apply(c, a);\n    };\n    nop.prototype = this.prototype;\n    _bound.prototype = new nop();\n    return _bound;\n  }\n  function bindAsEventListener(context) {\n    var __method = this,\n      args = slice.call(arguments, 1);\n    return function (event) {\n      var a = update([event || window.event], args);\n      return __method.apply(context, a);\n    };\n  }\n  function curry() {\n    if (!arguments.length) return this;\n    var __method = this,\n      args = slice.call(arguments, 0);\n    return function () {\n      var a = merge(args, arguments);\n      return __method.apply(this, a);\n    };\n  }\n  function delay(timeout) {\n    var __method = this,\n      args = slice.call(arguments, 1);\n    timeout = timeout * 1000;\n    return (0, _setTimeout2.default)(function () {\n      return __method.apply(__method, args);\n    }, timeout);\n  }\n  function defer() {\n    var args = update([0.01], arguments);\n    return this.delay.apply(this, args);\n  }\n  function wrap(wrapper) {\n    var __method = this;\n    return function () {\n      var a = update([(0, _bind.default)(__method).call(__method, this)], arguments);\n      return wrapper.apply(this, a);\n    };\n  }\n  function methodize() {\n    if (this._methodized) return this._methodized;\n    var __method = this;\n    return this._methodized = function () {\n      var a = update([this], arguments);\n      return __method.apply(null, a);\n    };\n  }\n  var extensions = {\n    argumentNames: argumentNames,\n    bindAsEventListener: bindAsEventListener,\n    curry: curry,\n    delay: delay,\n    defer: defer,\n    wrap: wrap,\n    methodize: methodize\n  };\n  if (!(0, _bind.default)(Function.prototype)) extensions.bind = bind;\n  return extensions;\n}());\n(function (proto) {\n  function toISOString() {\n    return this.getUTCFullYear() + '-' + (this.getUTCMonth() + 1).toPaddedString(2) + '-' + this.getUTCDate().toPaddedString(2) + 'T' + this.getUTCHours().toPaddedString(2) + ':' + this.getUTCMinutes().toPaddedString(2) + ':' + this.getUTCSeconds().toPaddedString(2) + 'Z';\n  }\n  function toJSON() {\n    return this.toISOString();\n  }\n  if (!proto.toISOString) proto.toISOString = toISOString;\n  if (!proto.toJSON) proto.toJSON = toJSON;\n})(Date.prototype);\nRegExp.prototype.match = RegExp.prototype.test;\nRegExp.escape = function (str) {\n  return String(str).replace(/([.*+?^=!:${}()|[\\]\\/\\\\])/g, '\\\\$1');\n};\nvar PeriodicalExecuter = Class.create({\n  initialize: function initialize(callback, frequency) {\n    this.callback = callback;\n    this.frequency = frequency;\n    this.currentlyExecuting = false;\n    this.registerCallback();\n  },\n  registerCallback: function registerCallback() {\n    var _context;\n    this.timer = (0, _setInterval2.default)((0, _bind.default)(_context = this.onTimerEvent).call(_context, this), this.frequency * 1000);\n  },\n  execute: function execute() {\n    this.callback(this);\n  },\n  stop: function stop() {\n    if (!this.timer) return;\n    clearInterval(this.timer);\n    this.timer = null;\n  },\n  onTimerEvent: function onTimerEvent() {\n    if (!this.currentlyExecuting) {\n      try {\n        this.currentlyExecuting = true;\n        this.execute();\n        this.currentlyExecuting = false;\n      } catch (e) {\n        this.currentlyExecuting = false;\n        throw e;\n      }\n    }\n  }\n});\nObject.extend(String, {\n  interpret: function interpret(value) {\n    return value == null ? '' : String(value);\n  },\n  specialChar: {\n    '\\b': '\\\\b',\n    '\\t': '\\\\t',\n    '\\n': '\\\\n',\n    '\\f': '\\\\f',\n    '\\r': '\\\\r',\n    '\\\\': '\\\\\\\\'\n  }\n});\nObject.extend(String.prototype, function () {\n  var NATIVE_JSON_PARSE_SUPPORT = window.JSON && typeof JSON.parse === 'function' && JSON.parse('{\"test\": true}').test;\n  function prepareReplacement(replacement) {\n    if (Object.isFunction(replacement)) return replacement;\n    var template = new Template(replacement);\n    return function (match) {\n      return template.evaluate(match);\n    };\n  }\n  function isNonEmptyRegExp(regexp) {\n    return regexp.source && regexp.source !== '(?:)';\n  }\n  function gsub(pattern, replacement) {\n    var result = '',\n      source = this,\n      match;\n    replacement = prepareReplacement(replacement);\n    if (Object.isString(pattern)) pattern = RegExp.escape(pattern);\n    if (!(pattern.length || isNonEmptyRegExp(pattern))) {\n      replacement = replacement('');\n      return replacement + source.split('').join(replacement) + replacement;\n    }\n    while (source.length > 0) {\n      match = source.match(pattern);\n      if (match && match[0].length > 0) {\n        result += (0, _slice.default)(source).call(source, 0, match.index);\n        result += String.interpret(replacement(match));\n        source = (0, _slice.default)(source).call(source, match.index + match[0].length);\n      } else {\n        result += source, source = '';\n      }\n    }\n    return result;\n  }\n  function sub(pattern, replacement, count) {\n    replacement = prepareReplacement(replacement);\n    count = Object.isUndefined(count) ? 1 : count;\n    return this.gsub(pattern, function (match) {\n      if (--count < 0) return match[0];\n      return replacement(match);\n    });\n  }\n  function scan(pattern, iterator) {\n    this.gsub(pattern, iterator);\n    return String(this);\n  }\n  function truncate(length, truncation) {\n    var _context2;\n    length = length || 30;\n    truncation = Object.isUndefined(truncation) ? '...' : truncation;\n    return this.length > length ? (0, _slice.default)(_context2 = this).call(_context2, 0, length - truncation.length) + truncation : String(this);\n  }\n  function strip() {\n    return this.replace(/^\\s+/, '').replace(/\\s+$/, '');\n  }\n  function stripTags() {\n    return this.replace(/<\\w+(\\s+(\"[^\"]*\"|'[^']*'|[^>])+)?(\\/)?>|<\\/\\w+>/gi, '');\n  }\n  function stripScripts() {\n    return this.replace(new RegExp(Prototype.ScriptFragment, 'img'), '');\n  }\n  function extractScripts() {\n    var _context3;\n    var matchAll = new RegExp(Prototype.ScriptFragment, 'img'),\n      matchOne = new RegExp(Prototype.ScriptFragment, 'im');\n    return (0, _map.default)(_context3 = this.match(matchAll) || []).call(_context3, function (scriptTag) {\n      return (scriptTag.match(matchOne) || ['', ''])[1];\n    });\n  }\n  function evalScripts() {\n    var _context4;\n    return (0, _map.default)(_context4 = this.extractScripts()).call(_context4, function (script) {\n      return eval(script);\n    });\n  }\n  function escapeHTML() {\n    return this.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');\n  }\n  function unescapeHTML() {\n    return this.stripTags().replace(/&lt;/g, '<').replace(/&gt;/g, '>').replace(/&amp;/g, '&');\n  }\n  function toQueryParams(separator) {\n    var match = this.strip().match(/([^?#]*)(#.*)?$/);\n    if (!match) return {};\n    return match[1].split(separator || '&').inject({}, function (hash, pair) {\n      if ((pair = pair.split('='))[0]) {\n        var key = decodeURIComponent(pair.shift()),\n          value = pair.length > 1 ? pair.join('=') : pair[0];\n        if (value != undefined) {\n          value = value.gsub('+', ' ');\n          value = decodeURIComponent(value);\n        }\n        if (key in hash) {\n          if (!Object.isArray(hash[key])) hash[key] = [hash[key]];\n          hash[key].push(value);\n        } else hash[key] = value;\n      }\n      return hash;\n    });\n  }\n  function toArray() {\n    return this.split('');\n  }\n  function succ() {\n    var _context5;\n    return (0, _slice.default)(_context5 = this).call(_context5, 0, this.length - 1) + String.fromCharCode(this.charCodeAt(this.length - 1) + 1);\n  }\n  function times(count) {\n    return count < 1 ? '' : new Array(count + 1).join(this);\n  }\n  function camelize() {\n    return this.replace(/-+(.)?/g, function (match, chr) {\n      return chr ? chr.toUpperCase() : '';\n    });\n  }\n  function capitalize() {\n    return this.charAt(0).toUpperCase() + this.substring(1).toLowerCase();\n  }\n  function underscore() {\n    return this.replace(/::/g, '/').replace(/([A-Z]+)([A-Z][a-z])/g, '$1_$2').replace(/([a-z\\d])([A-Z])/g, '$1_$2').replace(/-/g, '_').toLowerCase();\n  }\n  function dasherize() {\n    return this.replace(/_/g, '-');\n  }\n  function inspect(useDoubleQuotes) {\n    var escapedString = this.replace(/[\\x00-\\x1f\\\\]/g, function (character) {\n      if (character in String.specialChar) {\n        return String.specialChar[character];\n      }\n      return \"\\\\u00\" + character.charCodeAt().toPaddedString(2, 16);\n    });\n    if (useDoubleQuotes) return '\"' + escapedString.replace(/\"/g, '\\\\\"') + '\"';\n    return \"'\" + escapedString.replace(/'/g, '\\\\\\'') + \"'\";\n  }\n  function unfilterJSON(filter) {\n    return this.replace(filter || Prototype.JSONFilter, '$1');\n  }\n  function isJSON() {\n    var str = this;\n    if (str.blank()) return false;\n    str = str.replace(/\\\\(?:[\"\\\\\\/bfnrt]|u[0-9a-fA-F]{4})/g, '@');\n    str = str.replace(/\"[^\"\\\\\\n\\r]*\"|true|false|null|-?\\d+(?:\\.\\d*)?(?:[eE][+\\-]?\\d+)?/g, ']');\n    str = str.replace(/(?:^|:|,)(?:\\s*\\[)+/g, '');\n    return /^[\\],:{}\\s]*$/.test(str);\n  }\n  function evalJSON(sanitize) {\n    var json = this.unfilterJSON(),\n      cx = /[\\u00ad\\u0600-\\u0604\\u070f\\u17b4\\u17b5\\u200c-\\u200f\\u2028-\\u202f\\u2060-\\u206f\\ufeff\\ufff0-\\uffff\\u0000]/g;\n    if (cx.test(json)) {\n      json = json.replace(cx, function (a) {\n        var _context6;\n        return \"\\\\u\" + (0, _slice.default)(_context6 = '0000' + a.charCodeAt(0).toString(16)).call(_context6, -4);\n      });\n    }\n    try {\n      if (!sanitize || json.isJSON()) return eval('(' + json + ')');\n    } catch (e) {}\n    throw new SyntaxError('Badly formed JSON string: ' + this.inspect());\n  }\n  function parseJSON() {\n    var json = this.unfilterJSON();\n    return JSON.parse(json);\n  }\n  function include(pattern) {\n    var _context7;\n    return (0, _indexOf.default)(_context7 = this).call(_context7, pattern) > -1;\n  }\n  function startsWith(pattern, position) {\n    var _context8;\n    position = Object.isNumber(position) ? position : 0;\n    return (0, _lastIndexOf.default)(_context8 = this).call(_context8, pattern, position) === position;\n  }\n  function endsWith(pattern, position) {\n    var _context9;\n    pattern = String(pattern);\n    position = Object.isNumber(position) ? position : this.length;\n    if (position < 0) position = 0;\n    if (position > this.length) position = this.length;\n    var d = position - pattern.length;\n    return d >= 0 && (0, _indexOf.default)(_context9 = this).call(_context9, pattern, d) === d;\n  }\n  function empty() {\n    return this == '';\n  }\n  function blank() {\n    return /^\\s*$/.test(this);\n  }\n  function interpolate(object, pattern) {\n    return new Template(this, pattern).evaluate(object);\n  }\n  return {\n    gsub: gsub,\n    sub: sub,\n    scan: scan,\n    truncate: truncate,\n    strip: (0, _trim.default)(String.prototype) || strip,\n    stripTags: stripTags,\n    stripScripts: stripScripts,\n    extractScripts: extractScripts,\n    evalScripts: evalScripts,\n    escapeHTML: escapeHTML,\n    unescapeHTML: unescapeHTML,\n    toQueryParams: toQueryParams,\n    parseQuery: toQueryParams,\n    toArray: toArray,\n    succ: succ,\n    times: times,\n    camelize: camelize,\n    capitalize: capitalize,\n    underscore: underscore,\n    dasherize: dasherize,\n    inspect: inspect,\n    unfilterJSON: unfilterJSON,\n    isJSON: isJSON,\n    evalJSON: NATIVE_JSON_PARSE_SUPPORT ? parseJSON : evalJSON,\n    include: include,\n    startsWith: (0, _startsWith.default)(String.prototype) || startsWith,\n    endsWith: (0, _endsWith.default)(String.prototype) || endsWith,\n    empty: empty,\n    blank: blank,\n    interpolate: interpolate\n  };\n}());\nvar Template = Class.create({\n  initialize: function initialize(template, pattern) {\n    this.template = template.toString();\n    this.pattern = pattern || Template.Pattern;\n  },\n  evaluate: function evaluate(object) {\n    if (object && Object.isFunction(object.toTemplateReplacements)) object = object.toTemplateReplacements();\n    return this.template.gsub(this.pattern, function (match) {\n      if (object == null) return match[1] + '';\n      var before = match[1] || '';\n      if (before == '\\\\') return match[2];\n      var ctx = object,\n        expr = match[3],\n        pattern = /^([^.[]+|\\[((?:.*?[^\\\\])?)\\])(\\.|\\[|$)/;\n      match = pattern.exec(expr);\n      if (match == null) return before;\n      while (match != null) {\n        var _context0;\n        var comp = (0, _startsWith.default)(_context0 = match[1]).call(_context0, '[') ? match[2].replace(/\\\\\\\\]/g, ']') : match[1];\n        ctx = ctx[comp];\n        if (null == ctx || '' == match[3]) break;\n        expr = expr.substring('[' == match[3] ? match[1].length : match[0].length);\n        match = pattern.exec(expr);\n      }\n      return before + String.interpret(ctx);\n    });\n  }\n});\nTemplate.Pattern = /(^|.|\\r|\\n)(#\\{(.*?)\\})/;\nvar $break = {};\nvar Enumerable = function () {\n  function each(iterator, context) {\n    try {\n      this._each(iterator, context);\n    } catch (e) {\n      if (e != $break) throw e;\n    }\n    return this;\n  }\n  function eachSlice(number, iterator, context) {\n    var index = -number,\n      slices = [],\n      array = this.toArray();\n    if (number < 1) return array;\n    while ((index += number) < array.length) slices.push((0, _slice.default)(array).call(array, index, index + number));\n    return slices.collect(iterator, context);\n  }\n  function all(iterator, context) {\n    iterator = iterator || Prototype.K;\n    var result = true;\n    this.each(function (value, index) {\n      result = result && !!iterator.call(context, value, index, this);\n      if (!result) throw $break;\n    }, this);\n    return result;\n  }\n  function any(iterator, context) {\n    iterator = iterator || Prototype.K;\n    var result = false;\n    this.each(function (value, index) {\n      if (result = !!iterator.call(context, value, index, this)) throw $break;\n    }, this);\n    return result;\n  }\n  function collect(iterator, context) {\n    iterator = iterator || Prototype.K;\n    var results = [];\n    this.each(function (value, index) {\n      results.push(iterator.call(context, value, index, this));\n    }, this);\n    return results;\n  }\n  function detect(iterator, context) {\n    var result;\n    this.each(function (value, index) {\n      if (iterator.call(context, value, index, this)) {\n        result = value;\n        throw $break;\n      }\n    }, this);\n    return result;\n  }\n  function findAll(iterator, context) {\n    var results = [];\n    this.each(function (value, index) {\n      if (iterator.call(context, value, index, this)) results.push(value);\n    }, this);\n    return results;\n  }\n  function grep(filter, iterator, context) {\n    iterator = iterator || Prototype.K;\n    var results = [];\n    if (Object.isString(filter)) filter = new RegExp(RegExp.escape(filter));\n    this.each(function (value, index) {\n      if (filter.match(value)) results.push(iterator.call(context, value, index, this));\n    }, this);\n    return results;\n  }\n  function include(object) {\n    var _context1;\n    if (Object.isFunction((0, _indexOf.default)(this)) && (0, _indexOf.default)(_context1 = this).call(_context1, object) != -1) return true;\n    var found = false;\n    this.each(function (value) {\n      if (value == object) {\n        found = true;\n        throw $break;\n      }\n    });\n    return found;\n  }\n  function inGroupsOf(number, fillWith) {\n    fillWith = Object.isUndefined(fillWith) ? null : fillWith;\n    return this.eachSlice(number, function (slice) {\n      while (slice.length < number) slice.push(fillWith);\n      return slice;\n    });\n  }\n  function inject(memo, iterator, context) {\n    this.each(function (value, index) {\n      memo = iterator.call(context, memo, value, index, this);\n    }, this);\n    return memo;\n  }\n  function invoke(method) {\n    var _context10, _context11;\n    var args = (0, _slice.default)(_context10 = $A(arguments)).call(_context10, 1);\n    return (0, _map.default)(_context11 = this).call(_context11, function (value) {\n      return value[method].apply(value, args);\n    });\n  }\n  function max(iterator, context) {\n    iterator = iterator || Prototype.K;\n    var result;\n    this.each(function (value, index) {\n      value = iterator.call(context, value, index, this);\n      if (result == null || value >= result) result = value;\n    }, this);\n    return result;\n  }\n  function min(iterator, context) {\n    iterator = iterator || Prototype.K;\n    var result;\n    this.each(function (value, index) {\n      value = iterator.call(context, value, index, this);\n      if (result == null || value < result) result = value;\n    }, this);\n    return result;\n  }\n  function partition(iterator, context) {\n    iterator = iterator || Prototype.K;\n    var trues = [],\n      falses = [];\n    this.each(function (value, index) {\n      (iterator.call(context, value, index, this) ? trues : falses).push(value);\n    }, this);\n    return [trues, falses];\n  }\n  function pluck(property) {\n    var results = [];\n    this.each(function (value) {\n      results.push(value[property]);\n    });\n    return results;\n  }\n  function reject(iterator, context) {\n    var results = [];\n    this.each(function (value, index) {\n      if (!iterator.call(context, value, index, this)) results.push(value);\n    }, this);\n    return results;\n  }\n  function sortBy(iterator, context) {\n    var _context12, _context13;\n    return (0, _sort.default)(_context12 = (0, _map.default)(_context13 = this).call(_context13, function (value, index) {\n      return {\n        value: value,\n        criteria: iterator.call(context, value, index, this)\n      };\n    }, this)).call(_context12, function (left, right) {\n      var a = left.criteria,\n        b = right.criteria;\n      return a < b ? -1 : a > b ? 1 : 0;\n    }).pluck('value');\n  }\n  function toArray() {\n    var _context14;\n    return (0, _map.default)(_context14 = this).call(_context14);\n  }\n  function zip() {\n    var _context15, _context16, _context17;\n    var iterator = Prototype.K,\n      args = $A(arguments);\n    if (Object.isFunction(args.last())) iterator = args.pop();\n    var collections = (0, _map.default)(_context15 = (0, _concat.default)(_context16 = [this]).call(_context16, args)).call(_context15, $A);\n    return (0, _map.default)(_context17 = this).call(_context17, function (value, index) {\n      return iterator(collections.pluck(index));\n    });\n  }\n  function size() {\n    return this.toArray().length;\n  }\n  function inspect() {\n    return '#<Enumerable:' + this.toArray().inspect() + '>';\n  }\n  return {\n    each: each,\n    eachSlice: eachSlice,\n    all: all,\n    every: all,\n    any: any,\n    some: any,\n    collect: collect,\n    map: collect,\n    detect: detect,\n    findAll: findAll,\n    select: findAll,\n    filter: findAll,\n    grep: grep,\n    include: include,\n    member: include,\n    inGroupsOf: inGroupsOf,\n    inject: inject,\n    invoke: invoke,\n    max: max,\n    min: min,\n    partition: partition,\n    pluck: pluck,\n    reject: reject,\n    sortBy: sortBy,\n    toArray: toArray,\n    entries: toArray,\n    zip: zip,\n    size: size,\n    inspect: inspect,\n    find: detect\n  };\n}();\nfunction $A(iterable) {\n  if (!iterable) return [];\n  if ('toArray' in Object(iterable)) return iterable.toArray();\n  var length = iterable.length || 0,\n    results = new Array(length);\n  while (length--) results[length] = iterable[length];\n  return results;\n}\nfunction $w(string) {\n  if (!Object.isString(string)) return [];\n  string = string.strip();\n  return string ? string.split(/\\s+/) : [];\n}\nArray.from = $A;\n(function () {\n  var arrayProto = Array.prototype,\n    slice = (0, _slice.default)(arrayProto),\n    _each = (0, _forEach.default)(arrayProto); // use native browser JS 1.6 implementation if available\n\n  function each(iterator, context) {\n    for (var i = 0, length = this.length >>> 0; i < length; i++) {\n      if (i in this) iterator.call(context, this[i], i, this);\n    }\n  }\n  if (!_each) _each = each;\n  function clear() {\n    this.length = 0;\n    return this;\n  }\n  function first() {\n    return this[0];\n  }\n  function last() {\n    return this[this.length - 1];\n  }\n  function compact() {\n    return this.select(function (value) {\n      return value != null;\n    });\n  }\n  function flatten() {\n    return this.inject([], function (array, value) {\n      if (Object.isArray(value)) return (0, _concat.default)(array).call(array, value.flatten());\n      array.push(value);\n      return array;\n    });\n  }\n  function without() {\n    var values = slice.call(arguments, 0);\n    return this.select(function (value) {\n      return !values.include(value);\n    });\n  }\n  function reverse(inline) {\n    return (inline === false ? this.toArray() : this)._reverse();\n  }\n  function uniq(sorted) {\n    return this.inject([], function (array, value, index) {\n      if (0 == index || (sorted ? array.last() != value : !array.include(value))) array.push(value);\n      return array;\n    });\n  }\n  function intersect(array) {\n    return this.uniq().findAll(function (item) {\n      return (0, _indexOf.default)(array).call(array, item) !== -1;\n    });\n  }\n  function clone() {\n    return slice.call(this, 0);\n  }\n  function size() {\n    return this.length;\n  }\n  function inspect() {\n    var _context18;\n    return '[' + (0, _map.default)(_context18 = this).call(_context18, Object.inspect).join(', ') + ']';\n  }\n  function indexOf(item, i) {\n    if (this == null) throw new TypeError();\n    var array = Object(this),\n      length = array.length >>> 0;\n    if (length === 0) return -1;\n    i = Number(i);\n    if (isNaN(i)) {\n      i = 0;\n    } else if (i !== 0 && isFinite(i)) {\n      i = (i > 0 ? 1 : -1) * Math.floor(Math.abs(i));\n    }\n    if (i > length) return -1;\n    var k = i >= 0 ? i : Math.max(length - Math.abs(i), 0);\n    for (; k < length; k++) if (k in array && array[k] === item) return k;\n    return -1;\n  }\n  function lastIndexOf(item, i) {\n    if (this == null) throw new TypeError();\n    var array = Object(this),\n      length = array.length >>> 0;\n    if (length === 0) return -1;\n    if (!Object.isUndefined(i)) {\n      i = Number(i);\n      if (isNaN(i)) {\n        i = 0;\n      } else if (i !== 0 && isFinite(i)) {\n        i = (i > 0 ? 1 : -1) * Math.floor(Math.abs(i));\n      }\n    } else {\n      i = length;\n    }\n    var k = i >= 0 ? Math.min(i, length - 1) : length - Math.abs(i);\n    for (; k >= 0; k--) if (k in array && array[k] === item) return k;\n    return -1;\n  }\n  function concat(_) {\n    var array = [],\n      items = slice.call(arguments, 0),\n      item,\n      n = 0;\n    items.unshift(this);\n    for (var i = 0, length = items.length; i < length; i++) {\n      item = items[i];\n      if (Object.isArray(item) && !('callee' in item)) {\n        for (var j = 0, arrayLength = item.length; j < arrayLength; j++) {\n          if (j in item) array[n] = item[j];\n          n++;\n        }\n      } else {\n        array[n++] = item;\n      }\n    }\n    array.length = n;\n    return array;\n  }\n  function wrapNative(method) {\n    return function () {\n      if (arguments.length === 0) {\n        return method.call(this, Prototype.K);\n      } else if (arguments[0] === undefined) {\n        var args = slice.call(arguments, 1);\n        args.unshift(Prototype.K);\n        return method.apply(this, args);\n      } else {\n        return method.apply(this, arguments);\n      }\n    };\n  }\n  function map(iterator) {\n    if (this == null) throw new TypeError();\n    iterator = iterator || Prototype.K;\n    var object = Object(this);\n    var results = [],\n      context = arguments[1],\n      n = 0;\n    for (var i = 0, length = object.length >>> 0; i < length; i++) {\n      if (i in object) {\n        results[n] = iterator.call(context, object[i], i, object);\n      }\n      n++;\n    }\n    results.length = n;\n    return results;\n  }\n  if ((0, _map.default)(arrayProto)) {\n    map = wrapNative((0, _map.default)(Array.prototype));\n  }\n  function filter(iterator) {\n    if (this == null || !Object.isFunction(iterator)) throw new TypeError();\n    var object = Object(this);\n    var results = [],\n      context = arguments[1],\n      value;\n    for (var i = 0, length = object.length >>> 0; i < length; i++) {\n      if (i in object) {\n        value = object[i];\n        if (iterator.call(context, value, i, object)) {\n          results.push(value);\n        }\n      }\n    }\n    return results;\n  }\n  if ((0, _filter.default)(arrayProto)) {\n    filter = (0, _filter.default)(Array.prototype);\n  }\n  function some(iterator) {\n    if (this == null) throw new TypeError();\n    iterator = iterator || Prototype.K;\n    var context = arguments[1];\n    var object = Object(this);\n    for (var i = 0, length = object.length >>> 0; i < length; i++) {\n      if (i in object && iterator.call(context, object[i], i, object)) {\n        return true;\n      }\n    }\n    return false;\n  }\n  if ((0, _some.default)(arrayProto)) {\n    some = wrapNative((0, _some.default)(Array.prototype));\n  }\n  function every(iterator) {\n    if (this == null) throw new TypeError();\n    iterator = iterator || Prototype.K;\n    var context = arguments[1];\n    var object = Object(this);\n    for (var i = 0, length = object.length >>> 0; i < length; i++) {\n      if (i in object && !iterator.call(context, object[i], i, object)) {\n        return false;\n      }\n    }\n    return true;\n  }\n  if ((0, _every.default)(arrayProto)) {\n    every = wrapNative((0, _every.default)(Array.prototype));\n  }\n  Object.extend(arrayProto, Enumerable);\n  if ((0, _entries.default)(arrayProto) === (0, _entries.default)(Enumerable)) {\n    delete arrayProto.entries;\n  }\n  if (!arrayProto._reverse) arrayProto._reverse = (0, _reverse.default)(arrayProto);\n  Object.extend(arrayProto, {\n    _each: _each,\n    map: map,\n    collect: map,\n    select: filter,\n    filter: filter,\n    findAll: filter,\n    some: some,\n    any: some,\n    every: every,\n    all: every,\n    clear: clear,\n    first: first,\n    last: last,\n    compact: compact,\n    flatten: flatten,\n    without: without,\n    reverse: reverse,\n    uniq: uniq,\n    intersect: intersect,\n    clone: clone,\n    toArray: clone,\n    size: size,\n    inspect: inspect\n  });\n  var CONCAT_ARGUMENTS_BUGGY = function () {\n    var _context19;\n    return (0, _concat.default)(_context19 = []).call(_context19, arguments)[0][0] !== 1;\n  }(1, 2);\n  if (CONCAT_ARGUMENTS_BUGGY) arrayProto.concat = concat;\n  if (!(0, _indexOf.default)(arrayProto)) arrayProto.indexOf = indexOf;\n  if (!(0, _lastIndexOf.default)(arrayProto)) arrayProto.lastIndexOf = lastIndexOf;\n})();\nfunction $H(object) {\n  return new Hash(object);\n}\n;\nvar Hash = Class.create(Enumerable, function () {\n  function initialize(object) {\n    this._object = Object.isHash(object) ? object.toObject() : Object.clone(object);\n  }\n  function _each(iterator, context) {\n    var i = 0;\n    for (var key in this._object) {\n      var value = this._object[key],\n        pair = [key, value];\n      pair.key = key;\n      pair.value = value;\n      iterator.call(context, pair, i);\n      i++;\n    }\n  }\n  function set(key, value) {\n    return this._object[key] = value;\n  }\n  function get(key) {\n    if (this._object[key] !== Object.prototype[key]) return this._object[key];\n  }\n  function unset(key) {\n    var value = this._object[key];\n    delete this._object[key];\n    return value;\n  }\n  function toObject() {\n    return Object.clone(this._object);\n  }\n  function keys() {\n    return this.pluck('key');\n  }\n  function values() {\n    return this.pluck('value');\n  }\n  function index(value) {\n    var match = this.detect(function (pair) {\n      return pair.value === value;\n    });\n    return match && match.key;\n  }\n  function merge(object) {\n    return this.clone().update(object);\n  }\n  function update(object) {\n    return new Hash(object).inject(this, function (result, pair) {\n      result.set(pair.key, pair.value);\n      return result;\n    });\n  }\n  function toQueryPair(key, value) {\n    if (Object.isUndefined(value)) return key;\n    value = String.interpret(value);\n    value = value.gsub(/(\\r)?\\n/, '\\r\\n');\n    value = encodeURIComponent(value);\n    value = value.gsub(/%20/, '+');\n    return key + '=' + value;\n  }\n  function toQueryString() {\n    return this.inject([], function (results, pair) {\n      var key = encodeURIComponent(pair.key),\n        values = pair.value;\n      if (values && _typeof(values) == 'object') {\n        if (Object.isArray(values)) {\n          var queryValues = [];\n          for (var i = 0, len = values.length, value; i < len; i++) {\n            value = values[i];\n            queryValues.push(toQueryPair(key, value));\n          }\n          return (0, _concat.default)(results).call(results, queryValues);\n        }\n      } else results.push(toQueryPair(key, values));\n      return results;\n    }).join('&');\n  }\n  function inspect() {\n    var _context20;\n    return '#<Hash:{' + (0, _map.default)(_context20 = this).call(_context20, function (pair) {\n      return (0, _map.default)(pair).call(pair, Object.inspect).join(': ');\n    }).join(', ') + '}>';\n  }\n  function clone() {\n    return new Hash(this);\n  }\n  return {\n    initialize: initialize,\n    _each: _each,\n    set: set,\n    get: get,\n    unset: unset,\n    toObject: toObject,\n    toTemplateReplacements: toObject,\n    keys: keys,\n    values: values,\n    index: index,\n    merge: merge,\n    update: update,\n    toQueryString: toQueryString,\n    inspect: inspect,\n    toJSON: toObject,\n    clone: clone\n  };\n}());\nHash.from = $H;\nObject.extend(Number.prototype, function () {\n  function toColorPart() {\n    return this.toPaddedString(2, 16);\n  }\n  function succ() {\n    return this + 1;\n  }\n  function times(iterator, context) {\n    $R(0, this, true).each(iterator, context);\n    return this;\n  }\n  function toPaddedString(length, radix) {\n    var string = this.toString(radix || 10);\n    return '0'.times(length - string.length) + string;\n  }\n  function abs() {\n    return Math.abs(this);\n  }\n  function round() {\n    return Math.round(this);\n  }\n  function ceil() {\n    return Math.ceil(this);\n  }\n  function floor() {\n    return Math.floor(this);\n  }\n  return {\n    toColorPart: toColorPart,\n    succ: succ,\n    times: times,\n    toPaddedString: toPaddedString,\n    abs: abs,\n    round: round,\n    ceil: ceil,\n    floor: floor\n  };\n}());\nfunction $R(start, end, exclusive) {\n  return new ObjectRange(start, end, exclusive);\n}\nvar ObjectRange = Class.create(Enumerable, function () {\n  function initialize(start, end, exclusive) {\n    this.start = start;\n    this.end = end;\n    this.exclusive = exclusive;\n  }\n  function _each(iterator, context) {\n    var value = this.start,\n      i;\n    for (i = 0; this.include(value); i++) {\n      iterator.call(context, value, i);\n      value = value.succ();\n    }\n  }\n  function include(value) {\n    if (value < this.start) return false;\n    if (this.exclusive) return value < this.end;\n    return value <= this.end;\n  }\n  return {\n    initialize: initialize,\n    _each: _each,\n    include: include\n  };\n}());\nvar Abstract = {};\nvar Try = {\n  these: function these() {\n    var returnValue;\n    for (var i = 0, length = arguments.length; i < length; i++) {\n      var lambda = arguments[i];\n      try {\n        returnValue = lambda();\n        break;\n      } catch (e) {}\n    }\n    return returnValue;\n  }\n};\nvar Ajax = {\n  getTransport: function getTransport() {\n    return Try.these(function () {\n      return new XMLHttpRequest();\n    }, function () {\n      return new ActiveXObject('Msxml2.XMLHTTP');\n    }, function () {\n      return new ActiveXObject('Microsoft.XMLHTTP');\n    }) || false;\n  },\n  activeRequestCount: 0\n};\nAjax.Responders = {\n  responders: [],\n  _each: function _each(iterator, context) {\n    this.responders._each(iterator, context);\n  },\n  register: function register(responder) {\n    if (!this.include(responder)) this.responders.push(responder);\n  },\n  unregister: function unregister(responder) {\n    this.responders = this.responders.without(responder);\n  },\n  dispatch: function dispatch(callback, request, transport, json) {\n    this.each(function (responder) {\n      if (Object.isFunction(responder[callback])) {\n        try {\n          responder[callback].apply(responder, [request, transport, json]);\n        } catch (e) {}\n      }\n    });\n  }\n};\nObject.extend(Ajax.Responders, Enumerable);\nAjax.Responders.register({\n  onCreate: function onCreate() {\n    Ajax.activeRequestCount++;\n  },\n  onComplete: function onComplete() {\n    Ajax.activeRequestCount--;\n  }\n});\nAjax.Base = Class.create({\n  initialize: function initialize(options) {\n    this.options = {\n      method: 'post',\n      asynchronous: true,\n      contentType: 'application/x-www-form-urlencoded',\n      encoding: 'UTF-8',\n      parameters: '',\n      evalJSON: true,\n      evalJS: true\n    };\n    Object.extend(this.options, options || {});\n    this.options.method = this.options.method.toLowerCase();\n    if (Object.isHash(this.options.parameters)) this.options.parameters = this.options.parameters.toObject();\n  }\n});\nAjax.Request = Class.create(Ajax.Base, {\n  _complete: false,\n  initialize: function initialize($super, url, options) {\n    $super(options);\n    this.transport = Ajax.getTransport();\n    this.request(url);\n  },\n  request: function request(url) {\n    this.url = url;\n    this.method = this.options.method;\n    var params = Object.isString(this.options.parameters) ? this.options.parameters : Object.toQueryString(this.options.parameters);\n    if (!['get', 'post'].include(this.method)) {\n      params += (params ? '&' : '') + \"_method=\" + this.method;\n      this.method = 'post';\n    }\n    if (params && this.method === 'get') {\n      this.url += (this.url.include('?') ? '&' : '?') + params;\n    }\n    this.parameters = params.toQueryParams();\n    try {\n      var _context21, _context22;\n      var response = new Ajax.Response(this);\n      if (this.options.onCreate) this.options.onCreate(response);\n      Ajax.Responders.dispatch('onCreate', this, response);\n      this.transport.open(this.method.toUpperCase(), this.url, this.options.asynchronous);\n      if (this.options.asynchronous) (0, _bind.default)(_context21 = this.respondToReadyState).call(_context21, this).defer(1);\n      this.transport.onreadystatechange = (0, _bind.default)(_context22 = this.onStateChange).call(_context22, this);\n      this.setRequestHeaders();\n      this.body = this.method == 'post' ? this.options.postBody || params : null;\n      this.transport.send(this.body);\n\n      /* Force Firefox to handle ready state 4 for synchronous requests */\n      if (!this.options.asynchronous && this.transport.overrideMimeType) this.onStateChange();\n    } catch (e) {\n      this.dispatchException(e);\n    }\n  },\n  onStateChange: function onStateChange() {\n    var readyState = this.transport.readyState;\n    if (readyState > 1 && !(readyState == 4 && this._complete)) this.respondToReadyState(this.transport.readyState);\n  },\n  setRequestHeaders: function setRequestHeaders() {\n    var headers = {\n      'X-Requested-With': 'XMLHttpRequest',\n      'X-Prototype-Version': Prototype.Version,\n      'Accept': 'text/javascript, text/html, application/xml, text/xml, */*'\n    };\n    if (this.method == 'post') {\n      headers['Content-type'] = this.options.contentType + (this.options.encoding ? '; charset=' + this.options.encoding : '');\n\n      /* Force \"Connection: close\" for older Mozilla browsers to work\n       * around a bug where XMLHttpRequest sends an incorrect\n       * Content-length header. See Mozilla Bugzilla #246651.\n       */\n      if (this.transport.overrideMimeType && (navigator.userAgent.match(/Gecko\\/(\\d{4})/) || [0, 2005])[1] < 2005) headers['Connection'] = 'close';\n    }\n    if (_typeof(this.options.requestHeaders) == 'object') {\n      var extras = this.options.requestHeaders;\n      if (Object.isFunction(extras.push)) for (var i = 0, length = extras.length; i < length; i += 2) headers[extras[i]] = extras[i + 1];else $H(extras).each(function (pair) {\n        headers[pair.key] = pair.value;\n      });\n    }\n    for (var name in headers) if (headers[name] != null) this.transport.setRequestHeader(name, headers[name]);\n  },\n  success: function success() {\n    var status = this.getStatus();\n    return !status || status >= 200 && status < 300 || status == 304;\n  },\n  getStatus: function getStatus() {\n    try {\n      if (this.transport.status === 1223) return 204;\n      return this.transport.status || 0;\n    } catch (e) {\n      return 0;\n    }\n  },\n  respondToReadyState: function respondToReadyState(readyState) {\n    var state = Ajax.Request.Events[readyState],\n      response = new Ajax.Response(this);\n    if (state == 'Complete') {\n      try {\n        this._complete = true;\n        (this.options['on' + response.status] || this.options['on' + (this.success() ? 'Success' : 'Failure')] || Prototype.emptyFunction)(response, response.headerJSON);\n      } catch (e) {\n        this.dispatchException(e);\n      }\n      var contentType = response.getHeader('Content-type');\n      if (this.options.evalJS == 'force' || this.options.evalJS && this.isSameOrigin() && contentType && contentType.match(/^\\s*(text|application)\\/(x-)?(java|ecma)script(;.*)?\\s*$/i)) this.evalResponse();\n    }\n    try {\n      (this.options['on' + state] || Prototype.emptyFunction)(response, response.headerJSON);\n      Ajax.Responders.dispatch('on' + state, this, response, response.headerJSON);\n    } catch (e) {\n      this.dispatchException(e);\n    }\n    if (state == 'Complete') {\n      this.transport.onreadystatechange = Prototype.emptyFunction;\n    }\n  },\n  isSameOrigin: function isSameOrigin() {\n    var m = this.url.match(/^\\s*https?:\\/\\/[^\\/]*/);\n    return !m || m[0] == '#{protocol}//#{domain}#{port}'.interpolate({\n      protocol: location.protocol,\n      domain: document.domain,\n      port: location.port ? ':' + location.port : ''\n    });\n  },\n  getHeader: function getHeader(name) {\n    try {\n      return this.transport.getResponseHeader(name) || null;\n    } catch (e) {\n      return null;\n    }\n  },\n  evalResponse: function evalResponse() {\n    try {\n      return eval((this.transport.responseText || '').unfilterJSON());\n    } catch (e) {\n      this.dispatchException(e);\n    }\n  },\n  dispatchException: function dispatchException(exception) {\n    (this.options.onException || Prototype.emptyFunction)(this, exception);\n    Ajax.Responders.dispatch('onException', this, exception);\n  }\n});\nAjax.Request.Events = ['Uninitialized', 'Loading', 'Loaded', 'Interactive', 'Complete'];\nAjax.Response = Class.create({\n  initialize: function initialize(request) {\n    this.request = request;\n    var transport = this.transport = request.transport,\n      readyState = this.readyState = transport.readyState;\n    if (readyState > 2 && !Prototype.Browser.IE || readyState == 4) {\n      this.status = this.getStatus();\n      this.statusText = this.getStatusText();\n      this.responseText = String.interpret(transport.responseText);\n      this.headerJSON = this._getHeaderJSON();\n    }\n    if (readyState == 4) {\n      var xml = transport.responseXML;\n      this.responseXML = Object.isUndefined(xml) ? null : xml;\n      this.responseJSON = this._getResponseJSON();\n    }\n  },\n  status: 0,\n  statusText: '',\n  getStatus: Ajax.Request.prototype.getStatus,\n  getStatusText: function getStatusText() {\n    try {\n      return this.transport.statusText || '';\n    } catch (e) {\n      return '';\n    }\n  },\n  getHeader: Ajax.Request.prototype.getHeader,\n  getAllHeaders: function getAllHeaders() {\n    try {\n      return this.getAllResponseHeaders();\n    } catch (e) {\n      return null;\n    }\n  },\n  getResponseHeader: function getResponseHeader(name) {\n    return this.transport.getResponseHeader(name);\n  },\n  getAllResponseHeaders: function getAllResponseHeaders() {\n    return this.transport.getAllResponseHeaders();\n  },\n  _getHeaderJSON: function _getHeaderJSON() {\n    var json = this.getHeader('X-JSON');\n    if (!json) return null;\n    try {\n      json = decodeURIComponent(escape(json));\n    } catch (e) {}\n    try {\n      return json.evalJSON(this.request.options.sanitizeJSON || !this.request.isSameOrigin());\n    } catch (e) {\n      this.request.dispatchException(e);\n    }\n  },\n  _getResponseJSON: function _getResponseJSON() {\n    var options = this.request.options;\n    if (!options.evalJSON || options.evalJSON != 'force' && !(this.getHeader('Content-type') || '').include('application/json') || this.responseText.blank()) return null;\n    try {\n      return this.responseText.evalJSON(options.sanitizeJSON || !this.request.isSameOrigin());\n    } catch (e) {\n      this.request.dispatchException(e);\n    }\n  }\n});\nAjax.Updater = Class.create(Ajax.Request, {\n  initialize: function initialize($super, container, url, options) {\n    var _context23;\n    this.container = {\n      success: container.success || container,\n      failure: container.failure || (container.success ? null : container)\n    };\n    options = Object.clone(options);\n    var onComplete = options.onComplete;\n    options.onComplete = (0, _bind.default)(_context23 = function _context23(response, json) {\n      this.updateContent(response.responseText);\n      if (Object.isFunction(onComplete)) onComplete(response, json);\n    }).call(_context23, this);\n    $super(url, options);\n  },\n  updateContent: function updateContent(responseText) {\n    var receiver = this.container[this.success() ? 'success' : 'failure'],\n      options = this.options;\n    if (!options.evalScripts) responseText = responseText.stripScripts();\n    if (receiver = $(receiver)) {\n      if (options.insertion) {\n        if (Object.isString(options.insertion)) {\n          var insertion = {};\n          insertion[options.insertion] = responseText;\n          receiver.insert(insertion);\n        } else options.insertion(receiver, responseText);\n      } else receiver.update(responseText);\n    }\n  }\n});\nAjax.PeriodicalUpdater = Class.create(Ajax.Base, {\n  initialize: function initialize($super, container, url, options) {\n    $super(options);\n    this.onComplete = this.options.onComplete;\n    this.frequency = this.options.frequency || 2;\n    this.decay = this.options.decay || 1;\n    this.updater = {};\n    this.container = container;\n    this.url = url;\n    this.start();\n  },\n  start: function start() {\n    var _context24;\n    this.options.onComplete = (0, _bind.default)(_context24 = this.updateComplete).call(_context24, this);\n    this.onTimerEvent();\n  },\n  stop: function stop() {\n    this.updater.options.onComplete = undefined;\n    clearTimeout(this.timer);\n    (this.onComplete || Prototype.emptyFunction).apply(this, arguments);\n  },\n  updateComplete: function updateComplete(response) {\n    var _context25;\n    if (this.options.decay) {\n      this.decay = response.responseText == this.lastText ? this.decay * this.options.decay : 1;\n      this.lastText = response.responseText;\n    }\n    this.timer = (0, _bind.default)(_context25 = this.onTimerEvent).call(_context25, this).delay(this.decay * this.frequency);\n  },\n  onTimerEvent: function onTimerEvent() {\n    this.updater = new Ajax.Updater(this.container, this.url, this.options);\n  }\n});\n(function (GLOBAL, _context31) {\n  var UNDEFINED;\n  var SLICE = (0, _slice.default)(Array.prototype);\n  var DIV = document.createElement('div');\n  function $(element) {\n    if (arguments.length > 1) {\n      for (var i = 0, elements = [], length = arguments.length; i < length; i++) elements.push($(arguments[i]));\n      return elements;\n    }\n    if (Object.isString(element)) element = document.getElementById(element);\n    return Element.extend(element);\n  }\n  GLOBAL.$ = $;\n  if (!GLOBAL.Node) GLOBAL.Node = {};\n  if (!GLOBAL.Node.ELEMENT_NODE) {\n    Object.extend(GLOBAL.Node, {\n      ELEMENT_NODE: 1,\n      ATTRIBUTE_NODE: 2,\n      TEXT_NODE: 3,\n      CDATA_SECTION_NODE: 4,\n      ENTITY_REFERENCE_NODE: 5,\n      ENTITY_NODE: 6,\n      PROCESSING_INSTRUCTION_NODE: 7,\n      COMMENT_NODE: 8,\n      DOCUMENT_NODE: 9,\n      DOCUMENT_TYPE_NODE: 10,\n      DOCUMENT_FRAGMENT_NODE: 11,\n      NOTATION_NODE: 12\n    });\n  }\n  var ELEMENT_CACHE = {};\n  function shouldUseCreationCache(tagName, attributes) {\n    if (tagName === 'select') return false;\n    if ('type' in attributes) return false;\n    return true;\n  }\n  var HAS_EXTENDED_CREATE_ELEMENT_SYNTAX = function () {\n    try {\n      var el = document.createElement('<input name=\"x\">');\n      return el.tagName.toLowerCase() === 'input' && el.name === 'x';\n    } catch (err) {\n      return false;\n    }\n  }();\n  var oldElement = GLOBAL.Element;\n  function Element(tagName, attributes) {\n    attributes = attributes || {};\n    tagName = tagName.toLowerCase();\n    if (HAS_EXTENDED_CREATE_ELEMENT_SYNTAX && attributes.name) {\n      tagName = '<' + tagName + ' name=\"' + attributes.name + '\">';\n      delete attributes.name;\n      return Element.writeAttribute(document.createElement(tagName), attributes);\n    }\n    if (!ELEMENT_CACHE[tagName]) ELEMENT_CACHE[tagName] = Element.extend(document.createElement(tagName));\n    var node = shouldUseCreationCache(tagName, attributes) ? ELEMENT_CACHE[tagName].cloneNode(false) : document.createElement(tagName);\n    return Element.writeAttribute(node, attributes);\n  }\n  GLOBAL.Element = Element;\n  Object.extend(GLOBAL.Element, oldElement || {});\n  if (oldElement) GLOBAL.Element.prototype = oldElement.prototype;\n  Element.Methods = {\n    ByTag: {},\n    Simulated: {}\n  };\n  var methods = {};\n  var INSPECT_ATTRIBUTES = {\n    id: 'id',\n    className: 'class'\n  };\n  function inspect(element) {\n    element = $(element);\n    var result = '<' + element.tagName.toLowerCase();\n    var attribute, value;\n    for (var property in INSPECT_ATTRIBUTES) {\n      attribute = INSPECT_ATTRIBUTES[property];\n      value = (element[property] || '').toString();\n      if (value) result += ' ' + attribute + '=' + value.inspect(true);\n    }\n    return result + '>';\n  }\n  methods.inspect = inspect;\n  function visible(element) {\n    return $(element).getStyle('display') !== 'none';\n  }\n  function toggle(element, bool) {\n    element = $(element);\n    if (typeof bool !== 'boolean') bool = !Element.visible(element);\n    Element[bool ? 'show' : 'hide'](element);\n    return element;\n  }\n  function hide(element) {\n    element = $(element);\n    element.style.display = 'none';\n    return element;\n  }\n  function show(element) {\n    element = $(element);\n    element.style.display = '';\n    return element;\n  }\n  Object.extend(methods, {\n    visible: visible,\n    toggle: toggle,\n    hide: hide,\n    show: show\n  });\n  function remove(element) {\n    element = $(element);\n    element.parentNode.removeChild(element);\n    return element;\n  }\n  var SELECT_ELEMENT_INNERHTML_BUGGY = function () {\n    var el = document.createElement(\"select\"),\n      isBuggy = true;\n    el.innerHTML = \"<option value=\\\"test\\\">test</option>\";\n    if (el.options && el.options[0]) {\n      isBuggy = el.options[0].nodeName.toUpperCase() !== \"OPTION\";\n    }\n    el = null;\n    return isBuggy;\n  }();\n  var TABLE_ELEMENT_INNERHTML_BUGGY = function () {\n    try {\n      var el = document.createElement(\"table\");\n      if (el && el.tBodies) {\n        el.innerHTML = \"<tbody><tr><td>test</td></tr></tbody>\";\n        var isBuggy = typeof el.tBodies[0] == \"undefined\";\n        el = null;\n        return isBuggy;\n      }\n    } catch (e) {\n      return true;\n    }\n  }();\n  var LINK_ELEMENT_INNERHTML_BUGGY = function () {\n    try {\n      var el = document.createElement('div');\n      el.innerHTML = \"<link />\";\n      var isBuggy = el.childNodes.length === 0;\n      el = null;\n      return isBuggy;\n    } catch (e) {\n      return true;\n    }\n  }();\n  var ANY_INNERHTML_BUGGY = SELECT_ELEMENT_INNERHTML_BUGGY || TABLE_ELEMENT_INNERHTML_BUGGY || LINK_ELEMENT_INNERHTML_BUGGY;\n  var SCRIPT_ELEMENT_REJECTS_TEXTNODE_APPENDING = function () {\n    var s = document.createElement(\"script\"),\n      isBuggy = false;\n    try {\n      s.appendChild(document.createTextNode(\"\"));\n      isBuggy = !s.firstChild || s.firstChild && s.firstChild.nodeType !== 3;\n    } catch (e) {\n      isBuggy = true;\n    }\n    s = null;\n    return isBuggy;\n  }();\n  function update(element, content) {\n    var _context26;\n    element = $(element);\n    var descendants = element.getElementsByTagName('*'),\n      i = descendants.length;\n    while (i--) purgeElement(descendants[i]);\n    if (content && content.toElement) content = content.toElement();\n    if (Object.isElement(content)) return element.update().insert(content);\n    content = Object.toHTML(content);\n    var tagName = element.tagName.toUpperCase();\n    if (tagName === 'SCRIPT' && SCRIPT_ELEMENT_REJECTS_TEXTNODE_APPENDING) {\n      element.text = content;\n      return element;\n    }\n    if (ANY_INNERHTML_BUGGY) {\n      if (tagName in INSERTION_TRANSLATIONS.tags) {\n        while (element.firstChild) element.removeChild(element.firstChild);\n        var nodes = getContentFromAnonymousElement(tagName, content.stripScripts());\n        for (var i = 0, node; node = nodes[i]; i++) element.appendChild(node);\n      } else if (LINK_ELEMENT_INNERHTML_BUGGY && Object.isString(content) && (0, _indexOf.default)(content).call(content, '<link') > -1) {\n        while (element.firstChild) element.removeChild(element.firstChild);\n        var nodes = getContentFromAnonymousElement(tagName, content.stripScripts(), true);\n        for (var i = 0, node; node = nodes[i]; i++) element.appendChild(node);\n      } else {\n        element.innerHTML = content.stripScripts();\n      }\n    } else {\n      element.innerHTML = content.stripScripts();\n    }\n    (0, _bind.default)(_context26 = content.evalScripts).call(_context26, content).defer();\n    return element;\n  }\n  function replace(element, content) {\n    element = $(element);\n    if (content && content.toElement) {\n      content = content.toElement();\n    } else if (!Object.isElement(content)) {\n      var _context27;\n      content = Object.toHTML(content);\n      var range = element.ownerDocument.createRange();\n      range.selectNode(element);\n      (0, _bind.default)(_context27 = content.evalScripts).call(_context27, content).defer();\n      content = range.createContextualFragment(content.stripScripts());\n    }\n    element.parentNode.replaceChild(content, element);\n    return element;\n  }\n  var INSERTION_TRANSLATIONS = {\n    before: function before(element, node) {\n      element.parentNode.insertBefore(node, element);\n    },\n    top: function top(element, node) {\n      element.insertBefore(node, element.firstChild);\n    },\n    bottom: function bottom(element, node) {\n      element.appendChild(node);\n    },\n    after: function after(element, node) {\n      element.parentNode.insertBefore(node, element.nextSibling);\n    },\n    tags: {\n      TABLE: ['<table>', '</table>', 1],\n      TBODY: ['<table><tbody>', '</tbody></table>', 2],\n      TR: ['<table><tbody><tr>', '</tr></tbody></table>', 3],\n      TD: ['<table><tbody><tr><td>', '</td></tr></tbody></table>', 4],\n      SELECT: ['<select>', '</select>', 1]\n    }\n  };\n  var tags = INSERTION_TRANSLATIONS.tags;\n  Object.extend(tags, {\n    THEAD: tags.TBODY,\n    TFOOT: tags.TBODY,\n    TH: tags.TD\n  });\n  function replace_IE(element, content) {\n    var _context28;\n    element = $(element);\n    if (content && content.toElement) content = content.toElement();\n    if (Object.isElement(content)) {\n      element.parentNode.replaceChild(content, element);\n      return element;\n    }\n    content = Object.toHTML(content);\n    var parent = element.parentNode,\n      tagName = parent.tagName.toUpperCase();\n    if (tagName in INSERTION_TRANSLATIONS.tags) {\n      var nextSibling = Element.next(element);\n      var fragments = getContentFromAnonymousElement(tagName, content.stripScripts());\n      parent.removeChild(element);\n      var iterator;\n      if (nextSibling) iterator = function iterator(node) {\n        parent.insertBefore(node, nextSibling);\n      };else iterator = function iterator(node) {\n        parent.appendChild(node);\n      };\n      fragments.each(iterator);\n    } else {\n      element.outerHTML = content.stripScripts();\n    }\n    (0, _bind.default)(_context28 = content.evalScripts).call(_context28, content).defer();\n    return element;\n  }\n  if ('outerHTML' in document.documentElement) replace = replace_IE;\n  function isContent(content) {\n    if (Object.isUndefined(content) || content === null) return false;\n    if (Object.isString(content) || Object.isNumber(content)) return true;\n    if (Object.isElement(content)) return true;\n    if (content.toElement || content.toHTML) return true;\n    return false;\n  }\n  function insertContentAt(element, content, position) {\n    var _context29;\n    position = position.toLowerCase();\n    var method = INSERTION_TRANSLATIONS[position];\n    if (content && content.toElement) content = content.toElement();\n    if (Object.isElement(content)) {\n      method(element, content);\n      return element;\n    }\n    content = Object.toHTML(content);\n    var tagName = (position === 'before' || position === 'after' ? element.parentNode : element).tagName.toUpperCase();\n    var childNodes = getContentFromAnonymousElement(tagName, content.stripScripts());\n    if (position === 'top' || position === 'after') (0, _reverse.default)(childNodes).call(childNodes);\n    for (var i = 0, node; node = childNodes[i]; i++) method(element, node);\n    (0, _bind.default)(_context29 = content.evalScripts).call(_context29, content).defer();\n  }\n  function insert(element, insertions) {\n    element = $(element);\n    if (isContent(insertions)) insertions = {\n      bottom: insertions\n    };\n    for (var position in insertions) insertContentAt(element, insertions[position], position);\n    return element;\n  }\n  function wrap(element, wrapper, attributes) {\n    element = $(element);\n    if (Object.isElement(wrapper)) {\n      $(wrapper).writeAttribute(attributes || {});\n    } else if (Object.isString(wrapper)) {\n      wrapper = new Element(wrapper, attributes);\n    } else {\n      wrapper = new Element('div', wrapper);\n    }\n    if (element.parentNode) element.parentNode.replaceChild(wrapper, element);\n    wrapper.appendChild(element);\n    return wrapper;\n  }\n  function cleanWhitespace(element) {\n    element = $(element);\n    var node = element.firstChild;\n    while (node) {\n      var nextNode = node.nextSibling;\n      if (node.nodeType === Node.TEXT_NODE && !/\\S/.test(node.nodeValue)) element.removeChild(node);\n      node = nextNode;\n    }\n    return element;\n  }\n  function empty(element) {\n    return $(element).innerHTML.blank();\n  }\n  function getContentFromAnonymousElement(tagName, html, force) {\n    var t = INSERTION_TRANSLATIONS.tags[tagName],\n      div = DIV;\n    var workaround = !!t;\n    if (!workaround && force) {\n      workaround = true;\n      t = ['', '', 0];\n    }\n    if (workaround) {\n      div.innerHTML = '&#160;' + t[0] + html + t[1];\n      div.removeChild(div.firstChild);\n      for (var i = t[2]; i--;) div = div.firstChild;\n    } else {\n      div.innerHTML = html;\n    }\n    return $A(div.childNodes);\n  }\n  function clone(element, deep) {\n    if (!(element = $(element))) return;\n    var clone = element.cloneNode(deep);\n    if (!HAS_UNIQUE_ID_PROPERTY) {\n      clone._prototypeUID = UNDEFINED;\n      if (deep) {\n        var descendants = Element.select(clone, '*'),\n          i = descendants.length;\n        while (i--) descendants[i]._prototypeUID = UNDEFINED;\n      }\n    }\n    return Element.extend(clone);\n  }\n  function purgeElement(element) {\n    var uid = getUniqueElementID(element);\n    if (uid) {\n      Element.stopObserving(element);\n      if (!HAS_UNIQUE_ID_PROPERTY) element._prototypeUID = UNDEFINED;\n      delete Element.Storage[uid];\n    }\n  }\n  function purgeCollection(elements) {\n    var i = elements.length;\n    while (i--) purgeElement(elements[i]);\n  }\n  function purgeCollection_IE(elements) {\n    var i = elements.length,\n      element,\n      uid;\n    while (i--) {\n      element = elements[i];\n      uid = getUniqueElementID(element);\n      delete Element.Storage[uid];\n      delete Event.cache[uid];\n    }\n  }\n  if (HAS_UNIQUE_ID_PROPERTY) {\n    purgeCollection = purgeCollection_IE;\n  }\n  function purge(element) {\n    if (!(element = $(element))) return;\n    purgeElement(element);\n    var descendants = element.getElementsByTagName('*'),\n      i = descendants.length;\n    while (i--) purgeElement(descendants[i]);\n    return null;\n  }\n  Object.extend(methods, {\n    remove: remove,\n    update: update,\n    replace: replace,\n    insert: insert,\n    wrap: wrap,\n    cleanWhitespace: cleanWhitespace,\n    empty: empty,\n    clone: clone,\n    purge: purge\n  });\n  function recursivelyCollect(element, property, maximumLength) {\n    element = $(element);\n    maximumLength = maximumLength || -1;\n    var elements = [];\n    while (element = element[property]) {\n      if (element.nodeType === Node.ELEMENT_NODE) elements.push(Element.extend(element));\n      if (elements.length === maximumLength) break;\n    }\n    return elements;\n  }\n  function ancestors(element) {\n    return recursivelyCollect(element, 'parentNode');\n  }\n  function descendants(element) {\n    return Element.select(element, '*');\n  }\n  function firstDescendant(element) {\n    element = $(element).firstChild;\n    while (element && element.nodeType !== Node.ELEMENT_NODE) element = element.nextSibling;\n    return $(element);\n  }\n  function immediateDescendants(element) {\n    var results = [],\n      child = $(element).firstChild;\n    while (child) {\n      if (child.nodeType === Node.ELEMENT_NODE) results.push(Element.extend(child));\n      child = child.nextSibling;\n    }\n    return results;\n  }\n  function previousSiblings(element) {\n    return recursivelyCollect(element, 'previousSibling');\n  }\n  function nextSiblings(element) {\n    return recursivelyCollect(element, 'nextSibling');\n  }\n  function siblings(element) {\n    var _context30;\n    element = $(element);\n    var previous = previousSiblings(element),\n      next = nextSiblings(element);\n    return (0, _concat.default)(_context30 = (0, _reverse.default)(previous).call(previous)).call(_context30, next);\n  }\n  function match(element, selector) {\n    element = $(element);\n    if (Object.isString(selector)) return Prototype.Selector.match(element, selector);\n    return selector.match(element);\n  }\n  function _recursivelyFind(element, property, expression, index) {\n    element = $(element), expression = expression || 0, index = index || 0;\n    if (Object.isNumber(expression)) {\n      index = expression, expression = null;\n    }\n    while (element = element[property]) {\n      if (element.nodeType !== 1) continue;\n      if (expression && !Prototype.Selector.match(element, expression)) continue;\n      if (--index >= 0) continue;\n      return Element.extend(element);\n    }\n  }\n  function up(element, expression, index) {\n    element = $(element);\n    if (arguments.length === 1) return $(element.parentNode);\n    return _recursivelyFind(element, 'parentNode', expression, index);\n  }\n  function down(element, expression, index) {\n    if (arguments.length === 1) return firstDescendant(element);\n    element = $(element), expression = expression || 0, index = index || 0;\n    if (Object.isNumber(expression)) index = expression, expression = '*';\n    var node = Prototype.Selector.select(expression, element)[index];\n    return Element.extend(node);\n  }\n  function previous(element, expression, index) {\n    return _recursivelyFind(element, 'previousSibling', expression, index);\n  }\n  function next(element, expression, index) {\n    return _recursivelyFind(element, 'nextSibling', expression, index);\n  }\n  function select(element) {\n    element = $(element);\n    var expressions = SLICE.call(arguments, 1).join(', ');\n    return Prototype.Selector.select(expressions, element);\n  }\n  function adjacent(element) {\n    element = $(element);\n    var expressions = SLICE.call(arguments, 1).join(', ');\n    var siblings = Element.siblings(element),\n      results = [];\n    for (var i = 0, sibling; sibling = siblings[i]; i++) {\n      if (Prototype.Selector.match(sibling, expressions)) results.push(sibling);\n    }\n    return results;\n  }\n  function descendantOf_DOM(element, ancestor) {\n    element = $(element), ancestor = $(ancestor);\n    if (!element || !ancestor) return false;\n    while (element = element.parentNode) if (element === ancestor) return true;\n    return false;\n  }\n  function descendantOf_contains(element, ancestor) {\n    element = $(element), ancestor = $(ancestor);\n    if (!element || !ancestor) return false;\n    if (!ancestor.contains) return descendantOf_DOM(element, ancestor);\n    return ancestor.contains(element) && ancestor !== element;\n  }\n  function descendantOf_compareDocumentPosition(element, ancestor) {\n    element = $(element), ancestor = $(ancestor);\n    if (!element || !ancestor) return false;\n    return (element.compareDocumentPosition(ancestor) & 8) === 8;\n  }\n  var descendantOf;\n  if (DIV.compareDocumentPosition) {\n    descendantOf = descendantOf_compareDocumentPosition;\n  } else if (DIV.contains) {\n    descendantOf = descendantOf_contains;\n  } else {\n    descendantOf = descendantOf_DOM;\n  }\n  Object.extend(methods, {\n    recursivelyCollect: recursivelyCollect,\n    ancestors: ancestors,\n    descendants: descendants,\n    firstDescendant: firstDescendant,\n    immediateDescendants: immediateDescendants,\n    previousSiblings: previousSiblings,\n    nextSiblings: nextSiblings,\n    siblings: siblings,\n    match: match,\n    up: up,\n    down: down,\n    previous: previous,\n    next: next,\n    select: select,\n    adjacent: adjacent,\n    descendantOf: descendantOf,\n    getElementsBySelector: select,\n    childElements: immediateDescendants\n  });\n  var idCounter = 1;\n  function identify(element) {\n    element = $(element);\n    var id = Element.readAttribute(element, 'id');\n    if (id) return id;\n    do {\n      id = 'anonymous_element_' + idCounter++;\n    } while ($(id));\n    Element.writeAttribute(element, 'id', id);\n    return id;\n  }\n  function readAttribute(element, name) {\n    return $(element).getAttribute(name);\n  }\n  function readAttribute_IE(element, name) {\n    element = $(element);\n    var table = ATTRIBUTE_TRANSLATIONS.read;\n    if ((0, _values.default)(table)[name]) return (0, _values.default)(table)[name](element, name);\n    if (table.names[name]) name = table.names[name];\n    if (name.include(':')) {\n      if (!element.attributes || !element.attributes[name]) return null;\n      return element.attributes[name].value;\n    }\n    return element.getAttribute(name);\n  }\n  function readAttribute_Opera(element, name) {\n    if (name === 'title') return element.title;\n    return element.getAttribute(name);\n  }\n  var PROBLEMATIC_ATTRIBUTE_READING = function () {\n    DIV.setAttribute('onclick', []);\n    var value = DIV.getAttribute('onclick');\n    var isFunction = Object.isArray(value);\n    DIV.removeAttribute('onclick');\n    return isFunction;\n  }();\n  if (PROBLEMATIC_ATTRIBUTE_READING) {\n    readAttribute = readAttribute_IE;\n  } else if (Prototype.Browser.Opera) {\n    readAttribute = readAttribute_Opera;\n  }\n  function writeAttribute(element, name, value) {\n    element = $(element);\n    var attributes = {},\n      table = ATTRIBUTE_TRANSLATIONS.write;\n    if (_typeof(name) === 'object') {\n      attributes = name;\n    } else {\n      attributes[name] = Object.isUndefined(value) ? true : value;\n    }\n    for (var attr in attributes) {\n      name = table.names[attr] || attr;\n      value = attributes[attr];\n      if ((0, _values.default)(table)[attr]) {\n        value = (0, _values.default)(table)[attr](element, value);\n        if (Object.isUndefined(value)) continue;\n      }\n      if (value === false || value === null) element.removeAttribute(name);else if (value === true) element.setAttribute(name, name);else element.setAttribute(name, value);\n    }\n    return element;\n  }\n  var PROBLEMATIC_HAS_ATTRIBUTE_WITH_CHECKBOXES = function () {\n    if (!HAS_EXTENDED_CREATE_ELEMENT_SYNTAX) {\n      return false;\n    }\n    var checkbox = document.createElement('<input type=\"checkbox\">');\n    checkbox.checked = true;\n    var node = checkbox.getAttributeNode('checked');\n    return !node || !node.specified;\n  }();\n  function hasAttribute(element, attribute) {\n    attribute = ATTRIBUTE_TRANSLATIONS.has[attribute] || attribute;\n    var node = $(element).getAttributeNode(attribute);\n    return !!(node && node.specified);\n  }\n  function hasAttribute_IE(element, attribute) {\n    if (attribute === 'checked') {\n      return element.checked;\n    }\n    return hasAttribute(element, attribute);\n  }\n  GLOBAL.Element.Methods.Simulated.hasAttribute = PROBLEMATIC_HAS_ATTRIBUTE_WITH_CHECKBOXES ? hasAttribute_IE : hasAttribute;\n  function classNames(element) {\n    return new Element.ClassNames(element);\n  }\n  var regExpCache = {};\n  function getRegExpForClassName(className) {\n    if (regExpCache[className]) return regExpCache[className];\n    var re = new RegExp(\"(^|\\\\s+)\" + className + \"(\\\\s+|$)\");\n    regExpCache[className] = re;\n    return re;\n  }\n  function hasClassName(element, className) {\n    if (!(element = $(element))) return;\n    var elementClassName = element.className;\n    if (elementClassName.length === 0) return false;\n    if (elementClassName === className) return true;\n    return getRegExpForClassName(className).test(elementClassName);\n  }\n  function addClassName(element, className) {\n    if (!(element = $(element))) return;\n    if (!hasClassName(element, className)) element.className += (element.className ? ' ' : '') + className;\n    return element;\n  }\n  function removeClassName(element, className) {\n    if (!(element = $(element))) return;\n    element.className = element.className.replace(getRegExpForClassName(className), ' ').strip();\n    return element;\n  }\n  function toggleClassName(element, className, bool) {\n    if (!(element = $(element))) return;\n    if (Object.isUndefined(bool)) bool = !hasClassName(element, className);\n    var method = Element[bool ? 'addClassName' : 'removeClassName'];\n    return method(element, className);\n  }\n  var ATTRIBUTE_TRANSLATIONS = {};\n  var classProp = 'className',\n    forProp = 'for';\n  DIV.setAttribute(classProp, 'x');\n  if (DIV.className !== 'x') {\n    DIV.setAttribute('class', 'x');\n    if (DIV.className === 'x') classProp = 'class';\n  }\n  var LABEL = document.createElement('label');\n  LABEL.setAttribute(forProp, 'x');\n  if (LABEL.htmlFor !== 'x') {\n    LABEL.setAttribute('htmlFor', 'x');\n    if (LABEL.htmlFor === 'x') forProp = 'htmlFor';\n  }\n  LABEL = null;\n  function _getAttr(element, attribute) {\n    return element.getAttribute(attribute);\n  }\n  function _getAttr2(element, attribute) {\n    return element.getAttribute(attribute, 2);\n  }\n  function _getAttrNode(element, attribute) {\n    var node = element.getAttributeNode(attribute);\n    return node ? node.value : '';\n  }\n  function _getFlag(element, attribute) {\n    return $(element).hasAttribute(attribute) ? attribute : null;\n  }\n  DIV.onclick = Prototype.emptyFunction;\n  var onclickValue = DIV.getAttribute('onclick');\n  var _getEv;\n  if ((0, _indexOf.default)(_context31 = String(onclickValue)).call(_context31, '{') > -1) {\n    _getEv = function _getEv(element, attribute) {\n      var value = element.getAttribute(attribute);\n      if (!value) return null;\n      value = value.toString();\n      value = value.split('{')[1];\n      value = value.split('}')[0];\n      return value.strip();\n    };\n  } else if (onclickValue === '') {\n    _getEv = function _getEv(element, attribute) {\n      var value = element.getAttribute(attribute);\n      if (!value) return null;\n      return value.strip();\n    };\n  }\n  ATTRIBUTE_TRANSLATIONS.read = {\n    names: {\n      'class': classProp,\n      'className': classProp,\n      'for': forProp,\n      'htmlFor': forProp\n    },\n    values: {\n      style: function style(element) {\n        return element.style.cssText.toLowerCase();\n      },\n      title: function title(element) {\n        return element.title;\n      }\n    }\n  };\n  ATTRIBUTE_TRANSLATIONS.write = {\n    names: {\n      className: 'class',\n      htmlFor: 'for',\n      cellpadding: 'cellPadding',\n      cellspacing: 'cellSpacing'\n    },\n    values: {\n      checked: function checked(element, value) {\n        value = !!value;\n        element.checked = value;\n        return value ? 'checked' : null;\n      },\n      style: function style(element, value) {\n        element.style.cssText = value ? value : '';\n      }\n    }\n  };\n  ATTRIBUTE_TRANSLATIONS.has = {\n    names: {}\n  };\n  Object.extend(ATTRIBUTE_TRANSLATIONS.write.names, ATTRIBUTE_TRANSLATIONS.read.names);\n  var CAMEL_CASED_ATTRIBUTE_NAMES = $w('colSpan rowSpan vAlign dateTime ' + 'accessKey tabIndex encType maxLength readOnly longDesc frameBorder');\n  for (var i = 0, attr; attr = CAMEL_CASED_ATTRIBUTE_NAMES[i]; i++) {\n    ATTRIBUTE_TRANSLATIONS.write.names[attr.toLowerCase()] = attr;\n    ATTRIBUTE_TRANSLATIONS.has.names[attr.toLowerCase()] = attr;\n  }\n  Object.extend((0, _values.default)(ATTRIBUTE_TRANSLATIONS.read), {\n    href: _getAttr2,\n    src: _getAttr2,\n    type: _getAttr,\n    action: _getAttrNode,\n    disabled: _getFlag,\n    checked: _getFlag,\n    readonly: _getFlag,\n    multiple: _getFlag,\n    onload: _getEv,\n    onunload: _getEv,\n    onclick: _getEv,\n    ondblclick: _getEv,\n    onmousedown: _getEv,\n    onmouseup: _getEv,\n    onmouseover: _getEv,\n    onmousemove: _getEv,\n    onmouseout: _getEv,\n    onfocus: _getEv,\n    onblur: _getEv,\n    onkeypress: _getEv,\n    onkeydown: _getEv,\n    onkeyup: _getEv,\n    onsubmit: _getEv,\n    onreset: _getEv,\n    onselect: _getEv,\n    onchange: _getEv\n  });\n  Object.extend(methods, {\n    identify: identify,\n    readAttribute: readAttribute,\n    writeAttribute: writeAttribute,\n    classNames: classNames,\n    hasClassName: hasClassName,\n    addClassName: addClassName,\n    removeClassName: removeClassName,\n    toggleClassName: toggleClassName\n  });\n  function normalizeStyleName(style) {\n    if (style === 'float' || style === 'styleFloat') return 'cssFloat';\n    return style.camelize();\n  }\n  function normalizeStyleName_IE(style) {\n    if (style === 'float' || style === 'cssFloat') return 'styleFloat';\n    return style.camelize();\n  }\n  function setStyle(element, styles) {\n    element = $(element);\n    var elementStyle = element.style,\n      match;\n    if (Object.isString(styles)) {\n      elementStyle.cssText += ';' + styles;\n      if (styles.include('opacity')) {\n        var opacity = styles.match(/opacity:\\s*(\\d?\\.?\\d*)/)[1];\n        Element.setOpacity(element, opacity);\n      }\n      return element;\n    }\n    for (var property in styles) {\n      if (property === 'opacity') {\n        Element.setOpacity(element, styles[property]);\n      } else {\n        var value = styles[property];\n        if (property === 'float' || property === 'cssFloat') {\n          property = Object.isUndefined(elementStyle.styleFloat) ? 'cssFloat' : 'styleFloat';\n        }\n        elementStyle[property] = value;\n      }\n    }\n    return element;\n  }\n  function getStyle(element, style) {\n    element = $(element);\n    style = normalizeStyleName(style);\n    var value = element.style[style];\n    if (!value || value === 'auto') {\n      var css = document.defaultView.getComputedStyle(element, null);\n      value = css ? css[style] : null;\n    }\n    if (style === 'opacity') return value ? (0, _parseFloat2.default)(value) : 1.0;\n    return value === 'auto' ? null : value;\n  }\n  function getStyle_Opera(element, style) {\n    switch (style) {\n      case 'height':\n      case 'width':\n        if (!Element.visible(element)) return null;\n        var dim = (0, _parseInt2.default)(getStyle(element, style), 10);\n        if (dim !== element['offset' + style.capitalize()]) return dim + 'px';\n        return Element.measure(element, style);\n      default:\n        return getStyle(element, style);\n    }\n  }\n  function getStyle_IE(element, style) {\n    element = $(element);\n    style = normalizeStyleName_IE(style);\n    var value = element.style[style];\n    if (!value && element.currentStyle) {\n      value = element.currentStyle[style];\n    }\n    if (style === 'opacity') {\n      if (!STANDARD_CSS_OPACITY_SUPPORTED) return getOpacity_IE(element);else return value ? (0, _parseFloat2.default)(value) : 1.0;\n    }\n    if (value === 'auto') {\n      if ((style === 'width' || style === 'height') && Element.visible(element)) return Element.measure(element, style) + 'px';\n      return null;\n    }\n    return value;\n  }\n  function stripAlphaFromFilter_IE(filter) {\n    return (filter || '').replace(/alpha\\([^\\)]*\\)/gi, '');\n  }\n  function hasLayout_IE(element) {\n    if (!element.currentStyle || !element.currentStyle.hasLayout) element.style.zoom = 1;\n    return element;\n  }\n  var STANDARD_CSS_OPACITY_SUPPORTED = function () {\n    DIV.style.cssText = \"opacity:.55\";\n    return /^0.55/.test(DIV.style.opacity);\n  }();\n  function setOpacity(element, value) {\n    element = $(element);\n    if (value == 1 || value === '') value = '';else if (value < 0.00001) value = 0;\n    element.style.opacity = value;\n    return element;\n  }\n  function setOpacity_IE(element, value) {\n    if (STANDARD_CSS_OPACITY_SUPPORTED) return setOpacity(element, value);\n    element = hasLayout_IE($(element));\n    var filter = Element.getStyle(element, 'filter'),\n      style = element.style;\n    if (value == 1 || value === '') {\n      filter = stripAlphaFromFilter_IE(filter);\n      if (filter) style.filter = filter;else style.removeAttribute('filter');\n      return element;\n    }\n    if (value < 0.00001) value = 0;\n    style.filter = stripAlphaFromFilter_IE(filter) + ' alpha(opacity=' + value * 100 + ')';\n    return element;\n  }\n  function getOpacity(element) {\n    return Element.getStyle(element, 'opacity');\n  }\n  function getOpacity_IE(element) {\n    if (STANDARD_CSS_OPACITY_SUPPORTED) return getOpacity(element);\n    var filter = Element.getStyle(element, 'filter');\n    if (filter.length === 0) return 1.0;\n    var match = (filter || '').match(/alpha\\(opacity=(.*)\\)/i);\n    if (match && match[1]) return (0, _parseFloat2.default)(match[1]) / 100;\n    return 1.0;\n  }\n  Object.extend(methods, {\n    setStyle: setStyle,\n    getStyle: getStyle,\n    setOpacity: setOpacity,\n    getOpacity: getOpacity\n  });\n  if ('styleFloat' in DIV.style) {\n    methods.getStyle = getStyle_IE;\n    methods.setOpacity = setOpacity_IE;\n    methods.getOpacity = getOpacity_IE;\n  }\n  var UID = 0;\n  GLOBAL.Element.Storage = {\n    UID: 1\n  };\n  function getUniqueElementID(element) {\n    if (element === window) return 0;\n    if (typeof element._prototypeUID === 'undefined') element._prototypeUID = Element.Storage.UID++;\n    return element._prototypeUID;\n  }\n  function getUniqueElementID_IE(element) {\n    if (element === window) return 0;\n    if (element == document) return 1;\n    return element.uniqueID;\n  }\n  var HAS_UNIQUE_ID_PROPERTY = 'uniqueID' in DIV;\n  if (HAS_UNIQUE_ID_PROPERTY) getUniqueElementID = getUniqueElementID_IE;\n  function getStorage(element) {\n    if (!(element = $(element))) return;\n    var uid = getUniqueElementID(element);\n    if (!Element.Storage[uid]) Element.Storage[uid] = $H();\n    return Element.Storage[uid];\n  }\n  function store(element, key, value) {\n    if (!(element = $(element))) return;\n    var storage = getStorage(element);\n    if (arguments.length === 2) {\n      storage.update(key);\n    } else {\n      storage.set(key, value);\n    }\n    return element;\n  }\n  function retrieve(element, key, defaultValue) {\n    if (!(element = $(element))) return;\n    var storage = getStorage(element),\n      value = storage.get(key);\n    if (Object.isUndefined(value)) {\n      storage.set(key, defaultValue);\n      value = defaultValue;\n    }\n    return value;\n  }\n  Object.extend(methods, {\n    getStorage: getStorage,\n    store: store,\n    retrieve: retrieve\n  });\n  var Methods = {},\n    ByTag = Element.Methods.ByTag,\n    F = Prototype.BrowserFeatures;\n  if (!F.ElementExtensions && '__proto__' in DIV) {\n    GLOBAL.HTMLElement = {};\n    GLOBAL.HTMLElement.prototype = DIV['__proto__'];\n    F.ElementExtensions = true;\n  }\n  function checkElementPrototypeDeficiency(tagName) {\n    if (typeof window.Element === 'undefined') return false;\n    if (!HAS_EXTENDED_CREATE_ELEMENT_SYNTAX) return false;\n    var proto = window.Element.prototype;\n    if (proto) {\n      var _context32;\n      var id = '_' + (0, _slice.default)(_context32 = Math.random() + '').call(_context32, 2),\n        el = document.createElement(tagName);\n      proto[id] = 'x';\n      var isBuggy = el[id] !== 'x';\n      delete proto[id];\n      el = null;\n      return isBuggy;\n    }\n    return false;\n  }\n  var HTMLOBJECTELEMENT_PROTOTYPE_BUGGY = checkElementPrototypeDeficiency('object');\n  function extendElementWith(element, methods) {\n    for (var property in methods) {\n      var value = methods[property];\n      if (Object.isFunction(value) && !(property in element)) element[property] = value.methodize();\n    }\n  }\n  var EXTENDED = {};\n  function elementIsExtended(element) {\n    var uid = getUniqueElementID(element);\n    return uid in EXTENDED;\n  }\n  function extend(element) {\n    if (!element || elementIsExtended(element)) return element;\n    if (element.nodeType !== Node.ELEMENT_NODE || element == window) return element;\n    var methods = Object.clone(Methods),\n      tagName = element.tagName.toUpperCase();\n    if (ByTag[tagName]) Object.extend(methods, ByTag[tagName]);\n    extendElementWith(element, methods);\n    EXTENDED[getUniqueElementID(element)] = true;\n    return element;\n  }\n  function extend_IE8(element) {\n    if (!element || elementIsExtended(element)) return element;\n    var t = element.tagName;\n    if (t && /^(?:object|applet|embed)$/i.test(t)) {\n      extendElementWith(element, Element.Methods);\n      extendElementWith(element, Element.Methods.Simulated);\n      extendElementWith(element, Element.Methods.ByTag[t.toUpperCase()]);\n    }\n    return element;\n  }\n  if (F.SpecificElementExtensions) {\n    extend = HTMLOBJECTELEMENT_PROTOTYPE_BUGGY ? extend_IE8 : Prototype.K;\n  }\n  function addMethodsToTagName(tagName, methods) {\n    tagName = tagName.toUpperCase();\n    if (!ByTag[tagName]) ByTag[tagName] = {};\n    Object.extend(ByTag[tagName], methods);\n  }\n  function mergeMethods(destination, methods, onlyIfAbsent) {\n    if (Object.isUndefined(onlyIfAbsent)) onlyIfAbsent = false;\n    for (var property in methods) {\n      var value = methods[property];\n      if (!Object.isFunction(value)) continue;\n      if (!onlyIfAbsent || !(property in destination)) destination[property] = value.methodize();\n    }\n  }\n  function findDOMClass(tagName) {\n    var klass;\n    var trans = {\n      \"OPTGROUP\": \"OptGroup\",\n      \"TEXTAREA\": \"TextArea\",\n      \"P\": \"Paragraph\",\n      \"FIELDSET\": \"FieldSet\",\n      \"UL\": \"UList\",\n      \"OL\": \"OList\",\n      \"DL\": \"DList\",\n      \"DIR\": \"Directory\",\n      \"H1\": \"Heading\",\n      \"H2\": \"Heading\",\n      \"H3\": \"Heading\",\n      \"H4\": \"Heading\",\n      \"H5\": \"Heading\",\n      \"H6\": \"Heading\",\n      \"Q\": \"Quote\",\n      \"INS\": \"Mod\",\n      \"DEL\": \"Mod\",\n      \"A\": \"Anchor\",\n      \"IMG\": \"Image\",\n      \"CAPTION\": \"TableCaption\",\n      \"COL\": \"TableCol\",\n      \"COLGROUP\": \"TableCol\",\n      \"THEAD\": \"TableSection\",\n      \"TFOOT\": \"TableSection\",\n      \"TBODY\": \"TableSection\",\n      \"TR\": \"TableRow\",\n      \"TH\": \"TableCell\",\n      \"TD\": \"TableCell\",\n      \"FRAMESET\": \"FrameSet\",\n      \"IFRAME\": \"IFrame\"\n    };\n    if (trans[tagName]) klass = 'HTML' + trans[tagName] + 'Element';\n    if (window[klass]) return window[klass];\n    klass = 'HTML' + tagName + 'Element';\n    if (window[klass]) return window[klass];\n    klass = 'HTML' + tagName.capitalize() + 'Element';\n    if (window[klass]) return window[klass];\n    var element = document.createElement(tagName),\n      proto = element['__proto__'] || element.constructor.prototype;\n    element = null;\n    return proto;\n  }\n  function addMethods(methods) {\n    if (arguments.length === 0) addFormMethods();\n    if (arguments.length === 2) {\n      var tagName = methods;\n      methods = arguments[1];\n    }\n    if (!tagName) {\n      Object.extend(Element.Methods, methods || {});\n    } else {\n      if (Object.isArray(tagName)) {\n        for (var i = 0, tag; tag = tagName[i]; i++) addMethodsToTagName(tag, methods);\n      } else {\n        addMethodsToTagName(tagName, methods);\n      }\n    }\n    var ELEMENT_PROTOTYPE = window.HTMLElement ? HTMLElement.prototype : Element.prototype;\n    if (F.ElementExtensions) {\n      mergeMethods(ELEMENT_PROTOTYPE, Element.Methods);\n      mergeMethods(ELEMENT_PROTOTYPE, Element.Methods.Simulated, true);\n    }\n    if (F.SpecificElementExtensions) {\n      for (var tag in Element.Methods.ByTag) {\n        var klass = findDOMClass(tag);\n        if (Object.isUndefined(klass)) continue;\n        mergeMethods(klass.prototype, ByTag[tag]);\n      }\n    }\n    Object.extend(Element, Element.Methods);\n    Object.extend(Element, Element.Methods.Simulated);\n    delete Element.ByTag;\n    delete Element.Simulated;\n    Element.extend.refresh();\n    ELEMENT_CACHE = {};\n  }\n  Object.extend(GLOBAL.Element, {\n    extend: extend,\n    addMethods: addMethods\n  });\n  if (extend === Prototype.K) {\n    GLOBAL.Element.extend.refresh = Prototype.emptyFunction;\n  } else {\n    GLOBAL.Element.extend.refresh = function () {\n      if (Prototype.BrowserFeatures.ElementExtensions) return;\n      Object.extend(Methods, Element.Methods);\n      Object.extend(Methods, Element.Methods.Simulated);\n      EXTENDED = {};\n    };\n  }\n  function addFormMethods() {\n    Object.extend(Form, Form.Methods);\n    Object.extend(Form.Element, Form.Element.Methods);\n    Object.extend(Element.Methods.ByTag, {\n      \"FORM\": Object.clone(Form.Methods),\n      \"INPUT\": Object.clone(Form.Element.Methods),\n      \"SELECT\": Object.clone(Form.Element.Methods),\n      \"TEXTAREA\": Object.clone(Form.Element.Methods),\n      \"BUTTON\": Object.clone(Form.Element.Methods)\n    });\n  }\n  Element.addMethods(methods);\n  function destroyCache_IE() {\n    DIV = null;\n    ELEMENT_CACHE = null;\n  }\n  if (window.attachEvent) window.attachEvent('onunload', destroyCache_IE);\n})(void 0);\n(function () {\n  function toDecimal(pctString) {\n    var match = pctString.match(/^(\\d+)%?$/i);\n    if (!match) return null;\n    return Number(match[1]) / 100;\n  }\n  function getRawStyle(element, style) {\n    element = $(element);\n    var value = element.style[style];\n    if (!value || value === 'auto') {\n      var css = document.defaultView.getComputedStyle(element, null);\n      value = css ? css[style] : null;\n    }\n    if (style === 'opacity') return value ? (0, _parseFloat2.default)(value) : 1.0;\n    return value === 'auto' ? null : value;\n  }\n  function getRawStyle_IE(element, style) {\n    var value = element.style[style];\n    if (!value && element.currentStyle) {\n      value = element.currentStyle[style];\n    }\n    return value;\n  }\n  function getContentWidth(element, context) {\n    var boxWidth = element.offsetWidth;\n    var bl = getPixelValue(element, 'borderLeftWidth', context) || 0;\n    var br = getPixelValue(element, 'borderRightWidth', context) || 0;\n    var pl = getPixelValue(element, 'paddingLeft', context) || 0;\n    var pr = getPixelValue(element, 'paddingRight', context) || 0;\n    return boxWidth - bl - br - pl - pr;\n  }\n  if (!Object.isUndefined(document.documentElement.currentStyle) && !Prototype.Browser.Opera) {\n    getRawStyle = getRawStyle_IE;\n  }\n  function getPixelValue(value, property, context) {\n    var element = null;\n    if (Object.isElement(value)) {\n      element = value;\n      value = getRawStyle(element, property);\n    }\n    if (value === null || Object.isUndefined(value)) {\n      return null;\n    }\n    if (/^(?:-)?\\d+(\\.\\d+)?(px)?$/i.test(value)) {\n      return (0, _parseFloat2.default)(value);\n    }\n    var isPercentage = value.include('%'),\n      isViewport = context === document.viewport;\n    if (/\\d/.test(value) && element && element.runtimeStyle && !(isPercentage && isViewport)) {\n      var style = element.style.left,\n        rStyle = element.runtimeStyle.left;\n      element.runtimeStyle.left = element.currentStyle.left;\n      element.style.left = value || 0;\n      value = element.style.pixelLeft;\n      element.style.left = style;\n      element.runtimeStyle.left = rStyle;\n      return value;\n    }\n    if (element && isPercentage) {\n      context = context || element.parentNode;\n      var decimal = toDecimal(value),\n        whole = null;\n      var isHorizontal = property.include('left') || property.include('right') || property.include('width');\n      var isVertical = property.include('top') || property.include('bottom') || property.include('height');\n      if (context === document.viewport) {\n        if (isHorizontal) {\n          whole = document.viewport.getWidth();\n        } else if (isVertical) {\n          whole = document.viewport.getHeight();\n        }\n      } else {\n        if (isHorizontal) {\n          whole = $(context).measure('width');\n        } else if (isVertical) {\n          whole = $(context).measure('height');\n        }\n      }\n      return whole === null ? 0 : whole * decimal;\n    }\n    return 0;\n  }\n  function toCSSPixels(number) {\n    if (Object.isString(number) && (0, _endsWith.default)(number).call(number, 'px')) return number;\n    return number + 'px';\n  }\n  function isDisplayed(element) {\n    while (element && element.parentNode) {\n      var display = element.getStyle('display');\n      if (display === 'none') {\n        return false;\n      }\n      element = $(element.parentNode);\n    }\n    return true;\n  }\n  var hasLayout = Prototype.K;\n  if ('currentStyle' in document.documentElement) {\n    hasLayout = function hasLayout(element) {\n      if (!element.currentStyle.hasLayout) {\n        element.style.zoom = 1;\n      }\n      return element;\n    };\n  }\n  function cssNameFor(key) {\n    if (key.include('border')) key = key + '-width';\n    return key.camelize();\n  }\n  Element.Layout = Class.create(Hash, {\n    initialize: function initialize($super, element, preCompute) {\n      $super();\n      this.element = $(element);\n      Element.Layout.PROPERTIES.each(function (property) {\n        this._set(property, null);\n      }, this);\n      if (preCompute) {\n        this._preComputing = true;\n        this._begin();\n        Element.Layout.PROPERTIES.each(this._compute, this);\n        this._end();\n        this._preComputing = false;\n      }\n    },\n    _set: function _set(property, value) {\n      return Hash.prototype.set.call(this, property, value);\n    },\n    set: function set(property, value) {\n      throw \"Properties of Element.Layout are read-only.\";\n    },\n    get: function get($super, property) {\n      var value = $super(property);\n      return value === null ? this._compute(property) : value;\n    },\n    _begin: function _begin() {\n      if (this._isPrepared()) return;\n      var element = this.element;\n      if (isDisplayed(element)) {\n        this._setPrepared(true);\n        return;\n      }\n      var originalStyles = {\n        position: element.style.position || '',\n        width: element.style.width || '',\n        visibility: element.style.visibility || '',\n        display: element.style.display || ''\n      };\n      element.store('prototype_original_styles', originalStyles);\n      var position = getRawStyle(element, 'position'),\n        width = element.offsetWidth;\n      if (width === 0 || width === null) {\n        element.style.display = 'block';\n        width = element.offsetWidth;\n      }\n      var context = position === 'fixed' ? document.viewport : element.parentNode;\n      var tempStyles = {\n        visibility: 'hidden',\n        display: 'block'\n      };\n      if (position !== 'fixed') tempStyles.position = 'absolute';\n      element.setStyle(tempStyles);\n      var positionedWidth = element.offsetWidth,\n        newWidth;\n      if (width && positionedWidth === width) {\n        newWidth = getContentWidth(element, context);\n      } else if (position === 'absolute' || position === 'fixed') {\n        newWidth = getContentWidth(element, context);\n      } else {\n        var parent = element.parentNode,\n          pLayout = $(parent).getLayout();\n        newWidth = pLayout.get('width') - this.get('margin-left') - this.get('border-left') - this.get('padding-left') - this.get('padding-right') - this.get('border-right') - this.get('margin-right');\n      }\n      element.setStyle({\n        width: newWidth + 'px'\n      });\n      this._setPrepared(true);\n    },\n    _end: function _end() {\n      var element = this.element;\n      var originalStyles = element.retrieve('prototype_original_styles');\n      element.store('prototype_original_styles', null);\n      element.setStyle(originalStyles);\n      this._setPrepared(false);\n    },\n    _compute: function _compute(property) {\n      var COMPUTATIONS = Element.Layout.COMPUTATIONS;\n      if (!(property in COMPUTATIONS)) {\n        throw \"Property not found.\";\n      }\n      return this._set(property, COMPUTATIONS[property].call(this, this.element));\n    },\n    _isPrepared: function _isPrepared() {\n      return this.element.retrieve('prototype_element_layout_prepared', false);\n    },\n    _setPrepared: function _setPrepared(bool) {\n      return this.element.store('prototype_element_layout_prepared', bool);\n    },\n    toObject: function toObject() {\n      var args = $A(arguments);\n      var keys = args.length === 0 ? Element.Layout.PROPERTIES : args.join(' ').split(' ');\n      var obj = {};\n      keys.each(function (key) {\n        if (!Element.Layout.PROPERTIES.include(key)) return;\n        var value = this.get(key);\n        if (value != null) obj[key] = value;\n      }, this);\n      return obj;\n    },\n    toHash: function toHash() {\n      var obj = this.toObject.apply(this, arguments);\n      return new Hash(obj);\n    },\n    toCSS: function toCSS() {\n      var args = $A(arguments);\n      var keys = args.length === 0 ? Element.Layout.PROPERTIES : args.join(' ').split(' ');\n      var css = {};\n      keys.each(function (key) {\n        if (!Element.Layout.PROPERTIES.include(key)) return;\n        if (Element.Layout.COMPOSITE_PROPERTIES.include(key)) return;\n        var value = this.get(key);\n        if (value != null) css[cssNameFor(key)] = value + 'px';\n      }, this);\n      return css;\n    },\n    inspect: function inspect() {\n      return \"#<Element.Layout>\";\n    }\n  });\n  Object.extend(Element.Layout, {\n    PROPERTIES: $w('height width top left right bottom border-left border-right border-top border-bottom padding-left padding-right padding-top padding-bottom margin-top margin-bottom margin-left margin-right padding-box-width padding-box-height border-box-width border-box-height margin-box-width margin-box-height'),\n    COMPOSITE_PROPERTIES: $w('padding-box-width padding-box-height margin-box-width margin-box-height border-box-width border-box-height'),\n    COMPUTATIONS: {\n      'height': function height(element) {\n        if (!this._preComputing) this._begin();\n        var bHeight = this.get('border-box-height');\n        if (bHeight <= 0) {\n          if (!this._preComputing) this._end();\n          return 0;\n        }\n        var bTop = this.get('border-top'),\n          bBottom = this.get('border-bottom');\n        var pTop = this.get('padding-top'),\n          pBottom = this.get('padding-bottom');\n        if (!this._preComputing) this._end();\n        return bHeight - bTop - bBottom - pTop - pBottom;\n      },\n      'width': function width(element) {\n        if (!this._preComputing) this._begin();\n        var bWidth = this.get('border-box-width');\n        if (bWidth <= 0) {\n          if (!this._preComputing) this._end();\n          return 0;\n        }\n        var bLeft = this.get('border-left'),\n          bRight = this.get('border-right');\n        var pLeft = this.get('padding-left'),\n          pRight = this.get('padding-right');\n        if (!this._preComputing) this._end();\n        return bWidth - bLeft - bRight - pLeft - pRight;\n      },\n      'padding-box-height': function paddingBoxHeight(element) {\n        var height = this.get('height'),\n          pTop = this.get('padding-top'),\n          pBottom = this.get('padding-bottom');\n        return height + pTop + pBottom;\n      },\n      'padding-box-width': function paddingBoxWidth(element) {\n        var width = this.get('width'),\n          pLeft = this.get('padding-left'),\n          pRight = this.get('padding-right');\n        return width + pLeft + pRight;\n      },\n      'border-box-height': function borderBoxHeight(element) {\n        if (!this._preComputing) this._begin();\n        var height = element.offsetHeight;\n        if (!this._preComputing) this._end();\n        return height;\n      },\n      'border-box-width': function borderBoxWidth(element) {\n        if (!this._preComputing) this._begin();\n        var width = element.offsetWidth;\n        if (!this._preComputing) this._end();\n        return width;\n      },\n      'margin-box-height': function marginBoxHeight(element) {\n        var bHeight = this.get('border-box-height'),\n          mTop = this.get('margin-top'),\n          mBottom = this.get('margin-bottom');\n        if (bHeight <= 0) return 0;\n        return bHeight + mTop + mBottom;\n      },\n      'margin-box-width': function marginBoxWidth(element) {\n        var bWidth = this.get('border-box-width'),\n          mLeft = this.get('margin-left'),\n          mRight = this.get('margin-right');\n        if (bWidth <= 0) return 0;\n        return bWidth + mLeft + mRight;\n      },\n      'top': function top(element) {\n        var offset = element.positionedOffset();\n        return offset.top;\n      },\n      'bottom': function bottom(element) {\n        var offset = element.positionedOffset(),\n          parent = element.getOffsetParent(),\n          pHeight = parent.measure('height');\n        var mHeight = this.get('border-box-height');\n        return pHeight - mHeight - offset.top;\n      },\n      'left': function left(element) {\n        var offset = element.positionedOffset();\n        return offset.left;\n      },\n      'right': function right(element) {\n        var offset = element.positionedOffset(),\n          parent = element.getOffsetParent(),\n          pWidth = parent.measure('width');\n        var mWidth = this.get('border-box-width');\n        return pWidth - mWidth - offset.left;\n      },\n      'padding-top': function paddingTop(element) {\n        return getPixelValue(element, 'paddingTop');\n      },\n      'padding-bottom': function paddingBottom(element) {\n        return getPixelValue(element, 'paddingBottom');\n      },\n      'padding-left': function paddingLeft(element) {\n        return getPixelValue(element, 'paddingLeft');\n      },\n      'padding-right': function paddingRight(element) {\n        return getPixelValue(element, 'paddingRight');\n      },\n      'border-top': function borderTop(element) {\n        return getPixelValue(element, 'borderTopWidth');\n      },\n      'border-bottom': function borderBottom(element) {\n        return getPixelValue(element, 'borderBottomWidth');\n      },\n      'border-left': function borderLeft(element) {\n        return getPixelValue(element, 'borderLeftWidth');\n      },\n      'border-right': function borderRight(element) {\n        return getPixelValue(element, 'borderRightWidth');\n      },\n      'margin-top': function marginTop(element) {\n        return getPixelValue(element, 'marginTop');\n      },\n      'margin-bottom': function marginBottom(element) {\n        return getPixelValue(element, 'marginBottom');\n      },\n      'margin-left': function marginLeft(element) {\n        return getPixelValue(element, 'marginLeft');\n      },\n      'margin-right': function marginRight(element) {\n        return getPixelValue(element, 'marginRight');\n      }\n    }\n  });\n  if ('getBoundingClientRect' in document.documentElement) {\n    Object.extend(Element.Layout.COMPUTATIONS, {\n      'right': function right(element) {\n        var parent = hasLayout(element.getOffsetParent());\n        var rect = element.getBoundingClientRect(),\n          pRect = parent.getBoundingClientRect();\n        return (pRect.right - rect.right).round();\n      },\n      'bottom': function bottom(element) {\n        var parent = hasLayout(element.getOffsetParent());\n        var rect = element.getBoundingClientRect(),\n          pRect = parent.getBoundingClientRect();\n        return (pRect.bottom - rect.bottom).round();\n      }\n    });\n  }\n  Element.Offset = Class.create({\n    initialize: function initialize(left, top) {\n      this.left = left.round();\n      this.top = top.round();\n      this[0] = this.left;\n      this[1] = this.top;\n    },\n    relativeTo: function relativeTo(offset) {\n      return new Element.Offset(this.left - offset.left, this.top - offset.top);\n    },\n    inspect: function inspect() {\n      return \"#<Element.Offset left: #{left} top: #{top}>\".interpolate(this);\n    },\n    toString: function toString() {\n      return \"[#{left}, #{top}]\".interpolate(this);\n    },\n    toArray: function toArray() {\n      return [this.left, this.top];\n    }\n  });\n  function getLayout(element, preCompute) {\n    return new Element.Layout(element, preCompute);\n  }\n  function measure(element, property) {\n    return $(element).getLayout().get(property);\n  }\n  function getHeight(element) {\n    return Element.getDimensions(element).height;\n  }\n  function getWidth(element) {\n    return Element.getDimensions(element).width;\n  }\n  function getDimensions(element) {\n    element = $(element);\n    var display = Element.getStyle(element, 'display');\n    if (display && display !== 'none') {\n      return {\n        width: element.offsetWidth,\n        height: element.offsetHeight\n      };\n    }\n    var style = element.style;\n    var originalStyles = {\n      visibility: style.visibility,\n      position: style.position,\n      display: style.display\n    };\n    var newStyles = {\n      visibility: 'hidden',\n      display: 'block'\n    };\n    if (originalStyles.position !== 'fixed') newStyles.position = 'absolute';\n    Element.setStyle(element, newStyles);\n    var dimensions = {\n      width: element.offsetWidth,\n      height: element.offsetHeight\n    };\n    Element.setStyle(element, originalStyles);\n    return dimensions;\n  }\n  function getOffsetParent(element) {\n    element = $(element);\n    function selfOrBody(element) {\n      return isHtml(element) ? $(document.body) : $(element);\n    }\n    if (isDocument(element) || isDetached(element) || isBody(element) || isHtml(element)) return $(document.body);\n    var isInline = Element.getStyle(element, 'display') === 'inline';\n    if (!isInline && element.offsetParent) return selfOrBody(element.offsetParent);\n    while ((element = element.parentNode) && element !== document.body) {\n      if (Element.getStyle(element, 'position') !== 'static') {\n        return selfOrBody(element);\n      }\n    }\n    return $(document.body);\n  }\n  function cumulativeOffset(element) {\n    element = $(element);\n    var valueT = 0,\n      valueL = 0;\n    if (element.parentNode) {\n      do {\n        valueT += element.offsetTop || 0;\n        valueL += element.offsetLeft || 0;\n        element = element.offsetParent;\n      } while (element);\n    }\n    return new Element.Offset(valueL, valueT);\n  }\n  function positionedOffset(element) {\n    element = $(element);\n    var layout = element.getLayout();\n    var valueT = 0,\n      valueL = 0;\n    do {\n      valueT += element.offsetTop || 0;\n      valueL += element.offsetLeft || 0;\n      element = element.offsetParent;\n      if (element) {\n        if (isBody(element)) break;\n        var p = Element.getStyle(element, 'position');\n        if (p !== 'static') break;\n      }\n    } while (element);\n    valueL -= layout.get('margin-left');\n    valueT -= layout.get('margin-top');\n    return new Element.Offset(valueL, valueT);\n  }\n  function cumulativeScrollOffset(element) {\n    var valueT = 0,\n      valueL = 0;\n    do {\n      if (element === document.body) {\n        var bodyScrollNode = document.documentElement || document.body.parentNode || document.body;\n        valueT += !Object.isUndefined(window.pageYOffset) ? window.pageYOffset : bodyScrollNode.scrollTop || 0;\n        valueL += !Object.isUndefined(window.pageXOffset) ? window.pageXOffset : bodyScrollNode.scrollLeft || 0;\n        break;\n      } else {\n        valueT += element.scrollTop || 0;\n        valueL += element.scrollLeft || 0;\n        element = element.parentNode;\n      }\n    } while (element);\n    return new Element.Offset(valueL, valueT);\n  }\n  function viewportOffset(forElement) {\n    var valueT = 0,\n      valueL = 0,\n      docBody = document.body;\n    forElement = $(forElement);\n    var element = forElement;\n    do {\n      valueT += element.offsetTop || 0;\n      valueL += element.offsetLeft || 0;\n      if (element.offsetParent == docBody && Element.getStyle(element, 'position') == 'absolute') break;\n    } while (element = element.offsetParent);\n    element = forElement;\n    do {\n      if (element != docBody) {\n        valueT -= element.scrollTop || 0;\n        valueL -= element.scrollLeft || 0;\n      }\n    } while (element = element.parentNode);\n    return new Element.Offset(valueL, valueT);\n  }\n  function absolutize(element) {\n    element = $(element);\n    if (Element.getStyle(element, 'position') === 'absolute') {\n      return element;\n    }\n    var offsetParent = getOffsetParent(element);\n    var eOffset = element.viewportOffset(),\n      pOffset = offsetParent.viewportOffset();\n    var offset = eOffset.relativeTo(pOffset);\n    var layout = element.getLayout();\n    element.store('prototype_absolutize_original_styles', {\n      position: element.getStyle('position'),\n      left: element.getStyle('left'),\n      top: element.getStyle('top'),\n      width: element.getStyle('width'),\n      height: element.getStyle('height')\n    });\n    element.setStyle({\n      position: 'absolute',\n      top: offset.top + 'px',\n      left: offset.left + 'px',\n      width: layout.get('width') + 'px',\n      height: layout.get('height') + 'px'\n    });\n    return element;\n  }\n  function relativize(element) {\n    element = $(element);\n    if (Element.getStyle(element, 'position') === 'relative') {\n      return element;\n    }\n    var originalStyles = element.retrieve('prototype_absolutize_original_styles');\n    if (originalStyles) element.setStyle(originalStyles);\n    return element;\n  }\n  function scrollTo(element) {\n    element = $(element);\n    var pos = Element.cumulativeOffset(element);\n    window.scrollTo(pos.left, pos.top);\n    return element;\n  }\n  function makePositioned(element) {\n    element = $(element);\n    var position = Element.getStyle(element, 'position'),\n      styles = {};\n    if (position === 'static' || !position) {\n      styles.position = 'relative';\n      if (Prototype.Browser.Opera) {\n        styles.top = 0;\n        styles.left = 0;\n      }\n      Element.setStyle(element, styles);\n      Element.store(element, 'prototype_made_positioned', true);\n    }\n    return element;\n  }\n  function undoPositioned(element) {\n    element = $(element);\n    var storage = Element.getStorage(element),\n      madePositioned = storage.get('prototype_made_positioned');\n    if (madePositioned) {\n      storage.unset('prototype_made_positioned');\n      Element.setStyle(element, {\n        position: '',\n        top: '',\n        bottom: '',\n        left: '',\n        right: ''\n      });\n    }\n    return element;\n  }\n  function makeClipping(element) {\n    element = $(element);\n    var storage = Element.getStorage(element),\n      madeClipping = storage.get('prototype_made_clipping');\n    if (Object.isUndefined(madeClipping)) {\n      var overflow = Element.getStyle(element, 'overflow');\n      storage.set('prototype_made_clipping', overflow);\n      if (overflow !== 'hidden') element.style.overflow = 'hidden';\n    }\n    return element;\n  }\n  function undoClipping(element) {\n    element = $(element);\n    var storage = Element.getStorage(element),\n      overflow = storage.get('prototype_made_clipping');\n    if (!Object.isUndefined(overflow)) {\n      storage.unset('prototype_made_clipping');\n      element.style.overflow = overflow || '';\n    }\n    return element;\n  }\n  function clonePosition(element, source, options) {\n    options = Object.extend({\n      setLeft: true,\n      setTop: true,\n      setWidth: true,\n      setHeight: true,\n      offsetTop: 0,\n      offsetLeft: 0\n    }, options || {});\n    var docEl = document.documentElement;\n    source = $(source);\n    element = $(element);\n    var p,\n      delta,\n      layout,\n      styles = {};\n    if (options.setLeft || options.setTop) {\n      p = Element.viewportOffset(source);\n      delta = [0, 0];\n      if (Element.getStyle(element, 'position') === 'absolute') {\n        var parent = Element.getOffsetParent(element);\n        if (parent !== document.body) delta = Element.viewportOffset(parent);\n      }\n    }\n    function pageScrollXY() {\n      var x = 0,\n        y = 0;\n      if (Object.isNumber(window.pageXOffset)) {\n        x = window.pageXOffset;\n        y = window.pageYOffset;\n      } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {\n        x = document.body.scrollLeft;\n        y = document.body.scrollTop;\n      } else if (docEl && (docEl.scrollLeft || docEl.scrollTop)) {\n        x = docEl.scrollLeft;\n        y = docEl.scrollTop;\n      }\n      return {\n        x: x,\n        y: y\n      };\n    }\n    var pageXY = pageScrollXY();\n    if (options.setWidth || options.setHeight) {\n      layout = Element.getLayout(source);\n    }\n    if (options.setLeft) styles.left = p[0] + pageXY.x - delta[0] + options.offsetLeft + 'px';\n    if (options.setTop) styles.top = p[1] + pageXY.y - delta[1] + options.offsetTop + 'px';\n    var currentLayout = element.getLayout();\n    if (options.setWidth) {\n      styles.width = layout.get('width') + 'px';\n    }\n    if (options.setHeight) {\n      styles.height = layout.get('height') + 'px';\n    }\n    return Element.setStyle(element, styles);\n  }\n  if (Prototype.Browser.IE) {\n    getOffsetParent = getOffsetParent.wrap(function (proceed, element) {\n      element = $(element);\n      if (isDocument(element) || isDetached(element) || isBody(element) || isHtml(element)) return $(document.body);\n      var position = element.getStyle('position');\n      if (position !== 'static') return proceed(element);\n      element.setStyle({\n        position: 'relative'\n      });\n      var value = proceed(element);\n      element.setStyle({\n        position: position\n      });\n      return value;\n    });\n    positionedOffset = positionedOffset.wrap(function (proceed, element) {\n      element = $(element);\n      if (!element.parentNode) return new Element.Offset(0, 0);\n      var position = element.getStyle('position');\n      if (position !== 'static') return proceed(element);\n      var offsetParent = element.getOffsetParent();\n      if (offsetParent && offsetParent.getStyle('position') === 'fixed') hasLayout(offsetParent);\n      element.setStyle({\n        position: 'relative'\n      });\n      var value = proceed(element);\n      element.setStyle({\n        position: position\n      });\n      return value;\n    });\n  } else if (Prototype.Browser.Webkit) {\n    cumulativeOffset = function cumulativeOffset(element) {\n      element = $(element);\n      var valueT = 0,\n        valueL = 0;\n      do {\n        valueT += element.offsetTop || 0;\n        valueL += element.offsetLeft || 0;\n        if (element.offsetParent == document.body) {\n          if (Element.getStyle(element, 'position') == 'absolute') break;\n        }\n        element = element.offsetParent;\n      } while (element);\n      return new Element.Offset(valueL, valueT);\n    };\n  }\n  Element.addMethods({\n    getLayout: getLayout,\n    measure: measure,\n    getWidth: getWidth,\n    getHeight: getHeight,\n    getDimensions: getDimensions,\n    getOffsetParent: getOffsetParent,\n    cumulativeOffset: cumulativeOffset,\n    positionedOffset: positionedOffset,\n    cumulativeScrollOffset: cumulativeScrollOffset,\n    viewportOffset: viewportOffset,\n    absolutize: absolutize,\n    relativize: relativize,\n    scrollTo: scrollTo,\n    makePositioned: makePositioned,\n    undoPositioned: undoPositioned,\n    makeClipping: makeClipping,\n    undoClipping: undoClipping,\n    clonePosition: clonePosition\n  });\n  function isBody(element) {\n    return element.nodeName.toUpperCase() === 'BODY';\n  }\n  function isHtml(element) {\n    return element.nodeName.toUpperCase() === 'HTML';\n  }\n  function isDocument(element) {\n    return element.nodeType === Node.DOCUMENT_NODE;\n  }\n  function isDetached(element) {\n    return element !== document.body && !Element.descendantOf(element, document.body);\n  }\n  if ('getBoundingClientRect' in document.documentElement) {\n    Element.addMethods({\n      viewportOffset: function viewportOffset(element) {\n        element = $(element);\n        if (isDetached(element)) return new Element.Offset(0, 0);\n        var rect = element.getBoundingClientRect(),\n          docEl = document.documentElement;\n        return new Element.Offset(rect.left - docEl.clientLeft, rect.top - docEl.clientTop);\n      }\n    });\n  }\n})();\n(function () {\n  var IS_OLD_OPERA = Prototype.Browser.Opera && (0, _parseFloat2.default)(window.opera.version()) < 9.5;\n  var ROOT = null;\n  function getRootElement() {\n    if (ROOT) return ROOT;\n    ROOT = IS_OLD_OPERA ? document.body : document.documentElement;\n    return ROOT;\n  }\n  function getDimensions() {\n    return {\n      width: this.getWidth(),\n      height: this.getHeight()\n    };\n  }\n  function getWidth() {\n    return getRootElement().clientWidth;\n  }\n  function getHeight() {\n    return getRootElement().clientHeight;\n  }\n  function getScrollOffsets() {\n    var x = window.pageXOffset || document.documentElement.scrollLeft || document.body.scrollLeft;\n    var y = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop;\n    return new Element.Offset(x, y);\n  }\n  document.viewport = {\n    getDimensions: getDimensions,\n    getWidth: getWidth,\n    getHeight: getHeight,\n    getScrollOffsets: getScrollOffsets\n  };\n})();\nwindow.$$ = function () {\n  var expression = $A(arguments).join(', ');\n  return Prototype.Selector.select(expression, document);\n};\nPrototype.Selector = function () {\n  function select() {\n    throw new Error('Method \"Prototype.Selector.select\" must be defined.');\n  }\n  function match() {\n    throw new Error('Method \"Prototype.Selector.match\" must be defined.');\n  }\n  function find(elements, expression, index) {\n    index = index || 0;\n    var match = Prototype.Selector.match,\n      length = elements.length,\n      matchIndex = 0,\n      i;\n    for (i = 0; i < length; i++) {\n      if (match(elements[i], expression) && index == matchIndex++) {\n        return Element.extend(elements[i]);\n      }\n    }\n  }\n  function extendElements(elements) {\n    for (var i = 0, length = elements.length; i < length; i++) {\n      Element.extend(elements[i]);\n    }\n    return elements;\n  }\n  var K = Prototype.K;\n  return {\n    select: select,\n    match: match,\n    find: find,\n    extendElements: Element.extend === K ? K : extendElements,\n    extendElement: Element.extend\n  };\n}();\nPrototype._original_property = window.Sizzle;\n;\n(function () {\n  function fakeDefine(fn) {\n    Prototype._actual_sizzle = fn();\n  }\n  fakeDefine.amd = true;\n  if (typeof define !== 'undefined' && define.amd) {\n    Prototype._original_define = define;\n    Prototype._actual_sizzle = null;\n    window.define = fakeDefine;\n  }\n})();\n\n/*!\n * Sizzle CSS Selector Engine v1.10.18\n * http://sizzlejs.com/\n *\n * Copyright 2013 jQuery Foundation, Inc. and other contributors\n * Released under the MIT license\n * http://jquery.org/license\n *\n * Date: 2014-02-05\n */\n(function (window, _context40) {\n  var i,\n    support,\n    Expr,\n    getText,\n    isXML,\n    compile,\n    select,\n    outermostContext,\n    sortInput,\n    hasDuplicate,\n    setDocument,\n    document,\n    docElem,\n    documentIsHTML,\n    rbuggyQSA,\n    rbuggyMatches,\n    matches,\n    contains,\n    expando = \"sizzle\" + -new Date(),\n    preferredDoc = window.document,\n    dirruns = 0,\n    done = 0,\n    classCache = createCache(),\n    tokenCache = createCache(),\n    compilerCache = createCache(),\n    sortOrder = function sortOrder(a, b) {\n      if (a === b) {\n        hasDuplicate = true;\n      }\n      return 0;\n    },\n    strundefined = typeof undefined === \"undefined\" ? \"undefined\" : _typeof(undefined),\n    MAX_NEGATIVE = 1 << 31,\n    hasOwn = {}.hasOwnProperty,\n    arr = [],\n    pop = arr.pop,\n    push_native = arr.push,\n    push = arr.push,\n    slice = (0, _slice.default)(arr),\n    indexOf = (0, _indexOf.default)(arr) || function (elem) {\n      var i = 0,\n        len = this.length;\n      for (; i < len; i++) {\n        if (this[i] === elem) {\n          return i;\n        }\n      }\n      return -1;\n    },\n    booleans = \"checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped\",\n    whitespace = \"[\\\\x20\\\\t\\\\r\\\\n\\\\f]\",\n    characterEncoding = \"(?:\\\\\\\\.|[\\\\w-]|[^\\\\x00-\\\\xa0])+\",\n    identifier = characterEncoding.replace(\"w\", \"w#\"),\n    attributes = \"\\\\[\" + whitespace + \"*(\" + characterEncoding + \")\" + whitespace + \"*(?:([*^$|!~]?=)\" + whitespace + \"*(?:(['\\\"])((?:\\\\\\\\.|[^\\\\\\\\])*?)\\\\3|(\" + identifier + \")|)|)\" + whitespace + \"*\\\\]\",\n    pseudos = \":(\" + characterEncoding + \")(?:\\\\(((['\\\"])((?:\\\\\\\\.|[^\\\\\\\\])*?)\\\\3|((?:\\\\\\\\.|[^\\\\\\\\()[\\\\]]|\" + attributes.replace(3, 8) + \")*)|.*)\\\\)|)\",\n    rtrim = new RegExp(\"^\" + whitespace + \"+|((?:^|[^\\\\\\\\])(?:\\\\\\\\.)*)\" + whitespace + \"+$\", \"g\"),\n    rcomma = new RegExp(\"^\" + whitespace + \"*,\" + whitespace + \"*\"),\n    rcombinators = new RegExp(\"^\" + whitespace + \"*([>+~]|\" + whitespace + \")\" + whitespace + \"*\"),\n    rattributeQuotes = new RegExp(\"=\" + whitespace + \"*([^\\\\]'\\\"]*?)\" + whitespace + \"*\\\\]\", \"g\"),\n    rpseudo = new RegExp(pseudos),\n    ridentifier = new RegExp(\"^\" + identifier + \"$\"),\n    matchExpr = {\n      \"ID\": new RegExp(\"^#(\" + characterEncoding + \")\"),\n      \"CLASS\": new RegExp(\"^\\\\.(\" + characterEncoding + \")\"),\n      \"TAG\": new RegExp(\"^(\" + characterEncoding.replace(\"w\", \"w*\") + \")\"),\n      \"ATTR\": new RegExp(\"^\" + attributes),\n      \"PSEUDO\": new RegExp(\"^\" + pseudos),\n      \"CHILD\": new RegExp(\"^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\\\(\" + whitespace + \"*(even|odd|(([+-]|)(\\\\d*)n|)\" + whitespace + \"*(?:([+-]|)\" + whitespace + \"*(\\\\d+)|))\" + whitespace + \"*\\\\)|)\", \"i\"),\n      \"bool\": new RegExp(\"^(?:\" + booleans + \")$\", \"i\"),\n      \"needsContext\": new RegExp(\"^\" + whitespace + \"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\\\(\" + whitespace + \"*((?:-\\\\d)?\\\\d*)\" + whitespace + \"*\\\\)|)(?=[^-]|$)\", \"i\")\n    },\n    rinputs = /^(?:input|select|textarea|button)$/i,\n    rheader = /^h\\d$/i,\n    rnative = /^[^{]+\\{\\s*\\[native \\w/,\n    rquickExpr = /^(?:#([\\w-]+)|(\\w+)|\\.([\\w-]+))$/,\n    rsibling = /[+~]/,\n    rescape = /'|\\\\/g,\n    runescape = new RegExp(\"\\\\\\\\([\\\\da-f]{1,6}\" + whitespace + \"?|(\" + whitespace + \")|.)\", \"ig\"),\n    funescape = function funescape(_, escaped, escapedWhitespace) {\n      var high = \"0x\" + escaped - 0x10000;\n      return high !== high || escapedWhitespace ? escaped : high < 0 ? String.fromCharCode(high + 0x10000) : String.fromCharCode(high >> 10 | 0xD800, high & 0x3FF | 0xDC00);\n    };\n  try {\n    push.apply(arr = slice.call(preferredDoc.childNodes), preferredDoc.childNodes);\n    arr[preferredDoc.childNodes.length].nodeType;\n  } catch (e) {\n    push = {\n      apply: arr.length ? function (target, els) {\n        push_native.apply(target, slice.call(els));\n      } : function (target, els) {\n        var j = target.length,\n          i = 0;\n        while (target[j++] = els[i++]) {}\n        target.length = j - 1;\n      }\n    };\n  }\n  function Sizzle(selector, context, results, seed) {\n    var match, elem, m, nodeType, i, groups, old, nid, newContext, newSelector;\n    if ((context ? context.ownerDocument || context : preferredDoc) !== document) {\n      setDocument(context);\n    }\n    context = context || document;\n    results = results || [];\n    if (!selector || typeof selector !== \"string\") {\n      return results;\n    }\n    if ((nodeType = context.nodeType) !== 1 && nodeType !== 9) {\n      return [];\n    }\n    if (documentIsHTML && !seed) {\n      if (match = rquickExpr.exec(selector)) {\n        if (m = match[1]) {\n          if (nodeType === 9) {\n            elem = context.getElementById(m);\n            if (elem && elem.parentNode) {\n              if (elem.id === m) {\n                results.push(elem);\n                return results;\n              }\n            } else {\n              return results;\n            }\n          } else {\n            if (context.ownerDocument && (elem = context.ownerDocument.getElementById(m)) && contains(context, elem) && elem.id === m) {\n              results.push(elem);\n              return results;\n            }\n          }\n        } else if (match[2]) {\n          push.apply(results, context.getElementsByTagName(selector));\n          return results;\n        } else if ((m = match[3]) && support.getElementsByClassName && context.getElementsByClassName) {\n          push.apply(results, context.getElementsByClassName(m));\n          return results;\n        }\n      }\n      if (support.qsa && (!rbuggyQSA || !rbuggyQSA.test(selector))) {\n        nid = old = expando;\n        newContext = context;\n        newSelector = nodeType === 9 && selector;\n        if (nodeType === 1 && context.nodeName.toLowerCase() !== \"object\") {\n          groups = tokenize(selector);\n          if (old = context.getAttribute(\"id\")) {\n            nid = old.replace(rescape, \"\\\\$&\");\n          } else {\n            context.setAttribute(\"id\", nid);\n          }\n          nid = \"[id='\" + nid + \"'] \";\n          i = groups.length;\n          while (i--) {\n            groups[i] = nid + toSelector(groups[i]);\n          }\n          newContext = rsibling.test(selector) && testContext(context.parentNode) || context;\n          newSelector = groups.join(\",\");\n        }\n        if (newSelector) {\n          try {\n            push.apply(results, newContext.querySelectorAll(newSelector));\n            return results;\n          } catch (qsaError) {} finally {\n            if (!old) {\n              context.removeAttribute(\"id\");\n            }\n          }\n        }\n      }\n    }\n    return select(selector.replace(rtrim, \"$1\"), context, results, seed);\n  }\n\n  /**\n   * Create key-value caches of limited size\n   * @returns {Function(string, Object)} Returns the Object data after storing it on itself with\n   *\tproperty name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)\n   *\tdeleting the oldest entry\n   */\n  function createCache() {\n    var keys = [];\n    function cache(key, value) {\n      if (keys.push(key + \" \") > Expr.cacheLength) {\n        delete cache[keys.shift()];\n      }\n      return cache[key + \" \"] = value;\n    }\n    return cache;\n  }\n\n  /**\n   * Mark a function for special use by Sizzle\n   * @param {Function} fn The function to mark\n   */\n  function markFunction(fn) {\n    fn[expando] = true;\n    return fn;\n  }\n\n  /**\n   * Support testing using an element\n   * @param {Function} fn Passed the created div and expects a boolean result\n   */\n  function assert(fn) {\n    var div = document.createElement(\"div\");\n    try {\n      return !!fn(div);\n    } catch (e) {\n      return false;\n    } finally {\n      if (div.parentNode) {\n        div.parentNode.removeChild(div);\n      }\n      div = null;\n    }\n  }\n\n  /**\n   * Adds the same handler for all of the specified attrs\n   * @param {String} attrs Pipe-separated list of attributes\n   * @param {Function} handler The method that will be applied\n   */\n  function addHandle(attrs, handler) {\n    var arr = attrs.split(\"|\"),\n      i = attrs.length;\n    while (i--) {\n      Expr.attrHandle[arr[i]] = handler;\n    }\n  }\n\n  /**\n   * Checks document order of two siblings\n   * @param {Element} a\n   * @param {Element} b\n   * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b\n   */\n  function siblingCheck(a, b) {\n    var cur = b && a,\n      diff = cur && a.nodeType === 1 && b.nodeType === 1 && (~b.sourceIndex || MAX_NEGATIVE) - (~a.sourceIndex || MAX_NEGATIVE);\n    if (diff) {\n      return diff;\n    }\n    if (cur) {\n      while (cur = cur.nextSibling) {\n        if (cur === b) {\n          return -1;\n        }\n      }\n    }\n    return a ? 1 : -1;\n  }\n\n  /**\n   * Returns a function to use in pseudos for input types\n   * @param {String} type\n   */\n  function createInputPseudo(type) {\n    return function (elem) {\n      var name = elem.nodeName.toLowerCase();\n      return name === \"input\" && elem.type === type;\n    };\n  }\n\n  /**\n   * Returns a function to use in pseudos for buttons\n   * @param {String} type\n   */\n  function createButtonPseudo(type) {\n    return function (elem) {\n      var name = elem.nodeName.toLowerCase();\n      return (name === \"input\" || name === \"button\") && elem.type === type;\n    };\n  }\n\n  /**\n   * Returns a function to use in pseudos for positionals\n   * @param {Function} fn\n   */\n  function createPositionalPseudo(fn) {\n    return markFunction(function (argument) {\n      argument = +argument;\n      return markFunction(function (seed, matches) {\n        var j,\n          matchIndexes = fn([], seed.length, argument),\n          i = matchIndexes.length;\n        while (i--) {\n          if (seed[j = matchIndexes[i]]) {\n            seed[j] = !(matches[j] = seed[j]);\n          }\n        }\n      });\n    });\n  }\n\n  /**\n   * Checks a node for validity as a Sizzle context\n   * @param {Element|Object=} context\n   * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value\n   */\n  function testContext(context) {\n    return context && _typeof(context.getElementsByTagName) !== strundefined && context;\n  }\n  support = Sizzle.support = {};\n\n  /**\n   * Detects XML nodes\n   * @param {Element|Object} elem An element or a document\n   * @returns {Boolean} True iff elem is a non-HTML XML node\n   */\n  isXML = Sizzle.isXML = function (elem) {\n    var documentElement = elem && (elem.ownerDocument || elem).documentElement;\n    return documentElement ? documentElement.nodeName !== \"HTML\" : false;\n  };\n\n  /**\n   * Sets document-related variables once based on the current document\n   * @param {Element|Object} [doc] An element or document object to use to set the document\n   * @returns {Object} Returns the current document\n   */\n  setDocument = Sizzle.setDocument = function (node) {\n    var hasCompare,\n      doc = node ? node.ownerDocument || node : preferredDoc,\n      parent = doc.defaultView;\n    if (doc === document || doc.nodeType !== 9 || !doc.documentElement) {\n      return document;\n    }\n    document = doc;\n    docElem = doc.documentElement;\n    documentIsHTML = !isXML(doc);\n    if (parent && parent !== parent.top) {\n      if (parent.addEventListener) {\n        parent.addEventListener(\"unload\", function () {\n          setDocument();\n        }, false);\n      } else if (parent.attachEvent) {\n        parent.attachEvent(\"onunload\", function () {\n          setDocument();\n        });\n      }\n    }\n\n    /* Attributes\n    ---------------------------------------------------------------------- */\n\n    support.attributes = assert(function (div) {\n      div.className = \"i\";\n      return !div.getAttribute(\"className\");\n    });\n\n    /* getElement(s)By*\n    ---------------------------------------------------------------------- */\n\n    support.getElementsByTagName = assert(function (div) {\n      div.appendChild(doc.createComment(\"\"));\n      return !div.getElementsByTagName(\"*\").length;\n    });\n    support.getElementsByClassName = rnative.test(doc.getElementsByClassName) && assert(function (div) {\n      div.innerHTML = \"<div class='a'></div><div class='a i'></div>\";\n      div.firstChild.className = \"i\";\n      return div.getElementsByClassName(\"i\").length === 2;\n    });\n    support.getById = assert(function (div) {\n      docElem.appendChild(div).id = expando;\n      return !doc.getElementsByName || !doc.getElementsByName(expando).length;\n    });\n    if (support.getById) {\n      (0, _find.default)(Expr)[\"ID\"] = function (id, context) {\n        if (_typeof(context.getElementById) !== strundefined && documentIsHTML) {\n          var m = context.getElementById(id);\n          return m && m.parentNode ? [m] : [];\n        }\n      };\n      (0, _filter.default)(Expr)[\"ID\"] = function (id) {\n        var attrId = id.replace(runescape, funescape);\n        return function (elem) {\n          return elem.getAttribute(\"id\") === attrId;\n        };\n      };\n    } else {\n      delete (0, _find.default)(Expr)[\"ID\"];\n      (0, _filter.default)(Expr)[\"ID\"] = function (id) {\n        var attrId = id.replace(runescape, funescape);\n        return function (elem) {\n          var node = _typeof(elem.getAttributeNode) !== strundefined && elem.getAttributeNode(\"id\");\n          return node && node.value === attrId;\n        };\n      };\n    }\n    (0, _find.default)(Expr)[\"TAG\"] = support.getElementsByTagName ? function (tag, context) {\n      if (_typeof(context.getElementsByTagName) !== strundefined) {\n        return context.getElementsByTagName(tag);\n      }\n    } : function (tag, context) {\n      var elem,\n        tmp = [],\n        i = 0,\n        results = context.getElementsByTagName(tag);\n      if (tag === \"*\") {\n        while (elem = results[i++]) {\n          if (elem.nodeType === 1) {\n            tmp.push(elem);\n          }\n        }\n        return tmp;\n      }\n      return results;\n    };\n    (0, _find.default)(Expr)[\"CLASS\"] = support.getElementsByClassName && function (className, context) {\n      if (_typeof(context.getElementsByClassName) !== strundefined && documentIsHTML) {\n        return context.getElementsByClassName(className);\n      }\n    };\n\n    /* QSA/matchesSelector\n    ---------------------------------------------------------------------- */\n\n    rbuggyMatches = [];\n    rbuggyQSA = [];\n    if (support.qsa = rnative.test(doc.querySelectorAll)) {\n      assert(function (div) {\n        div.innerHTML = \"<select t=''><option selected=''></option></select>\";\n        if (div.querySelectorAll(\"[t^='']\").length) {\n          rbuggyQSA.push(\"[*^$]=\" + whitespace + \"*(?:''|\\\"\\\")\");\n        }\n        if (!div.querySelectorAll(\"[selected]\").length) {\n          rbuggyQSA.push(\"\\\\[\" + whitespace + \"*(?:value|\" + booleans + \")\");\n        }\n        if (!div.querySelectorAll(\":checked\").length) {\n          rbuggyQSA.push(\":checked\");\n        }\n      });\n      assert(function (div) {\n        var input = doc.createElement(\"input\");\n        input.setAttribute(\"type\", \"hidden\");\n        div.appendChild(input).setAttribute(\"name\", \"D\");\n        if (div.querySelectorAll(\"[name=d]\").length) {\n          rbuggyQSA.push(\"name\" + whitespace + \"*[*^$|!~]?=\");\n        }\n        if (!div.querySelectorAll(\":enabled\").length) {\n          rbuggyQSA.push(\":enabled\", \":disabled\");\n        }\n        div.querySelectorAll(\"*,:x\");\n        rbuggyQSA.push(\",.*:\");\n      });\n    }\n    if (support.matchesSelector = rnative.test(matches = docElem.webkitMatchesSelector || docElem.mozMatchesSelector || docElem.oMatchesSelector || docElem.msMatchesSelector)) {\n      assert(function (div) {\n        support.disconnectedMatch = matches.call(div, \"div\");\n        matches.call(div, \"[s!='']:x\");\n        rbuggyMatches.push(\"!=\", pseudos);\n      });\n    }\n    rbuggyQSA = rbuggyQSA.length && new RegExp(rbuggyQSA.join(\"|\"));\n    rbuggyMatches = rbuggyMatches.length && new RegExp(rbuggyMatches.join(\"|\"));\n\n    /* Contains\n    ---------------------------------------------------------------------- */\n    hasCompare = rnative.test(docElem.compareDocumentPosition);\n    contains = hasCompare || rnative.test(docElem.contains) ? function (a, b) {\n      var adown = a.nodeType === 9 ? a.documentElement : a,\n        bup = b && b.parentNode;\n      return a === bup || !!(bup && bup.nodeType === 1 && (adown.contains ? adown.contains(bup) : a.compareDocumentPosition && a.compareDocumentPosition(bup) & 16));\n    } : function (a, b) {\n      if (b) {\n        while (b = b.parentNode) {\n          if (b === a) {\n            return true;\n          }\n        }\n      }\n      return false;\n    };\n\n    /* Sorting\n    ---------------------------------------------------------------------- */\n\n    sortOrder = hasCompare ? function (a, b) {\n      if (a === b) {\n        hasDuplicate = true;\n        return 0;\n      }\n      var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;\n      if (compare) {\n        return compare;\n      }\n      compare = (a.ownerDocument || a) === (b.ownerDocument || b) ? a.compareDocumentPosition(b) : 1;\n      if (compare & 1 || !support.sortDetached && b.compareDocumentPosition(a) === compare) {\n        if (a === doc || a.ownerDocument === preferredDoc && contains(preferredDoc, a)) {\n          return -1;\n        }\n        if (b === doc || b.ownerDocument === preferredDoc && contains(preferredDoc, b)) {\n          return 1;\n        }\n        return sortInput ? indexOf.call(sortInput, a) - indexOf.call(sortInput, b) : 0;\n      }\n      return compare & 4 ? -1 : 1;\n    } : function (a, b) {\n      if (a === b) {\n        hasDuplicate = true;\n        return 0;\n      }\n      var cur,\n        i = 0,\n        aup = a.parentNode,\n        bup = b.parentNode,\n        ap = [a],\n        bp = [b];\n      if (!aup || !bup) {\n        return a === doc ? -1 : b === doc ? 1 : aup ? -1 : bup ? 1 : sortInput ? indexOf.call(sortInput, a) - indexOf.call(sortInput, b) : 0;\n      } else if (aup === bup) {\n        return siblingCheck(a, b);\n      }\n      cur = a;\n      while (cur = cur.parentNode) {\n        ap.unshift(cur);\n      }\n      cur = b;\n      while (cur = cur.parentNode) {\n        bp.unshift(cur);\n      }\n      while (ap[i] === bp[i]) {\n        i++;\n      }\n      return i ? siblingCheck(ap[i], bp[i]) : ap[i] === preferredDoc ? -1 : bp[i] === preferredDoc ? 1 : 0;\n    };\n    return doc;\n  };\n  Sizzle.matches = function (expr, elements) {\n    return Sizzle(expr, null, null, elements);\n  };\n  Sizzle.matchesSelector = function (elem, expr) {\n    if ((elem.ownerDocument || elem) !== document) {\n      setDocument(elem);\n    }\n    expr = expr.replace(rattributeQuotes, \"='$1']\");\n    if (support.matchesSelector && documentIsHTML && (!rbuggyMatches || !rbuggyMatches.test(expr)) && (!rbuggyQSA || !rbuggyQSA.test(expr))) {\n      try {\n        var ret = matches.call(elem, expr);\n        if (ret || support.disconnectedMatch || elem.document && elem.document.nodeType !== 11) {\n          return ret;\n        }\n      } catch (e) {}\n    }\n    return Sizzle(expr, document, null, [elem]).length > 0;\n  };\n  Sizzle.contains = function (context, elem) {\n    if ((context.ownerDocument || context) !== document) {\n      setDocument(context);\n    }\n    return contains(context, elem);\n  };\n  Sizzle.attr = function (elem, name) {\n    if ((elem.ownerDocument || elem) !== document) {\n      setDocument(elem);\n    }\n    var fn = Expr.attrHandle[name.toLowerCase()],\n      val = fn && hasOwn.call(Expr.attrHandle, name.toLowerCase()) ? fn(elem, name, !documentIsHTML) : undefined;\n    return val !== undefined ? val : support.attributes || !documentIsHTML ? elem.getAttribute(name) : (val = elem.getAttributeNode(name)) && val.specified ? val.value : null;\n  };\n  Sizzle.error = function (msg) {\n    throw new Error(\"Syntax error, unrecognized expression: \" + msg);\n  };\n\n  /**\n   * Document sorting and removing duplicates\n   * @param {ArrayLike} results\n   */\n  Sizzle.uniqueSort = function (results) {\n    var elem,\n      duplicates = [],\n      j = 0,\n      i = 0;\n    hasDuplicate = !support.detectDuplicates;\n    sortInput = !support.sortStable && (0, _slice.default)(results).call(results, 0);\n    (0, _sort.default)(results).call(results, sortOrder);\n    if (hasDuplicate) {\n      while (elem = results[i++]) {\n        if (elem === results[i]) {\n          j = duplicates.push(i);\n        }\n      }\n      while (j--) {\n        (0, _splice.default)(results).call(results, duplicates[j], 1);\n      }\n    }\n    sortInput = null;\n    return results;\n  };\n\n  /**\n   * Utility function for retrieving the text value of an array of DOM nodes\n   * @param {Array|Element} elem\n   */\n  getText = Sizzle.getText = function (elem) {\n    var node,\n      ret = \"\",\n      i = 0,\n      nodeType = elem.nodeType;\n    if (!nodeType) {\n      while (node = elem[i++]) {\n        ret += getText(node);\n      }\n    } else if (nodeType === 1 || nodeType === 9 || nodeType === 11) {\n      if (typeof elem.textContent === \"string\") {\n        return elem.textContent;\n      } else {\n        for (elem = elem.firstChild; elem; elem = elem.nextSibling) {\n          ret += getText(elem);\n        }\n      }\n    } else if (nodeType === 3 || nodeType === 4) {\n      return elem.nodeValue;\n    }\n    return ret;\n  };\n  Expr = Sizzle.selectors = {\n    cacheLength: 50,\n    createPseudo: markFunction,\n    match: matchExpr,\n    attrHandle: {},\n    find: {},\n    relative: {\n      \">\": {\n        dir: \"parentNode\",\n        first: true\n      },\n      \" \": {\n        dir: \"parentNode\"\n      },\n      \"+\": {\n        dir: \"previousSibling\",\n        first: true\n      },\n      \"~\": {\n        dir: \"previousSibling\"\n      }\n    },\n    preFilter: {\n      \"ATTR\": function ATTR(match) {\n        match[1] = match[1].replace(runescape, funescape);\n        match[3] = (match[4] || match[5] || \"\").replace(runescape, funescape);\n        if (match[2] === \"~=\") {\n          match[3] = \" \" + match[3] + \" \";\n        }\n        return (0, _slice.default)(match).call(match, 0, 4);\n      },\n      \"CHILD\": function CHILD(match) {\n        var _context33;\n        /* matches from matchExpr[\"CHILD\"]\n        \t1 type (only|nth|...)\n        \t2 what (child|of-type)\n        \t3 argument (even|odd|\\d*|\\d*n([+-]\\d+)?|...)\n        \t4 xn-component of xn+y argument ([+-]?\\d*n|)\n        \t5 sign of xn-component\n        \t6 x of xn-component\n        \t7 sign of y-component\n        \t8 y of y-component\n        */\n        match[1] = match[1].toLowerCase();\n        if ((0, _slice.default)(_context33 = match[1]).call(_context33, 0, 3) === \"nth\") {\n          if (!match[3]) {\n            Sizzle.error(match[0]);\n          }\n          match[4] = +(match[4] ? match[5] + (match[6] || 1) : 2 * (match[3] === \"even\" || match[3] === \"odd\"));\n          match[5] = +(match[7] + match[8] || match[3] === \"odd\");\n        } else if (match[3]) {\n          Sizzle.error(match[0]);\n        }\n        return match;\n      },\n      \"PSEUDO\": function PSEUDO(match) {\n        var excess,\n          unquoted = !match[5] && match[2];\n        if (matchExpr[\"CHILD\"].test(match[0])) {\n          return null;\n        }\n        if (match[3] && match[4] !== undefined) {\n          match[2] = match[4];\n        } else if (unquoted && rpseudo.test(unquoted) && (excess = tokenize(unquoted, true)) && (excess = (0, _indexOf.default)(unquoted).call(unquoted, \")\", unquoted.length - excess) - unquoted.length)) {\n          var _context34;\n          match[0] = (0, _slice.default)(_context34 = match[0]).call(_context34, 0, excess);\n          match[2] = (0, _slice.default)(unquoted).call(unquoted, 0, excess);\n        }\n        return (0, _slice.default)(match).call(match, 0, 3);\n      }\n    },\n    filter: {\n      \"TAG\": function TAG(nodeNameSelector) {\n        var nodeName = nodeNameSelector.replace(runescape, funescape).toLowerCase();\n        return nodeNameSelector === \"*\" ? function () {\n          return true;\n        } : function (elem) {\n          return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;\n        };\n      },\n      \"CLASS\": function CLASS(className) {\n        var pattern = classCache[className + \" \"];\n        return pattern || (pattern = new RegExp(\"(^|\" + whitespace + \")\" + className + \"(\" + whitespace + \"|$)\")) && classCache(className, function (elem) {\n          return pattern.test(typeof elem.className === \"string\" && elem.className || _typeof(elem.getAttribute) !== strundefined && elem.getAttribute(\"class\") || \"\");\n        });\n      },\n      \"ATTR\": function ATTR(name, operator, check) {\n        return function (elem) {\n          var _context35;\n          var result = Sizzle.attr(elem, name);\n          if (result == null) {\n            return operator === \"!=\";\n          }\n          if (!operator) {\n            return true;\n          }\n          result += \"\";\n          return operator === \"=\" ? result === check : operator === \"!=\" ? result !== check : operator === \"^=\" ? check && (0, _indexOf.default)(result).call(result, check) === 0 : operator === \"*=\" ? check && (0, _indexOf.default)(result).call(result, check) > -1 : operator === \"$=\" ? check && (0, _slice.default)(result).call(result, -check.length) === check : operator === \"~=\" ? (0, _indexOf.default)(_context35 = \" \" + result + \" \").call(_context35, check) > -1 : operator === \"|=\" ? result === check || (0, _slice.default)(result).call(result, 0, check.length + 1) === check + \"-\" : false;\n        };\n      },\n      \"CHILD\": function CHILD(type, what, argument, first, last) {\n        var simple = (0, _slice.default)(type).call(type, 0, 3) !== \"nth\",\n          forward = (0, _slice.default)(type).call(type, -4) !== \"last\",\n          ofType = what === \"of-type\";\n        return first === 1 && last === 0 ? function (elem) {\n          return !!elem.parentNode;\n        } : function (elem, context, xml) {\n          var cache,\n            outerCache,\n            node,\n            diff,\n            nodeIndex,\n            start,\n            dir = simple !== forward ? \"nextSibling\" : \"previousSibling\",\n            parent = elem.parentNode,\n            name = ofType && elem.nodeName.toLowerCase(),\n            useCache = !xml && !ofType;\n          if (parent) {\n            if (simple) {\n              while (dir) {\n                node = elem;\n                while (node = node[dir]) {\n                  if (ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1) {\n                    return false;\n                  }\n                }\n                start = dir = type === \"only\" && !start && \"nextSibling\";\n              }\n              return true;\n            }\n            start = [forward ? parent.firstChild : parent.lastChild];\n            if (forward && useCache) {\n              outerCache = parent[expando] || (parent[expando] = {});\n              cache = outerCache[type] || [];\n              nodeIndex = cache[0] === dirruns && cache[1];\n              diff = cache[0] === dirruns && cache[2];\n              node = nodeIndex && parent.childNodes[nodeIndex];\n              while (node = ++nodeIndex && node && node[dir] || (diff = nodeIndex = 0) || start.pop()) {\n                if (node.nodeType === 1 && ++diff && node === elem) {\n                  outerCache[type] = [dirruns, nodeIndex, diff];\n                  break;\n                }\n              }\n            } else if (useCache && (cache = (elem[expando] || (elem[expando] = {}))[type]) && cache[0] === dirruns) {\n              diff = cache[1];\n            } else {\n              while (node = ++nodeIndex && node && node[dir] || (diff = nodeIndex = 0) || start.pop()) {\n                if ((ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1) && ++diff) {\n                  if (useCache) {\n                    (node[expando] || (node[expando] = {}))[type] = [dirruns, diff];\n                  }\n                  if (node === elem) {\n                    break;\n                  }\n                }\n              }\n            }\n            diff -= last;\n            return diff === first || diff % first === 0 && diff / first >= 0;\n          }\n        };\n      },\n      \"PSEUDO\": function PSEUDO(pseudo, argument) {\n        var args,\n          fn = Expr.pseudos[pseudo] || Expr.setFilters[pseudo.toLowerCase()] || Sizzle.error(\"unsupported pseudo: \" + pseudo);\n        if (fn[expando]) {\n          return fn(argument);\n        }\n        if (fn.length > 1) {\n          args = [pseudo, pseudo, \"\", argument];\n          return Expr.setFilters.hasOwnProperty(pseudo.toLowerCase()) ? markFunction(function (seed, matches) {\n            var idx,\n              matched = fn(seed, argument),\n              i = matched.length;\n            while (i--) {\n              idx = indexOf.call(seed, matched[i]);\n              seed[idx] = !(matches[idx] = matched[i]);\n            }\n          }) : function (elem) {\n            return fn(elem, 0, args);\n          };\n        }\n        return fn;\n      }\n    },\n    pseudos: {\n      \"not\": markFunction(function (selector) {\n        var input = [],\n          results = [],\n          matcher = compile(selector.replace(rtrim, \"$1\"));\n        return matcher[expando] ? markFunction(function (seed, matches, context, xml) {\n          var elem,\n            unmatched = matcher(seed, null, xml, []),\n            i = seed.length;\n          while (i--) {\n            if (elem = unmatched[i]) {\n              seed[i] = !(matches[i] = elem);\n            }\n          }\n        }) : function (elem, context, xml) {\n          input[0] = elem;\n          matcher(input, null, xml, results);\n          return !results.pop();\n        };\n      }),\n      \"has\": markFunction(function (selector) {\n        return function (elem) {\n          return Sizzle(selector, elem).length > 0;\n        };\n      }),\n      \"contains\": markFunction(function (text) {\n        return function (elem) {\n          var _context36;\n          return (0, _indexOf.default)(_context36 = elem.textContent || elem.innerText || getText(elem)).call(_context36, text) > -1;\n        };\n      }),\n      \"lang\": markFunction(function (lang) {\n        if (!ridentifier.test(lang || \"\")) {\n          Sizzle.error(\"unsupported lang: \" + lang);\n        }\n        lang = lang.replace(runescape, funescape).toLowerCase();\n        return function (elem) {\n          var elemLang;\n          do {\n            if (elemLang = documentIsHTML ? elem.lang : elem.getAttribute(\"xml:lang\") || elem.getAttribute(\"lang\")) {\n              elemLang = elemLang.toLowerCase();\n              return elemLang === lang || (0, _indexOf.default)(elemLang).call(elemLang, lang + \"-\") === 0;\n            }\n          } while ((elem = elem.parentNode) && elem.nodeType === 1);\n          return false;\n        };\n      }),\n      \"target\": function target(elem) {\n        var hash = window.location && window.location.hash;\n        return hash && (0, _slice.default)(hash).call(hash, 1) === elem.id;\n      },\n      \"root\": function root(elem) {\n        return elem === docElem;\n      },\n      \"focus\": function focus(elem) {\n        return elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);\n      },\n      \"enabled\": function enabled(elem) {\n        return elem.disabled === false;\n      },\n      \"disabled\": function disabled(elem) {\n        return elem.disabled === true;\n      },\n      \"checked\": function checked(elem) {\n        var nodeName = elem.nodeName.toLowerCase();\n        return nodeName === \"input\" && !!elem.checked || nodeName === \"option\" && !!elem.selected;\n      },\n      \"selected\": function selected(elem) {\n        if (elem.parentNode) {\n          elem.parentNode.selectedIndex;\n        }\n        return elem.selected === true;\n      },\n      \"empty\": function empty(elem) {\n        for (elem = elem.firstChild; elem; elem = elem.nextSibling) {\n          if (elem.nodeType < 6) {\n            return false;\n          }\n        }\n        return true;\n      },\n      \"parent\": function parent(elem) {\n        return !Expr.pseudos[\"empty\"](elem);\n      },\n      \"header\": function header(elem) {\n        return rheader.test(elem.nodeName);\n      },\n      \"input\": function input(elem) {\n        return rinputs.test(elem.nodeName);\n      },\n      \"button\": function button(elem) {\n        var name = elem.nodeName.toLowerCase();\n        return name === \"input\" && elem.type === \"button\" || name === \"button\";\n      },\n      \"text\": function text(elem) {\n        var attr;\n        return elem.nodeName.toLowerCase() === \"input\" && elem.type === \"text\" && ((attr = elem.getAttribute(\"type\")) == null || attr.toLowerCase() === \"text\");\n      },\n      \"first\": createPositionalPseudo(function () {\n        return [0];\n      }),\n      \"last\": createPositionalPseudo(function (matchIndexes, length) {\n        return [length - 1];\n      }),\n      \"eq\": createPositionalPseudo(function (matchIndexes, length, argument) {\n        return [argument < 0 ? argument + length : argument];\n      }),\n      \"even\": createPositionalPseudo(function (matchIndexes, length) {\n        var i = 0;\n        for (; i < length; i += 2) {\n          matchIndexes.push(i);\n        }\n        return matchIndexes;\n      }),\n      \"odd\": createPositionalPseudo(function (matchIndexes, length) {\n        var i = 1;\n        for (; i < length; i += 2) {\n          matchIndexes.push(i);\n        }\n        return matchIndexes;\n      }),\n      \"lt\": createPositionalPseudo(function (matchIndexes, length, argument) {\n        var i = argument < 0 ? argument + length : argument;\n        for (; --i >= 0;) {\n          matchIndexes.push(i);\n        }\n        return matchIndexes;\n      }),\n      \"gt\": createPositionalPseudo(function (matchIndexes, length, argument) {\n        var i = argument < 0 ? argument + length : argument;\n        for (; ++i < length;) {\n          matchIndexes.push(i);\n        }\n        return matchIndexes;\n      })\n    }\n  };\n  Expr.pseudos[\"nth\"] = Expr.pseudos[\"eq\"];\n  for (i in {\n    radio: true,\n    checkbox: true,\n    file: true,\n    password: true,\n    image: true\n  }) {\n    Expr.pseudos[i] = createInputPseudo(i);\n  }\n  for (i in {\n    submit: true,\n    reset: true\n  }) {\n    Expr.pseudos[i] = createButtonPseudo(i);\n  }\n  function setFilters() {}\n  setFilters.prototype = Expr.filters = Expr.pseudos;\n  Expr.setFilters = new setFilters();\n  function tokenize(selector, parseOnly) {\n    var _context37;\n    var matched,\n      match,\n      tokens,\n      type,\n      soFar,\n      groups,\n      preFilters,\n      cached = tokenCache[selector + \" \"];\n    if (cached) {\n      return parseOnly ? 0 : (0, _slice.default)(cached).call(cached, 0);\n    }\n    soFar = selector;\n    groups = [];\n    preFilters = Expr.preFilter;\n    while (soFar) {\n      if (!matched || (match = rcomma.exec(soFar))) {\n        if (match) {\n          soFar = (0, _slice.default)(soFar).call(soFar, match[0].length) || soFar;\n        }\n        groups.push(tokens = []);\n      }\n      matched = false;\n      if (match = rcombinators.exec(soFar)) {\n        matched = match.shift();\n        tokens.push({\n          value: matched,\n          type: match[0].replace(rtrim, \" \")\n        });\n        soFar = (0, _slice.default)(soFar).call(soFar, matched.length);\n      }\n      for (type in (0, _filter.default)(Expr)) {\n        if ((match = matchExpr[type].exec(soFar)) && (!preFilters[type] || (match = preFilters[type](match)))) {\n          matched = match.shift();\n          tokens.push({\n            value: matched,\n            type: type,\n            matches: match\n          });\n          soFar = (0, _slice.default)(soFar).call(soFar, matched.length);\n        }\n      }\n      if (!matched) {\n        break;\n      }\n    }\n    return parseOnly ? soFar.length : soFar ? Sizzle.error(selector) : (0, _slice.default)(_context37 = tokenCache(selector, groups)).call(_context37, 0);\n  }\n  function toSelector(tokens) {\n    var i = 0,\n      len = tokens.length,\n      selector = \"\";\n    for (; i < len; i++) {\n      selector += tokens[i].value;\n    }\n    return selector;\n  }\n  function addCombinator(matcher, combinator, base) {\n    var dir = combinator.dir,\n      checkNonElements = base && dir === \"parentNode\",\n      doneName = done++;\n    return combinator.first ? function (elem, context, xml) {\n      while (elem = elem[dir]) {\n        if (elem.nodeType === 1 || checkNonElements) {\n          return matcher(elem, context, xml);\n        }\n      }\n    } : function (elem, context, xml) {\n      var oldCache,\n        outerCache,\n        newCache = [dirruns, doneName];\n      if (xml) {\n        while (elem = elem[dir]) {\n          if (elem.nodeType === 1 || checkNonElements) {\n            if (matcher(elem, context, xml)) {\n              return true;\n            }\n          }\n        }\n      } else {\n        while (elem = elem[dir]) {\n          if (elem.nodeType === 1 || checkNonElements) {\n            outerCache = elem[expando] || (elem[expando] = {});\n            if ((oldCache = outerCache[dir]) && oldCache[0] === dirruns && oldCache[1] === doneName) {\n              return newCache[2] = oldCache[2];\n            } else {\n              outerCache[dir] = newCache;\n              if (newCache[2] = matcher(elem, context, xml)) {\n                return true;\n              }\n            }\n          }\n        }\n      }\n    };\n  }\n  function elementMatcher(matchers) {\n    return matchers.length > 1 ? function (elem, context, xml) {\n      var i = matchers.length;\n      while (i--) {\n        if (!matchers[i](elem, context, xml)) {\n          return false;\n        }\n      }\n      return true;\n    } : matchers[0];\n  }\n  function multipleContexts(selector, contexts, results) {\n    var i = 0,\n      len = contexts.length;\n    for (; i < len; i++) {\n      Sizzle(selector, contexts[i], results);\n    }\n    return results;\n  }\n  function condense(unmatched, map, filter, context, xml) {\n    var elem,\n      newUnmatched = [],\n      i = 0,\n      len = unmatched.length,\n      mapped = map != null;\n    for (; i < len; i++) {\n      if (elem = unmatched[i]) {\n        if (!filter || filter(elem, context, xml)) {\n          newUnmatched.push(elem);\n          if (mapped) {\n            map.push(i);\n          }\n        }\n      }\n    }\n    return newUnmatched;\n  }\n  function setMatcher(preFilter, selector, matcher, postFilter, postFinder, postSelector) {\n    if (postFilter && !postFilter[expando]) {\n      postFilter = setMatcher(postFilter);\n    }\n    if (postFinder && !postFinder[expando]) {\n      postFinder = setMatcher(postFinder, postSelector);\n    }\n    return markFunction(function (seed, results, context, xml) {\n      var temp,\n        i,\n        elem,\n        preMap = [],\n        postMap = [],\n        preexisting = results.length,\n        elems = seed || multipleContexts(selector || \"*\", context.nodeType ? [context] : context, []),\n        matcherIn = preFilter && (seed || !selector) ? condense(elems, preMap, preFilter, context, xml) : elems,\n        matcherOut = matcher ? postFinder || (seed ? preFilter : preexisting || postFilter) ? [] : results : matcherIn;\n      if (matcher) {\n        matcher(matcherIn, matcherOut, context, xml);\n      }\n      if (postFilter) {\n        temp = condense(matcherOut, postMap);\n        postFilter(temp, [], context, xml);\n        i = temp.length;\n        while (i--) {\n          if (elem = temp[i]) {\n            matcherOut[postMap[i]] = !(matcherIn[postMap[i]] = elem);\n          }\n        }\n      }\n      if (seed) {\n        if (postFinder || preFilter) {\n          if (postFinder) {\n            temp = [];\n            i = matcherOut.length;\n            while (i--) {\n              if (elem = matcherOut[i]) {\n                temp.push(matcherIn[i] = elem);\n              }\n            }\n            postFinder(null, matcherOut = [], temp, xml);\n          }\n          i = matcherOut.length;\n          while (i--) {\n            if ((elem = matcherOut[i]) && (temp = postFinder ? indexOf.call(seed, elem) : preMap[i]) > -1) {\n              seed[temp] = !(results[temp] = elem);\n            }\n          }\n        }\n      } else {\n        matcherOut = condense(matcherOut === results ? (0, _splice.default)(matcherOut).call(matcherOut, preexisting, matcherOut.length) : matcherOut);\n        if (postFinder) {\n          postFinder(null, results, matcherOut, xml);\n        } else {\n          push.apply(results, matcherOut);\n        }\n      }\n    });\n  }\n  function matcherFromTokens(tokens) {\n    var checkContext,\n      matcher,\n      j,\n      len = tokens.length,\n      leadingRelative = Expr.relative[tokens[0].type],\n      implicitRelative = leadingRelative || Expr.relative[\" \"],\n      i = leadingRelative ? 1 : 0,\n      matchContext = addCombinator(function (elem) {\n        return elem === checkContext;\n      }, implicitRelative, true),\n      matchAnyContext = addCombinator(function (elem) {\n        return indexOf.call(checkContext, elem) > -1;\n      }, implicitRelative, true),\n      matchers = [function (elem, context, xml) {\n        return !leadingRelative && (xml || context !== outermostContext) || ((checkContext = context).nodeType ? matchContext(elem, context, xml) : matchAnyContext(elem, context, xml));\n      }];\n    for (; i < len; i++) {\n      if (matcher = Expr.relative[tokens[i].type]) {\n        matchers = [addCombinator(elementMatcher(matchers), matcher)];\n      } else {\n        matcher = (0, _filter.default)(Expr)[tokens[i].type].apply(null, tokens[i].matches);\n        if (matcher[expando]) {\n          var _context38;\n          j = ++i;\n          for (; j < len; j++) {\n            if (Expr.relative[tokens[j].type]) {\n              break;\n            }\n          }\n          return setMatcher(i > 1 && elementMatcher(matchers), i > 1 && toSelector((0, _concat.default)(_context38 = (0, _slice.default)(tokens).call(tokens, 0, i - 1)).call(_context38, {\n            value: tokens[i - 2].type === \" \" ? \"*\" : \"\"\n          })).replace(rtrim, \"$1\"), matcher, i < j && matcherFromTokens((0, _slice.default)(tokens).call(tokens, i, j)), j < len && matcherFromTokens(tokens = (0, _slice.default)(tokens).call(tokens, j)), j < len && toSelector(tokens));\n        }\n        matchers.push(matcher);\n      }\n    }\n    return elementMatcher(matchers);\n  }\n  function matcherFromGroupMatchers(elementMatchers, setMatchers) {\n    var bySet = setMatchers.length > 0,\n      byElement = elementMatchers.length > 0,\n      superMatcher = function superMatcher(seed, context, xml, results, outermost) {\n        var elem,\n          j,\n          matcher,\n          matchedCount = 0,\n          i = \"0\",\n          unmatched = seed && [],\n          setMatched = [],\n          contextBackup = outermostContext,\n          elems = seed || byElement && (0, _find.default)(Expr)[\"TAG\"](\"*\", outermost),\n          dirrunsUnique = dirruns += contextBackup == null ? 1 : Math.random() || 0.1,\n          len = elems.length;\n        if (outermost) {\n          outermostContext = context !== document && context;\n        }\n        for (; i !== len && (elem = elems[i]) != null; i++) {\n          if (byElement && elem) {\n            j = 0;\n            while (matcher = elementMatchers[j++]) {\n              if (matcher(elem, context, xml)) {\n                results.push(elem);\n                break;\n              }\n            }\n            if (outermost) {\n              dirruns = dirrunsUnique;\n            }\n          }\n          if (bySet) {\n            if (elem = !matcher && elem) {\n              matchedCount--;\n            }\n            if (seed) {\n              unmatched.push(elem);\n            }\n          }\n        }\n        matchedCount += i;\n        if (bySet && i !== matchedCount) {\n          j = 0;\n          while (matcher = setMatchers[j++]) {\n            matcher(unmatched, setMatched, context, xml);\n          }\n          if (seed) {\n            if (matchedCount > 0) {\n              while (i--) {\n                if (!(unmatched[i] || setMatched[i])) {\n                  setMatched[i] = pop.call(results);\n                }\n              }\n            }\n            setMatched = condense(setMatched);\n          }\n          push.apply(results, setMatched);\n          if (outermost && !seed && setMatched.length > 0 && matchedCount + setMatchers.length > 1) {\n            Sizzle.uniqueSort(results);\n          }\n        }\n        if (outermost) {\n          dirruns = dirrunsUnique;\n          outermostContext = contextBackup;\n        }\n        return unmatched;\n      };\n    return bySet ? markFunction(superMatcher) : superMatcher;\n  }\n  compile = Sizzle.compile = function (selector, match /* Internal Use Only */) {\n    var i,\n      setMatchers = [],\n      elementMatchers = [],\n      cached = compilerCache[selector + \" \"];\n    if (!cached) {\n      if (!match) {\n        match = tokenize(selector);\n      }\n      i = match.length;\n      while (i--) {\n        cached = matcherFromTokens(match[i]);\n        if (cached[expando]) {\n          setMatchers.push(cached);\n        } else {\n          elementMatchers.push(cached);\n        }\n      }\n      cached = compilerCache(selector, matcherFromGroupMatchers(elementMatchers, setMatchers));\n      cached.selector = selector;\n    }\n    return cached;\n  };\n\n  /**\n   * A low-level selection function that works with Sizzle's compiled\n   *  selector functions\n   * @param {String|Function} selector A selector or a pre-compiled\n   *  selector function built with Sizzle.compile\n   * @param {Element} context\n   * @param {Array} [results]\n   * @param {Array} [seed] A set of elements to match against\n   */\n  select = Sizzle.select = function (selector, context, results, seed) {\n    var i,\n      tokens,\n      token,\n      type,\n      find,\n      compiled = typeof selector === \"function\" && selector,\n      match = !seed && tokenize(selector = compiled.selector || selector);\n    results = results || [];\n    if (match.length === 1) {\n      var _context39;\n      tokens = match[0] = (0, _slice.default)(_context39 = match[0]).call(_context39, 0);\n      if (tokens.length > 2 && (token = tokens[0]).type === \"ID\" && support.getById && context.nodeType === 9 && documentIsHTML && Expr.relative[tokens[1].type]) {\n        context = ((0, _find.default)(Expr)[\"ID\"](token.matches[0].replace(runescape, funescape), context) || [])[0];\n        if (!context) {\n          return results;\n        } else if (compiled) {\n          context = context.parentNode;\n        }\n        selector = (0, _slice.default)(selector).call(selector, tokens.shift().value.length);\n      }\n      i = matchExpr[\"needsContext\"].test(selector) ? 0 : tokens.length;\n      while (i--) {\n        token = tokens[i];\n        if (Expr.relative[type = token.type]) {\n          break;\n        }\n        if (find = (0, _find.default)(Expr)[type]) {\n          if (seed = find(token.matches[0].replace(runescape, funescape), rsibling.test(tokens[0].type) && testContext(context.parentNode) || context)) {\n            (0, _splice.default)(tokens).call(tokens, i, 1);\n            selector = seed.length && toSelector(tokens);\n            if (!selector) {\n              push.apply(results, seed);\n              return results;\n            }\n            break;\n          }\n        }\n      }\n    }\n    (compiled || compile(selector, match))(seed, context, !documentIsHTML, results, rsibling.test(selector) && testContext(context.parentNode) || context);\n    return results;\n  };\n  support.sortStable = (0, _sort.default)(_context40 = expando.split(\"\")).call(_context40, sortOrder).join(\"\") === expando;\n  support.detectDuplicates = !!hasDuplicate;\n  setDocument();\n  support.sortDetached = assert(function (div1) {\n    return div1.compareDocumentPosition(document.createElement(\"div\")) & 1;\n  });\n  if (!assert(function (div) {\n    div.innerHTML = \"<a href='#'></a>\";\n    return div.firstChild.getAttribute(\"href\") === \"#\";\n  })) {\n    addHandle(\"type|href|height|width\", function (elem, name, isXML) {\n      if (!isXML) {\n        return elem.getAttribute(name, name.toLowerCase() === \"type\" ? 1 : 2);\n      }\n    });\n  }\n  if (!support.attributes || !assert(function (div) {\n    div.innerHTML = \"<input/>\";\n    div.firstChild.setAttribute(\"value\", \"\");\n    return div.firstChild.getAttribute(\"value\") === \"\";\n  })) {\n    addHandle(\"value\", function (elem, name, isXML) {\n      if (!isXML && elem.nodeName.toLowerCase() === \"input\") {\n        return elem.defaultValue;\n      }\n    });\n  }\n  if (!assert(function (div) {\n    return div.getAttribute(\"disabled\") == null;\n  })) {\n    addHandle(booleans, function (elem, name, isXML) {\n      var val;\n      if (!isXML) {\n        return elem[name] === true ? name.toLowerCase() : (val = elem.getAttributeNode(name)) && val.specified ? val.value : null;\n      }\n    });\n  }\n  if (typeof define === \"function\" && define.amd) {\n    define(function () {\n      return Sizzle;\n    });\n  } else if (typeof module !== \"undefined\" && module.exports) {\n    module.exports = Sizzle;\n  } else {\n    window.Sizzle = Sizzle;\n  }\n})(window);\n;\n(function () {\n  if (typeof Sizzle !== 'undefined') {\n    return;\n  }\n  if (typeof define !== 'undefined' && define.amd) {\n    window.Sizzle = Prototype._actual_sizzle;\n    window.define = Prototype._original_define;\n    delete Prototype._actual_sizzle;\n    delete Prototype._original_define;\n  } else if (typeof module !== 'undefined' && module.exports) {\n    window.Sizzle = module.exports;\n    module.exports = {};\n  }\n})();\n;\n(function (engine) {\n  var extendElements = Prototype.Selector.extendElements;\n  function select(selector, scope) {\n    return extendElements(engine(selector, scope || document));\n  }\n  function match(element, selector) {\n    return engine.matches(selector, [element]).length == 1;\n  }\n  Prototype.Selector.engine = engine;\n  Prototype.Selector.select = select;\n  Prototype.Selector.match = match;\n})(Sizzle);\nwindow.Sizzle = Prototype._original_property;\ndelete Prototype._original_property;\nvar Form = {\n  reset: function reset(form) {\n    form = $(form);\n    form.reset();\n    return form;\n  },\n  serializeElements: function serializeElements(elements, options) {\n    if (_typeof(options) != 'object') options = {\n      hash: !!options\n    };else if (Object.isUndefined(options.hash)) options.hash = true;\n    var key,\n      value,\n      submitted = false,\n      submit = options.submit,\n      accumulator,\n      initial;\n    if (options.hash) {\n      initial = {};\n      accumulator = function accumulator(result, key, value) {\n        if (key in result) {\n          var _context41;\n          if (!Object.isArray(result[key])) result[key] = [result[key]];\n          result[key] = (0, _concat.default)(_context41 = result[key]).call(_context41, value);\n        } else result[key] = value;\n        return result;\n      };\n    } else {\n      initial = '';\n      accumulator = function accumulator(result, key, values) {\n        if (!Object.isArray(values)) {\n          values = [values];\n        }\n        if (!values.length) {\n          return result;\n        }\n        var encodedKey = encodeURIComponent(key).gsub(/%20/, '+');\n        return result + (result ? \"&\" : \"\") + (0, _map.default)(values).call(values, function (value) {\n          value = value.gsub(/(\\r)?\\n/, '\\r\\n');\n          value = encodeURIComponent(value);\n          value = value.gsub(/%20/, '+');\n          return encodedKey + \"=\" + value;\n        }).join(\"&\");\n      };\n    }\n    return elements.inject(initial, function (result, element) {\n      if (!element.disabled && element.name) {\n        key = element.name;\n        value = $(element).getValue();\n        if (value != null && element.type != 'file' && (element.type != 'submit' || !submitted && submit !== false && (!submit || key == submit) && (submitted = true))) {\n          result = accumulator(result, key, value);\n        }\n      }\n      return result;\n    });\n  }\n};\nForm.Methods = {\n  serialize: function serialize(form, options) {\n    return Form.serializeElements(Form.getElements(form), options);\n  },\n  getElements: function getElements(form) {\n    var elements = $(form).getElementsByTagName('*');\n    var element,\n      results = [],\n      serializers = Form.Element.Serializers;\n    for (var i = 0; element = elements[i]; i++) {\n      if (serializers[element.tagName.toLowerCase()]) results.push(Element.extend(element));\n    }\n    return results;\n  },\n  getInputs: function getInputs(form, typeName, name) {\n    var _context42;\n    form = $(form);\n    var inputs = form.getElementsByTagName('input');\n    if (!typeName && !name) return (0, _map.default)(_context42 = $A(inputs)).call(_context42, Element.extend);\n    for (var i = 0, matchingInputs = [], length = inputs.length; i < length; i++) {\n      var input = inputs[i];\n      if (typeName && input.type != typeName || name && input.name != name) continue;\n      matchingInputs.push(Element.extend(input));\n    }\n    return matchingInputs;\n  },\n  disable: function disable(form) {\n    form = $(form);\n    Form.getElements(form).invoke('disable');\n    return form;\n  },\n  enable: function enable(form) {\n    form = $(form);\n    Form.getElements(form).invoke('enable');\n    return form;\n  },\n  findFirstElement: function findFirstElement(form) {\n    var elements = $(form).getElements().findAll(function (element) {\n      return 'hidden' != element.type && !element.disabled;\n    });\n    var firstByIndex = elements.findAll(function (element) {\n      return element.hasAttribute('tabIndex') && element.tabIndex >= 0;\n    }).sortBy(function (element) {\n      return element.tabIndex;\n    }).first();\n    return firstByIndex ? firstByIndex : (0, _find.default)(elements).call(elements, function (element) {\n      return /^(?:input|select|textarea)$/i.test(element.tagName);\n    });\n  },\n  focusFirstElement: function focusFirstElement(form) {\n    form = $(form);\n    var element = form.findFirstElement();\n    if (element) element.activate();\n    return form;\n  },\n  request: function request(form, options) {\n    form = $(form), options = Object.clone(options || {});\n    var params = options.parameters,\n      action = form.readAttribute('action') || '';\n    if (action.blank()) action = window.location.href;\n    options.parameters = form.serialize(true);\n    if (params) {\n      if (Object.isString(params)) params = params.toQueryParams();\n      Object.extend(options.parameters, params);\n    }\n    if (form.hasAttribute('method') && !options.method) options.method = form.method;\n    return new Ajax.Request(action, options);\n  }\n};\n\n/*--------------------------------------------------------------------------*/\n\nForm.Element = {\n  focus: function focus(element) {\n    $(element).focus();\n    return element;\n  },\n  select: function select(element) {\n    $(element).select();\n    return element;\n  }\n};\nForm.Element.Methods = {\n  serialize: function serialize(element) {\n    element = $(element);\n    if (!element.disabled && element.name) {\n      var value = element.getValue();\n      if (value != undefined) {\n        var pair = {};\n        pair[element.name] = value;\n        return Object.toQueryString(pair);\n      }\n    }\n    return '';\n  },\n  getValue: function getValue(element) {\n    element = $(element);\n    var method = element.tagName.toLowerCase();\n    return Form.Element.Serializers[method](element);\n  },\n  setValue: function setValue(element, value) {\n    element = $(element);\n    var method = element.tagName.toLowerCase();\n    Form.Element.Serializers[method](element, value);\n    return element;\n  },\n  clear: function clear(element) {\n    $(element).value = '';\n    return element;\n  },\n  present: function present(element) {\n    return $(element).value != '';\n  },\n  activate: function activate(element) {\n    element = $(element);\n    try {\n      element.focus();\n      if (element.select && (element.tagName.toLowerCase() != 'input' || !/^(?:button|reset|submit)$/i.test(element.type))) element.select();\n    } catch (e) {}\n    return element;\n  },\n  disable: function disable(element) {\n    element = $(element);\n    element.disabled = true;\n    return element;\n  },\n  enable: function enable(element) {\n    element = $(element);\n    element.disabled = false;\n    return element;\n  }\n};\n\n/*--------------------------------------------------------------------------*/\n\nvar Field = Form.Element;\nvar $F = Form.Element.Methods.getValue;\n\n/*--------------------------------------------------------------------------*/\n\nForm.Element.Serializers = function () {\n  function input(element, value) {\n    switch (element.type.toLowerCase()) {\n      case 'checkbox':\n      case 'radio':\n        return inputSelector(element, value);\n      default:\n        return valueSelector(element, value);\n    }\n  }\n  function inputSelector(element, value) {\n    if (Object.isUndefined(value)) return element.checked ? element.value : null;else element.checked = !!value;\n  }\n  function valueSelector(element, value) {\n    if (Object.isUndefined(value)) return element.value;else element.value = value;\n  }\n  function select(element, value) {\n    if (Object.isUndefined(value)) return (element.type === 'select-one' ? selectOne : selectMany)(element);\n    var opt,\n      currentValue,\n      single = !Object.isArray(value);\n    for (var i = 0, length = element.length; i < length; i++) {\n      opt = element.options[i];\n      currentValue = this.optionValue(opt);\n      if (single) {\n        if (currentValue == value) {\n          opt.selected = true;\n          return;\n        }\n      } else opt.selected = value.include(currentValue);\n    }\n  }\n  function selectOne(element) {\n    var index = element.selectedIndex;\n    return index >= 0 ? optionValue(element.options[index]) : null;\n  }\n  function selectMany(element) {\n    var values,\n      length = element.length;\n    if (!length) return null;\n    for (var i = 0, values = []; i < length; i++) {\n      var opt = element.options[i];\n      if (opt.selected) values.push(optionValue(opt));\n    }\n    return values;\n  }\n  function optionValue(opt) {\n    return Element.hasAttribute(opt, 'value') ? opt.value : opt.text;\n  }\n  return {\n    input: input,\n    inputSelector: inputSelector,\n    textarea: valueSelector,\n    select: select,\n    selectOne: selectOne,\n    selectMany: selectMany,\n    optionValue: optionValue,\n    button: valueSelector\n  };\n}();\n\n/*--------------------------------------------------------------------------*/\n\nAbstract.TimedObserver = Class.create(PeriodicalExecuter, {\n  initialize: function initialize($super, element, frequency, callback) {\n    $super(callback, frequency);\n    this.element = $(element);\n    this.lastValue = this.getValue();\n  },\n  execute: function execute() {\n    var value = this.getValue();\n    if (Object.isString(this.lastValue) && Object.isString(value) ? this.lastValue != value : String(this.lastValue) != String(value)) {\n      this.callback(this.element, value);\n      this.lastValue = value;\n    }\n  }\n});\nForm.Element.Observer = Class.create(Abstract.TimedObserver, {\n  getValue: function getValue() {\n    return Form.Element.getValue(this.element);\n  }\n});\nForm.Observer = Class.create(Abstract.TimedObserver, {\n  getValue: function getValue() {\n    return Form.serialize(this.element);\n  }\n});\n\n/*--------------------------------------------------------------------------*/\n\nAbstract.EventObserver = Class.create({\n  initialize: function initialize(element, callback) {\n    this.element = $(element);\n    this.callback = callback;\n    this.lastValue = this.getValue();\n    if (this.element.tagName.toLowerCase() == 'form') this.registerFormCallbacks();else this.registerCallback(this.element);\n  },\n  onElementEvent: function onElementEvent() {\n    var value = this.getValue();\n    if (this.lastValue != value) {\n      this.callback(this.element, value);\n      this.lastValue = value;\n    }\n  },\n  registerFormCallbacks: function registerFormCallbacks() {\n    Form.getElements(this.element).each(this.registerCallback, this);\n  },\n  registerCallback: function registerCallback(element) {\n    var _context43, _context44;\n    if (element.type) {\n      switch (element.type.toLowerCase()) {\n        case 'checkbox':\n        case 'radio':\n          Event.observe(element, 'click', (0, _bind.default)(_context43 = this.onElementEvent).call(_context43, this));\n          break;\n        default:\n          Event.observe(element, 'change', (0, _bind.default)(_context44 = this.onElementEvent).call(_context44, this));\n          break;\n      }\n    }\n  }\n});\nForm.Element.EventObserver = Class.create(Abstract.EventObserver, {\n  getValue: function getValue() {\n    return Form.Element.getValue(this.element);\n  }\n});\nForm.EventObserver = Class.create(Abstract.EventObserver, {\n  getValue: function getValue() {\n    return Form.serialize(this.element);\n  }\n});\n(function (GLOBAL) {\n  var DIV = document.createElement('div');\n  var docEl = document.documentElement;\n  var MOUSEENTER_MOUSELEAVE_EVENTS_SUPPORTED = 'onmouseenter' in docEl && 'onmouseleave' in docEl;\n  var Event = {\n    KEY_BACKSPACE: 8,\n    KEY_TAB: 9,\n    KEY_RETURN: 13,\n    KEY_ESC: 27,\n    KEY_LEFT: 37,\n    KEY_UP: 38,\n    KEY_RIGHT: 39,\n    KEY_DOWN: 40,\n    KEY_DELETE: 46,\n    KEY_HOME: 36,\n    KEY_END: 35,\n    KEY_PAGEUP: 33,\n    KEY_PAGEDOWN: 34,\n    KEY_INSERT: 45\n  };\n  var isIELegacyEvent = function isIELegacyEvent(event) {\n    return false;\n  };\n  if (window.attachEvent) {\n    if (window.addEventListener) {\n      isIELegacyEvent = function isIELegacyEvent(event) {\n        return !(event instanceof window.Event);\n      };\n    } else {\n      isIELegacyEvent = function isIELegacyEvent(event) {\n        return true;\n      };\n    }\n  }\n  var _isButton;\n  function _isButtonForDOMEvents(event, code) {\n    return event.which ? event.which === code + 1 : event.button === code;\n  }\n  var legacyButtonMap = {\n    0: 1,\n    1: 4,\n    2: 2\n  };\n  function _isButtonForLegacyEvents(event, code) {\n    return event.button === legacyButtonMap[code];\n  }\n  function _isButtonForWebKit(event, code) {\n    switch (code) {\n      case 0:\n        return event.which == 1 && !event.metaKey;\n      case 1:\n        return event.which == 2 || event.which == 1 && event.metaKey;\n      case 2:\n        return event.which == 3;\n      default:\n        return false;\n    }\n  }\n  if (window.attachEvent) {\n    if (!window.addEventListener) {\n      _isButton = _isButtonForLegacyEvents;\n    } else {\n      _isButton = function _isButton(event, code) {\n        return isIELegacyEvent(event) ? _isButtonForLegacyEvents(event, code) : _isButtonForDOMEvents(event, code);\n      };\n    }\n  } else if (Prototype.Browser.WebKit) {\n    _isButton = _isButtonForWebKit;\n  } else {\n    _isButton = _isButtonForDOMEvents;\n  }\n  function isLeftClick(event) {\n    return _isButton(event, 0);\n  }\n  function isMiddleClick(event) {\n    return _isButton(event, 1);\n  }\n  function isRightClick(event) {\n    return _isButton(event, 2);\n  }\n  function element(event) {\n    return Element.extend(_element(event));\n  }\n  function _element(event) {\n    event = Event.extend(event);\n    var node = event.target,\n      type = event.type,\n      currentTarget = event.currentTarget;\n    if (currentTarget && currentTarget.tagName) {\n      if (type === 'load' || type === 'error' || type === 'click' && currentTarget.tagName.toLowerCase() === 'input' && currentTarget.type === 'radio') node = currentTarget;\n    }\n    return node.nodeType == Node.TEXT_NODE ? node.parentNode : node;\n  }\n  function findElement(event, expression) {\n    var element = _element(event),\n      selector = Prototype.Selector;\n    if (!expression) return Element.extend(element);\n    while (element) {\n      if (Object.isElement(element) && selector.match(element, expression)) return Element.extend(element);\n      element = element.parentNode;\n    }\n  }\n  function pointer(event) {\n    return {\n      x: pointerX(event),\n      y: pointerY(event)\n    };\n  }\n  function pointerX(event) {\n    var docElement = document.documentElement,\n      body = document.body || {\n        scrollLeft: 0\n      };\n    return event.pageX || event.clientX + (docElement.scrollLeft || body.scrollLeft) - (docElement.clientLeft || 0);\n  }\n  function pointerY(event) {\n    var docElement = document.documentElement,\n      body = document.body || {\n        scrollTop: 0\n      };\n    return event.pageY || event.clientY + (docElement.scrollTop || body.scrollTop) - (docElement.clientTop || 0);\n  }\n  function stop(event) {\n    Event.extend(event);\n    event.preventDefault();\n    event.stopPropagation();\n    event.stopped = true;\n  }\n  Event.Methods = {\n    isLeftClick: isLeftClick,\n    isMiddleClick: isMiddleClick,\n    isRightClick: isRightClick,\n    element: element,\n    findElement: findElement,\n    pointer: pointer,\n    pointerX: pointerX,\n    pointerY: pointerY,\n    stop: stop\n  };\n  var methods = (0, _keys.default)(Event.Methods).inject({}, function (m, name) {\n    m[name] = Event.Methods[name].methodize();\n    return m;\n  });\n  if (window.attachEvent) {\n    var _relatedTarget = function _relatedTarget(event) {\n      var element;\n      switch (event.type) {\n        case 'mouseover':\n        case 'mouseenter':\n          element = event.fromElement;\n          break;\n        case 'mouseout':\n        case 'mouseleave':\n          element = event.toElement;\n          break;\n        default:\n          return null;\n      }\n      return Element.extend(element);\n    };\n    var additionalMethods = {\n      stopPropagation: function stopPropagation() {\n        this.cancelBubble = true;\n      },\n      preventDefault: function preventDefault() {\n        this.returnValue = false;\n      },\n      inspect: function inspect() {\n        return '[object Event]';\n      }\n    };\n    Event.extend = function (event, element) {\n      if (!event) return false;\n      if (!isIELegacyEvent(event)) return event;\n      if (event._extendedByPrototype) return event;\n      event._extendedByPrototype = Prototype.emptyFunction;\n      var pointer = Event.pointer(event);\n      Object.extend(event, {\n        target: event.srcElement || element,\n        relatedTarget: _relatedTarget(event),\n        pageX: pointer.x,\n        pageY: pointer.y\n      });\n      Object.extend(event, methods);\n      Object.extend(event, additionalMethods);\n      return event;\n    };\n  } else {\n    Event.extend = Prototype.K;\n  }\n  if (window.addEventListener) {\n    Event.prototype = window.Event.prototype || document.createEvent('HTMLEvents').__proto__;\n    Object.extend(Event.prototype, methods);\n  }\n  var EVENT_TRANSLATIONS = {\n    mouseenter: 'mouseover',\n    mouseleave: 'mouseout'\n  };\n  function getDOMEventName(eventName) {\n    return EVENT_TRANSLATIONS[eventName] || eventName;\n  }\n  if (MOUSEENTER_MOUSELEAVE_EVENTS_SUPPORTED) getDOMEventName = Prototype.K;\n  function getUniqueElementID(element) {\n    if (element === window) return 0;\n    if (typeof element._prototypeUID === 'undefined') element._prototypeUID = Element.Storage.UID++;\n    return element._prototypeUID;\n  }\n  function getUniqueElementID_IE(element) {\n    if (element === window) return 0;\n    if (element == document) return 1;\n    return element.uniqueID;\n  }\n  if ('uniqueID' in DIV) getUniqueElementID = getUniqueElementID_IE;\n  function isCustomEvent(eventName) {\n    return eventName.include(':');\n  }\n  Event._isCustomEvent = isCustomEvent;\n  function getOrCreateRegistryFor(element, uid) {\n    var CACHE = GLOBAL.Event.cache;\n    if (Object.isUndefined(uid)) uid = getUniqueElementID(element);\n    if (!CACHE[uid]) CACHE[uid] = {\n      element: element\n    };\n    return CACHE[uid];\n  }\n  function destroyRegistryForElement(element, uid) {\n    if (Object.isUndefined(uid)) uid = getUniqueElementID(element);\n    delete GLOBAL.Event.cache[uid];\n  }\n  function register(element, eventName, handler) {\n    var registry = getOrCreateRegistryFor(element);\n    if (!registry[eventName]) registry[eventName] = [];\n    var entries = registry[eventName];\n    var i = entries.length;\n    while (i--) if (entries[i].handler === handler) return null;\n    var uid = getUniqueElementID(element);\n    var responder = GLOBAL.Event._createResponder(uid, eventName, handler);\n    var entry = {\n      responder: responder,\n      handler: handler\n    };\n    entries.push(entry);\n    return entry;\n  }\n  function unregister(element, eventName, handler) {\n    var registry = getOrCreateRegistryFor(element);\n    var entries = registry[eventName] || [];\n    var i = entries.length,\n      entry;\n    while (i--) {\n      if (entries[i].handler === handler) {\n        entry = entries[i];\n        break;\n      }\n    }\n    if (entry) {\n      var index = (0, _indexOf.default)(entries).call(entries, entry);\n      (0, _splice.default)(entries).call(entries, index, 1);\n    }\n    if (entries.length === 0) {\n      delete registry[eventName];\n      if ((0, _keys.default)(registry).length === 1 && 'element' in registry) destroyRegistryForElement(element);\n    }\n    return entry;\n  }\n  function observe(element, eventName, handler) {\n    element = $(element);\n    var entry = register(element, eventName, handler);\n    if (entry === null) return element;\n    var responder = entry.responder;\n    if (isCustomEvent(eventName)) observeCustomEvent(element, eventName, responder);else observeStandardEvent(element, eventName, responder);\n    return element;\n  }\n  function observeStandardEvent(element, eventName, responder) {\n    var actualEventName = getDOMEventName(eventName);\n    if (element.addEventListener) {\n      element.addEventListener(actualEventName, responder, false);\n    } else {\n      element.attachEvent('on' + actualEventName, responder);\n    }\n  }\n  function observeCustomEvent(element, eventName, responder) {\n    if (element.addEventListener) {\n      element.addEventListener('dataavailable', responder, false);\n    } else {\n      element.attachEvent('ondataavailable', responder);\n      element.attachEvent('onlosecapture', responder);\n    }\n  }\n  function stopObserving(element, eventName, handler) {\n    element = $(element);\n    var handlerGiven = !Object.isUndefined(handler),\n      eventNameGiven = !Object.isUndefined(eventName);\n    if (!eventNameGiven && !handlerGiven) {\n      stopObservingElement(element);\n      return element;\n    }\n    if (!handlerGiven) {\n      stopObservingEventName(element, eventName);\n      return element;\n    }\n    var entry = unregister(element, eventName, handler);\n    if (!entry) return element;\n    removeEvent(element, eventName, entry.responder);\n    return element;\n  }\n  function stopObservingStandardEvent(element, eventName, responder) {\n    var actualEventName = getDOMEventName(eventName);\n    if (element.removeEventListener) {\n      element.removeEventListener(actualEventName, responder, false);\n    } else {\n      element.detachEvent('on' + actualEventName, responder);\n    }\n  }\n  function stopObservingCustomEvent(element, eventName, responder) {\n    if (element.removeEventListener) {\n      element.removeEventListener('dataavailable', responder, false);\n    } else {\n      element.detachEvent('ondataavailable', responder);\n      element.detachEvent('onlosecapture', responder);\n    }\n  }\n  function stopObservingElement(element) {\n    var uid = getUniqueElementID(element),\n      registry = GLOBAL.Event.cache[uid];\n    if (!registry) return;\n    destroyRegistryForElement(element, uid);\n    var entries, i;\n    for (var eventName in registry) {\n      if (eventName === 'element') continue;\n      entries = registry[eventName];\n      i = entries.length;\n      while (i--) removeEvent(element, eventName, entries[i].responder);\n    }\n  }\n  function stopObservingEventName(element, eventName) {\n    var registry = getOrCreateRegistryFor(element);\n    var entries = registry[eventName];\n    if (entries) {\n      delete registry[eventName];\n    }\n    entries = entries || [];\n    var i = entries.length;\n    while (i--) removeEvent(element, eventName, entries[i].responder);\n    for (var name in registry) {\n      if (name === 'element') continue;\n      return; // There is another registered event\n    }\n    destroyRegistryForElement(element);\n  }\n  function removeEvent(element, eventName, handler) {\n    if (isCustomEvent(eventName)) stopObservingCustomEvent(element, eventName, handler);else stopObservingStandardEvent(element, eventName, handler);\n  }\n  function getFireTarget(element) {\n    if (element !== document) return element;\n    if (document.createEvent && !element.dispatchEvent) return document.documentElement;\n    return element;\n  }\n  function fire(element, eventName, memo, bubble) {\n    element = getFireTarget($(element));\n    if (Object.isUndefined(bubble)) bubble = true;\n    memo = memo || {};\n    var event = fireEvent(element, eventName, memo, bubble);\n    return Event.extend(event);\n  }\n  function fireEvent_DOM(element, eventName, memo, bubble) {\n    var event = document.createEvent('HTMLEvents');\n    event.initEvent('dataavailable', bubble, true);\n    event.eventName = eventName;\n    event.memo = memo;\n    element.dispatchEvent(event);\n    return event;\n  }\n  function fireEvent_IE(element, eventName, memo, bubble) {\n    var event = document.createEventObject();\n    event.eventType = bubble ? 'ondataavailable' : 'onlosecapture';\n    event.eventName = eventName;\n    event.memo = memo;\n    element.fireEvent(event.eventType, event);\n    return event;\n  }\n  var fireEvent = document.createEvent ? fireEvent_DOM : fireEvent_IE;\n  Event.Handler = Class.create({\n    initialize: function initialize(element, eventName, selector, callback) {\n      var _context45;\n      this.element = $(element);\n      this.eventName = eventName;\n      this.selector = selector;\n      this.callback = callback;\n      this.handler = (0, _bind.default)(_context45 = this.handleEvent).call(_context45, this);\n    },\n    start: function start() {\n      Event.observe(this.element, this.eventName, this.handler);\n      return this;\n    },\n    stop: function stop() {\n      Event.stopObserving(this.element, this.eventName, this.handler);\n      return this;\n    },\n    handleEvent: function handleEvent(event) {\n      var element = Event.findElement(event, this.selector);\n      if (element) this.callback.call(this.element, event, element);\n    }\n  });\n  function on(element, eventName, selector, callback) {\n    element = $(element);\n    if (Object.isFunction(selector) && Object.isUndefined(callback)) {\n      callback = selector, selector = null;\n    }\n    return new Event.Handler(element, eventName, selector, callback).start();\n  }\n  Object.extend(Event, Event.Methods);\n  Object.extend(Event, {\n    fire: fire,\n    observe: observe,\n    stopObserving: stopObserving,\n    on: on\n  });\n  Element.addMethods({\n    fire: fire,\n    observe: observe,\n    stopObserving: stopObserving,\n    on: on\n  });\n  Object.extend(document, {\n    fire: fire.methodize(),\n    observe: observe.methodize(),\n    stopObserving: stopObserving.methodize(),\n    on: on.methodize(),\n    loaded: false\n  });\n  if (GLOBAL.Event) Object.extend(window.Event, Event);else GLOBAL.Event = Event;\n  GLOBAL.Event.cache = {};\n  function destroyCache_IE() {\n    GLOBAL.Event.cache = null;\n  }\n  if (window.attachEvent) window.attachEvent('onunload', destroyCache_IE);\n  DIV = null;\n  docEl = null;\n})(void 0);\n(function (GLOBAL) {\n  /* Code for creating leak-free event responders is based on work by\n   John-David Dalton. */\n\n  var docEl = document.documentElement;\n  var MOUSEENTER_MOUSELEAVE_EVENTS_SUPPORTED = 'onmouseenter' in docEl && 'onmouseleave' in docEl;\n  function isSimulatedMouseEnterLeaveEvent(eventName) {\n    return !MOUSEENTER_MOUSELEAVE_EVENTS_SUPPORTED && (eventName === 'mouseenter' || eventName === 'mouseleave');\n  }\n  function createResponder(uid, eventName, handler) {\n    if (Event._isCustomEvent(eventName)) return createResponderForCustomEvent(uid, eventName, handler);\n    if (isSimulatedMouseEnterLeaveEvent(eventName)) return createMouseEnterLeaveResponder(uid, eventName, handler);\n    return function (event) {\n      if (!Event.cache) return;\n      var element = Event.cache[uid].element;\n      Event.extend(event, element);\n      handler.call(element, event);\n    };\n  }\n  function createResponderForCustomEvent(uid, eventName, handler) {\n    return function (event) {\n      var cache = Event.cache[uid];\n      var element = cache && cache.element;\n      if (Object.isUndefined(event.eventName)) return false;\n      if (event.eventName !== eventName) return false;\n      Event.extend(event, element);\n      handler.call(element, event);\n    };\n  }\n  function createMouseEnterLeaveResponder(uid, eventName, handler) {\n    return function (event) {\n      var element = Event.cache[uid].element;\n      Event.extend(event, element);\n      var parent = event.relatedTarget;\n      while (parent && parent !== element) {\n        try {\n          parent = parent.parentNode;\n        } catch (e) {\n          parent = element;\n        }\n      }\n      if (parent === element) return;\n      handler.call(element, event);\n    };\n  }\n  GLOBAL.Event._createResponder = createResponder;\n  docEl = null;\n})(void 0);\n(function (GLOBAL) {\n  /* Support for the DOMContentLoaded event is based on work by Dan Webb,\n     Matthias Miller, Dean Edwards, John Resig, and Diego Perini. */\n\n  var TIMER;\n  function fireContentLoadedEvent() {\n    if (document.loaded) return;\n    if (TIMER) window.clearTimeout(TIMER);\n    document.loaded = true;\n    document.fire('dom:loaded');\n  }\n  function checkReadyState() {\n    if (document.readyState === 'complete') {\n      document.detachEvent('onreadystatechange', checkReadyState);\n      fireContentLoadedEvent();\n    }\n  }\n  function pollDoScroll() {\n    try {\n      document.documentElement.doScroll('left');\n    } catch (e) {\n      TIMER = pollDoScroll.defer();\n      return;\n    }\n    fireContentLoadedEvent();\n  }\n  if (document.readyState === 'complete') {\n    fireContentLoadedEvent();\n    return;\n  }\n  if (document.addEventListener) {\n    document.addEventListener('DOMContentLoaded', fireContentLoadedEvent, false);\n  } else {\n    document.attachEvent('onreadystatechange', checkReadyState);\n    if (window == top) TIMER = pollDoScroll.defer();\n  }\n  Event.observe(window, 'load', fireContentLoadedEvent);\n})(void 0);\nElement.addMethods();\n/*------------------------------- DEPRECATED -------------------------------*/\n\nHash.toQueryString = Object.toQueryString;\nvar Toggle = {\n  display: Element.toggle\n};\nElement.addMethods({\n  childOf: Element.Methods.descendantOf\n});\nvar Insertion = {\n  Before: function Before(element, content) {\n    return Element.insert(element, {\n      before: content\n    });\n  },\n  Top: function Top(element, content) {\n    return Element.insert(element, {\n      top: content\n    });\n  },\n  Bottom: function Bottom(element, content) {\n    return Element.insert(element, {\n      bottom: content\n    });\n  },\n  After: function After(element, content) {\n    return Element.insert(element, {\n      after: content\n    });\n  }\n};\nvar $continue = new Error('\"throw $continue\" is deprecated, use \"return\" instead');\nvar Position = {\n  includeScrollOffsets: false,\n  prepare: function prepare() {\n    this.deltaX = window.pageXOffset || document.documentElement.scrollLeft || document.body.scrollLeft || 0;\n    this.deltaY = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0;\n  },\n  within: function within(element, x, y) {\n    if (this.includeScrollOffsets) return this.withinIncludingScrolloffsets(element, x, y);\n    this.xcomp = x;\n    this.ycomp = y;\n    this.offset = Element.cumulativeOffset(element);\n    return y >= this.offset[1] && y < this.offset[1] + element.offsetHeight && x >= this.offset[0] && x < this.offset[0] + element.offsetWidth;\n  },\n  withinIncludingScrolloffsets: function withinIncludingScrolloffsets(element, x, y) {\n    var offsetcache = Element.cumulativeScrollOffset(element);\n    this.xcomp = x + offsetcache[0] - this.deltaX;\n    this.ycomp = y + offsetcache[1] - this.deltaY;\n    this.offset = Element.cumulativeOffset(element);\n    return this.ycomp >= this.offset[1] && this.ycomp < this.offset[1] + element.offsetHeight && this.xcomp >= this.offset[0] && this.xcomp < this.offset[0] + element.offsetWidth;\n  },\n  overlap: function overlap(mode, element) {\n    if (!mode) return 0;\n    if (mode == 'vertical') return (this.offset[1] + element.offsetHeight - this.ycomp) / element.offsetHeight;\n    if (mode == 'horizontal') return (this.offset[0] + element.offsetWidth - this.xcomp) / element.offsetWidth;\n  },\n  cumulativeOffset: Element.Methods.cumulativeOffset,\n  positionedOffset: Element.Methods.positionedOffset,\n  absolutize: function absolutize(element) {\n    Position.prepare();\n    return Element.absolutize(element);\n  },\n  relativize: function relativize(element) {\n    Position.prepare();\n    return Element.relativize(element);\n  },\n  realOffset: Element.Methods.cumulativeScrollOffset,\n  offsetParent: Element.Methods.getOffsetParent,\n  page: Element.Methods.viewportOffset,\n  clone: function clone(source, target, options) {\n    options = options || {};\n    return Element.clonePosition(target, source, options);\n  }\n};\n\n/*--------------------------------------------------------------------------*/\n\nif (!document.getElementsByClassName) document.getElementsByClassName = function (instanceMethods) {\n  function iter(name) {\n    return name.blank() ? null : \"[contains(concat(' ', @class, ' '), ' \" + name + \" ')]\";\n  }\n  instanceMethods.getElementsByClassName = Prototype.BrowserFeatures.XPath ? function (element, className) {\n    var _context46;\n    className = className.toString().strip();\n    var cond = /\\s/.test(className) ? (0, _map.default)(_context46 = $w(className)).call(_context46, iter).join('') : iter(className);\n    return cond ? document._getElementsByXPath('.//*' + cond, element) : [];\n  } : function (element, className) {\n    className = className.toString().strip();\n    var elements = [],\n      classNames = /\\s/.test(className) ? $w(className) : null;\n    if (!classNames && !className) return elements;\n    var nodes = $(element).getElementsByTagName('*');\n    className = ' ' + className + ' ';\n    for (var i = 0, child, cn; child = nodes[i]; i++) {\n      if (child.className && (cn = ' ' + child.className + ' ') && (cn.include(className) || classNames && classNames.all(function (name) {\n        return !name.toString().blank() && cn.include(' ' + name + ' ');\n      }))) elements.push(Element.extend(child));\n    }\n    return elements;\n  };\n  return function (className, parentElement) {\n    return $(parentElement || document.body).getElementsByClassName(className);\n  };\n}(Element.Methods);\n\n/*--------------------------------------------------------------------------*/\n\nElement.ClassNames = Class.create();\nElement.ClassNames.prototype = {\n  initialize: function initialize(element) {\n    this.element = $(element);\n  },\n  _each: function _each(iterator, context) {\n    this.element.className.split(/\\s+/).select(function (name) {\n      return name.length > 0;\n    })._each(iterator, context);\n  },\n  set: function set(className) {\n    this.element.className = className;\n  },\n  add: function add(classNameToAdd) {\n    var _context47;\n    if (this.include(classNameToAdd)) return;\n    this.set((0, _concat.default)(_context47 = $A(this)).call(_context47, classNameToAdd).join(' '));\n  },\n  remove: function remove(classNameToRemove) {\n    if (!this.include(classNameToRemove)) return;\n    this.set($A(this).without(classNameToRemove).join(' '));\n  },\n  toString: function toString() {\n    return $A(this).join(' ');\n  }\n};\nObject.extend(Element.ClassNames.prototype, Enumerable);\n\n/*--------------------------------------------------------------------------*/\n\n(function () {\n  window.Selector = Class.create({\n    initialize: function initialize(expression) {\n      this.expression = expression.strip();\n    },\n    findElements: function findElements(rootElement) {\n      return Prototype.Selector.select(this.expression, rootElement);\n    },\n    match: function match(element) {\n      return Prototype.Selector.match(element, this.expression);\n    },\n    toString: function toString() {\n      return this.expression;\n    },\n    inspect: function inspect() {\n      return \"#<Selector: \" + this.expression + \">\";\n    }\n  });\n  Object.extend(Selector, {\n    matchElements: function matchElements(elements, expression) {\n      var match = Prototype.Selector.match,\n        results = [];\n      for (var i = 0, length = elements.length; i < length; i++) {\n        var element = elements[i];\n        if (match(element, expression)) {\n          results.push(Element.extend(element));\n        }\n      }\n      return results;\n    },\n    findElement: function findElement(elements, expression, index) {\n      index = index || 0;\n      var matchIndex = 0,\n        element;\n      for (var i = 0, length = elements.length; i < length; i++) {\n        element = elements[i];\n        if (Prototype.Selector.match(element, expression) && index === matchIndex++) {\n          return Element.extend(element);\n        }\n      }\n    },\n    findChildElements: function findChildElements(element, expressions) {\n      var selector = expressions.toArray().join(', ');\n      return Prototype.Selector.select(selector, element || document);\n    }\n  });\n})();"

/***/ }),

/***/ "./node_modules/script-loader/index.js!./src/main/assets/js/lib/3rdparty/cropper/cropper.uncompressed.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/script-loader!./src/main/assets/js/lib/3rdparty/cropper/cropper.uncompressed.js ***!
  \******************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! !./node_modules/script-loader/addScript.js */ "./node_modules/script-loader/addScript.js")(__webpack_require__(/*! !./node_modules/raw-loader!./node_modules/babel-loader/lib??ref--22-0!./src/main/assets/js/lib/3rdparty/cropper/cropper.uncompressed.js */ "./node_modules/raw-loader/index.js!./node_modules/babel-loader/lib/index.js?!./src/main/assets/js/lib/3rdparty/cropper/cropper.uncompressed.js")+"\n\n// SCRIPT-LOADER FOOTER\n//# sourceURL=script:///home/circleci/project/core/web-assets/node_modules/babel-loader/lib/index.js%3F?ref--22-0!/home/circleci/project/core/web-assets/src/main/assets/js/lib/3rdparty/cropper/cropper.uncompressed.js")

/***/ }),

/***/ "./node_modules/script-loader/index.js!./src/main/assets/js/lib/3rdparty/cropper/lib/scriptaculous.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/script-loader!./src/main/assets/js/lib/3rdparty/cropper/lib/scriptaculous.js ***!
  \***************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! !./node_modules/script-loader/addScript.js */ "./node_modules/script-loader/addScript.js")(__webpack_require__(/*! !./node_modules/raw-loader!./node_modules/babel-loader/lib??ref--22-0!./src/main/assets/js/lib/3rdparty/cropper/lib/scriptaculous.js */ "./node_modules/raw-loader/index.js!./node_modules/babel-loader/lib/index.js?!./src/main/assets/js/lib/3rdparty/cropper/lib/scriptaculous.js")+"\n\n// SCRIPT-LOADER FOOTER\n//# sourceURL=script:///home/circleci/project/core/web-assets/node_modules/babel-loader/lib/index.js%3F?ref--22-0!/home/circleci/project/core/web-assets/src/main/assets/js/lib/3rdparty/cropper/lib/scriptaculous.js")

/***/ }),

/***/ "./node_modules/script-loader/index.js!./src/main/assets/js/lib/3rdparty/prototype.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/script-loader!./src/main/assets/js/lib/3rdparty/prototype.js ***!
  \***********************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! !./node_modules/script-loader/addScript.js */ "./node_modules/script-loader/addScript.js")(__webpack_require__(/*! !./node_modules/raw-loader!./node_modules/babel-loader/lib??ref--22-0!./src/main/assets/js/lib/3rdparty/prototype.js */ "./node_modules/raw-loader/index.js!./node_modules/babel-loader/lib/index.js?!./src/main/assets/js/lib/3rdparty/prototype.js")+"\n\n// SCRIPT-LOADER FOOTER\n//# sourceURL=script:///home/circleci/project/core/web-assets/node_modules/babel-loader/lib/index.js%3F?ref--22-0!/home/circleci/project/core/web-assets/src/main/assets/js/lib/3rdparty/prototype.js")

/***/ }),

/***/ "./src/main/assets/js/vendor/cropper-js.js":
/*!*************************************************!*\
  !*** ./src/main/assets/js/vendor/cropper-js.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(/*! ../../../../../node_modules/core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
__webpack_require__(/*! ../../../../../node_modules/core-js/modules/es.string.split.js */ "./node_modules/core-js/modules/es.string.split.js");
/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
__webpack_require__(/*! script-loader!lib/3rdparty/prototype */ "./node_modules/script-loader/index.js!./src/main/assets/js/lib/3rdparty/prototype.js");
__webpack_require__(/*! script-loader!lib/3rdparty/cropper/lib/scriptaculous */ "./node_modules/script-loader/index.js!./src/main/assets/js/lib/3rdparty/cropper/lib/scriptaculous.js");
__webpack_require__(/*! script-loader!lib/3rdparty/cropper/cropper.uncompressed */ "./node_modules/script-loader/index.js!./src/main/assets/js/lib/3rdparty/cropper/cropper.uncompressed.js");

/* adapted from Tobi Oetiker's SmokePing zoom */

/* eslint-disable no-invalid-this */
function urlObj(url) {
  var urlBaseAndParameters;
  urlBaseAndParameters = url.split('?');
  this.urlBase = urlBaseAndParameters[0];
  this.urlParameters = new Array();
  var parameters = urlBaseAndParameters[1].split(/[;&]/);
  for (i = 0; i < parameters.length; i++) {
    var entry = parameters[i].split('=');
    this.urlParameters[i] = {
      'key': entry[0],
      'value': entry[1]
    };
  }
  this.getUrlBase = urlObjGetUrlBase;
  this.getUrlParameters = urlObjGetUrlParameters;
}
function urlObjGetUrlBase() {
  return this.urlBase;
}
function urlObjGetUrlParameters() {
  return this.urlParameters;
}
var doDebug = true;
function log(message) {
  if (doDebug) {
    if (window.console) {
      window.console.log(message);
    } else {
      // alert(message);
    }
  }
}

// example with minimum dimensions
var myCropper;
function changeRRDImage(coords, dimensions) {
  var SelectLeft = Math.min(coords.x1, coords.x2);
  var SelectRight = Math.max(coords.x1, coords.x2);
  if (SelectLeft === SelectRight) {
    return; // abort if nothing is selected.
  }
  var left = zoomGraphLeftOffset;
  var right = zoomGraphRightOffset; // the right offset is relative to the right-side
  var RRDImgWidth = $('zoomImage').getDimensions().width;
  var RRDImgUsable = RRDImgWidth - left + right;
  var form = $('range_form');
  var myURLObj = new urlObj(document.URL);
  var myURL = myURLObj.getUrlBase();
  var parameters = myURLObj.getUrlParameters();
  if (SelectLeft < left) {
    SelectLeft = left;
  }
  if (SelectRight > RRDImgWidth + right) {
    SelectRight = RRDImgWidth + right;
  }
  StartEpoch = zoomGraphStart;
  EndEpoch = zoomGraphEnd;
  var DivEpoch = EndEpoch - StartEpoch;
  var NewStartEpoch = Math.floor(StartEpoch + (SelectLeft - left) * DivEpoch / RRDImgUsable);
  EndEpoch = Math.ceil(StartEpoch + (SelectRight - left) * DivEpoch / RRDImgUsable);
  StartEpoch = NewStartEpoch;
  var newUrl = myURL + '?';
  for (i = 0; i < parameters.length; i++) {
    entry = parameters[i];
    if (entry.key === 'start') {
      entry.value = StartEpoch;
    } else if (entry.key === 'end') {
      entry.value = EndEpoch;
    }
    newUrl = newUrl + entry.key + '=' + entry.value + '&';
  }
  myCropper.setParams();
  window.location.href = newUrl;
}
console.log('init: cropper-js'); // eslint-disable-line no-console

window.changeRRDImage = changeRRDImage;
module.exports = changeRRDImage;

/***/ })

},[["./src/main/assets/js/vendor/cropper-js.js","vendor"]]]);
});
//# sourceMappingURL=cropper-js.js.map