/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
package org.opennms.netmgt.xml.event;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Class Header.
 * 
 * @version $Revision$ $Date$
 */

@XmlRootElement(name="header")
@XmlAccessorType(XmlAccessType.FIELD)
//@ValidateUsing("event.xsd")
public class Header implements Serializable {
	private static final long serialVersionUID = 1963826810463701325L;

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

	/**
     * Field _ver.
     */
	@XmlElement(name="ver")
    private java.lang.String _ver;

    /**
     * Field _dpName.
     */
	@XmlElement(name="dpName")
    private java.lang.String _dpName;

    /**
     * The time at which this log was generated. The time
     *  is in the format generated by the java.text.DateFormat
     * using the
     *  DateFormat.FULL style for the default locale. For example:
     *  "Monday, February 18, 2002 3:01:58 PM EST"
     */
	@XmlElement(name="created")
    private java.lang.String _created;

    /**
     * Field _mstation.
     */
	@XmlElement(name="mstation")
    private java.lang.String _mstation;


      //----------------/
     //- Constructors -/
    //----------------/

    public Header() {
        super();
    }


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Returns the value of field 'created'. The field 'created'
     * has the following description: The time at which this log
     * was generated. The time
     *  is in the format generated by the java.text.DateFormat
     * using the
     *  DateFormat.FULL style for the default locale. For example:
     *  "Monday, February 18, 2002 3:01:58 PM EST"
     * 
     * @return the value of field 'Created'.
     */
    public java.lang.String getCreated(
    ) {
        return this._created;
    }

    /**
     * Returns the value of field 'dpName'.
     * 
     * @return the value of field 'DpName'.
     */
    public java.lang.String getDpName(
    ) {
        return this._dpName;
    }

    /**
     * Returns the value of field 'mstation'.
     * 
     * @return the value of field 'Mstation'.
     */
    public java.lang.String getMstation(
    ) {
        return this._mstation;
    }

    /**
     * Returns the value of field 'ver'.
     * 
     * @return the value of field 'Ver'.
     */
    public java.lang.String getVer(
    ) {
        return this._ver;
    }

    /**
     * Sets the value of field 'created'. The field 'created' has
     * the following description: The time at which this log was
     * generated. The time
     *  is in the format generated by the java.text.DateFormat
     * using the
     *  DateFormat.FULL style for the default locale. For example:
     *  "Monday, February 18, 2002 3:01:58 PM EST"
     * 
     * @param created the value of field 'created'.
     */
    public void setCreated(
            final java.lang.String created) {
        this._created = created;
    }

    /**
     * Sets the value of field 'dpName'.
     * 
     * @param dpName the value of field 'dpName'.
     */
    public void setDpName(
            final java.lang.String dpName) {
        this._dpName = dpName;
    }

    /**
     * Sets the value of field 'mstation'.
     * 
     * @param mstation the value of field 'mstation'.
     */
    public void setMstation(
            final java.lang.String mstation) {
        this._mstation = mstation;
    }

    /**
     * Sets the value of field 'ver'.
     * 
     * @param ver the value of field 'ver'.
     */
    public void setVer(
            final java.lang.String ver) {
        this._ver = ver;
    }

        @Override
    public String toString() {
    	return new OnmsStringBuilder(this).toString();
    }
}
