/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample.health;

import java.util.Objects;
import org.opennms.integration.api.sample.AlarmTestContextManager;
import org.opennms.integration.api.v1.events.EventForwarder;
import org.opennms.integration.api.v1.health.Context;
import org.opennms.integration.api.v1.health.HealthCheck;
import org.opennms.integration.api.v1.health.Response;
import org.opennms.integration.api.v1.health.Status;
import org.opennms.integration.api.v1.health.immutables.ImmutableResponse;
import org.opennms.integration.api.v1.model.EventParameter;
import org.opennms.integration.api.v1.model.InMemoryEvent;
import org.opennms.integration.api.v1.model.immutables.ImmutableEventParameter;
import org.opennms.integration.api.v1.model.immutables.ImmutableInMemoryEvent;

public class AlarmLifecyleHealthCheck
implements HealthCheck {
    private static final String EVENT_SOURCE = AlarmLifecyleHealthCheck.class.getCanonicalName();
    private final AlarmTestContextManager alarmManager;
    private final EventForwarder eventForwarder;

    public AlarmLifecyleHealthCheck(AlarmTestContextManager alarmManager, EventForwarder eventForwarder) {
        this.alarmManager = Objects.requireNonNull(alarmManager);
        this.eventForwarder = Objects.requireNonNull(eventForwarder);
    }

    public String getDescription() {
        return "OIA :: Sample Project :: Alarm Lifecycle";
    }

    public Response perform(Context context) throws Exception {
        try (AlarmTestContextManager.AlarmTestSession session = this.alarmManager.newSession();){
            ImmutableInMemoryEvent trigger = ImmutableInMemoryEvent.newBuilder().setUei("uei.opennms.org/oia/sample/trigger").setSource(EVENT_SOURCE).addParameter((EventParameter)ImmutableEventParameter.newInstance((String)"sessionId", (String)session.getSessionId())).build();
            this.eventForwarder.sendSync((InMemoryEvent)trigger);
            session.waitForTrigger();
            ImmutableInMemoryEvent clear = ImmutableInMemoryEvent.newBuilder().setUei("uei.opennms.org/oia/sample/clear").setSource(EVENT_SOURCE).addParameter((EventParameter)ImmutableEventParameter.newInstance((String)"sessionId", (String)session.getSessionId())).build();
            this.eventForwarder.sendSync((InMemoryEvent)clear);
            session.waitForClear();
            ImmutableResponse immutableResponse = ImmutableResponse.newInstance((Status)Status.Success);
            return immutableResponse;
        }
    }
}

